package software.amazon.awscdk.services.supportapp;

/**
 * Properties for defining a <code>CfnSlackChannelConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.supportapp.*;
 * CfnSlackChannelConfigurationProps cfnSlackChannelConfigurationProps = CfnSlackChannelConfigurationProps.builder()
 *         .channelId("channelId")
 *         .channelRoleArn("channelRoleArn")
 *         .notifyOnCaseSeverity("notifyOnCaseSeverity")
 *         .teamId("teamId")
 *         // the properties below are optional
 *         .channelName("channelName")
 *         .notifyOnAddCorrespondenceToCase(false)
 *         .notifyOnCreateOrReopenCase(false)
 *         .notifyOnResolveCase(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.104.0 (build e79254c)", date = "2024-11-21T06:34:17.028Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_supportapp.CfnSlackChannelConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnSlackChannelConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSlackChannelConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The channel ID in Slack.
     * <p>
     * This ID identifies a channel within a Slack workspace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelId();

    /**
     * The Amazon Resource Name (ARN) of the IAM role for this Slack channel configuration.
     * <p>
     * The AWS Support App uses this role to perform AWS Support and Service Quotas actions on your behalf.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getChannelRoleArn();

    /**
     * The case severity for your support cases that you want to receive notifications.
     * <p>
     * You can specify <code>none</code> , <code>all</code> , or <code>high</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncaseseverity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncaseseverity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNotifyOnCaseSeverity();

    /**
     * The team ID in Slack.
     * <p>
     * This ID uniquely identifies a Slack workspace.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-teamid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-teamid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTeamId();

    /**
     * The channel name in Slack.
     * <p>
     * This is the channel where you invite the AWS Support App .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-channelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getChannelName() {
        return null;
    }

    /**
     * Whether to get notified when a correspondence is added to your support cases.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonaddcorrespondencetocase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonaddcorrespondencetocase</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnAddCorrespondenceToCase() {
        return null;
    }

    /**
     * Whether to get notified when your support cases are created or reopened.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncreateorreopencase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyoncreateorreopencase</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnCreateOrReopenCase() {
        return null;
    }

    /**
     * Whether to get notified when your support cases are resolved.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonresolvecase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-supportapp-slackchannelconfiguration.html#cfn-supportapp-slackchannelconfiguration-notifyonresolvecase</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getNotifyOnResolveCase() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSlackChannelConfigurationProps> {
        java.lang.String channelId;
        java.lang.String channelRoleArn;
        java.lang.String notifyOnCaseSeverity;
        java.lang.String teamId;
        java.lang.String channelName;
        java.lang.Object notifyOnAddCorrespondenceToCase;
        java.lang.Object notifyOnCreateOrReopenCase;
        java.lang.Object notifyOnResolveCase;

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getChannelId}
         * @param channelId The channel ID in Slack. This parameter is required.
         *                  This ID identifies a channel within a Slack workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelId(java.lang.String channelId) {
            this.channelId = channelId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getChannelRoleArn}
         * @param channelRoleArn The Amazon Resource Name (ARN) of the IAM role for this Slack channel configuration. This parameter is required.
         *                       The AWS Support App uses this role to perform AWS Support and Service Quotas actions on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelRoleArn(java.lang.String channelRoleArn) {
            this.channelRoleArn = channelRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getNotifyOnCaseSeverity}
         * @param notifyOnCaseSeverity The case severity for your support cases that you want to receive notifications. This parameter is required.
         *                             You can specify <code>none</code> , <code>all</code> , or <code>high</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCaseSeverity(java.lang.String notifyOnCaseSeverity) {
            this.notifyOnCaseSeverity = notifyOnCaseSeverity;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getTeamId}
         * @param teamId The team ID in Slack. This parameter is required.
         *               This ID uniquely identifies a Slack workspace.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamId(java.lang.String teamId) {
            this.teamId = teamId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getChannelName}
         * @param channelName The channel name in Slack.
         *                    This is the channel where you invite the AWS Support App .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(java.lang.String channelName) {
            this.channelName = channelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getNotifyOnAddCorrespondenceToCase}
         * @param notifyOnAddCorrespondenceToCase Whether to get notified when a correspondence is added to your support cases.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnAddCorrespondenceToCase(java.lang.Boolean notifyOnAddCorrespondenceToCase) {
            this.notifyOnAddCorrespondenceToCase = notifyOnAddCorrespondenceToCase;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getNotifyOnAddCorrespondenceToCase}
         * @param notifyOnAddCorrespondenceToCase Whether to get notified when a correspondence is added to your support cases.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnAddCorrespondenceToCase(software.amazon.awscdk.IResolvable notifyOnAddCorrespondenceToCase) {
            this.notifyOnAddCorrespondenceToCase = notifyOnAddCorrespondenceToCase;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getNotifyOnCreateOrReopenCase}
         * @param notifyOnCreateOrReopenCase Whether to get notified when your support cases are created or reopened.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCreateOrReopenCase(java.lang.Boolean notifyOnCreateOrReopenCase) {
            this.notifyOnCreateOrReopenCase = notifyOnCreateOrReopenCase;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getNotifyOnCreateOrReopenCase}
         * @param notifyOnCreateOrReopenCase Whether to get notified when your support cases are created or reopened.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnCreateOrReopenCase(software.amazon.awscdk.IResolvable notifyOnCreateOrReopenCase) {
            this.notifyOnCreateOrReopenCase = notifyOnCreateOrReopenCase;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getNotifyOnResolveCase}
         * @param notifyOnResolveCase Whether to get notified when your support cases are resolved.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnResolveCase(java.lang.Boolean notifyOnResolveCase) {
            this.notifyOnResolveCase = notifyOnResolveCase;
            return this;
        }

        /**
         * Sets the value of {@link CfnSlackChannelConfigurationProps#getNotifyOnResolveCase}
         * @param notifyOnResolveCase Whether to get notified when your support cases are resolved.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifyOnResolveCase(software.amazon.awscdk.IResolvable notifyOnResolveCase) {
            this.notifyOnResolveCase = notifyOnResolveCase;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSlackChannelConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSlackChannelConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSlackChannelConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSlackChannelConfigurationProps {
        private final java.lang.String channelId;
        private final java.lang.String channelRoleArn;
        private final java.lang.String notifyOnCaseSeverity;
        private final java.lang.String teamId;
        private final java.lang.String channelName;
        private final java.lang.Object notifyOnAddCorrespondenceToCase;
        private final java.lang.Object notifyOnCreateOrReopenCase;
        private final java.lang.Object notifyOnResolveCase;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelId = software.amazon.jsii.Kernel.get(this, "channelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.channelRoleArn = software.amazon.jsii.Kernel.get(this, "channelRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notifyOnCaseSeverity = software.amazon.jsii.Kernel.get(this, "notifyOnCaseSeverity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.teamId = software.amazon.jsii.Kernel.get(this, "teamId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.channelName = software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notifyOnAddCorrespondenceToCase = software.amazon.jsii.Kernel.get(this, "notifyOnAddCorrespondenceToCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notifyOnCreateOrReopenCase = software.amazon.jsii.Kernel.get(this, "notifyOnCreateOrReopenCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.notifyOnResolveCase = software.amazon.jsii.Kernel.get(this, "notifyOnResolveCase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelId = java.util.Objects.requireNonNull(builder.channelId, "channelId is required");
            this.channelRoleArn = java.util.Objects.requireNonNull(builder.channelRoleArn, "channelRoleArn is required");
            this.notifyOnCaseSeverity = java.util.Objects.requireNonNull(builder.notifyOnCaseSeverity, "notifyOnCaseSeverity is required");
            this.teamId = java.util.Objects.requireNonNull(builder.teamId, "teamId is required");
            this.channelName = builder.channelName;
            this.notifyOnAddCorrespondenceToCase = builder.notifyOnAddCorrespondenceToCase;
            this.notifyOnCreateOrReopenCase = builder.notifyOnCreateOrReopenCase;
            this.notifyOnResolveCase = builder.notifyOnResolveCase;
        }

        @Override
        public final java.lang.String getChannelId() {
            return this.channelId;
        }

        @Override
        public final java.lang.String getChannelRoleArn() {
            return this.channelRoleArn;
        }

        @Override
        public final java.lang.String getNotifyOnCaseSeverity() {
            return this.notifyOnCaseSeverity;
        }

        @Override
        public final java.lang.String getTeamId() {
            return this.teamId;
        }

        @Override
        public final java.lang.String getChannelName() {
            return this.channelName;
        }

        @Override
        public final java.lang.Object getNotifyOnAddCorrespondenceToCase() {
            return this.notifyOnAddCorrespondenceToCase;
        }

        @Override
        public final java.lang.Object getNotifyOnCreateOrReopenCase() {
            return this.notifyOnCreateOrReopenCase;
        }

        @Override
        public final java.lang.Object getNotifyOnResolveCase() {
            return this.notifyOnResolveCase;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("channelId", om.valueToTree(this.getChannelId()));
            data.set("channelRoleArn", om.valueToTree(this.getChannelRoleArn()));
            data.set("notifyOnCaseSeverity", om.valueToTree(this.getNotifyOnCaseSeverity()));
            data.set("teamId", om.valueToTree(this.getTeamId()));
            if (this.getChannelName() != null) {
                data.set("channelName", om.valueToTree(this.getChannelName()));
            }
            if (this.getNotifyOnAddCorrespondenceToCase() != null) {
                data.set("notifyOnAddCorrespondenceToCase", om.valueToTree(this.getNotifyOnAddCorrespondenceToCase()));
            }
            if (this.getNotifyOnCreateOrReopenCase() != null) {
                data.set("notifyOnCreateOrReopenCase", om.valueToTree(this.getNotifyOnCreateOrReopenCase()));
            }
            if (this.getNotifyOnResolveCase() != null) {
                data.set("notifyOnResolveCase", om.valueToTree(this.getNotifyOnResolveCase()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_supportapp.CfnSlackChannelConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSlackChannelConfigurationProps.Jsii$Proxy that = (CfnSlackChannelConfigurationProps.Jsii$Proxy) o;

            if (!channelId.equals(that.channelId)) return false;
            if (!channelRoleArn.equals(that.channelRoleArn)) return false;
            if (!notifyOnCaseSeverity.equals(that.notifyOnCaseSeverity)) return false;
            if (!teamId.equals(that.teamId)) return false;
            if (this.channelName != null ? !this.channelName.equals(that.channelName) : that.channelName != null) return false;
            if (this.notifyOnAddCorrespondenceToCase != null ? !this.notifyOnAddCorrespondenceToCase.equals(that.notifyOnAddCorrespondenceToCase) : that.notifyOnAddCorrespondenceToCase != null) return false;
            if (this.notifyOnCreateOrReopenCase != null ? !this.notifyOnCreateOrReopenCase.equals(that.notifyOnCreateOrReopenCase) : that.notifyOnCreateOrReopenCase != null) return false;
            return this.notifyOnResolveCase != null ? this.notifyOnResolveCase.equals(that.notifyOnResolveCase) : that.notifyOnResolveCase == null;
        }

        @Override
        public final int hashCode() {
            int result = this.channelId.hashCode();
            result = 31 * result + (this.channelRoleArn.hashCode());
            result = 31 * result + (this.notifyOnCaseSeverity.hashCode());
            result = 31 * result + (this.teamId.hashCode());
            result = 31 * result + (this.channelName != null ? this.channelName.hashCode() : 0);
            result = 31 * result + (this.notifyOnAddCorrespondenceToCase != null ? this.notifyOnAddCorrespondenceToCase.hashCode() : 0);
            result = 31 * result + (this.notifyOnCreateOrReopenCase != null ? this.notifyOnCreateOrReopenCase.hashCode() : 0);
            result = 31 * result + (this.notifyOnResolveCase != null ? this.notifyOnResolveCase.hashCode() : 0);
            return result;
        }
    }
}
