/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.elasticloadbalancingv2;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.ec2.Connections;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.ec2.SubnetSelection;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.BaseNetworkListenerProps;
import software.amazon.awscdk.services.elasticloadbalancingv2.ClientRoutingPolicy;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer;
import software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerMetrics;
import software.amazon.awscdk.services.elasticloadbalancingv2.IpAddressType;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkListener;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerAttributes;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerLookupOptions;
import software.amazon.awscdk.services.elasticloadbalancingv2.NetworkLoadBalancerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_elasticloadbalancingv2.NetworkLoadBalancer")
public class NetworkLoadBalancer
extends BaseLoadBalancer
implements INetworkLoadBalancer {
    protected NetworkLoadBalancer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NetworkLoadBalancer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public NetworkLoadBalancer(@NotNull Construct scope, @NotNull String id, @NotNull NetworkLoadBalancerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static INetworkLoadBalancer fromLookup(@NotNull Construct scope, @NotNull String id, @NotNull NetworkLoadBalancerLookupOptions options) {
        return (INetworkLoadBalancer)JsiiObject.jsiiStaticCall(NetworkLoadBalancer.class, (String)"fromLookup", (NativeType)NativeType.forClass(INetworkLoadBalancer.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @NotNull
    public static INetworkLoadBalancer fromNetworkLoadBalancerAttributes(@NotNull Construct scope, @NotNull String id, @NotNull NetworkLoadBalancerAttributes attrs) {
        return (INetworkLoadBalancer)JsiiObject.jsiiStaticCall(NetworkLoadBalancer.class, (String)"fromNetworkLoadBalancerAttributes", (NativeType)NativeType.forClass(INetworkLoadBalancer.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public NetworkListener addListener(@NotNull String id, @NotNull BaseNetworkListenerProps props) {
        return (NetworkListener)Kernel.call((Object)this, (String)"addListener", (NativeType)NativeType.forClass(NetworkListener.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void addSecurityGroup(@NotNull ISecurityGroup securityGroup) {
        Kernel.call((Object)this, (String)"addSecurityGroup", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(securityGroup, "securityGroup is required")});
    }

    @Deprecated
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Deprecated
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Deprecated
    @NotNull
    public Metric metricActiveFlowCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricActiveFlowCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricActiveFlowCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricActiveFlowCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricConsumedLCUs(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedLCUs", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricConsumedLCUs() {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedLCUs", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricNewFlowCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricNewFlowCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricNewFlowCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricNewFlowCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricProcessedBytes(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricProcessedBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricProcessedBytes() {
        return (Metric)Kernel.call((Object)this, (String)"metricProcessedBytes", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTcpClientResetCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTcpClientResetCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTcpClientResetCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricTcpClientResetCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTcpElbResetCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTcpElbResetCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTcpElbResetCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricTcpElbResetCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricTcpTargetResetCount(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricTcpTargetResetCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricTcpTargetResetCount() {
        return (Metric)Kernel.call((Object)this, (String)"metricTcpTargetResetCount", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Connections getConnections() {
        return (Connections)Kernel.get((Object)this, (String)"connections", (NativeType)NativeType.forClass(Connections.class));
    }

    @Override
    @NotNull
    public INetworkLoadBalancerMetrics getMetrics() {
        return (INetworkLoadBalancerMetrics)Kernel.get((Object)this, (String)"metrics", (NativeType)NativeType.forClass(INetworkLoadBalancerMetrics.class));
    }

    @Override
    @Nullable
    public String getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
        return (String)Kernel.get((Object)this, (String)"enforceSecurityGroupInboundRulesOnPrivateLinkTraffic", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public IpAddressType getIpAddressType() {
        return (IpAddressType)((Object)Kernel.get((Object)this, (String)"ipAddressType", (NativeType)NativeType.forClass(IpAddressType.class)));
    }

    @Override
    @Nullable
    public List<String> getSecurityGroups() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"securityGroups", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<NetworkLoadBalancer> {
        private final Construct scope;
        private final String id;
        private final NetworkLoadBalancerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new NetworkLoadBalancerProps.Builder();
        }

        public Builder vpc(IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        public Builder crossZoneEnabled(Boolean crossZoneEnabled) {
            this.props.crossZoneEnabled(crossZoneEnabled);
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        public Builder denyAllIgwTraffic(Boolean denyAllIgwTraffic) {
            this.props.denyAllIgwTraffic(denyAllIgwTraffic);
            return this;
        }

        public Builder internetFacing(Boolean internetFacing) {
            this.props.internetFacing(internetFacing);
            return this;
        }

        public Builder loadBalancerName(String loadBalancerName) {
            this.props.loadBalancerName(loadBalancerName);
            return this;
        }

        public Builder vpcSubnets(SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        public Builder clientRoutingPolicy(ClientRoutingPolicy clientRoutingPolicy) {
            this.props.clientRoutingPolicy(clientRoutingPolicy);
            return this;
        }

        public Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(Boolean enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.props.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
            return this;
        }

        public Builder ipAddressType(IpAddressType ipAddressType) {
            this.props.ipAddressType(ipAddressType);
            return this;
        }

        public Builder securityGroups(List<? extends ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        public Builder zonalShift(Boolean zonalShift) {
            this.props.zonalShift(zonalShift);
            return this;
        }

        public NetworkLoadBalancer build() {
            return new NetworkLoadBalancer(this.scope, this.id, this.props.build());
        }
    }
}

