/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.iam;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.services.iam.Effect;
import software.amazon.awscdk.services.iam.IPrincipal;
import software.amazon.awscdk.services.iam.PolicyStatementProps;
import software.amazon.awscdk.services.iam.ServicePrincipalOpts;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_iam.PolicyStatement")
public class PolicyStatement
extends JsiiObject {
    protected PolicyStatement(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PolicyStatement(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PolicyStatement(@Nullable PolicyStatementProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{props});
    }

    public PolicyStatement() {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[0]);
    }

    @NotNull
    public static PolicyStatement fromJson(@NotNull Object obj) {
        return (PolicyStatement)((Object)JsiiObject.jsiiStaticCall(PolicyStatement.class, (String)"fromJson", (NativeType)NativeType.forClass(PolicyStatement.class), (Object[])new Object[]{obj}));
    }

    public void addAccountCondition(@NotNull String accountId) {
        Kernel.call((Object)((Object)this), (String)"addAccountCondition", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addAccountRootPrincipal() {
        Kernel.call((Object)((Object)this), (String)"addAccountRootPrincipal", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void addActions(String ... actions) {
        Kernel.call((Object)((Object)this), (String)"addActions", (NativeType)NativeType.VOID, (Object[])Arrays.stream(actions).toArray(Object[]::new));
    }

    public void addAllResources() {
        Kernel.call((Object)((Object)this), (String)"addAllResources", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void addAnyPrincipal() {
        Kernel.call((Object)((Object)this), (String)"addAnyPrincipal", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    public void addArnPrincipal(@NotNull String arn) {
        Kernel.call((Object)((Object)this), (String)"addArnPrincipal", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    public void addAwsAccountPrincipal(@NotNull String accountId) {
        Kernel.call((Object)((Object)this), (String)"addAwsAccountPrincipal", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addCanonicalUserPrincipal(@NotNull String canonicalUserId) {
        Kernel.call((Object)((Object)this), (String)"addCanonicalUserPrincipal", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(canonicalUserId, "canonicalUserId is required")});
    }

    public void addCondition(@NotNull String key, @NotNull Object value) {
        Kernel.call((Object)((Object)this), (String)"addCondition", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(key, "key is required"), value});
    }

    public void addConditions(@NotNull Map<String, Object> conditions) {
        Kernel.call((Object)((Object)this), (String)"addConditions", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(conditions, "conditions is required")});
    }

    public void addFederatedPrincipal(@NotNull Object federated, @NotNull Map<String, Object> conditions) {
        Kernel.call((Object)((Object)this), (String)"addFederatedPrincipal", (NativeType)NativeType.VOID, (Object[])new Object[]{federated, Objects.requireNonNull(conditions, "conditions is required")});
    }

    public void addNotActions(String ... notActions) {
        Kernel.call((Object)((Object)this), (String)"addNotActions", (NativeType)NativeType.VOID, (Object[])Arrays.stream(notActions).toArray(Object[]::new));
    }

    public void addNotPrincipals(IPrincipal ... notPrincipals) {
        Kernel.call((Object)((Object)this), (String)"addNotPrincipals", (NativeType)NativeType.VOID, (Object[])Arrays.stream(notPrincipals).toArray(Object[]::new));
    }

    public void addNotResources(String ... arns) {
        Kernel.call((Object)((Object)this), (String)"addNotResources", (NativeType)NativeType.VOID, (Object[])Arrays.stream(arns).toArray(Object[]::new));
    }

    public void addPrincipals(IPrincipal ... principals) {
        Kernel.call((Object)((Object)this), (String)"addPrincipals", (NativeType)NativeType.VOID, (Object[])Arrays.stream(principals).toArray(Object[]::new));
    }

    public void addResources(String ... arns) {
        Kernel.call((Object)((Object)this), (String)"addResources", (NativeType)NativeType.VOID, (Object[])Arrays.stream(arns).toArray(Object[]::new));
    }

    public void addServicePrincipal(@NotNull String service, @Nullable ServicePrincipalOpts opts) {
        Kernel.call((Object)((Object)this), (String)"addServicePrincipal", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(service, "service is required"), opts});
    }

    public void addServicePrincipal(@NotNull String service) {
        Kernel.call((Object)((Object)this), (String)"addServicePrincipal", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(service, "service is required")});
    }

    public void addSourceAccountCondition(@NotNull String accountId) {
        Kernel.call((Object)((Object)this), (String)"addSourceAccountCondition", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(accountId, "accountId is required")});
    }

    public void addSourceArnCondition(@NotNull String arn) {
        Kernel.call((Object)((Object)this), (String)"addSourceArnCondition", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(arn, "arn is required")});
    }

    @NotNull
    public PolicyStatement copy(@Nullable PolicyStatementProps overrides) {
        return (PolicyStatement)((Object)Kernel.call((Object)((Object)this), (String)"copy", (NativeType)NativeType.forClass(PolicyStatement.class), (Object[])new Object[]{overrides}));
    }

    @NotNull
    public PolicyStatement copy() {
        return (PolicyStatement)((Object)Kernel.call((Object)((Object)this), (String)"copy", (NativeType)NativeType.forClass(PolicyStatement.class), (Object[])new Object[0]));
    }

    @NotNull
    public PolicyStatement freeze() {
        return (PolicyStatement)((Object)Kernel.call((Object)((Object)this), (String)"freeze", (NativeType)NativeType.forClass(PolicyStatement.class), (Object[])new Object[0]));
    }

    @NotNull
    public Object toJSON() {
        return Kernel.call((Object)((Object)this), (String)"toJSON", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    public Object toStatementJson() {
        return Kernel.call((Object)((Object)this), (String)"toStatementJson", (NativeType)NativeType.forClass(Object.class), (Object[])new Object[0]);
    }

    @NotNull
    public String toString() {
        return (String)Kernel.call((Object)((Object)this), (String)"toString", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @NotNull
    public List<String> validateForAnyPolicy() {
        return Collections.unmodifiableList((List)Kernel.call((Object)((Object)this), (String)"validateForAnyPolicy", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @NotNull
    public List<String> validateForIdentityPolicy() {
        return Collections.unmodifiableList((List)Kernel.call((Object)((Object)this), (String)"validateForIdentityPolicy", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @NotNull
    public List<String> validateForResourcePolicy() {
        return Collections.unmodifiableList((List)Kernel.call((Object)((Object)this), (String)"validateForResourcePolicy", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)), (Object[])new Object[0]));
    }

    @NotNull
    public List<String> getActions() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"actions", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Object getConditions() {
        return Kernel.get((Object)((Object)this), (String)"conditions", (NativeType)NativeType.forClass(Object.class));
    }

    @NotNull
    public Boolean getFrozen() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"frozen", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getHasPrincipal() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"hasPrincipal", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public Boolean getHasResource() {
        return (Boolean)Kernel.get((Object)((Object)this), (String)"hasResource", (NativeType)NativeType.forClass(Boolean.class));
    }

    @NotNull
    public List<String> getNotActions() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"notActions", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<IPrincipal> getNotPrincipals() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"notPrincipals", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IPrincipal.class))));
    }

    @NotNull
    public List<String> getNotResources() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"notResources", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public List<IPrincipal> getPrincipals() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"principals", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(IPrincipal.class))));
    }

    @NotNull
    public List<String> getResources() {
        return Collections.unmodifiableList((List)Kernel.get((Object)((Object)this), (String)"resources", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @NotNull
    public Effect getEffect() {
        return (Effect)((Object)Kernel.get((Object)((Object)this), (String)"effect", (NativeType)NativeType.forClass(Effect.class)));
    }

    public void setEffect(@NotNull Effect value) {
        Kernel.set((Object)((Object)this), (String)"effect", (Object)((Object)Objects.requireNonNull(value, "effect is required")));
    }

    @Nullable
    public String getSid() {
        return (String)Kernel.get((Object)((Object)this), (String)"sid", (NativeType)NativeType.forClass(String.class));
    }

    public void setSid(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"sid", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<PolicyStatement> {
        private PolicyStatementProps.Builder props;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder actions(List<String> actions) {
            this.props().actions(actions);
            return this;
        }

        public Builder conditions(Map<String, ? extends Object> conditions) {
            this.props().conditions(conditions);
            return this;
        }

        public Builder effect(Effect effect) {
            this.props().effect(effect);
            return this;
        }

        public Builder notActions(List<String> notActions) {
            this.props().notActions(notActions);
            return this;
        }

        public Builder notPrincipals(List<? extends IPrincipal> notPrincipals) {
            this.props().notPrincipals(notPrincipals);
            return this;
        }

        public Builder notResources(List<String> notResources) {
            this.props().notResources(notResources);
            return this;
        }

        public Builder principals(List<? extends IPrincipal> principals) {
            this.props().principals(principals);
            return this;
        }

        public Builder resources(List<String> resources) {
            this.props().resources(resources);
            return this;
        }

        public Builder sid(String sid) {
            this.props().sid(sid);
            return this;
        }

        public PolicyStatement build() {
            return new PolicyStatement(this.props != null ? this.props.build() : null);
        }

        private PolicyStatementProps.Builder props() {
            if (this.props == null) {
                this.props = new PolicyStatementProps.Builder();
            }
            return this.props;
        }
    }
}

