/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.pipes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.pipes.CfnPipe;
import software.amazon.awscdk.services.pipes.CfnPipeProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe")
public class CfnPipe
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnPipe.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnPipe(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPipe(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnPipe(@NotNull Construct scope, @NotNull String id, @NotNull CfnPipeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCreationTime() {
        return (String)Kernel.get((Object)this, (String)"attrCreationTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrCurrentState() {
        return (String)Kernel.get((Object)this, (String)"attrCurrentState", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrLastModifiedTime() {
        return (String)Kernel.get((Object)this, (String)"attrLastModifiedTime", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrStateReason() {
        return (String)Kernel.get((Object)this, (String)"attrStateReason", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getRoleArn() {
        return (String)Kernel.get((Object)this, (String)"roleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"roleArn", (Object)Objects.requireNonNull(value, "roleArn is required"));
    }

    @NotNull
    public String getSource() {
        return (String)Kernel.get((Object)this, (String)"source", (NativeType)NativeType.forClass(String.class));
    }

    public void setSource(@NotNull String value) {
        Kernel.set((Object)this, (String)"source", (Object)Objects.requireNonNull(value, "source is required"));
    }

    @NotNull
    public String getTarget() {
        return (String)Kernel.get((Object)this, (String)"target", (NativeType)NativeType.forClass(String.class));
    }

    public void setTarget(@NotNull String value) {
        Kernel.set((Object)this, (String)"target", (Object)Objects.requireNonNull(value, "target is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public String getDesiredState() {
        return (String)Kernel.get((Object)this, (String)"desiredState", (NativeType)NativeType.forClass(String.class));
    }

    public void setDesiredState(@Nullable String value) {
        Kernel.set((Object)this, (String)"desiredState", (Object)value);
    }

    @Nullable
    public String getEnrichment() {
        return (String)Kernel.get((Object)this, (String)"enrichment", (NativeType)NativeType.forClass(String.class));
    }

    public void setEnrichment(@Nullable String value) {
        Kernel.set((Object)this, (String)"enrichment", (Object)value);
    }

    @Nullable
    public Object getEnrichmentParameters() {
        return Kernel.get((Object)this, (String)"enrichmentParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEnrichmentParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"enrichmentParameters", (Object)value);
    }

    public void setEnrichmentParameters(@Nullable PipeEnrichmentParametersProperty value) {
        Kernel.set((Object)this, (String)"enrichmentParameters", (Object)value);
    }

    @Nullable
    public String getKmsKeyIdentifier() {
        return (String)Kernel.get((Object)this, (String)"kmsKeyIdentifier", (NativeType)NativeType.forClass(String.class));
    }

    public void setKmsKeyIdentifier(@Nullable String value) {
        Kernel.set((Object)this, (String)"kmsKeyIdentifier", (Object)value);
    }

    @Nullable
    public Object getLogConfiguration() {
        return Kernel.get((Object)this, (String)"logConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLogConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"logConfiguration", (Object)value);
    }

    public void setLogConfiguration(@Nullable PipeLogConfigurationProperty value) {
        Kernel.set((Object)this, (String)"logConfiguration", (Object)value);
    }

    @Nullable
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@Nullable String value) {
        Kernel.set((Object)this, (String)"name", (Object)value);
    }

    @Nullable
    public Object getSourceParameters() {
        return Kernel.get((Object)this, (String)"sourceParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSourceParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"sourceParameters", (Object)value);
    }

    public void setSourceParameters(@Nullable PipeSourceParametersProperty value) {
        Kernel.set((Object)this, (String)"sourceParameters", (Object)value);
    }

    @Nullable
    public Map<String, String> getTagsRaw() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTagsRaw(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Nullable
    public Object getTargetParameters() {
        return Kernel.get((Object)this, (String)"targetParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTargetParameters(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"targetParameters", (Object)value);
    }

    public void setTargetParameters(@Nullable PipeTargetParametersProperty value) {
        Kernel.set((Object)this, (String)"targetParameters", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnPipe> {
        private final Construct scope;
        private final String id;
        private final CfnPipeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnPipeProps.Builder();
        }

        public Builder roleArn(String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        public Builder source(String source) {
            this.props.source(source);
            return this;
        }

        public Builder target(String target) {
            this.props.target(target);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder desiredState(String desiredState) {
            this.props.desiredState(desiredState);
            return this;
        }

        public Builder enrichment(String enrichment) {
            this.props.enrichment(enrichment);
            return this;
        }

        public Builder enrichmentParameters(IResolvable enrichmentParameters) {
            this.props.enrichmentParameters(enrichmentParameters);
            return this;
        }

        public Builder enrichmentParameters(PipeEnrichmentParametersProperty enrichmentParameters) {
            this.props.enrichmentParameters(enrichmentParameters);
            return this;
        }

        public Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.props.kmsKeyIdentifier(kmsKeyIdentifier);
            return this;
        }

        public Builder logConfiguration(IResolvable logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }

        public Builder logConfiguration(PipeLogConfigurationProperty logConfiguration) {
            this.props.logConfiguration(logConfiguration);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder sourceParameters(IResolvable sourceParameters) {
            this.props.sourceParameters(sourceParameters);
            return this;
        }

        public Builder sourceParameters(PipeSourceParametersProperty sourceParameters) {
            this.props.sourceParameters(sourceParameters);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder targetParameters(IResolvable targetParameters) {
            this.props.targetParameters(targetParameters);
            return this;
        }

        public Builder targetParameters(PipeTargetParametersProperty targetParameters) {
            this.props.targetParameters(targetParameters);
            return this;
        }

        public CfnPipe build() {
            return new CfnPipe(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.SingleMeasureMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SingleMeasureMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getMeasureName();

        @NotNull
        public String getMeasureValue();

        @NotNull
        public String getMeasureValueType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SingleMeasureMappingProperty> {
            String measureName;
            String measureValue;
            String measureValueType;

            public Builder measureName(String measureName) {
                this.measureName = measureName;
                return this;
            }

            public Builder measureValue(String measureValue) {
                this.measureValue = measureValue;
                return this;
            }

            public Builder measureValueType(String measureValueType) {
                this.measureValueType = measureValueType;
                return this;
            }

            public SingleMeasureMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.SelfManagedKafkaAccessConfigurationVpcProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SelfManagedKafkaAccessConfigurationVpcProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getSecurityGroup() {
            return null;
        }

        @Nullable
        default public List<String> getSubnets() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SelfManagedKafkaAccessConfigurationVpcProperty> {
            List<String> securityGroup;
            List<String> subnets;

            public Builder securityGroup(List<String> securityGroup) {
                this.securityGroup = securityGroup;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public SelfManagedKafkaAccessConfigurationVpcProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.SelfManagedKafkaAccessConfigurationCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SelfManagedKafkaAccessConfigurationCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBasicAuth() {
            return null;
        }

        @Nullable
        default public String getClientCertificateTlsAuth() {
            return null;
        }

        @Nullable
        default public String getSaslScram256Auth() {
            return null;
        }

        @Nullable
        default public String getSaslScram512Auth() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SelfManagedKafkaAccessConfigurationCredentialsProperty> {
            String basicAuth;
            String clientCertificateTlsAuth;
            String saslScram256Auth;
            String saslScram512Auth;

            public Builder basicAuth(String basicAuth) {
                this.basicAuth = basicAuth;
                return this;
            }

            public Builder clientCertificateTlsAuth(String clientCertificateTlsAuth) {
                this.clientCertificateTlsAuth = clientCertificateTlsAuth;
                return this;
            }

            public Builder saslScram256Auth(String saslScram256Auth) {
                this.saslScram256Auth = saslScram256Auth;
                return this;
            }

            public Builder saslScram512Auth(String saslScram512Auth) {
                this.saslScram512Auth = saslScram512Auth;
                return this;
            }

            public SelfManagedKafkaAccessConfigurationCredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.SageMakerPipelineParameterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SageMakerPipelineParameterProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SageMakerPipelineParameterProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public SageMakerPipelineParameterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.S3LogDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LogDestinationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getBucketName() {
            return null;
        }

        @Nullable
        default public String getBucketOwner() {
            return null;
        }

        @Nullable
        default public String getOutputFormat() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LogDestinationProperty> {
            String bucketName;
            String bucketOwner;
            String outputFormat;
            String prefix;

            public Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            public Builder bucketOwner(String bucketOwner) {
                this.bucketOwner = bucketOwner;
                return this;
            }

            public Builder outputFormat(String outputFormat) {
                this.outputFormat = outputFormat;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public S3LogDestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PlacementStrategyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementStrategyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getField() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementStrategyProperty> {
            String field;
            String type;

            public Builder field(String field) {
                this.field = field;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public PlacementStrategyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PlacementConstraintProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PlacementConstraintProperty
    extends JsiiSerializable {
        @Nullable
        default public String getExpression() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PlacementConstraintProperty> {
            String expression;
            String type;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public PlacementConstraintProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetTimestreamParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetTimestreamParametersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDimensionMappings();

        @NotNull
        public String getTimeValue();

        @NotNull
        public String getVersionValue();

        @Nullable
        default public String getEpochTimeUnit() {
            return null;
        }

        @Nullable
        default public Object getMultiMeasureMappings() {
            return null;
        }

        @Nullable
        default public Object getSingleMeasureMappings() {
            return null;
        }

        @Nullable
        default public String getTimeFieldType() {
            return null;
        }

        @Nullable
        default public String getTimestampFormat() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetTimestreamParametersProperty> {
            Object dimensionMappings;
            String timeValue;
            String versionValue;
            String epochTimeUnit;
            Object multiMeasureMappings;
            Object singleMeasureMappings;
            String timeFieldType;
            String timestampFormat;

            public Builder dimensionMappings(IResolvable dimensionMappings) {
                this.dimensionMappings = dimensionMappings;
                return this;
            }

            public Builder dimensionMappings(List<? extends Object> dimensionMappings) {
                this.dimensionMappings = dimensionMappings;
                return this;
            }

            public Builder timeValue(String timeValue) {
                this.timeValue = timeValue;
                return this;
            }

            public Builder versionValue(String versionValue) {
                this.versionValue = versionValue;
                return this;
            }

            public Builder epochTimeUnit(String epochTimeUnit) {
                this.epochTimeUnit = epochTimeUnit;
                return this;
            }

            public Builder multiMeasureMappings(IResolvable multiMeasureMappings) {
                this.multiMeasureMappings = multiMeasureMappings;
                return this;
            }

            public Builder multiMeasureMappings(List<? extends Object> multiMeasureMappings) {
                this.multiMeasureMappings = multiMeasureMappings;
                return this;
            }

            public Builder singleMeasureMappings(IResolvable singleMeasureMappings) {
                this.singleMeasureMappings = singleMeasureMappings;
                return this;
            }

            public Builder singleMeasureMappings(List<? extends Object> singleMeasureMappings) {
                this.singleMeasureMappings = singleMeasureMappings;
                return this;
            }

            public Builder timeFieldType(String timeFieldType) {
                this.timeFieldType = timeFieldType;
                return this;
            }

            public Builder timestampFormat(String timestampFormat) {
                this.timestampFormat = timestampFormat;
                return this;
            }

            public PipeTargetTimestreamParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetStateMachineParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetStateMachineParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInvocationType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetStateMachineParametersProperty> {
            String invocationType;

            public Builder invocationType(String invocationType) {
                this.invocationType = invocationType;
                return this;
            }

            public PipeTargetStateMachineParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetSqsQueueParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetSqsQueueParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMessageDeduplicationId() {
            return null;
        }

        @Nullable
        default public String getMessageGroupId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetSqsQueueParametersProperty> {
            String messageDeduplicationId;
            String messageGroupId;

            public Builder messageDeduplicationId(String messageDeduplicationId) {
                this.messageDeduplicationId = messageDeduplicationId;
                return this;
            }

            public Builder messageGroupId(String messageGroupId) {
                this.messageGroupId = messageGroupId;
                return this;
            }

            public PipeTargetSqsQueueParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetSageMakerPipelineParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetSageMakerPipelineParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPipelineParameterList() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetSageMakerPipelineParametersProperty> {
            Object pipelineParameterList;

            public Builder pipelineParameterList(IResolvable pipelineParameterList) {
                this.pipelineParameterList = pipelineParameterList;
                return this;
            }

            public Builder pipelineParameterList(List<? extends Object> pipelineParameterList) {
                this.pipelineParameterList = pipelineParameterList;
                return this;
            }

            public PipeTargetSageMakerPipelineParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetRedshiftDataParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetRedshiftDataParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getDatabase();

        @NotNull
        public List<String> getSqls();

        @Nullable
        default public String getDbUser() {
            return null;
        }

        @Nullable
        default public String getSecretManagerArn() {
            return null;
        }

        @Nullable
        default public String getStatementName() {
            return null;
        }

        @Nullable
        default public Object getWithEvent() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetRedshiftDataParametersProperty> {
            String database;
            List<String> sqls;
            String dbUser;
            String secretManagerArn;
            String statementName;
            Object withEvent;

            public Builder database(String database) {
                this.database = database;
                return this;
            }

            public Builder sqls(List<String> sqls) {
                this.sqls = sqls;
                return this;
            }

            public Builder dbUser(String dbUser) {
                this.dbUser = dbUser;
                return this;
            }

            public Builder secretManagerArn(String secretManagerArn) {
                this.secretManagerArn = secretManagerArn;
                return this;
            }

            public Builder statementName(String statementName) {
                this.statementName = statementName;
                return this;
            }

            public Builder withEvent(Boolean withEvent) {
                this.withEvent = withEvent;
                return this;
            }

            public Builder withEvent(IResolvable withEvent) {
                this.withEvent = withEvent;
                return this;
            }

            public PipeTargetRedshiftDataParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getBatchJobParameters() {
            return null;
        }

        @Nullable
        default public Object getCloudWatchLogsParameters() {
            return null;
        }

        @Nullable
        default public Object getEcsTaskParameters() {
            return null;
        }

        @Nullable
        default public Object getEventBridgeEventBusParameters() {
            return null;
        }

        @Nullable
        default public Object getHttpParameters() {
            return null;
        }

        @Nullable
        default public String getInputTemplate() {
            return null;
        }

        @Nullable
        default public Object getKinesisStreamParameters() {
            return null;
        }

        @Nullable
        default public Object getLambdaFunctionParameters() {
            return null;
        }

        @Nullable
        default public Object getRedshiftDataParameters() {
            return null;
        }

        @Nullable
        default public Object getSageMakerPipelineParameters() {
            return null;
        }

        @Nullable
        default public Object getSqsQueueParameters() {
            return null;
        }

        @Nullable
        default public Object getStepFunctionStateMachineParameters() {
            return null;
        }

        @Nullable
        default public Object getTimestreamParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetParametersProperty> {
            Object batchJobParameters;
            Object cloudWatchLogsParameters;
            Object ecsTaskParameters;
            Object eventBridgeEventBusParameters;
            Object httpParameters;
            String inputTemplate;
            Object kinesisStreamParameters;
            Object lambdaFunctionParameters;
            Object redshiftDataParameters;
            Object sageMakerPipelineParameters;
            Object sqsQueueParameters;
            Object stepFunctionStateMachineParameters;
            Object timestreamParameters;

            public Builder batchJobParameters(IResolvable batchJobParameters) {
                this.batchJobParameters = batchJobParameters;
                return this;
            }

            public Builder batchJobParameters(PipeTargetBatchJobParametersProperty batchJobParameters) {
                this.batchJobParameters = batchJobParameters;
                return this;
            }

            public Builder cloudWatchLogsParameters(IResolvable cloudWatchLogsParameters) {
                this.cloudWatchLogsParameters = cloudWatchLogsParameters;
                return this;
            }

            public Builder cloudWatchLogsParameters(PipeTargetCloudWatchLogsParametersProperty cloudWatchLogsParameters) {
                this.cloudWatchLogsParameters = cloudWatchLogsParameters;
                return this;
            }

            public Builder ecsTaskParameters(IResolvable ecsTaskParameters) {
                this.ecsTaskParameters = ecsTaskParameters;
                return this;
            }

            public Builder ecsTaskParameters(PipeTargetEcsTaskParametersProperty ecsTaskParameters) {
                this.ecsTaskParameters = ecsTaskParameters;
                return this;
            }

            public Builder eventBridgeEventBusParameters(IResolvable eventBridgeEventBusParameters) {
                this.eventBridgeEventBusParameters = eventBridgeEventBusParameters;
                return this;
            }

            public Builder eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParametersProperty eventBridgeEventBusParameters) {
                this.eventBridgeEventBusParameters = eventBridgeEventBusParameters;
                return this;
            }

            public Builder httpParameters(IResolvable httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            public Builder httpParameters(PipeTargetHttpParametersProperty httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            public Builder inputTemplate(String inputTemplate) {
                this.inputTemplate = inputTemplate;
                return this;
            }

            public Builder kinesisStreamParameters(IResolvable kinesisStreamParameters) {
                this.kinesisStreamParameters = kinesisStreamParameters;
                return this;
            }

            public Builder kinesisStreamParameters(PipeTargetKinesisStreamParametersProperty kinesisStreamParameters) {
                this.kinesisStreamParameters = kinesisStreamParameters;
                return this;
            }

            public Builder lambdaFunctionParameters(IResolvable lambdaFunctionParameters) {
                this.lambdaFunctionParameters = lambdaFunctionParameters;
                return this;
            }

            public Builder lambdaFunctionParameters(PipeTargetLambdaFunctionParametersProperty lambdaFunctionParameters) {
                this.lambdaFunctionParameters = lambdaFunctionParameters;
                return this;
            }

            public Builder redshiftDataParameters(IResolvable redshiftDataParameters) {
                this.redshiftDataParameters = redshiftDataParameters;
                return this;
            }

            public Builder redshiftDataParameters(PipeTargetRedshiftDataParametersProperty redshiftDataParameters) {
                this.redshiftDataParameters = redshiftDataParameters;
                return this;
            }

            public Builder sageMakerPipelineParameters(IResolvable sageMakerPipelineParameters) {
                this.sageMakerPipelineParameters = sageMakerPipelineParameters;
                return this;
            }

            public Builder sageMakerPipelineParameters(PipeTargetSageMakerPipelineParametersProperty sageMakerPipelineParameters) {
                this.sageMakerPipelineParameters = sageMakerPipelineParameters;
                return this;
            }

            public Builder sqsQueueParameters(IResolvable sqsQueueParameters) {
                this.sqsQueueParameters = sqsQueueParameters;
                return this;
            }

            public Builder sqsQueueParameters(PipeTargetSqsQueueParametersProperty sqsQueueParameters) {
                this.sqsQueueParameters = sqsQueueParameters;
                return this;
            }

            public Builder stepFunctionStateMachineParameters(IResolvable stepFunctionStateMachineParameters) {
                this.stepFunctionStateMachineParameters = stepFunctionStateMachineParameters;
                return this;
            }

            public Builder stepFunctionStateMachineParameters(PipeTargetStateMachineParametersProperty stepFunctionStateMachineParameters) {
                this.stepFunctionStateMachineParameters = stepFunctionStateMachineParameters;
                return this;
            }

            public Builder timestreamParameters(IResolvable timestreamParameters) {
                this.timestreamParameters = timestreamParameters;
                return this;
            }

            public Builder timestreamParameters(PipeTargetTimestreamParametersProperty timestreamParameters) {
                this.timestreamParameters = timestreamParameters;
                return this;
            }

            public PipeTargetParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetLambdaFunctionParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetLambdaFunctionParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public String getInvocationType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetLambdaFunctionParametersProperty> {
            String invocationType;

            public Builder invocationType(String invocationType) {
                this.invocationType = invocationType;
                return this;
            }

            public PipeTargetLambdaFunctionParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetKinesisStreamParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetKinesisStreamParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getPartitionKey();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetKinesisStreamParametersProperty> {
            String partitionKey;

            public Builder partitionKey(String partitionKey) {
                this.partitionKey = partitionKey;
                return this;
            }

            public PipeTargetKinesisStreamParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetHttpParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetHttpParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHeaderParameters() {
            return null;
        }

        @Nullable
        default public List<String> getPathParameterValues() {
            return null;
        }

        @Nullable
        default public Object getQueryStringParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetHttpParametersProperty> {
            Object headerParameters;
            List<String> pathParameterValues;
            Object queryStringParameters;

            public Builder headerParameters(IResolvable headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            public Builder headerParameters(Map<String, String> headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            public Builder pathParameterValues(List<String> pathParameterValues) {
                this.pathParameterValues = pathParameterValues;
                return this;
            }

            public Builder queryStringParameters(IResolvable queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            public Builder queryStringParameters(Map<String, String> queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            public PipeTargetHttpParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetEventBridgeEventBusParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetEventBridgeEventBusParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDetailType() {
            return null;
        }

        @Nullable
        default public String getEndpointId() {
            return null;
        }

        @Nullable
        default public List<String> getResources() {
            return null;
        }

        @Nullable
        default public String getSource() {
            return null;
        }

        @Nullable
        default public String getTime() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetEventBridgeEventBusParametersProperty> {
            String detailType;
            String endpointId;
            List<String> resources;
            String source;
            String time;

            public Builder detailType(String detailType) {
                this.detailType = detailType;
                return this;
            }

            public Builder endpointId(String endpointId) {
                this.endpointId = endpointId;
                return this;
            }

            public Builder resources(List<String> resources) {
                this.resources = resources;
                return this;
            }

            public Builder source(String source) {
                this.source = source;
                return this;
            }

            public Builder time(String time) {
                this.time = time;
                return this;
            }

            public PipeTargetEventBridgeEventBusParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetEcsTaskParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetEcsTaskParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getTaskDefinitionArn();

        @Nullable
        default public Object getCapacityProviderStrategy() {
            return null;
        }

        @Nullable
        default public Object getEnableEcsManagedTags() {
            return null;
        }

        @Nullable
        default public Object getEnableExecuteCommand() {
            return null;
        }

        @Nullable
        default public String getGroup() {
            return null;
        }

        @Nullable
        default public String getLaunchType() {
            return null;
        }

        @Nullable
        default public Object getNetworkConfiguration() {
            return null;
        }

        @Nullable
        default public Object getOverrides() {
            return null;
        }

        @Nullable
        default public Object getPlacementConstraints() {
            return null;
        }

        @Nullable
        default public Object getPlacementStrategy() {
            return null;
        }

        @Nullable
        default public String getPlatformVersion() {
            return null;
        }

        @Nullable
        default public String getPropagateTags() {
            return null;
        }

        @Nullable
        default public String getReferenceId() {
            return null;
        }

        @Nullable
        default public List<CfnTag> getTags() {
            return null;
        }

        @Nullable
        default public Number getTaskCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetEcsTaskParametersProperty> {
            String taskDefinitionArn;
            Object capacityProviderStrategy;
            Object enableEcsManagedTags;
            Object enableExecuteCommand;
            String group;
            String launchType;
            Object networkConfiguration;
            Object overrides;
            Object placementConstraints;
            Object placementStrategy;
            String platformVersion;
            String propagateTags;
            String referenceId;
            List<CfnTag> tags;
            Number taskCount;

            public Builder taskDefinitionArn(String taskDefinitionArn) {
                this.taskDefinitionArn = taskDefinitionArn;
                return this;
            }

            public Builder capacityProviderStrategy(IResolvable capacityProviderStrategy) {
                this.capacityProviderStrategy = capacityProviderStrategy;
                return this;
            }

            public Builder capacityProviderStrategy(List<? extends Object> capacityProviderStrategy) {
                this.capacityProviderStrategy = capacityProviderStrategy;
                return this;
            }

            public Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
                this.enableEcsManagedTags = enableEcsManagedTags;
                return this;
            }

            public Builder enableEcsManagedTags(IResolvable enableEcsManagedTags) {
                this.enableEcsManagedTags = enableEcsManagedTags;
                return this;
            }

            public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            public Builder enableExecuteCommand(IResolvable enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            public Builder group(String group) {
                this.group = group;
                return this;
            }

            public Builder launchType(String launchType) {
                this.launchType = launchType;
                return this;
            }

            public Builder networkConfiguration(IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder overrides(IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder overrides(EcsTaskOverrideProperty overrides) {
                this.overrides = overrides;
                return this;
            }

            public Builder placementConstraints(IResolvable placementConstraints) {
                this.placementConstraints = placementConstraints;
                return this;
            }

            public Builder placementConstraints(List<? extends Object> placementConstraints) {
                this.placementConstraints = placementConstraints;
                return this;
            }

            public Builder placementStrategy(IResolvable placementStrategy) {
                this.placementStrategy = placementStrategy;
                return this;
            }

            public Builder placementStrategy(List<? extends Object> placementStrategy) {
                this.placementStrategy = placementStrategy;
                return this;
            }

            public Builder platformVersion(String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            public Builder propagateTags(String propagateTags) {
                this.propagateTags = propagateTags;
                return this;
            }

            public Builder referenceId(String referenceId) {
                this.referenceId = referenceId;
                return this;
            }

            public Builder tags(List<? extends CfnTag> tags) {
                this.tags = tags;
                return this;
            }

            public Builder taskCount(Number taskCount) {
                this.taskCount = taskCount;
                return this;
            }

            public PipeTargetEcsTaskParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetCloudWatchLogsParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetCloudWatchLogsParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLogStreamName() {
            return null;
        }

        @Nullable
        default public String getTimestamp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetCloudWatchLogsParametersProperty> {
            String logStreamName;
            String timestamp;

            public Builder logStreamName(String logStreamName) {
                this.logStreamName = logStreamName;
                return this;
            }

            public Builder timestamp(String timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public PipeTargetCloudWatchLogsParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeTargetBatchJobParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeTargetBatchJobParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getJobDefinition();

        @NotNull
        public String getJobName();

        @Nullable
        default public Object getArrayProperties() {
            return null;
        }

        @Nullable
        default public Object getContainerOverrides() {
            return null;
        }

        @Nullable
        default public Object getDependsOn() {
            return null;
        }

        @Nullable
        default public Object getParameters() {
            return null;
        }

        @Nullable
        default public Object getRetryStrategy() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeTargetBatchJobParametersProperty> {
            String jobDefinition;
            String jobName;
            Object arrayProperties;
            Object containerOverrides;
            Object dependsOn;
            Object parameters;
            Object retryStrategy;

            public Builder jobDefinition(String jobDefinition) {
                this.jobDefinition = jobDefinition;
                return this;
            }

            public Builder jobName(String jobName) {
                this.jobName = jobName;
                return this;
            }

            public Builder arrayProperties(IResolvable arrayProperties) {
                this.arrayProperties = arrayProperties;
                return this;
            }

            public Builder arrayProperties(BatchArrayPropertiesProperty arrayProperties) {
                this.arrayProperties = arrayProperties;
                return this;
            }

            public Builder containerOverrides(IResolvable containerOverrides) {
                this.containerOverrides = containerOverrides;
                return this;
            }

            public Builder containerOverrides(BatchContainerOverridesProperty containerOverrides) {
                this.containerOverrides = containerOverrides;
                return this;
            }

            public Builder dependsOn(IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            public Builder dependsOn(List<? extends Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            public Builder parameters(IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder parameters(Map<String, String> parameters) {
                this.parameters = parameters;
                return this;
            }

            public Builder retryStrategy(IResolvable retryStrategy) {
                this.retryStrategy = retryStrategy;
                return this;
            }

            public Builder retryStrategy(BatchRetryStrategyProperty retryStrategy) {
                this.retryStrategy = retryStrategy;
                return this;
            }

            public PipeTargetBatchJobParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeSourceSqsQueueParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeSourceSqsQueueParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeSourceSqsQueueParametersProperty> {
            Number batchSize;
            Number maximumBatchingWindowInSeconds;

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public PipeSourceSqsQueueParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeSourceSelfManagedKafkaParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeSourceSelfManagedKafkaParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getTopicName();

        @Nullable
        default public List<String> getAdditionalBootstrapServers() {
            return null;
        }

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public String getConsumerGroupId() {
            return null;
        }

        @Nullable
        default public Object getCredentials() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        @Nullable
        default public String getServerRootCaCertificate() {
            return null;
        }

        @Nullable
        default public String getStartingPosition() {
            return null;
        }

        @Nullable
        default public Object getVpc() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeSourceSelfManagedKafkaParametersProperty> {
            String topicName;
            List<String> additionalBootstrapServers;
            Number batchSize;
            String consumerGroupId;
            Object credentials;
            Number maximumBatchingWindowInSeconds;
            String serverRootCaCertificate;
            String startingPosition;
            Object vpc;

            public Builder topicName(String topicName) {
                this.topicName = topicName;
                return this;
            }

            public Builder additionalBootstrapServers(List<String> additionalBootstrapServers) {
                this.additionalBootstrapServers = additionalBootstrapServers;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder consumerGroupId(String consumerGroupId) {
                this.consumerGroupId = consumerGroupId;
                return this;
            }

            public Builder credentials(IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder credentials(SelfManagedKafkaAccessConfigurationCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public Builder serverRootCaCertificate(String serverRootCaCertificate) {
                this.serverRootCaCertificate = serverRootCaCertificate;
                return this;
            }

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder vpc(IResolvable vpc) {
                this.vpc = vpc;
                return this;
            }

            public Builder vpc(SelfManagedKafkaAccessConfigurationVpcProperty vpc) {
                this.vpc = vpc;
                return this;
            }

            public PipeSourceSelfManagedKafkaParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeSourceRabbitMQBrokerParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeSourceRabbitMQBrokerParametersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCredentials();

        @NotNull
        public String getQueueName();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        @Nullable
        default public String getVirtualHost() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeSourceRabbitMQBrokerParametersProperty> {
            Object credentials;
            String queueName;
            Number batchSize;
            Number maximumBatchingWindowInSeconds;
            String virtualHost;

            public Builder credentials(IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder credentials(MQBrokerAccessCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder queueName(String queueName) {
                this.queueName = queueName;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public Builder virtualHost(String virtualHost) {
                this.virtualHost = virtualHost;
                return this;
            }

            public PipeSourceRabbitMQBrokerParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeSourceParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeSourceParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getActiveMqBrokerParameters() {
            return null;
        }

        @Nullable
        default public Object getDynamoDbStreamParameters() {
            return null;
        }

        @Nullable
        default public Object getFilterCriteria() {
            return null;
        }

        @Nullable
        default public Object getKinesisStreamParameters() {
            return null;
        }

        @Nullable
        default public Object getManagedStreamingKafkaParameters() {
            return null;
        }

        @Nullable
        default public Object getRabbitMqBrokerParameters() {
            return null;
        }

        @Nullable
        default public Object getSelfManagedKafkaParameters() {
            return null;
        }

        @Nullable
        default public Object getSqsQueueParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeSourceParametersProperty> {
            Object activeMqBrokerParameters;
            Object dynamoDbStreamParameters;
            Object filterCriteria;
            Object kinesisStreamParameters;
            Object managedStreamingKafkaParameters;
            Object rabbitMqBrokerParameters;
            Object selfManagedKafkaParameters;
            Object sqsQueueParameters;

            public Builder activeMqBrokerParameters(IResolvable activeMqBrokerParameters) {
                this.activeMqBrokerParameters = activeMqBrokerParameters;
                return this;
            }

            public Builder activeMqBrokerParameters(PipeSourceActiveMQBrokerParametersProperty activeMqBrokerParameters) {
                this.activeMqBrokerParameters = activeMqBrokerParameters;
                return this;
            }

            public Builder dynamoDbStreamParameters(IResolvable dynamoDbStreamParameters) {
                this.dynamoDbStreamParameters = dynamoDbStreamParameters;
                return this;
            }

            public Builder dynamoDbStreamParameters(PipeSourceDynamoDBStreamParametersProperty dynamoDbStreamParameters) {
                this.dynamoDbStreamParameters = dynamoDbStreamParameters;
                return this;
            }

            public Builder filterCriteria(IResolvable filterCriteria) {
                this.filterCriteria = filterCriteria;
                return this;
            }

            public Builder filterCriteria(FilterCriteriaProperty filterCriteria) {
                this.filterCriteria = filterCriteria;
                return this;
            }

            public Builder kinesisStreamParameters(IResolvable kinesisStreamParameters) {
                this.kinesisStreamParameters = kinesisStreamParameters;
                return this;
            }

            public Builder kinesisStreamParameters(PipeSourceKinesisStreamParametersProperty kinesisStreamParameters) {
                this.kinesisStreamParameters = kinesisStreamParameters;
                return this;
            }

            public Builder managedStreamingKafkaParameters(IResolvable managedStreamingKafkaParameters) {
                this.managedStreamingKafkaParameters = managedStreamingKafkaParameters;
                return this;
            }

            public Builder managedStreamingKafkaParameters(PipeSourceManagedStreamingKafkaParametersProperty managedStreamingKafkaParameters) {
                this.managedStreamingKafkaParameters = managedStreamingKafkaParameters;
                return this;
            }

            public Builder rabbitMqBrokerParameters(IResolvable rabbitMqBrokerParameters) {
                this.rabbitMqBrokerParameters = rabbitMqBrokerParameters;
                return this;
            }

            public Builder rabbitMqBrokerParameters(PipeSourceRabbitMQBrokerParametersProperty rabbitMqBrokerParameters) {
                this.rabbitMqBrokerParameters = rabbitMqBrokerParameters;
                return this;
            }

            public Builder selfManagedKafkaParameters(IResolvable selfManagedKafkaParameters) {
                this.selfManagedKafkaParameters = selfManagedKafkaParameters;
                return this;
            }

            public Builder selfManagedKafkaParameters(PipeSourceSelfManagedKafkaParametersProperty selfManagedKafkaParameters) {
                this.selfManagedKafkaParameters = selfManagedKafkaParameters;
                return this;
            }

            public Builder sqsQueueParameters(IResolvable sqsQueueParameters) {
                this.sqsQueueParameters = sqsQueueParameters;
                return this;
            }

            public Builder sqsQueueParameters(PipeSourceSqsQueueParametersProperty sqsQueueParameters) {
                this.sqsQueueParameters = sqsQueueParameters;
                return this;
            }

            public PipeSourceParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeSourceManagedStreamingKafkaParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeSourceManagedStreamingKafkaParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getTopicName();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public String getConsumerGroupId() {
            return null;
        }

        @Nullable
        default public Object getCredentials() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        @Nullable
        default public String getStartingPosition() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeSourceManagedStreamingKafkaParametersProperty> {
            String topicName;
            Number batchSize;
            String consumerGroupId;
            Object credentials;
            Number maximumBatchingWindowInSeconds;
            String startingPosition;

            public Builder topicName(String topicName) {
                this.topicName = topicName;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder consumerGroupId(String consumerGroupId) {
                this.consumerGroupId = consumerGroupId;
                return this;
            }

            public Builder credentials(IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder credentials(MSKAccessCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public PipeSourceManagedStreamingKafkaParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeSourceKinesisStreamParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeSourceKinesisStreamParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getStartingPosition();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Object getDeadLetterConfig() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRecordAgeInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRetryAttempts() {
            return null;
        }

        @Nullable
        default public String getOnPartialBatchItemFailure() {
            return null;
        }

        @Nullable
        default public Number getParallelizationFactor() {
            return null;
        }

        @Nullable
        default public String getStartingPositionTimestamp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeSourceKinesisStreamParametersProperty> {
            String startingPosition;
            Number batchSize;
            Object deadLetterConfig;
            Number maximumBatchingWindowInSeconds;
            Number maximumRecordAgeInSeconds;
            Number maximumRetryAttempts;
            String onPartialBatchItemFailure;
            Number parallelizationFactor;
            String startingPositionTimestamp;

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder deadLetterConfig(IResolvable deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            public Builder deadLetterConfig(DeadLetterConfigProperty deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public Builder maximumRecordAgeInSeconds(Number maximumRecordAgeInSeconds) {
                this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
                return this;
            }

            public Builder maximumRetryAttempts(Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            public Builder onPartialBatchItemFailure(String onPartialBatchItemFailure) {
                this.onPartialBatchItemFailure = onPartialBatchItemFailure;
                return this;
            }

            public Builder parallelizationFactor(Number parallelizationFactor) {
                this.parallelizationFactor = parallelizationFactor;
                return this;
            }

            public Builder startingPositionTimestamp(String startingPositionTimestamp) {
                this.startingPositionTimestamp = startingPositionTimestamp;
                return this;
            }

            public PipeSourceKinesisStreamParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeSourceDynamoDBStreamParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeSourceDynamoDBStreamParametersProperty
    extends JsiiSerializable {
        @NotNull
        public String getStartingPosition();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Object getDeadLetterConfig() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRecordAgeInSeconds() {
            return null;
        }

        @Nullable
        default public Number getMaximumRetryAttempts() {
            return null;
        }

        @Nullable
        default public String getOnPartialBatchItemFailure() {
            return null;
        }

        @Nullable
        default public Number getParallelizationFactor() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeSourceDynamoDBStreamParametersProperty> {
            String startingPosition;
            Number batchSize;
            Object deadLetterConfig;
            Number maximumBatchingWindowInSeconds;
            Number maximumRecordAgeInSeconds;
            Number maximumRetryAttempts;
            String onPartialBatchItemFailure;
            Number parallelizationFactor;

            public Builder startingPosition(String startingPosition) {
                this.startingPosition = startingPosition;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder deadLetterConfig(IResolvable deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            public Builder deadLetterConfig(DeadLetterConfigProperty deadLetterConfig) {
                this.deadLetterConfig = deadLetterConfig;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public Builder maximumRecordAgeInSeconds(Number maximumRecordAgeInSeconds) {
                this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
                return this;
            }

            public Builder maximumRetryAttempts(Number maximumRetryAttempts) {
                this.maximumRetryAttempts = maximumRetryAttempts;
                return this;
            }

            public Builder onPartialBatchItemFailure(String onPartialBatchItemFailure) {
                this.onPartialBatchItemFailure = onPartialBatchItemFailure;
                return this;
            }

            public Builder parallelizationFactor(Number parallelizationFactor) {
                this.parallelizationFactor = parallelizationFactor;
                return this;
            }

            public PipeSourceDynamoDBStreamParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeSourceActiveMQBrokerParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeSourceActiveMQBrokerParametersProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCredentials();

        @NotNull
        public String getQueueName();

        @Nullable
        default public Number getBatchSize() {
            return null;
        }

        @Nullable
        default public Number getMaximumBatchingWindowInSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeSourceActiveMQBrokerParametersProperty> {
            Object credentials;
            String queueName;
            Number batchSize;
            Number maximumBatchingWindowInSeconds;

            public Builder credentials(IResolvable credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder credentials(MQBrokerAccessCredentialsProperty credentials) {
                this.credentials = credentials;
                return this;
            }

            public Builder queueName(String queueName) {
                this.queueName = queueName;
                return this;
            }

            public Builder batchSize(Number batchSize) {
                this.batchSize = batchSize;
                return this;
            }

            public Builder maximumBatchingWindowInSeconds(Number maximumBatchingWindowInSeconds) {
                this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
                return this;
            }

            public PipeSourceActiveMQBrokerParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeLogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeLogConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudwatchLogsLogDestination() {
            return null;
        }

        @Nullable
        default public Object getFirehoseLogDestination() {
            return null;
        }

        @Nullable
        default public List<String> getIncludeExecutionData() {
            return null;
        }

        @Nullable
        default public String getLevel() {
            return null;
        }

        @Nullable
        default public Object getS3LogDestination() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeLogConfigurationProperty> {
            Object cloudwatchLogsLogDestination;
            Object firehoseLogDestination;
            List<String> includeExecutionData;
            String level;
            Object s3LogDestination;

            public Builder cloudwatchLogsLogDestination(IResolvable cloudwatchLogsLogDestination) {
                this.cloudwatchLogsLogDestination = cloudwatchLogsLogDestination;
                return this;
            }

            public Builder cloudwatchLogsLogDestination(CloudwatchLogsLogDestinationProperty cloudwatchLogsLogDestination) {
                this.cloudwatchLogsLogDestination = cloudwatchLogsLogDestination;
                return this;
            }

            public Builder firehoseLogDestination(IResolvable firehoseLogDestination) {
                this.firehoseLogDestination = firehoseLogDestination;
                return this;
            }

            public Builder firehoseLogDestination(FirehoseLogDestinationProperty firehoseLogDestination) {
                this.firehoseLogDestination = firehoseLogDestination;
                return this;
            }

            public Builder includeExecutionData(List<String> includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            public Builder level(String level) {
                this.level = level;
                return this;
            }

            public Builder s3LogDestination(IResolvable s3LogDestination) {
                this.s3LogDestination = s3LogDestination;
                return this;
            }

            public Builder s3LogDestination(S3LogDestinationProperty s3LogDestination) {
                this.s3LogDestination = s3LogDestination;
                return this;
            }

            public PipeLogConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeEnrichmentParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeEnrichmentParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHttpParameters() {
            return null;
        }

        @Nullable
        default public String getInputTemplate() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeEnrichmentParametersProperty> {
            Object httpParameters;
            String inputTemplate;

            public Builder httpParameters(IResolvable httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            public Builder httpParameters(PipeEnrichmentHttpParametersProperty httpParameters) {
                this.httpParameters = httpParameters;
                return this;
            }

            public Builder inputTemplate(String inputTemplate) {
                this.inputTemplate = inputTemplate;
                return this;
            }

            public PipeEnrichmentParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.PipeEnrichmentHttpParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PipeEnrichmentHttpParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getHeaderParameters() {
            return null;
        }

        @Nullable
        default public List<String> getPathParameterValues() {
            return null;
        }

        @Nullable
        default public Object getQueryStringParameters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PipeEnrichmentHttpParametersProperty> {
            Object headerParameters;
            List<String> pathParameterValues;
            Object queryStringParameters;

            public Builder headerParameters(IResolvable headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            public Builder headerParameters(Map<String, String> headerParameters) {
                this.headerParameters = headerParameters;
                return this;
            }

            public Builder pathParameterValues(List<String> pathParameterValues) {
                this.pathParameterValues = pathParameterValues;
                return this;
            }

            public Builder queryStringParameters(IResolvable queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            public Builder queryStringParameters(Map<String, String> queryStringParameters) {
                this.queryStringParameters = queryStringParameters;
                return this;
            }

            public PipeEnrichmentHttpParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAwsvpcConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            Object awsvpcConfiguration;

            public Builder awsvpcConfiguration(IResolvable awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            public Builder awsvpcConfiguration(AwsVpcConfigurationProperty awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.MultiMeasureMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultiMeasureMappingProperty
    extends JsiiSerializable {
        @NotNull
        public Object getMultiMeasureAttributeMappings();

        @NotNull
        public String getMultiMeasureName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultiMeasureMappingProperty> {
            Object multiMeasureAttributeMappings;
            String multiMeasureName;

            public Builder multiMeasureAttributeMappings(IResolvable multiMeasureAttributeMappings) {
                this.multiMeasureAttributeMappings = multiMeasureAttributeMappings;
                return this;
            }

            public Builder multiMeasureAttributeMappings(List<? extends Object> multiMeasureAttributeMappings) {
                this.multiMeasureAttributeMappings = multiMeasureAttributeMappings;
                return this;
            }

            public Builder multiMeasureName(String multiMeasureName) {
                this.multiMeasureName = multiMeasureName;
                return this;
            }

            public MultiMeasureMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.MultiMeasureAttributeMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultiMeasureAttributeMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getMeasureValue();

        @NotNull
        public String getMeasureValueType();

        @NotNull
        public String getMultiMeasureAttributeName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultiMeasureAttributeMappingProperty> {
            String measureValue;
            String measureValueType;
            String multiMeasureAttributeName;

            public Builder measureValue(String measureValue) {
                this.measureValue = measureValue;
                return this;
            }

            public Builder measureValueType(String measureValueType) {
                this.measureValueType = measureValueType;
                return this;
            }

            public Builder multiMeasureAttributeName(String multiMeasureAttributeName) {
                this.multiMeasureAttributeName = multiMeasureAttributeName;
                return this;
            }

            public MultiMeasureAttributeMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.MSKAccessCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MSKAccessCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getClientCertificateTlsAuth() {
            return null;
        }

        @Nullable
        default public String getSaslScram512Auth() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MSKAccessCredentialsProperty> {
            String clientCertificateTlsAuth;
            String saslScram512Auth;

            public Builder clientCertificateTlsAuth(String clientCertificateTlsAuth) {
                this.clientCertificateTlsAuth = clientCertificateTlsAuth;
                return this;
            }

            public Builder saslScram512Auth(String saslScram512Auth) {
                this.saslScram512Auth = saslScram512Auth;
                return this;
            }

            public MSKAccessCredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.MQBrokerAccessCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MQBrokerAccessCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getBasicAuth();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MQBrokerAccessCredentialsProperty> {
            String basicAuth;

            public Builder basicAuth(String basicAuth) {
                this.basicAuth = basicAuth;
                return this;
            }

            public MQBrokerAccessCredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.FirehoseLogDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FirehoseLogDestinationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeliveryStreamArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FirehoseLogDestinationProperty> {
            String deliveryStreamArn;

            public Builder deliveryStreamArn(String deliveryStreamArn) {
                this.deliveryStreamArn = deliveryStreamArn;
                return this;
            }

            public FirehoseLogDestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.FilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPattern() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterProperty> {
            String pattern;

            public Builder pattern(String pattern) {
                this.pattern = pattern;
                return this;
            }

            public FilterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.FilterCriteriaProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FilterCriteriaProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FilterCriteriaProperty> {
            Object filters;

            public Builder filters(IResolvable filters) {
                this.filters = filters;
                return this;
            }

            public Builder filters(List<? extends Object> filters) {
                this.filters = filters;
                return this;
            }

            public FilterCriteriaProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.EcsTaskOverrideProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsTaskOverrideProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getContainerOverrides() {
            return null;
        }

        @Nullable
        default public String getCpu() {
            return null;
        }

        @Nullable
        default public Object getEphemeralStorage() {
            return null;
        }

        @Nullable
        default public String getExecutionRoleArn() {
            return null;
        }

        @Nullable
        default public Object getInferenceAcceleratorOverrides() {
            return null;
        }

        @Nullable
        default public String getMemory() {
            return null;
        }

        @Nullable
        default public String getTaskRoleArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsTaskOverrideProperty> {
            Object containerOverrides;
            String cpu;
            Object ephemeralStorage;
            String executionRoleArn;
            Object inferenceAcceleratorOverrides;
            String memory;
            String taskRoleArn;

            public Builder containerOverrides(IResolvable containerOverrides) {
                this.containerOverrides = containerOverrides;
                return this;
            }

            public Builder containerOverrides(List<? extends Object> containerOverrides) {
                this.containerOverrides = containerOverrides;
                return this;
            }

            public Builder cpu(String cpu) {
                this.cpu = cpu;
                return this;
            }

            public Builder ephemeralStorage(IResolvable ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            public Builder ephemeralStorage(EcsEphemeralStorageProperty ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            public Builder executionRoleArn(String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            public Builder inferenceAcceleratorOverrides(IResolvable inferenceAcceleratorOverrides) {
                this.inferenceAcceleratorOverrides = inferenceAcceleratorOverrides;
                return this;
            }

            public Builder inferenceAcceleratorOverrides(List<? extends Object> inferenceAcceleratorOverrides) {
                this.inferenceAcceleratorOverrides = inferenceAcceleratorOverrides;
                return this;
            }

            public Builder memory(String memory) {
                this.memory = memory;
                return this;
            }

            public Builder taskRoleArn(String taskRoleArn) {
                this.taskRoleArn = taskRoleArn;
                return this;
            }

            public EcsTaskOverrideProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.EcsResourceRequirementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsResourceRequirementProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsResourceRequirementProperty> {
            String type;
            String value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EcsResourceRequirementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.EcsInferenceAcceleratorOverrideProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsInferenceAcceleratorOverrideProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDeviceName() {
            return null;
        }

        @Nullable
        default public String getDeviceType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsInferenceAcceleratorOverrideProperty> {
            String deviceName;
            String deviceType;

            public Builder deviceName(String deviceName) {
                this.deviceName = deviceName;
                return this;
            }

            public Builder deviceType(String deviceType) {
                this.deviceType = deviceType;
                return this;
            }

            public EcsInferenceAcceleratorOverrideProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.EcsEphemeralStorageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsEphemeralStorageProperty
    extends JsiiSerializable {
        @NotNull
        public Number getSizeInGiB();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsEphemeralStorageProperty> {
            Number sizeInGiB;

            public Builder sizeInGiB(Number sizeInGiB) {
                this.sizeInGiB = sizeInGiB;
                return this;
            }

            public EcsEphemeralStorageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.EcsEnvironmentVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsEnvironmentVariableProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsEnvironmentVariableProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EcsEnvironmentVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.EcsEnvironmentFileProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsEnvironmentFileProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsEnvironmentFileProperty> {
            String type;
            String value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EcsEnvironmentFileProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.EcsContainerOverrideProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsContainerOverrideProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public Number getCpu() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public Object getEnvironmentFiles() {
            return null;
        }

        @Nullable
        default public Number getMemory() {
            return null;
        }

        @Nullable
        default public Number getMemoryReservation() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getResourceRequirements() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsContainerOverrideProperty> {
            List<String> command;
            Number cpu;
            Object environment;
            Object environmentFiles;
            Number memory;
            Number memoryReservation;
            String name;
            Object resourceRequirements;

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder cpu(Number cpu) {
                this.cpu = cpu;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(List<? extends Object> environment) {
                this.environment = environment;
                return this;
            }

            public Builder environmentFiles(IResolvable environmentFiles) {
                this.environmentFiles = environmentFiles;
                return this;
            }

            public Builder environmentFiles(List<? extends Object> environmentFiles) {
                this.environmentFiles = environmentFiles;
                return this;
            }

            public Builder memory(Number memory) {
                this.memory = memory;
                return this;
            }

            public Builder memoryReservation(Number memoryReservation) {
                this.memoryReservation = memoryReservation;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder resourceRequirements(IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder resourceRequirements(List<? extends Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public EcsContainerOverrideProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.DimensionMappingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DimensionMappingProperty
    extends JsiiSerializable {
        @NotNull
        public String getDimensionName();

        @NotNull
        public String getDimensionValue();

        @NotNull
        public String getDimensionValueType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DimensionMappingProperty> {
            String dimensionName;
            String dimensionValue;
            String dimensionValueType;

            public Builder dimensionName(String dimensionName) {
                this.dimensionName = dimensionName;
                return this;
            }

            public Builder dimensionValue(String dimensionValue) {
                this.dimensionValue = dimensionValue;
                return this;
            }

            public Builder dimensionValueType(String dimensionValueType) {
                this.dimensionValueType = dimensionValueType;
                return this;
            }

            public DimensionMappingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.DeadLetterConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeadLetterConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeadLetterConfigProperty> {
            String arn;

            public Builder arn(String arn) {
                this.arn = arn;
                return this;
            }

            public DeadLetterConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.CloudwatchLogsLogDestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudwatchLogsLogDestinationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLogGroupArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudwatchLogsLogDestinationProperty> {
            String logGroupArn;

            public Builder logGroupArn(String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            public CloudwatchLogsLogDestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityProviderStrategyItemProperty
    extends JsiiSerializable {
        @NotNull
        public String getCapacityProvider();

        @Nullable
        default public Number getBase() {
            return null;
        }

        @Nullable
        default public Number getWeight() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            String capacityProvider;
            Number base;
            Number weight;

            public Builder capacityProvider(String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            public Builder base(Number base) {
                this.base = base;
                return this;
            }

            public Builder weight(Number weight) {
                this.weight = weight;
                return this;
            }

            public CapacityProviderStrategyItemProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.BatchRetryStrategyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchRetryStrategyProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAttempts() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BatchRetryStrategyProperty> {
            Number attempts;

            public Builder attempts(Number attempts) {
                this.attempts = attempts;
                return this;
            }

            public BatchRetryStrategyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.BatchResourceRequirementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchResourceRequirementProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BatchResourceRequirementProperty> {
            String type;
            String value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public BatchResourceRequirementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.BatchJobDependencyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchJobDependencyProperty
    extends JsiiSerializable {
        @Nullable
        default public String getJobId() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BatchJobDependencyProperty> {
            String jobId;
            String type;

            public Builder jobId(String jobId) {
                this.jobId = jobId;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public BatchJobDependencyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.BatchEnvironmentVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchEnvironmentVariableProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BatchEnvironmentVariableProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public BatchEnvironmentVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.BatchContainerOverridesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchContainerOverridesProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public Object getResourceRequirements() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BatchContainerOverridesProperty> {
            List<String> command;
            Object environment;
            String instanceType;
            Object resourceRequirements;

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(List<? extends Object> environment) {
                this.environment = environment;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder resourceRequirements(IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder resourceRequirements(List<? extends Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public BatchContainerOverridesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.BatchArrayPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BatchArrayPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getSize() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BatchArrayPropertiesProperty> {
            Number size;

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public BatchArrayPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_pipes.CfnPipe.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AwsVpcConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSubnets();

        @Nullable
        default public String getAssignPublicIp() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroups() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            List<String> subnets;
            String assignPublicIp;
            List<String> securityGroups;

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public Builder assignPublicIp(String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public AwsVpcConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

