package software.amazon.awscdk.alexa.ask;

/**
 * A CloudFormation `Alexa::ASK::Skill`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.alexa.ask.*;
 * Object manifest;
 * CfnSkill cfnSkill = CfnSkill.Builder.create(this, "MyCfnSkill")
 *         .authenticationConfiguration(AuthenticationConfigurationProperty.builder()
 *                 .clientId("clientId")
 *                 .clientSecret("clientSecret")
 *                 .refreshToken("refreshToken")
 *                 .build())
 *         .skillPackage(SkillPackageProperty.builder()
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 // the properties below are optional
 *                 .overrides(OverridesProperty.builder()
 *                         .manifest(manifest)
 *                         .build())
 *                 .s3BucketRole("s3BucketRole")
 *                 .s3ObjectVersion("s3ObjectVersion")
 *                 .build())
 *         .vendorId("vendorId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:43.122Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.alexa_ask.CfnSkill")
public class CfnSkill extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSkill(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSkill(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.alexa.ask.CfnSkill.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `Alexa::ASK::Skill`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSkill(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.alexa.ask.CfnSkillProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `Alexa::ASK::Skill.AuthenticationConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `Alexa::ASK::Skill.AuthenticationConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.alexa.ask.CfnSkill.AuthenticationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "authenticationConfiguration", java.util.Objects.requireNonNull(value, "authenticationConfiguration is required"));
    }

    /**
     * `Alexa::ASK::Skill.AuthenticationConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authenticationConfiguration", java.util.Objects.requireNonNull(value, "authenticationConfiguration is required"));
    }

    /**
     * `Alexa::ASK::Skill.SkillPackage`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSkillPackage() {
        return software.amazon.jsii.Kernel.get(this, "skillPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `Alexa::ASK::Skill.SkillPackage`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSkillPackage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.alexa.ask.CfnSkill.SkillPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "skillPackage", java.util.Objects.requireNonNull(value, "skillPackage is required"));
    }

    /**
     * `Alexa::ASK::Skill.SkillPackage`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSkillPackage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "skillPackage", java.util.Objects.requireNonNull(value, "skillPackage is required"));
    }

    /**
     * `Alexa::ASK::Skill.VendorId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVendorId() {
        return software.amazon.jsii.Kernel.get(this, "vendorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `Alexa::ASK::Skill.VendorId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVendorId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vendorId", java.util.Objects.requireNonNull(value, "vendorId is required"));
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.alexa.ask.*;
     * AuthenticationConfigurationProperty authenticationConfigurationProperty = AuthenticationConfigurationProperty.builder()
     *         .clientId("clientId")
     *         .clientSecret("clientSecret")
     *         .refreshToken("refreshToken")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.alexa_ask.CfnSkill.AuthenticationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AuthenticationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AuthenticationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSkill.AuthenticationConfigurationProperty.ClientId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientId();

        /**
         * `CfnSkill.AuthenticationConfigurationProperty.ClientSecret`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getClientSecret();

        /**
         * `CfnSkill.AuthenticationConfigurationProperty.RefreshToken`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRefreshToken();

        /**
         * @return a {@link Builder} of {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AuthenticationConfigurationProperty> {
            java.lang.String clientId;
            java.lang.String clientSecret;
            java.lang.String refreshToken;

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getClientId}
             * @param clientId `CfnSkill.AuthenticationConfigurationProperty.ClientId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientId(java.lang.String clientId) {
                this.clientId = clientId;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getClientSecret}
             * @param clientSecret `CfnSkill.AuthenticationConfigurationProperty.ClientSecret`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSecret(java.lang.String clientSecret) {
                this.clientSecret = clientSecret;
                return this;
            }

            /**
             * Sets the value of {@link AuthenticationConfigurationProperty#getRefreshToken}
             * @param refreshToken `CfnSkill.AuthenticationConfigurationProperty.RefreshToken`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder refreshToken(java.lang.String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AuthenticationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AuthenticationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AuthenticationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AuthenticationConfigurationProperty {
            private final java.lang.String clientId;
            private final java.lang.String clientSecret;
            private final java.lang.String refreshToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientSecret = software.amazon.jsii.Kernel.get(this, "clientSecret", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.refreshToken = software.amazon.jsii.Kernel.get(this, "refreshToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
                this.clientSecret = java.util.Objects.requireNonNull(builder.clientSecret, "clientSecret is required");
                this.refreshToken = java.util.Objects.requireNonNull(builder.refreshToken, "refreshToken is required");
            }

            @Override
            public final java.lang.String getClientId() {
                return this.clientId;
            }

            @Override
            public final java.lang.String getClientSecret() {
                return this.clientSecret;
            }

            @Override
            public final java.lang.String getRefreshToken() {
                return this.refreshToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientId", om.valueToTree(this.getClientId()));
                data.set("clientSecret", om.valueToTree(this.getClientSecret()));
                data.set("refreshToken", om.valueToTree(this.getRefreshToken()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.alexa_ask.CfnSkill.AuthenticationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AuthenticationConfigurationProperty.Jsii$Proxy that = (AuthenticationConfigurationProperty.Jsii$Proxy) o;

                if (!clientId.equals(that.clientId)) return false;
                if (!clientSecret.equals(that.clientSecret)) return false;
                return this.refreshToken.equals(that.refreshToken);
            }

            @Override
            public final int hashCode() {
                int result = this.clientId.hashCode();
                result = 31 * result + (this.clientSecret.hashCode());
                result = 31 * result + (this.refreshToken.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.alexa.ask.*;
     * Object manifest;
     * OverridesProperty overridesProperty = OverridesProperty.builder()
     *         .manifest(manifest)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.alexa_ask.CfnSkill.OverridesProperty")
    @software.amazon.jsii.Jsii.Proxy(OverridesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OverridesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSkill.OverridesProperty.Manifest`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManifest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OverridesProperty> {
            java.lang.Object manifest;

            /**
             * Sets the value of {@link OverridesProperty#getManifest}
             * @param manifest `CfnSkill.OverridesProperty.Manifest`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifest(java.lang.Object manifest) {
                this.manifest = manifest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OverridesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OverridesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OverridesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OverridesProperty {
            private final java.lang.Object manifest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifest = software.amazon.jsii.Kernel.get(this, "manifest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifest = builder.manifest;
            }

            @Override
            public final java.lang.Object getManifest() {
                return this.manifest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManifest() != null) {
                    data.set("manifest", om.valueToTree(this.getManifest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.alexa_ask.CfnSkill.OverridesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OverridesProperty.Jsii$Proxy that = (OverridesProperty.Jsii$Proxy) o;

                return this.manifest != null ? this.manifest.equals(that.manifest) : that.manifest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifest != null ? this.manifest.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.alexa.ask.*;
     * Object manifest;
     * SkillPackageProperty skillPackageProperty = SkillPackageProperty.builder()
     *         .s3Bucket("s3Bucket")
     *         .s3Key("s3Key")
     *         // the properties below are optional
     *         .overrides(OverridesProperty.builder()
     *                 .manifest(manifest)
     *                 .build())
     *         .s3BucketRole("s3BucketRole")
     *         .s3ObjectVersion("s3ObjectVersion")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.alexa_ask.CfnSkill.SkillPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(SkillPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SkillPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnSkill.SkillPackageProperty.S3Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

        /**
         * `CfnSkill.SkillPackageProperty.S3Key`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getS3Key();

        /**
         * `CfnSkill.SkillPackageProperty.Overrides`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * `CfnSkill.SkillPackageProperty.S3BucketRole`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3BucketRole() {
            return null;
        }

        /**
         * `CfnSkill.SkillPackageProperty.S3ObjectVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3ObjectVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SkillPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SkillPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SkillPackageProperty> {
            java.lang.String s3Bucket;
            java.lang.String s3Key;
            java.lang.Object overrides;
            java.lang.String s3BucketRole;
            java.lang.String s3ObjectVersion;

            /**
             * Sets the value of {@link SkillPackageProperty#getS3Bucket}
             * @param s3Bucket `CfnSkill.SkillPackageProperty.S3Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Bucket(java.lang.String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            /**
             * Sets the value of {@link SkillPackageProperty#getS3Key}
             * @param s3Key `CfnSkill.SkillPackageProperty.S3Key`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Key(java.lang.String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            /**
             * Sets the value of {@link SkillPackageProperty#getOverrides}
             * @param overrides `CfnSkill.SkillPackageProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.alexa.ask.CfnSkill.OverridesProperty overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link SkillPackageProperty#getOverrides}
             * @param overrides `CfnSkill.SkillPackageProperty.Overrides`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(software.amazon.awscdk.IResolvable overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link SkillPackageProperty#getS3BucketRole}
             * @param s3BucketRole `CfnSkill.SkillPackageProperty.S3BucketRole`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3BucketRole(java.lang.String s3BucketRole) {
                this.s3BucketRole = s3BucketRole;
                return this;
            }

            /**
             * Sets the value of {@link SkillPackageProperty#getS3ObjectVersion}
             * @param s3ObjectVersion `CfnSkill.SkillPackageProperty.S3ObjectVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3ObjectVersion(java.lang.String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SkillPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SkillPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SkillPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SkillPackageProperty {
            private final java.lang.String s3Bucket;
            private final java.lang.String s3Key;
            private final java.lang.Object overrides;
            private final java.lang.String s3BucketRole;
            private final java.lang.String s3ObjectVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3Key = software.amazon.jsii.Kernel.get(this, "s3Key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3BucketRole = software.amazon.jsii.Kernel.get(this, "s3BucketRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3ObjectVersion = software.amazon.jsii.Kernel.get(this, "s3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
                this.s3Key = java.util.Objects.requireNonNull(builder.s3Key, "s3Key is required");
                this.overrides = builder.overrides;
                this.s3BucketRole = builder.s3BucketRole;
                this.s3ObjectVersion = builder.s3ObjectVersion;
            }

            @Override
            public final java.lang.String getS3Bucket() {
                return this.s3Bucket;
            }

            @Override
            public final java.lang.String getS3Key() {
                return this.s3Key;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            public final java.lang.String getS3BucketRole() {
                return this.s3BucketRole;
            }

            @Override
            public final java.lang.String getS3ObjectVersion() {
                return this.s3ObjectVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
                data.set("s3Key", om.valueToTree(this.getS3Key()));
                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }
                if (this.getS3BucketRole() != null) {
                    data.set("s3BucketRole", om.valueToTree(this.getS3BucketRole()));
                }
                if (this.getS3ObjectVersion() != null) {
                    data.set("s3ObjectVersion", om.valueToTree(this.getS3ObjectVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.alexa_ask.CfnSkill.SkillPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SkillPackageProperty.Jsii$Proxy that = (SkillPackageProperty.Jsii$Proxy) o;

                if (!s3Bucket.equals(that.s3Bucket)) return false;
                if (!s3Key.equals(that.s3Key)) return false;
                if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) return false;
                if (this.s3BucketRole != null ? !this.s3BucketRole.equals(that.s3BucketRole) : that.s3BucketRole != null) return false;
                return this.s3ObjectVersion != null ? this.s3ObjectVersion.equals(that.s3ObjectVersion) : that.s3ObjectVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3Bucket.hashCode();
                result = 31 * result + (this.s3Key.hashCode());
                result = 31 * result + (this.overrides != null ? this.overrides.hashCode() : 0);
                result = 31 * result + (this.s3BucketRole != null ? this.s3BucketRole.hashCode() : 0);
                result = 31 * result + (this.s3ObjectVersion != null ? this.s3ObjectVersion.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.alexa.ask.CfnSkill}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.alexa.ask.CfnSkill> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.alexa.ask.CfnSkillProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.alexa.ask.CfnSkillProps.Builder();
        }

        /**
         * `Alexa::ASK::Skill.AuthenticationConfiguration`.
         * <p>
         * @return {@code this}
         * @param authenticationConfiguration `Alexa::ASK::Skill.AuthenticationConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationConfiguration(final software.amazon.awscdk.alexa.ask.CfnSkill.AuthenticationConfigurationProperty authenticationConfiguration) {
            this.props.authenticationConfiguration(authenticationConfiguration);
            return this;
        }
        /**
         * `Alexa::ASK::Skill.AuthenticationConfiguration`.
         * <p>
         * @return {@code this}
         * @param authenticationConfiguration `Alexa::ASK::Skill.AuthenticationConfiguration`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationConfiguration(final software.amazon.awscdk.IResolvable authenticationConfiguration) {
            this.props.authenticationConfiguration(authenticationConfiguration);
            return this;
        }

        /**
         * `Alexa::ASK::Skill.SkillPackage`.
         * <p>
         * @return {@code this}
         * @param skillPackage `Alexa::ASK::Skill.SkillPackage`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skillPackage(final software.amazon.awscdk.alexa.ask.CfnSkill.SkillPackageProperty skillPackage) {
            this.props.skillPackage(skillPackage);
            return this;
        }
        /**
         * `Alexa::ASK::Skill.SkillPackage`.
         * <p>
         * @return {@code this}
         * @param skillPackage `Alexa::ASK::Skill.SkillPackage`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skillPackage(final software.amazon.awscdk.IResolvable skillPackage) {
            this.props.skillPackage(skillPackage);
            return this;
        }

        /**
         * `Alexa::ASK::Skill.VendorId`.
         * <p>
         * @return {@code this}
         * @param vendorId `Alexa::ASK::Skill.VendorId`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vendorId(final java.lang.String vendorId) {
            this.props.vendorId(vendorId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.alexa.ask.CfnSkill}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.alexa.ask.CfnSkill build() {
            return new software.amazon.awscdk.alexa.ask.CfnSkill(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
