package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * // We define the JSON Schema for the transformed valid response
 * Model responseModel = api.addModel("ResponseModel", ModelOptions.builder()
 *         .contentType("application/json")
 *         .modelName("ResponseModel")
 *         .schema(JsonSchema.builder()
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("pollResponse")
 *                 .type(JsonSchemaType.OBJECT)
 *                 .properties(Map.of(
 *                         "state", JsonSchema.builder().type(JsonSchemaType.STRING).build(),
 *                         "greeting", JsonSchema.builder().type(JsonSchemaType.STRING).build()))
 *                 .build())
 *         .build());
 * // We define the JSON Schema for the transformed error response
 * Model errorResponseModel = api.addModel("ErrorResponseModel", ModelOptions.builder()
 *         .contentType("application/json")
 *         .modelName("ErrorResponseModel")
 *         .schema(JsonSchema.builder()
 *                 .schema(JsonSchemaVersion.DRAFT4)
 *                 .title("errorResponse")
 *                 .type(JsonSchemaType.OBJECT)
 *                 .properties(Map.of(
 *                         "state", JsonSchema.builder().type(JsonSchemaType.STRING).build(),
 *                         "message", JsonSchema.builder().type(JsonSchemaType.STRING).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:43.356Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.JsonSchemaVersion")
public enum JsonSchemaVersion {
    /**
     * In API Gateway models are defined using the JSON schema draft 4.
     * <p>
     * @see https://tools.ietf.org/html/draft-zyp-json-schema-04
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DRAFT4,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DRAFT7,
}
