package software.amazon.awscdk.services.applicationautoscaling;

/**
 * Schedule for scheduled scaling actions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.autoscaling.*;
 * Function fn;
 * Alias alias = Alias.Builder.create(this, "Alias")
 *         .aliasName("prod")
 *         .version(fn.getLatestVersion())
 *         .build();
 * // Create AutoScaling target
 * IScalableFunctionAttribute as = alias.addAutoScaling(AutoScalingOptions.builder().maxCapacity(50).build());
 * // Configure Target Tracking
 * as.scaleOnUtilization(UtilizationScalingOptions.builder()
 *         .utilizationTarget(0.5)
 *         .build());
 * // Configure Scheduled Scaling
 * as.scaleOnSchedule("ScaleUpInTheMorning", ScalingSchedule.builder()
 *         .schedule(Schedule.cron(CronOptions.builder().hour("8").minute("0").build()))
 *         .minCapacity(20)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:43.581Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.Schedule")
public abstract class Schedule extends software.amazon.jsii.JsiiObject {

    protected Schedule(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Schedule(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Schedule() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Construct a Schedule from a moment in time.
     * <p>
     * @param moment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.Schedule at(final @org.jetbrains.annotations.NotNull java.time.Instant moment) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.applicationautoscaling.Schedule.class, "at", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.Schedule.class), new Object[] { java.util.Objects.requireNonNull(moment, "moment is required") });
    }

    /**
     * Create a schedule from a set of cron fields.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.Schedule cron(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.CronOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.applicationautoscaling.Schedule.class, "cron", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.Schedule.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Construct a schedule from a literal schedule expression.
     * <p>
     * @param expression The expression to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.Schedule expression(final @org.jetbrains.annotations.NotNull java.lang.String expression) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.applicationautoscaling.Schedule.class, "expression", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.Schedule.class), new Object[] { java.util.Objects.requireNonNull(expression, "expression is required") });
    }

    /**
     * Construct a schedule from an interval and a time unit.
     * <p>
     * @param duration This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.Schedule rate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration duration) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.applicationautoscaling.Schedule.class, "rate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.Schedule.class), new Object[] { java.util.Objects.requireNonNull(duration, "duration is required") });
    }

    /**
     * Retrieve the expression for this schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getExpressionString();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.applicationautoscaling.Schedule {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Retrieve the expression for this schedule.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getExpressionString() {
            return software.amazon.jsii.Kernel.get(this, "expressionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
