package software.amazon.awscdk.services.appmesh;

/**
 * gRPC retry policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * VirtualRouter router;
 * VirtualNode node;
 * router.addRoute("route-grpc-retry", RouteBaseProps.builder()
 *         .routeSpec(RouteSpec.grpc(GrpcRouteSpecOptions.builder()
 *                 .weightedTargets(List.of(WeightedTarget.builder().virtualNode(node).build()))
 *                 .match(GrpcRouteMatch.builder().serviceName("servicename").build())
 *                 .retryPolicy(GrpcRetryPolicy.builder()
 *                         .tcpRetryEvents(List.of(TcpRetryEvent.CONNECTION_ERROR))
 *                         .httpRetryEvents(List.of(HttpRetryEvent.GATEWAY_ERROR))
 *                         // Retry if gRPC responds that the request was cancelled, a resource
 *                         // was exhausted, or if the service is unavailable
 *                         .grpcRetryEvents(List.of(GrpcRetryEvent.CANCELLED, GrpcRetryEvent.RESOURCE_EXHAUSTED, GrpcRetryEvent.UNAVAILABLE))
 *                         .retryAttempts(5)
 *                         .retryTimeout(Duration.seconds(1))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:43.715Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.GrpcRetryPolicy")
@software.amazon.jsii.Jsii.Proxy(GrpcRetryPolicy.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrpcRetryPolicy extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appmesh.HttpRetryPolicy {

    /**
     * gRPC events on which to retry.
     * <p>
     * You must specify at least one value
     * for at least one types of retry events.
     * <p>
     * Default: - no retries for gRPC events
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.GrpcRetryEvent> getGrpcRetryEvents() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrpcRetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrpcRetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrpcRetryPolicy> {
        java.util.List<software.amazon.awscdk.services.appmesh.GrpcRetryEvent> grpcRetryEvents;
        java.lang.Number retryAttempts;
        software.amazon.awscdk.Duration retryTimeout;
        java.util.List<software.amazon.awscdk.services.appmesh.HttpRetryEvent> httpRetryEvents;
        java.util.List<software.amazon.awscdk.services.appmesh.TcpRetryEvent> tcpRetryEvents;

        /**
         * Sets the value of {@link GrpcRetryPolicy#getGrpcRetryEvents}
         * @param grpcRetryEvents gRPC events on which to retry.
         *                        You must specify at least one value
         *                        for at least one types of retry events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder grpcRetryEvents(java.util.List<? extends software.amazon.awscdk.services.appmesh.GrpcRetryEvent> grpcRetryEvents) {
            this.grpcRetryEvents = (java.util.List<software.amazon.awscdk.services.appmesh.GrpcRetryEvent>)grpcRetryEvents;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRetryPolicy#getRetryAttempts}
         * @param retryAttempts The maximum number of retry attempts. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRetryPolicy#getRetryTimeout}
         * @param retryTimeout The timeout for each retry attempt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryTimeout(software.amazon.awscdk.Duration retryTimeout) {
            this.retryTimeout = retryTimeout;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRetryPolicy#getHttpRetryEvents}
         * @param httpRetryEvents Specify HTTP events on which to retry.
         *                        You must specify at least one value
         *                        for at least one types of retry events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder httpRetryEvents(java.util.List<? extends software.amazon.awscdk.services.appmesh.HttpRetryEvent> httpRetryEvents) {
            this.httpRetryEvents = (java.util.List<software.amazon.awscdk.services.appmesh.HttpRetryEvent>)httpRetryEvents;
            return this;
        }

        /**
         * Sets the value of {@link GrpcRetryPolicy#getTcpRetryEvents}
         * @param tcpRetryEvents TCP events on which to retry.
         *                       The event occurs before any processing of a
         *                       request has started and is encountered when the upstream is temporarily or
         *                       permanently unavailable. You must specify at least one value for at least
         *                       one types of retry events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tcpRetryEvents(java.util.List<? extends software.amazon.awscdk.services.appmesh.TcpRetryEvent> tcpRetryEvents) {
            this.tcpRetryEvents = (java.util.List<software.amazon.awscdk.services.appmesh.TcpRetryEvent>)tcpRetryEvents;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrpcRetryPolicy}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrpcRetryPolicy build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrpcRetryPolicy}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRetryPolicy {
        private final java.util.List<software.amazon.awscdk.services.appmesh.GrpcRetryEvent> grpcRetryEvents;
        private final java.lang.Number retryAttempts;
        private final software.amazon.awscdk.Duration retryTimeout;
        private final java.util.List<software.amazon.awscdk.services.appmesh.HttpRetryEvent> httpRetryEvents;
        private final java.util.List<software.amazon.awscdk.services.appmesh.TcpRetryEvent> tcpRetryEvents;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.grpcRetryEvents = software.amazon.jsii.Kernel.get(this, "grpcRetryEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.GrpcRetryEvent.class)));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.retryTimeout = software.amazon.jsii.Kernel.get(this, "retryTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.httpRetryEvents = software.amazon.jsii.Kernel.get(this, "httpRetryEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpRetryEvent.class)));
            this.tcpRetryEvents = software.amazon.jsii.Kernel.get(this, "tcpRetryEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.TcpRetryEvent.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.grpcRetryEvents = (java.util.List<software.amazon.awscdk.services.appmesh.GrpcRetryEvent>)builder.grpcRetryEvents;
            this.retryAttempts = java.util.Objects.requireNonNull(builder.retryAttempts, "retryAttempts is required");
            this.retryTimeout = java.util.Objects.requireNonNull(builder.retryTimeout, "retryTimeout is required");
            this.httpRetryEvents = (java.util.List<software.amazon.awscdk.services.appmesh.HttpRetryEvent>)builder.httpRetryEvents;
            this.tcpRetryEvents = (java.util.List<software.amazon.awscdk.services.appmesh.TcpRetryEvent>)builder.tcpRetryEvents;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.GrpcRetryEvent> getGrpcRetryEvents() {
            return this.grpcRetryEvents;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.Duration getRetryTimeout() {
            return this.retryTimeout;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.HttpRetryEvent> getHttpRetryEvents() {
            return this.httpRetryEvents;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.TcpRetryEvent> getTcpRetryEvents() {
            return this.tcpRetryEvents;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGrpcRetryEvents() != null) {
                data.set("grpcRetryEvents", om.valueToTree(this.getGrpcRetryEvents()));
            }
            data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            data.set("retryTimeout", om.valueToTree(this.getRetryTimeout()));
            if (this.getHttpRetryEvents() != null) {
                data.set("httpRetryEvents", om.valueToTree(this.getHttpRetryEvents()));
            }
            if (this.getTcpRetryEvents() != null) {
                data.set("tcpRetryEvents", om.valueToTree(this.getTcpRetryEvents()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.GrpcRetryPolicy"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrpcRetryPolicy.Jsii$Proxy that = (GrpcRetryPolicy.Jsii$Proxy) o;

            if (this.grpcRetryEvents != null ? !this.grpcRetryEvents.equals(that.grpcRetryEvents) : that.grpcRetryEvents != null) return false;
            if (!retryAttempts.equals(that.retryAttempts)) return false;
            if (!retryTimeout.equals(that.retryTimeout)) return false;
            if (this.httpRetryEvents != null ? !this.httpRetryEvents.equals(that.httpRetryEvents) : that.httpRetryEvents != null) return false;
            return this.tcpRetryEvents != null ? this.tcpRetryEvents.equals(that.tcpRetryEvents) : that.tcpRetryEvents == null;
        }

        @Override
        public final int hashCode() {
            int result = this.grpcRetryEvents != null ? this.grpcRetryEvents.hashCode() : 0;
            result = 31 * result + (this.retryAttempts.hashCode());
            result = 31 * result + (this.retryTimeout.hashCode());
            result = 31 * result + (this.httpRetryEvents != null ? this.httpRetryEvents.hashCode() : 0);
            result = 31 * result + (this.tcpRetryEvents != null ? this.tcpRetryEvents.hashCode() : 0);
            return result;
        }
    }
}
