package software.amazon.awscdk.services.appmesh;

/**
 * Interface with base properties all routers willl inherit.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Mesh mesh;
 * VirtualRouter router = mesh.addVirtualRouter("router", VirtualRouterBaseProps.builder()
 *         .listeners(List.of(VirtualRouterListener.http(8080)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:43.765Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualRouterBaseProps")
@software.amazon.jsii.Jsii.Proxy(VirtualRouterBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualRouterBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Listener specification for the VirtualRouter.
     * <p>
     * Default: - A listener on HTTP port 8080
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appmesh.VirtualRouterListener> getListeners() {
        return null;
    }

    /**
     * The name of the VirtualRouter.
     * <p>
     * Default: - A name is automatically determined
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVirtualRouterName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VirtualRouterBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualRouterBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualRouterBaseProps> {
        java.util.List<software.amazon.awscdk.services.appmesh.VirtualRouterListener> listeners;
        java.lang.String virtualRouterName;

        /**
         * Sets the value of {@link VirtualRouterBaseProps#getListeners}
         * @param listeners Listener specification for the VirtualRouter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder listeners(java.util.List<? extends software.amazon.awscdk.services.appmesh.VirtualRouterListener> listeners) {
            this.listeners = (java.util.List<software.amazon.awscdk.services.appmesh.VirtualRouterListener>)listeners;
            return this;
        }

        /**
         * Sets the value of {@link VirtualRouterBaseProps#getVirtualRouterName}
         * @param virtualRouterName The name of the VirtualRouter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouterName(java.lang.String virtualRouterName) {
            this.virtualRouterName = virtualRouterName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualRouterBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualRouterBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualRouterBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualRouterBaseProps {
        private final java.util.List<software.amazon.awscdk.services.appmesh.VirtualRouterListener> listeners;
        private final java.lang.String virtualRouterName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listeners = software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.VirtualRouterListener.class)));
            this.virtualRouterName = software.amazon.jsii.Kernel.get(this, "virtualRouterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listeners = (java.util.List<software.amazon.awscdk.services.appmesh.VirtualRouterListener>)builder.listeners;
            this.virtualRouterName = builder.virtualRouterName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appmesh.VirtualRouterListener> getListeners() {
            return this.listeners;
        }

        @Override
        public final java.lang.String getVirtualRouterName() {
            return this.virtualRouterName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getListeners() != null) {
                data.set("listeners", om.valueToTree(this.getListeners()));
            }
            if (this.getVirtualRouterName() != null) {
                data.set("virtualRouterName", om.valueToTree(this.getVirtualRouterName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualRouterBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualRouterBaseProps.Jsii$Proxy that = (VirtualRouterBaseProps.Jsii$Proxy) o;

            if (this.listeners != null ? !this.listeners.equals(that.listeners) : that.listeners != null) return false;
            return this.virtualRouterName != null ? this.virtualRouterName.equals(that.virtualRouterName) : that.virtualRouterName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.listeners != null ? this.listeners.hashCode() : 0;
            result = 31 * result + (this.virtualRouterName != null ? this.virtualRouterName.hashCode() : 0);
            return result;
        }
    }
}
