package software.amazon.awscdk.services.appstream;

/**
 * Properties for defining a `CfnAppBlock`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appstream.*;
 * CfnAppBlockProps cfnAppBlockProps = CfnAppBlockProps.builder()
 *         .name("name")
 *         .setupScriptDetails(ScriptDetailsProperty.builder()
 *                 .executablePath("executablePath")
 *                 .scriptS3Location(S3LocationProperty.builder()
 *                         .s3Bucket("s3Bucket")
 *                         .s3Key("s3Key")
 *                         .build())
 *                 .timeoutInSeconds(123)
 *                 // the properties below are optional
 *                 .executableParameters("executableParameters")
 *                 .build())
 *         .sourceS3Location(S3LocationProperty.builder()
 *                 .s3Bucket("s3Bucket")
 *                 .s3Key("s3Key")
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .displayName("displayName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:43.783Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appstream.CfnAppBlockProps")
@software.amazon.jsii.Jsii.Proxy(CfnAppBlockProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAppBlockProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the app block.
     * <p>
     * <em>Pattern</em> : <code>^[a-zA-Z0-9][a-zA-Z0-9_.-]{0,100}$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The setup script details of the app block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSetupScriptDetails();

    /**
     * The source S3 location of the app block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSourceS3Location();

    /**
     * The description of the app block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The display name of the app block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * The tags of the app block.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAppBlockProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAppBlockProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAppBlockProps> {
        java.lang.String name;
        java.lang.Object setupScriptDetails;
        java.lang.Object sourceS3Location;
        java.lang.String description;
        java.lang.String displayName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnAppBlockProps#getName}
         * @param name The name of the app block. This parameter is required.
         *             <em>Pattern</em> : <code>^[a-zA-Z0-9][a-zA-Z0-9_.-]{0,100}$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppBlockProps#getSetupScriptDetails}
         * @param setupScriptDetails The setup script details of the app block. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setupScriptDetails(software.amazon.awscdk.services.appstream.CfnAppBlock.ScriptDetailsProperty setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppBlockProps#getSetupScriptDetails}
         * @param setupScriptDetails The setup script details of the app block. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder setupScriptDetails(software.amazon.awscdk.IResolvable setupScriptDetails) {
            this.setupScriptDetails = setupScriptDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppBlockProps#getSourceS3Location}
         * @param sourceS3Location The source S3 location of the app block. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceS3Location(software.amazon.awscdk.services.appstream.CfnAppBlock.S3LocationProperty sourceS3Location) {
            this.sourceS3Location = sourceS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppBlockProps#getSourceS3Location}
         * @param sourceS3Location The source S3 location of the app block. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceS3Location(software.amazon.awscdk.IResolvable sourceS3Location) {
            this.sourceS3Location = sourceS3Location;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppBlockProps#getDescription}
         * @param description The description of the app block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppBlockProps#getDisplayName}
         * @param displayName The display name of the app block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAppBlockProps#getTags}
         * @param tags The tags of the app block.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAppBlockProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAppBlockProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAppBlockProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAppBlockProps {
        private final java.lang.String name;
        private final java.lang.Object setupScriptDetails;
        private final java.lang.Object sourceS3Location;
        private final java.lang.String description;
        private final java.lang.String displayName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.setupScriptDetails = software.amazon.jsii.Kernel.get(this, "setupScriptDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceS3Location = software.amazon.jsii.Kernel.get(this, "sourceS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.setupScriptDetails = java.util.Objects.requireNonNull(builder.setupScriptDetails, "setupScriptDetails is required");
            this.sourceS3Location = java.util.Objects.requireNonNull(builder.sourceS3Location, "sourceS3Location is required");
            this.description = builder.description;
            this.displayName = builder.displayName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getSetupScriptDetails() {
            return this.setupScriptDetails;
        }

        @Override
        public final java.lang.Object getSourceS3Location() {
            return this.sourceS3Location;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("setupScriptDetails", om.valueToTree(this.getSetupScriptDetails()));
            data.set("sourceS3Location", om.valueToTree(this.getSourceS3Location()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appstream.CfnAppBlockProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAppBlockProps.Jsii$Proxy that = (CfnAppBlockProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!setupScriptDetails.equals(that.setupScriptDetails)) return false;
            if (!sourceS3Location.equals(that.sourceS3Location)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.displayName != null ? !this.displayName.equals(that.displayName) : that.displayName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.setupScriptDetails.hashCode());
            result = 31 * result + (this.sourceS3Location.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
