package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for defining a `CfnScalingPolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * CfnScalingPolicyProps cfnScalingPolicyProps = CfnScalingPolicyProps.builder()
 *         .autoScalingGroupName("autoScalingGroupName")
 *         // the properties below are optional
 *         .adjustmentType("adjustmentType")
 *         .cooldown("cooldown")
 *         .estimatedInstanceWarmup(123)
 *         .metricAggregationType("metricAggregationType")
 *         .minAdjustmentMagnitude(123)
 *         .policyType("policyType")
 *         .predictiveScalingConfiguration(PredictiveScalingConfigurationProperty.builder()
 *                 .metricSpecifications(List.of(PredictiveScalingMetricSpecificationProperty.builder()
 *                         .targetValue(123)
 *                         // the properties below are optional
 *                         .customizedCapacityMetricSpecification(PredictiveScalingCustomizedCapacityMetricProperty.builder()
 *                                 .metricDataQueries(List.of(MetricDataQueryProperty.builder()
 *                                         .id("id")
 *                                         // the properties below are optional
 *                                         .expression("expression")
 *                                         .label("label")
 *                                         .metricStat(MetricStatProperty.builder()
 *                                                 .metric(MetricProperty.builder()
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         // the properties below are optional
 *                                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 // the properties below are optional
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .customizedLoadMetricSpecification(PredictiveScalingCustomizedLoadMetricProperty.builder()
 *                                 .metricDataQueries(List.of(MetricDataQueryProperty.builder()
 *                                         .id("id")
 *                                         // the properties below are optional
 *                                         .expression("expression")
 *                                         .label("label")
 *                                         .metricStat(MetricStatProperty.builder()
 *                                                 .metric(MetricProperty.builder()
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         // the properties below are optional
 *                                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 // the properties below are optional
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .customizedScalingMetricSpecification(PredictiveScalingCustomizedScalingMetricProperty.builder()
 *                                 .metricDataQueries(List.of(MetricDataQueryProperty.builder()
 *                                         .id("id")
 *                                         // the properties below are optional
 *                                         .expression("expression")
 *                                         .label("label")
 *                                         .metricStat(MetricStatProperty.builder()
 *                                                 .metric(MetricProperty.builder()
 *                                                         .metricName("metricName")
 *                                                         .namespace("namespace")
 *                                                         // the properties below are optional
 *                                                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                                                 .name("name")
 *                                                                 .value("value")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .stat("stat")
 *                                                 // the properties below are optional
 *                                                 .unit("unit")
 *                                                 .build())
 *                                         .returnData(false)
 *                                         .build()))
 *                                 .build())
 *                         .predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetricProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPairProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetricProperty.builder()
 *                                 .predefinedMetricType("predefinedMetricType")
 *                                 // the properties below are optional
 *                                 .resourceLabel("resourceLabel")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .maxCapacityBreachBehavior("maxCapacityBreachBehavior")
 *                 .maxCapacityBuffer(123)
 *                 .mode("mode")
 *                 .schedulingBufferTime(123)
 *                 .build())
 *         .scalingAdjustment(123)
 *         .stepAdjustments(List.of(StepAdjustmentProperty.builder()
 *                 .scalingAdjustment(123)
 *                 // the properties below are optional
 *                 .metricIntervalLowerBound(123)
 *                 .metricIntervalUpperBound(123)
 *                 .build()))
 *         .targetTrackingConfiguration(TargetTrackingConfigurationProperty.builder()
 *                 .targetValue(123)
 *                 // the properties below are optional
 *                 .customizedMetricSpecification(CustomizedMetricSpecificationProperty.builder()
 *                         .metricName("metricName")
 *                         .namespace("namespace")
 *                         .statistic("statistic")
 *                         // the properties below are optional
 *                         .dimensions(List.of(MetricDimensionProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .unit("unit")
 *                         .build())
 *                 .disableScaleIn(false)
 *                 .predefinedMetricSpecification(PredefinedMetricSpecificationProperty.builder()
 *                         .predefinedMetricType("predefinedMetricType")
 *                         // the properties below are optional
 *                         .resourceLabel("resourceLabel")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:43.963Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnScalingPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName();

    /**
     * Specifies how the scaling adjustment is interpreted. The valid values are `ChangeInCapacity` , `ExactCapacity` , and `PercentChangeInCapacity` .
     * <p>
     * Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAdjustmentType() {
        return null;
    }

    /**
     * The duration of the policy's cooldown period, in seconds.
     * <p>
     * When a cooldown period is specified here, it overrides the default cooldown period defined for the Auto Scaling group.
     * <p>
     * Valid only if the policy type is <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCooldown() {
        return null;
    }

    /**
     * The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
     * <p>
     * If not provided, the default is to use the value from the default cooldown period for the Auto Scaling group.
     * <p>
     * Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEstimatedInstanceWarmup() {
        return null;
    }

    /**
     * The aggregation type for the CloudWatch metrics.
     * <p>
     * The valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMetricAggregationType() {
        return null;
    }

    /**
     * The minimum value to scale by when the adjustment type is `PercentChangeInCapacity` .
     * <p>
     * For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
     * <p>
     * Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinAdjustmentMagnitude() {
        return null;
    }

    /**
     * One of the following policy types:.
     * <p>
     * <ul>
     * <li><code>TargetTrackingScaling</code></li>
     * <li><code>StepScaling</code></li>
     * <li><code>SimpleScaling</code> (default)</li>
     * <li><code>PredictiveScaling</code></li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling policies</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicyType() {
        return null;
    }

    /**
     * A predictive scaling policy. Provides support for predefined and custom metrics.
     * <p>
     * Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPredictiveScalingConfiguration() {
        return null;
    }

    /**
     * The amount by which to scale, based on the specified adjustment type.
     * <p>
     * A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
     * <p>
     * Required if the policy type is <code>SimpleScaling</code> . (Not used with any other policy type.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getScalingAdjustment() {
        return null;
    }

    /**
     * A set of adjustments that enable you to scale based on the size of the alarm breach.
     * <p>
     * Required if the policy type is <code>StepScaling</code> . (Not used with any other policy type.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStepAdjustments() {
        return null;
    }

    /**
     * A target tracking scaling policy. Includes support for predefined or customized metrics.
     * <p>
     * The following predefined metrics are available:
     * <p>
     * <ul>
     * <li><code>ASGAverageCPUUtilization</code></li>
     * <li><code>ASGAverageNetworkIn</code></li>
     * <li><code>ASGAverageNetworkOut</code></li>
     * <li><code>ALBRequestCountPerTarget</code></li>
     * </ul>
     * <p>
     * If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetTrackingConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnScalingPolicyProps> {
        java.lang.String autoScalingGroupName;
        java.lang.String adjustmentType;
        java.lang.String cooldown;
        java.lang.Number estimatedInstanceWarmup;
        java.lang.String metricAggregationType;
        java.lang.Number minAdjustmentMagnitude;
        java.lang.String policyType;
        java.lang.Object predictiveScalingConfiguration;
        java.lang.Number scalingAdjustment;
        java.lang.Object stepAdjustments;
        java.lang.Object targetTrackingConfiguration;

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getAutoScalingGroupName}
         * @param autoScalingGroupName The name of the Auto Scaling group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(java.lang.String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getAdjustmentType}
         * @param adjustmentType Specifies how the scaling adjustment is interpreted. The valid values are `ChangeInCapacity` , `ExactCapacity` , and `PercentChangeInCapacity` .
         *                       Required if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder adjustmentType(java.lang.String adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getCooldown}
         * @param cooldown The duration of the policy's cooldown period, in seconds.
         *                 When a cooldown period is specified here, it overrides the default cooldown period defined for the Auto Scaling group.
         *                 <p>
         *                 Valid only if the policy type is <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html">Scaling cooldowns for Amazon EC2 Auto Scaling</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(java.lang.String cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getEstimatedInstanceWarmup}
         * @param estimatedInstanceWarmup The estimated time, in seconds, until a newly launched instance can contribute to the CloudWatch metrics.
         *                                If not provided, the default is to use the value from the default cooldown period for the Auto Scaling group.
         *                                <p>
         *                                Valid only if the policy type is <code>TargetTrackingScaling</code> or <code>StepScaling</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder estimatedInstanceWarmup(java.lang.Number estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getMetricAggregationType}
         * @param metricAggregationType The aggregation type for the CloudWatch metrics.
         *                              The valid values are <code>Minimum</code> , <code>Maximum</code> , and <code>Average</code> . If the aggregation type is null, the value is treated as <code>Average</code> .
         *                              <p>
         *                              Valid only if the policy type is <code>StepScaling</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricAggregationType(java.lang.String metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getMinAdjustmentMagnitude}
         * @param minAdjustmentMagnitude The minimum value to scale by when the adjustment type is `PercentChangeInCapacity` .
         *                               For example, suppose that you create a step scaling policy to scale out an Auto Scaling group by 25 percent and you specify a <code>MinAdjustmentMagnitude</code> of 2. If the group has 4 instances and the scaling policy is performed, 25 percent of 4 is 1. However, because you specified a <code>MinAdjustmentMagnitude</code> of 2, Amazon EC2 Auto Scaling scales out the group by 2 instances.
         *                               <p>
         *                               Valid only if the policy type is <code>StepScaling</code> or <code>SimpleScaling</code> . For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-adjustment">Scaling adjustment types</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         *                               <p>
         *                               <blockquote>
         *                               <p>
         *                               Some Auto Scaling groups use instance weights. In this case, set the <code>MinAdjustmentMagnitude</code> to a value that is at least as large as your largest instance weight.
         *                               <p>
         *                               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getPolicyType}
         * @param policyType One of the following policy types:.
         *                   <ul>
         *                   <li><code>TargetTrackingScaling</code></li>
         *                   <li><code>StepScaling</code></li>
         *                   <li><code>SimpleScaling</code> (default)</li>
         *                   <li><code>PredictiveScaling</code></li>
         *                   </ul>
         *                   <p>
         *                   For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html">Target tracking scaling policies</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Step and simple scaling policies</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyType(java.lang.String policyType) {
            this.policyType = policyType;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getPredictiveScalingConfiguration}
         * @param predictiveScalingConfiguration A predictive scaling policy. Provides support for predefined and custom metrics.
         *                                       Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predictiveScalingConfiguration(software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.PredictiveScalingConfigurationProperty predictiveScalingConfiguration) {
            this.predictiveScalingConfiguration = predictiveScalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getPredictiveScalingConfiguration}
         * @param predictiveScalingConfiguration A predictive scaling policy. Provides support for predefined and custom metrics.
         *                                       Predefined metrics include CPU utilization, network in/out, and the Application Load Balancer request count.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder predictiveScalingConfiguration(software.amazon.awscdk.IResolvable predictiveScalingConfiguration) {
            this.predictiveScalingConfiguration = predictiveScalingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getScalingAdjustment}
         * @param scalingAdjustment The amount by which to scale, based on the specified adjustment type.
         *                          A positive value adds to the current capacity while a negative number removes from the current capacity. For exact capacity, you must specify a positive value.
         *                          <p>
         *                          Required if the policy type is <code>SimpleScaling</code> . (Not used with any other policy type.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingAdjustment(java.lang.Number scalingAdjustment) {
            this.scalingAdjustment = scalingAdjustment;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getStepAdjustments}
         * @param stepAdjustments A set of adjustments that enable you to scale based on the size of the alarm breach.
         *                        Required if the policy type is <code>StepScaling</code> . (Not used with any other policy type.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepAdjustments(software.amazon.awscdk.IResolvable stepAdjustments) {
            this.stepAdjustments = stepAdjustments;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getStepAdjustments}
         * @param stepAdjustments A set of adjustments that enable you to scale based on the size of the alarm breach.
         *                        Required if the policy type is <code>StepScaling</code> . (Not used with any other policy type.)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stepAdjustments(java.util.List<? extends java.lang.Object> stepAdjustments) {
            this.stepAdjustments = stepAdjustments;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getTargetTrackingConfiguration}
         * @param targetTrackingConfiguration A target tracking scaling policy. Includes support for predefined or customized metrics.
         *                                    The following predefined metrics are available:
         *                                    <p>
         *                                    <ul>
         *                                    <li><code>ASGAverageCPUUtilization</code></li>
         *                                    <li><code>ASGAverageNetworkIn</code></li>
         *                                    <li><code>ASGAverageNetworkOut</code></li>
         *                                    <li><code>ALBRequestCountPerTarget</code></li>
         *                                    </ul>
         *                                    <p>
         *                                    If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingConfiguration(software.amazon.awscdk.services.autoscaling.CfnScalingPolicy.TargetTrackingConfigurationProperty targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnScalingPolicyProps#getTargetTrackingConfiguration}
         * @param targetTrackingConfiguration A target tracking scaling policy. Includes support for predefined or customized metrics.
         *                                    The following predefined metrics are available:
         *                                    <p>
         *                                    <ul>
         *                                    <li><code>ASGAverageCPUUtilization</code></li>
         *                                    <li><code>ASGAverageNetworkIn</code></li>
         *                                    <li><code>ASGAverageNetworkOut</code></li>
         *                                    <li><code>ALBRequestCountPerTarget</code></li>
         *                                    </ul>
         *                                    <p>
         *                                    If you specify <code>ALBRequestCountPerTarget</code> for the metric, you must specify the <code>ResourceLabel</code> property with the <code>PredefinedMetricSpecification</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetTrackingConfiguration(software.amazon.awscdk.IResolvable targetTrackingConfiguration) {
            this.targetTrackingConfiguration = targetTrackingConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnScalingPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnScalingPolicyProps {
        private final java.lang.String autoScalingGroupName;
        private final java.lang.String adjustmentType;
        private final java.lang.String cooldown;
        private final java.lang.Number estimatedInstanceWarmup;
        private final java.lang.String metricAggregationType;
        private final java.lang.Number minAdjustmentMagnitude;
        private final java.lang.String policyType;
        private final java.lang.Object predictiveScalingConfiguration;
        private final java.lang.Number scalingAdjustment;
        private final java.lang.Object stepAdjustments;
        private final java.lang.Object targetTrackingConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroupName = software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.estimatedInstanceWarmup = software.amazon.jsii.Kernel.get(this, "estimatedInstanceWarmup", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.metricAggregationType = software.amazon.jsii.Kernel.get(this, "metricAggregationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.minAdjustmentMagnitude = software.amazon.jsii.Kernel.get(this, "minAdjustmentMagnitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.policyType = software.amazon.jsii.Kernel.get(this, "policyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.predictiveScalingConfiguration = software.amazon.jsii.Kernel.get(this, "predictiveScalingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scalingAdjustment = software.amazon.jsii.Kernel.get(this, "scalingAdjustment", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.stepAdjustments = software.amazon.jsii.Kernel.get(this, "stepAdjustments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetTrackingConfiguration = software.amazon.jsii.Kernel.get(this, "targetTrackingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroupName = java.util.Objects.requireNonNull(builder.autoScalingGroupName, "autoScalingGroupName is required");
            this.adjustmentType = builder.adjustmentType;
            this.cooldown = builder.cooldown;
            this.estimatedInstanceWarmup = builder.estimatedInstanceWarmup;
            this.metricAggregationType = builder.metricAggregationType;
            this.minAdjustmentMagnitude = builder.minAdjustmentMagnitude;
            this.policyType = builder.policyType;
            this.predictiveScalingConfiguration = builder.predictiveScalingConfiguration;
            this.scalingAdjustment = builder.scalingAdjustment;
            this.stepAdjustments = builder.stepAdjustments;
            this.targetTrackingConfiguration = builder.targetTrackingConfiguration;
        }

        @Override
        public final java.lang.String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final java.lang.String getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final java.lang.String getCooldown() {
            return this.cooldown;
        }

        @Override
        public final java.lang.Number getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        public final java.lang.String getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final java.lang.Number getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        public final java.lang.String getPolicyType() {
            return this.policyType;
        }

        @Override
        public final java.lang.Object getPredictiveScalingConfiguration() {
            return this.predictiveScalingConfiguration;
        }

        @Override
        public final java.lang.Number getScalingAdjustment() {
            return this.scalingAdjustment;
        }

        @Override
        public final java.lang.Object getStepAdjustments() {
            return this.stepAdjustments;
        }

        @Override
        public final java.lang.Object getTargetTrackingConfiguration() {
            return this.targetTrackingConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroupName", om.valueToTree(this.getAutoScalingGroupName()));
            if (this.getAdjustmentType() != null) {
                data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getEstimatedInstanceWarmup() != null) {
                data.set("estimatedInstanceWarmup", om.valueToTree(this.getEstimatedInstanceWarmup()));
            }
            if (this.getMetricAggregationType() != null) {
                data.set("metricAggregationType", om.valueToTree(this.getMetricAggregationType()));
            }
            if (this.getMinAdjustmentMagnitude() != null) {
                data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
            }
            if (this.getPolicyType() != null) {
                data.set("policyType", om.valueToTree(this.getPolicyType()));
            }
            if (this.getPredictiveScalingConfiguration() != null) {
                data.set("predictiveScalingConfiguration", om.valueToTree(this.getPredictiveScalingConfiguration()));
            }
            if (this.getScalingAdjustment() != null) {
                data.set("scalingAdjustment", om.valueToTree(this.getScalingAdjustment()));
            }
            if (this.getStepAdjustments() != null) {
                data.set("stepAdjustments", om.valueToTree(this.getStepAdjustments()));
            }
            if (this.getTargetTrackingConfiguration() != null) {
                data.set("targetTrackingConfiguration", om.valueToTree(this.getTargetTrackingConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.CfnScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnScalingPolicyProps.Jsii$Proxy that = (CfnScalingPolicyProps.Jsii$Proxy) o;

            if (!autoScalingGroupName.equals(that.autoScalingGroupName)) return false;
            if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.estimatedInstanceWarmup != null ? !this.estimatedInstanceWarmup.equals(that.estimatedInstanceWarmup) : that.estimatedInstanceWarmup != null) return false;
            if (this.metricAggregationType != null ? !this.metricAggregationType.equals(that.metricAggregationType) : that.metricAggregationType != null) return false;
            if (this.minAdjustmentMagnitude != null ? !this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude != null) return false;
            if (this.policyType != null ? !this.policyType.equals(that.policyType) : that.policyType != null) return false;
            if (this.predictiveScalingConfiguration != null ? !this.predictiveScalingConfiguration.equals(that.predictiveScalingConfiguration) : that.predictiveScalingConfiguration != null) return false;
            if (this.scalingAdjustment != null ? !this.scalingAdjustment.equals(that.scalingAdjustment) : that.scalingAdjustment != null) return false;
            if (this.stepAdjustments != null ? !this.stepAdjustments.equals(that.stepAdjustments) : that.stepAdjustments != null) return false;
            return this.targetTrackingConfiguration != null ? this.targetTrackingConfiguration.equals(that.targetTrackingConfiguration) : that.targetTrackingConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroupName.hashCode();
            result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.hashCode() : 0);
            result = 31 * result + (this.metricAggregationType != null ? this.metricAggregationType.hashCode() : 0);
            result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
            result = 31 * result + (this.policyType != null ? this.policyType.hashCode() : 0);
            result = 31 * result + (this.predictiveScalingConfiguration != null ? this.predictiveScalingConfiguration.hashCode() : 0);
            result = 31 * result + (this.scalingAdjustment != null ? this.scalingAdjustment.hashCode() : 0);
            result = 31 * result + (this.stepAdjustments != null ? this.stepAdjustments.hashCode() : 0);
            result = 31 * result + (this.targetTrackingConfiguration != null ? this.targetTrackingConfiguration.hashCode() : 0);
            return result;
        }
    }
}
