package software.amazon.awscdk.services.cassandra;

/**
 * Properties for defining a `CfnTable`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cassandra.*;
 * CfnTableProps cfnTableProps = CfnTableProps.builder()
 *         .keyspaceName("keyspaceName")
 *         .partitionKeyColumns(List.of(ColumnProperty.builder()
 *                 .columnName("columnName")
 *                 .columnType("columnType")
 *                 .build()))
 *         // the properties below are optional
 *         .billingMode(BillingModeProperty.builder()
 *                 .mode("mode")
 *                 // the properties below are optional
 *                 .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                         .readCapacityUnits(123)
 *                         .writeCapacityUnits(123)
 *                         .build())
 *                 .build())
 *         .clusteringKeyColumns(List.of(ClusteringKeyColumnProperty.builder()
 *                 .column(ColumnProperty.builder()
 *                         .columnName("columnName")
 *                         .columnType("columnType")
 *                         .build())
 *                 // the properties below are optional
 *                 .orderBy("orderBy")
 *                 .build()))
 *         .defaultTimeToLive(123)
 *         .encryptionSpecification(EncryptionSpecificationProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 // the properties below are optional
 *                 .kmsKeyIdentifier("kmsKeyIdentifier")
 *                 .build())
 *         .pointInTimeRecoveryEnabled(false)
 *         .regularColumns(List.of(ColumnProperty.builder()
 *                 .columnName("columnName")
 *                 .columnType("columnType")
 *                 .build()))
 *         .tableName("tableName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:44.082Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cassandra.CfnTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the keyspace in which to create the table.
     * <p>
     * The keyspace must already exist.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKeyspaceName();

    /**
     * One or more columns that uniquely identify every row in the table.
     * <p>
     * Every table must have a partition key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPartitionKeyColumns();

    /**
     * The billing mode for the table, which determines how you'll be charged for reads and writes:.
     * <p>
     * <ul>
     * <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
     * <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
     * </ul>
     * <p>
     * If you don't specify a value for this property, then the table will use on-demand mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBillingMode() {
        return null;
    }

    /**
     * One or more columns that determine how the table data is sorted.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClusteringKeyColumns() {
        return null;
    }

    /**
     * The default Time To Live (TTL) value for all rows in a table in seconds.
     * <p>
     * The maximum configurable value is 630,720,000 seconds, which is the equivalent of 20 years. By default, the TTL value for a table is 0, which means data does not expire.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTimeToLive() {
        return null;
    }

    /**
     * The encryption at rest options for the table.
     * <p>
     * <ul>
     * <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces.</li>
     * <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
     * <p>
     * </blockquote>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionSpecification() {
        return null;
    }

    /**
     * Specifies if point-in-time recovery is enabled or disabled for the table.
     * <p>
     * The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPointInTimeRecoveryEnabled() {
        return null;
    }

    /**
     * One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns.
     * <p>
     * You can add regular columns to existing tables by adding them to the template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRegularColumns() {
        return null;
    }

    /**
     * The name of the table to be created.
     * <p>
     * The table name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * <em>Length constraints:</em> Minimum length of 3. Maximum length of 255.
     * <p>
     * <em>Pattern:</em> <code>^[a-zA-Z0-9][a-zA-Z0-9_]{1,47}$</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * A list of key-value pair tags to be attached to the resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTableProps> {
        java.lang.String keyspaceName;
        java.lang.Object partitionKeyColumns;
        java.lang.Object billingMode;
        java.lang.Object clusteringKeyColumns;
        java.lang.Number defaultTimeToLive;
        java.lang.Object encryptionSpecification;
        java.lang.Object pointInTimeRecoveryEnabled;
        java.lang.Object regularColumns;
        java.lang.String tableName;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTableProps#getKeyspaceName}
         * @param keyspaceName The name of the keyspace in which to create the table. This parameter is required.
         *                     The keyspace must already exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyspaceName(java.lang.String keyspaceName) {
            this.keyspaceName = keyspaceName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getPartitionKeyColumns}
         * @param partitionKeyColumns One or more columns that uniquely identify every row in the table. This parameter is required.
         *                            Every table must have a partition key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKeyColumns(software.amazon.awscdk.IResolvable partitionKeyColumns) {
            this.partitionKeyColumns = partitionKeyColumns;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getPartitionKeyColumns}
         * @param partitionKeyColumns One or more columns that uniquely identify every row in the table. This parameter is required.
         *                            Every table must have a partition key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKeyColumns(java.util.List<? extends java.lang.Object> partitionKeyColumns) {
            this.partitionKeyColumns = partitionKeyColumns;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getBillingMode}
         * @param billingMode The billing mode for the table, which determines how you'll be charged for reads and writes:.
         *                    <ul>
         *                    <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
         *                    <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
         *                    </ul>
         *                    <p>
         *                    If you don't specify a value for this property, then the table will use on-demand mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(software.amazon.awscdk.services.cassandra.CfnTable.BillingModeProperty billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getBillingMode}
         * @param billingMode The billing mode for the table, which determines how you'll be charged for reads and writes:.
         *                    <ul>
         *                    <li><em>On-demand mode</em> (default) - You pay based on the actual reads and writes your application performs.</li>
         *                    <li><em>Provisioned mode</em> - Lets you specify the number of reads and writes per second that you need for your application.</li>
         *                    </ul>
         *                    <p>
         *                    If you don't specify a value for this property, then the table will use on-demand mode.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(software.amazon.awscdk.IResolvable billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getClusteringKeyColumns}
         * @param clusteringKeyColumns One or more columns that determine how the table data is sorted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusteringKeyColumns(software.amazon.awscdk.IResolvable clusteringKeyColumns) {
            this.clusteringKeyColumns = clusteringKeyColumns;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getClusteringKeyColumns}
         * @param clusteringKeyColumns One or more columns that determine how the table data is sorted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusteringKeyColumns(java.util.List<? extends java.lang.Object> clusteringKeyColumns) {
            this.clusteringKeyColumns = clusteringKeyColumns;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getDefaultTimeToLive}
         * @param defaultTimeToLive The default Time To Live (TTL) value for all rows in a table in seconds.
         *                          The maximum configurable value is 630,720,000 seconds, which is the equivalent of 20 years. By default, the TTL value for a table is 0, which means data does not expire.
         *                          <p>
         *                          For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/TTL-how-it-works.html#ttl-howitworks_default_ttl">Setting the default TTL value for a table</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTimeToLive(java.lang.Number defaultTimeToLive) {
            this.defaultTimeToLive = defaultTimeToLive;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getEncryptionSpecification}
         * @param encryptionSpecification The encryption at rest options for the table.
         *                                <ul>
         *                                <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces.</li>
         *                                <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
         *                                </ul>
         *                                <p>
         *                                <blockquote>
         *                                <p>
         *                                If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
         *                                <p>
         *                                </blockquote>
         *                                <p>
         *                                For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionSpecification(software.amazon.awscdk.services.cassandra.CfnTable.EncryptionSpecificationProperty encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getEncryptionSpecification}
         * @param encryptionSpecification The encryption at rest options for the table.
         *                                <ul>
         *                                <li><em>AWS owned key</em> (default) - The key is owned by Amazon Keyspaces.</li>
         *                                <li><em>Customer managed key</em> - The key is stored in your account and is created, owned, and managed by you.</li>
         *                                </ul>
         *                                <p>
         *                                <blockquote>
         *                                <p>
         *                                If you choose encryption with a customer managed key, you must specify a valid customer managed KMS key with permissions granted to Amazon Keyspaces.
         *                                <p>
         *                                </blockquote>
         *                                <p>
         *                                For more information, see <a href="https://docs.aws.amazon.com/keyspaces/latest/devguide/EncryptionAtRest.html">Encryption at rest in Amazon Keyspaces</a> in the <em>Amazon Keyspaces Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionSpecification(software.amazon.awscdk.IResolvable encryptionSpecification) {
            this.encryptionSpecification = encryptionSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getPointInTimeRecoveryEnabled}
         * @param pointInTimeRecoveryEnabled Specifies if point-in-time recovery is enabled or disabled for the table.
         *                                   The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoveryEnabled(java.lang.Boolean pointInTimeRecoveryEnabled) {
            this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getPointInTimeRecoveryEnabled}
         * @param pointInTimeRecoveryEnabled Specifies if point-in-time recovery is enabled or disabled for the table.
         *                                   The options are <code>PointInTimeRecoveryEnabled=true</code> and <code>PointInTimeRecoveryEnabled=false</code> . If not specified, the default is <code>PointInTimeRecoveryEnabled=false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecoveryEnabled(software.amazon.awscdk.IResolvable pointInTimeRecoveryEnabled) {
            this.pointInTimeRecoveryEnabled = pointInTimeRecoveryEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getRegularColumns}
         * @param regularColumns One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns.
         *                       You can add regular columns to existing tables by adding them to the template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regularColumns(software.amazon.awscdk.IResolvable regularColumns) {
            this.regularColumns = regularColumns;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getRegularColumns}
         * @param regularColumns One or more columns that are not part of the primary key - that is, columns that are *not* defined as partition key columns or clustering key columns.
         *                       You can add regular columns to existing tables by adding them to the template.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regularColumns(java.util.List<? extends java.lang.Object> regularColumns) {
            this.regularColumns = regularColumns;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTableName}
         * @param tableName The name of the table to be created.
         *                  The table name is case sensitive. If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                  <p>
         *                  </blockquote>
         *                  <p>
         *                  <em>Length constraints:</em> Minimum length of 3. Maximum length of 255.
         *                  <p>
         *                  <em>Pattern:</em> <code>^[a-zA-Z0-9][a-zA-Z0-9_]{1,47}$</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTableProps#getTags}
         * @param tags A list of key-value pair tags to be attached to the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTableProps {
        private final java.lang.String keyspaceName;
        private final java.lang.Object partitionKeyColumns;
        private final java.lang.Object billingMode;
        private final java.lang.Object clusteringKeyColumns;
        private final java.lang.Number defaultTimeToLive;
        private final java.lang.Object encryptionSpecification;
        private final java.lang.Object pointInTimeRecoveryEnabled;
        private final java.lang.Object regularColumns;
        private final java.lang.String tableName;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.keyspaceName = software.amazon.jsii.Kernel.get(this, "keyspaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.partitionKeyColumns = software.amazon.jsii.Kernel.get(this, "partitionKeyColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.billingMode = software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clusteringKeyColumns = software.amazon.jsii.Kernel.get(this, "clusteringKeyColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultTimeToLive = software.amazon.jsii.Kernel.get(this, "defaultTimeToLive", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.encryptionSpecification = software.amazon.jsii.Kernel.get(this, "encryptionSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.pointInTimeRecoveryEnabled = software.amazon.jsii.Kernel.get(this, "pointInTimeRecoveryEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.regularColumns = software.amazon.jsii.Kernel.get(this, "regularColumns", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.keyspaceName = java.util.Objects.requireNonNull(builder.keyspaceName, "keyspaceName is required");
            this.partitionKeyColumns = java.util.Objects.requireNonNull(builder.partitionKeyColumns, "partitionKeyColumns is required");
            this.billingMode = builder.billingMode;
            this.clusteringKeyColumns = builder.clusteringKeyColumns;
            this.defaultTimeToLive = builder.defaultTimeToLive;
            this.encryptionSpecification = builder.encryptionSpecification;
            this.pointInTimeRecoveryEnabled = builder.pointInTimeRecoveryEnabled;
            this.regularColumns = builder.regularColumns;
            this.tableName = builder.tableName;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getKeyspaceName() {
            return this.keyspaceName;
        }

        @Override
        public final java.lang.Object getPartitionKeyColumns() {
            return this.partitionKeyColumns;
        }

        @Override
        public final java.lang.Object getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final java.lang.Object getClusteringKeyColumns() {
            return this.clusteringKeyColumns;
        }

        @Override
        public final java.lang.Number getDefaultTimeToLive() {
            return this.defaultTimeToLive;
        }

        @Override
        public final java.lang.Object getEncryptionSpecification() {
            return this.encryptionSpecification;
        }

        @Override
        public final java.lang.Object getPointInTimeRecoveryEnabled() {
            return this.pointInTimeRecoveryEnabled;
        }

        @Override
        public final java.lang.Object getRegularColumns() {
            return this.regularColumns;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("keyspaceName", om.valueToTree(this.getKeyspaceName()));
            data.set("partitionKeyColumns", om.valueToTree(this.getPartitionKeyColumns()));
            if (this.getBillingMode() != null) {
                data.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getClusteringKeyColumns() != null) {
                data.set("clusteringKeyColumns", om.valueToTree(this.getClusteringKeyColumns()));
            }
            if (this.getDefaultTimeToLive() != null) {
                data.set("defaultTimeToLive", om.valueToTree(this.getDefaultTimeToLive()));
            }
            if (this.getEncryptionSpecification() != null) {
                data.set("encryptionSpecification", om.valueToTree(this.getEncryptionSpecification()));
            }
            if (this.getPointInTimeRecoveryEnabled() != null) {
                data.set("pointInTimeRecoveryEnabled", om.valueToTree(this.getPointInTimeRecoveryEnabled()));
            }
            if (this.getRegularColumns() != null) {
                data.set("regularColumns", om.valueToTree(this.getRegularColumns()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cassandra.CfnTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTableProps.Jsii$Proxy that = (CfnTableProps.Jsii$Proxy) o;

            if (!keyspaceName.equals(that.keyspaceName)) return false;
            if (!partitionKeyColumns.equals(that.partitionKeyColumns)) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.clusteringKeyColumns != null ? !this.clusteringKeyColumns.equals(that.clusteringKeyColumns) : that.clusteringKeyColumns != null) return false;
            if (this.defaultTimeToLive != null ? !this.defaultTimeToLive.equals(that.defaultTimeToLive) : that.defaultTimeToLive != null) return false;
            if (this.encryptionSpecification != null ? !this.encryptionSpecification.equals(that.encryptionSpecification) : that.encryptionSpecification != null) return false;
            if (this.pointInTimeRecoveryEnabled != null ? !this.pointInTimeRecoveryEnabled.equals(that.pointInTimeRecoveryEnabled) : that.pointInTimeRecoveryEnabled != null) return false;
            if (this.regularColumns != null ? !this.regularColumns.equals(that.regularColumns) : that.regularColumns != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.keyspaceName.hashCode();
            result = 31 * result + (this.partitionKeyColumns.hashCode());
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.clusteringKeyColumns != null ? this.clusteringKeyColumns.hashCode() : 0);
            result = 31 * result + (this.defaultTimeToLive != null ? this.defaultTimeToLive.hashCode() : 0);
            result = 31 * result + (this.encryptionSpecification != null ? this.encryptionSpecification.hashCode() : 0);
            result = 31 * result + (this.pointInTimeRecoveryEnabled != null ? this.pointInTimeRecoveryEnabled.hashCode() : 0);
            result = 31 * result + (this.regularColumns != null ? this.regularColumns.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
