package software.amazon.awscdk.services.cloudformation;

/**
 * Properties for defining a `CfnPublisher`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * CfnPublisherProps cfnPublisherProps = CfnPublisherProps.builder()
 *         .acceptTermsAndConditions(false)
 *         // the properties below are optional
 *         .connectionArn("connectionArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:44.141Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnPublisherProps")
@software.amazon.jsii.Jsii.Proxy(CfnPublisherProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPublisherProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether you accept the [Terms and Conditions](https://docs.aws.amazon.com/https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf) for publishing extensions in the CloudFormation registry. You must accept the terms and conditions in order to register to publish public extensions to the CloudFormation registry.
     * <p>
     * The default is <code>false</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAcceptTermsAndConditions();

    /**
     * If you are using a Bitbucket or GitHub account for identity verification, the Amazon Resource Name (ARN) for your connection to that account.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation extensions</a> in the <em>CloudFormation CLI User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectionArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPublisherProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPublisherProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPublisherProps> {
        java.lang.Object acceptTermsAndConditions;
        java.lang.String connectionArn;

        /**
         * Sets the value of {@link CfnPublisherProps#getAcceptTermsAndConditions}
         * @param acceptTermsAndConditions Whether you accept the [Terms and Conditions](https://docs.aws.amazon.com/https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf) for publishing extensions in the CloudFormation registry. You must accept the terms and conditions in order to register to publish public extensions to the CloudFormation registry. This parameter is required.
         *                                 The default is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptTermsAndConditions(java.lang.Boolean acceptTermsAndConditions) {
            this.acceptTermsAndConditions = acceptTermsAndConditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublisherProps#getAcceptTermsAndConditions}
         * @param acceptTermsAndConditions Whether you accept the [Terms and Conditions](https://docs.aws.amazon.com/https://cloudformation-registry-documents.s3.amazonaws.com/Terms_and_Conditions_for_AWS_CloudFormation_Registry_Publishers.pdf) for publishing extensions in the CloudFormation registry. You must accept the terms and conditions in order to register to publish public extensions to the CloudFormation registry. This parameter is required.
         *                                 The default is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptTermsAndConditions(software.amazon.awscdk.IResolvable acceptTermsAndConditions) {
            this.acceptTermsAndConditions = acceptTermsAndConditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnPublisherProps#getConnectionArn}
         * @param connectionArn If you are using a Bitbucket or GitHub account for identity verification, the Amazon Resource Name (ARN) for your connection to that account.
         *                      For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/publish-extension.html#publish-extension-prereqs">Registering your account to publish CloudFormation extensions</a> in the <em>CloudFormation CLI User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionArn(java.lang.String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPublisherProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPublisherProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPublisherProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPublisherProps {
        private final java.lang.Object acceptTermsAndConditions;
        private final java.lang.String connectionArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acceptTermsAndConditions = software.amazon.jsii.Kernel.get(this, "acceptTermsAndConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectionArn = software.amazon.jsii.Kernel.get(this, "connectionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acceptTermsAndConditions = java.util.Objects.requireNonNull(builder.acceptTermsAndConditions, "acceptTermsAndConditions is required");
            this.connectionArn = builder.connectionArn;
        }

        @Override
        public final java.lang.Object getAcceptTermsAndConditions() {
            return this.acceptTermsAndConditions;
        }

        @Override
        public final java.lang.String getConnectionArn() {
            return this.connectionArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("acceptTermsAndConditions", om.valueToTree(this.getAcceptTermsAndConditions()));
            if (this.getConnectionArn() != null) {
                data.set("connectionArn", om.valueToTree(this.getConnectionArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnPublisherProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPublisherProps.Jsii$Proxy that = (CfnPublisherProps.Jsii$Proxy) o;

            if (!acceptTermsAndConditions.equals(that.acceptTermsAndConditions)) return false;
            return this.connectionArn != null ? this.connectionArn.equals(that.connectionArn) : that.connectionArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.acceptTermsAndConditions.hashCode();
            result = 31 * result + (this.connectionArn != null ? this.connectionArn.hashCode() : 0);
            return result;
        }
    }
}
