package software.amazon.awscdk.services.codepipeline;

/**
 * A CloudFormation `AWS::CodePipeline::Webhook`.
 * <p>
 * The <code>AWS::CodePipeline::Webhook</code> resource creates and registers your webhook. After the webhook is created and registered, it triggers your pipeline to start every time an external event occurs. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipelines-webhooks-migration.html">Configure Your GitHub Pipelines to Use Webhooks for Change Detection</a> in the <em>AWS CodePipeline User Guide</em> .
 * <p>
 * We strongly recommend that you use AWS Secrets Manager to store your credentials. If you use Secrets Manager, you must have already configured and stored your secret parameters in Secrets Manager. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html#dynamic-references-secretsmanager">Using Dynamic References to Specify Template Values</a> .
 * <p>
 * <blockquote>
 * <p>
 * When passing secret parameters, do not enter the value directly into the template. The value is rendered as plaintext and is therefore readable. For security reasons, do not use plaintext in your AWS CloudFormation template to store your credentials.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * CfnWebhook cfnWebhook = CfnWebhook.Builder.create(this, "MyCfnWebhook")
 *         .authentication("authentication")
 *         .authenticationConfiguration(WebhookAuthConfigurationProperty.builder()
 *                 .allowedIpRange("allowedIpRange")
 *                 .secretToken("secretToken")
 *                 .build())
 *         .filters(List.of(WebhookFilterRuleProperty.builder()
 *                 .jsonPath("jsonPath")
 *                 // the properties below are optional
 *                 .matchEquals("matchEquals")
 *                 .build()))
 *         .targetAction("targetAction")
 *         .targetPipeline("targetPipeline")
 *         .targetPipelineVersion(123)
 *         // the properties below are optional
 *         .name("name")
 *         .registerWithThirdParty(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:44.574Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnWebhook")
public class CfnWebhook extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnWebhook(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWebhook(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codepipeline.CfnWebhook.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CodePipeline::Webhook`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWebhook(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnWebhookProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The webhook URL generated by AWS CodePipeline , such as `https://eu-central-1.webhooks.aws/trigger123456` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.
     * <p>
     * <ul>
     * <li>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://docs.aws.amazon.com/https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</li>
     * <li>IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</li>
     * <li>UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "authentication", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.
     * <p>
     * <ul>
     * <li>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://docs.aws.amazon.com/https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</li>
     * <li>IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</li>
     * <li>UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthentication(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authentication", java.util.Objects.requireNonNull(value, "authentication is required"));
    }

    /**
     * Properties that configure the authentication applied to incoming webhook trigger requests.
     * <p>
     * The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set. For IP, only the <code>AllowedIPRange</code> property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAuthenticationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "authenticationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Properties that configure the authentication applied to incoming webhook trigger requests.
     * <p>
     * The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set. For IP, only the <code>AllowedIPRange</code> property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnWebhook.WebhookAuthConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "authenticationConfiguration", java.util.Objects.requireNonNull(value, "authenticationConfiguration is required"));
    }

    /**
     * Properties that configure the authentication applied to incoming webhook trigger requests.
     * <p>
     * The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set. For IP, only the <code>AllowedIPRange</code> property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authenticationConfiguration", java.util.Objects.requireNonNull(value, "authenticationConfiguration is required"));
    }

    /**
     * A list of rules applied to the body/payload sent in the POST request to a webhook URL.
     * <p>
     * All defined rules must pass for the request to be accepted and the pipeline started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getFilters() {
        return software.amazon.jsii.Kernel.get(this, "filters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of rules applied to the body/payload sent in the POST request to a webhook URL.
     * <p>
     * All defined rules must pass for the request to be accepted and the pipeline started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilters(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "filters", java.util.Objects.requireNonNull(value, "filters is required"));
    }

    /**
     * A list of rules applied to the body/payload sent in the POST request to a webhook URL.
     * <p>
     * All defined rules must pass for the request to be accepted and the pipeline started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilters(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "filters", java.util.Objects.requireNonNull(value, "filters is required"));
    }

    /**
     * The name of the action in a pipeline you want to connect to the webhook.
     * <p>
     * The action must be from the source (first) stage of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetAction() {
        return software.amazon.jsii.Kernel.get(this, "targetAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the action in a pipeline you want to connect to the webhook.
     * <p>
     * The action must be from the source (first) stage of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetAction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetAction", java.util.Objects.requireNonNull(value, "targetAction is required"));
    }

    /**
     * The name of the pipeline you want to connect to the webhook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetPipeline() {
        return software.amazon.jsii.Kernel.get(this, "targetPipeline", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the pipeline you want to connect to the webhook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetPipeline(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetPipeline", java.util.Objects.requireNonNull(value, "targetPipeline is required"));
    }

    /**
     * The version number of the pipeline to be connected to the trigger request.
     * <p>
     * Required: Yes
     * <p>
     * Type: Integer
     * <p>
     * Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-no-interrupt">No interruption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getTargetPipelineVersion() {
        return software.amazon.jsii.Kernel.get(this, "targetPipelineVersion", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The version number of the pipeline to be connected to the trigger request.
     * <p>
     * Required: Yes
     * <p>
     * Type: Integer
     * <p>
     * Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-no-interrupt">No interruption</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetPipelineVersion(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "targetPipelineVersion", java.util.Objects.requireNonNull(value, "targetPipelineVersion is required"));
    }

    /**
     * The name of the webhook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the webhook.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Configures a connection between the webhook that was created and the external tool with events to be detected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRegisterWithThirdParty() {
        return software.amazon.jsii.Kernel.get(this, "registerWithThirdParty", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures a connection between the webhook that was created and the external tool with events to be detected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegisterWithThirdParty(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "registerWithThirdParty", value);
    }

    /**
     * Configures a connection between the webhook that was created and the external tool with events to be detected.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRegisterWithThirdParty(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "registerWithThirdParty", value);
    }
    /**
     * The authentication applied to incoming webhook trigger requests.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * WebhookAuthConfigurationProperty webhookAuthConfigurationProperty = WebhookAuthConfigurationProperty.builder()
     *         .allowedIpRange("allowedIpRange")
     *         .secretToken("secretToken")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnWebhook.WebhookAuthConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(WebhookAuthConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebhookAuthConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The property used to configure acceptance of webhooks in an IP address range.
         * <p>
         * For IP, only the <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAllowedIpRange() {
            return null;
        }

        /**
         * The property used to configure GitHub authentication.
         * <p>
         * For GITHUB_HMAC, only the <code>SecretToken</code> property must be set.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSecretToken() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebhookAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebhookAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebhookAuthConfigurationProperty> {
            java.lang.String allowedIpRange;
            java.lang.String secretToken;

            /**
             * Sets the value of {@link WebhookAuthConfigurationProperty#getAllowedIpRange}
             * @param allowedIpRange The property used to configure acceptance of webhooks in an IP address range.
             *                       For IP, only the <code>AllowedIPRange</code> property must be set. This property must be set to a valid CIDR range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedIpRange(java.lang.String allowedIpRange) {
                this.allowedIpRange = allowedIpRange;
                return this;
            }

            /**
             * Sets the value of {@link WebhookAuthConfigurationProperty#getSecretToken}
             * @param secretToken The property used to configure GitHub authentication.
             *                    For GITHUB_HMAC, only the <code>SecretToken</code> property must be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretToken(java.lang.String secretToken) {
                this.secretToken = secretToken;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebhookAuthConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebhookAuthConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebhookAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebhookAuthConfigurationProperty {
            private final java.lang.String allowedIpRange;
            private final java.lang.String secretToken;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowedIpRange = software.amazon.jsii.Kernel.get(this, "allowedIpRange", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretToken = software.amazon.jsii.Kernel.get(this, "secretToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowedIpRange = builder.allowedIpRange;
                this.secretToken = builder.secretToken;
            }

            @Override
            public final java.lang.String getAllowedIpRange() {
                return this.allowedIpRange;
            }

            @Override
            public final java.lang.String getSecretToken() {
                return this.secretToken;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowedIpRange() != null) {
                    data.set("allowedIpRange", om.valueToTree(this.getAllowedIpRange()));
                }
                if (this.getSecretToken() != null) {
                    data.set("secretToken", om.valueToTree(this.getSecretToken()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnWebhook.WebhookAuthConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebhookAuthConfigurationProperty.Jsii$Proxy that = (WebhookAuthConfigurationProperty.Jsii$Proxy) o;

                if (this.allowedIpRange != null ? !this.allowedIpRange.equals(that.allowedIpRange) : that.allowedIpRange != null) return false;
                return this.secretToken != null ? this.secretToken.equals(that.secretToken) : that.secretToken == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowedIpRange != null ? this.allowedIpRange.hashCode() : 0;
                result = 31 * result + (this.secretToken != null ? this.secretToken.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The event criteria that specify when a webhook notification is sent to your URL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * WebhookFilterRuleProperty webhookFilterRuleProperty = WebhookFilterRuleProperty.builder()
     *         .jsonPath("jsonPath")
     *         // the properties below are optional
     *         .matchEquals("matchEquals")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnWebhook.WebhookFilterRuleProperty")
    @software.amazon.jsii.Jsii.Proxy(WebhookFilterRuleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WebhookFilterRuleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A JsonPath expression that is applied to the body/payload of the webhook.
         * <p>
         * The value selected by the JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is ignored. For more information, see <a href="https://docs.aws.amazon.com/https://github.com/json-path/JsonPath">Java JsonPath implementation</a> in GitHub.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getJsonPath();

        /**
         * The value selected by the `JsonPath` expression must match what is supplied in the `MatchEquals` field.
         * <p>
         * Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "main", the <code>MatchEquals</code> value is evaluated as "refs/heads/main". For a list of action configuration properties for built-in action types, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Pipeline Structure Reference Action Requirements</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMatchEquals() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WebhookFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WebhookFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WebhookFilterRuleProperty> {
            java.lang.String jsonPath;
            java.lang.String matchEquals;

            /**
             * Sets the value of {@link WebhookFilterRuleProperty#getJsonPath}
             * @param jsonPath A JsonPath expression that is applied to the body/payload of the webhook. This parameter is required.
             *                 The value selected by the JsonPath expression must match the value specified in the <code>MatchEquals</code> field. Otherwise, the request is ignored. For more information, see <a href="https://docs.aws.amazon.com/https://github.com/json-path/JsonPath">Java JsonPath implementation</a> in GitHub.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jsonPath(java.lang.String jsonPath) {
                this.jsonPath = jsonPath;
                return this;
            }

            /**
             * Sets the value of {@link WebhookFilterRuleProperty#getMatchEquals}
             * @param matchEquals The value selected by the `JsonPath` expression must match what is supplied in the `MatchEquals` field.
             *                    Otherwise, the request is ignored. Properties from the target action configuration can be included as placeholders in this value by surrounding the action configuration key with curly brackets. For example, if the value supplied here is "refs/heads/{Branch}" and the target action has an action configuration property called "Branch" with a value of "main", the <code>MatchEquals</code> value is evaluated as "refs/heads/main". For a list of action configuration properties for built-in action types, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Pipeline Structure Reference Action Requirements</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchEquals(java.lang.String matchEquals) {
                this.matchEquals = matchEquals;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WebhookFilterRuleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WebhookFilterRuleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WebhookFilterRuleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebhookFilterRuleProperty {
            private final java.lang.String jsonPath;
            private final java.lang.String matchEquals;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jsonPath = software.amazon.jsii.Kernel.get(this, "jsonPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchEquals = software.amazon.jsii.Kernel.get(this, "matchEquals", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jsonPath = java.util.Objects.requireNonNull(builder.jsonPath, "jsonPath is required");
                this.matchEquals = builder.matchEquals;
            }

            @Override
            public final java.lang.String getJsonPath() {
                return this.jsonPath;
            }

            @Override
            public final java.lang.String getMatchEquals() {
                return this.matchEquals;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("jsonPath", om.valueToTree(this.getJsonPath()));
                if (this.getMatchEquals() != null) {
                    data.set("matchEquals", om.valueToTree(this.getMatchEquals()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnWebhook.WebhookFilterRuleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WebhookFilterRuleProperty.Jsii$Proxy that = (WebhookFilterRuleProperty.Jsii$Proxy) o;

                if (!jsonPath.equals(that.jsonPath)) return false;
                return this.matchEquals != null ? this.matchEquals.equals(that.matchEquals) : that.matchEquals == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jsonPath.hashCode();
                result = 31 * result + (this.matchEquals != null ? this.matchEquals.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.CfnWebhook}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.CfnWebhook> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codepipeline.CfnWebhookProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codepipeline.CfnWebhookProps.Builder();
        }

        /**
         * Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED.
         * <p>
         * <ul>
         * <li>For information about the authentication scheme implemented by GITHUB_HMAC, see <a href="https://docs.aws.amazon.com/https://developer.github.com/webhooks/securing/">Securing your webhooks</a> on the GitHub Developer website.</li>
         * <li>IP rejects webhooks trigger requests unless they originate from an IP address in the IP range whitelisted in the authentication configuration.</li>
         * <li>UNAUTHENTICATED accepts all webhook trigger requests regardless of origin.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param authentication Supported options are GITHUB_HMAC, IP, and UNAUTHENTICATED. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authentication(final java.lang.String authentication) {
            this.props.authentication(authentication);
            return this;
        }

        /**
         * Properties that configure the authentication applied to incoming webhook trigger requests.
         * <p>
         * The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set. For IP, only the <code>AllowedIPRange</code> property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.
         * <p>
         * @return {@code this}
         * @param authenticationConfiguration Properties that configure the authentication applied to incoming webhook trigger requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationConfiguration(final software.amazon.awscdk.services.codepipeline.CfnWebhook.WebhookAuthConfigurationProperty authenticationConfiguration) {
            this.props.authenticationConfiguration(authenticationConfiguration);
            return this;
        }
        /**
         * Properties that configure the authentication applied to incoming webhook trigger requests.
         * <p>
         * The required properties depend on the authentication type. For GITHUB_HMAC, only the <code>SecretToken</code> property must be set. For IP, only the <code>AllowedIPRange</code> property must be set to a valid CIDR range. For UNAUTHENTICATED, no properties can be set.
         * <p>
         * @return {@code this}
         * @param authenticationConfiguration Properties that configure the authentication applied to incoming webhook trigger requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationConfiguration(final software.amazon.awscdk.IResolvable authenticationConfiguration) {
            this.props.authenticationConfiguration(authenticationConfiguration);
            return this;
        }

        /**
         * A list of rules applied to the body/payload sent in the POST request to a webhook URL.
         * <p>
         * All defined rules must pass for the request to be accepted and the pipeline started.
         * <p>
         * @return {@code this}
         * @param filters A list of rules applied to the body/payload sent in the POST request to a webhook URL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(final software.amazon.awscdk.IResolvable filters) {
            this.props.filters(filters);
            return this;
        }
        /**
         * A list of rules applied to the body/payload sent in the POST request to a webhook URL.
         * <p>
         * All defined rules must pass for the request to be accepted and the pipeline started.
         * <p>
         * @return {@code this}
         * @param filters A list of rules applied to the body/payload sent in the POST request to a webhook URL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filters(final java.util.List<? extends java.lang.Object> filters) {
            this.props.filters(filters);
            return this;
        }

        /**
         * The name of the action in a pipeline you want to connect to the webhook.
         * <p>
         * The action must be from the source (first) stage of the pipeline.
         * <p>
         * @return {@code this}
         * @param targetAction The name of the action in a pipeline you want to connect to the webhook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetAction(final java.lang.String targetAction) {
            this.props.targetAction(targetAction);
            return this;
        }

        /**
         * The name of the pipeline you want to connect to the webhook.
         * <p>
         * @return {@code this}
         * @param targetPipeline The name of the pipeline you want to connect to the webhook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPipeline(final java.lang.String targetPipeline) {
            this.props.targetPipeline(targetPipeline);
            return this;
        }

        /**
         * The version number of the pipeline to be connected to the trigger request.
         * <p>
         * Required: Yes
         * <p>
         * Type: Integer
         * <p>
         * Update requires: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-no-interrupt">No interruption</a>
         * <p>
         * @return {@code this}
         * @param targetPipelineVersion The version number of the pipeline to be connected to the trigger request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetPipelineVersion(final java.lang.Number targetPipelineVersion) {
            this.props.targetPipelineVersion(targetPipelineVersion);
            return this;
        }

        /**
         * The name of the webhook.
         * <p>
         * @return {@code this}
         * @param name The name of the webhook. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Configures a connection between the webhook that was created and the external tool with events to be detected.
         * <p>
         * @return {@code this}
         * @param registerWithThirdParty Configures a connection between the webhook that was created and the external tool with events to be detected. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registerWithThirdParty(final java.lang.Boolean registerWithThirdParty) {
            this.props.registerWithThirdParty(registerWithThirdParty);
            return this;
        }
        /**
         * Configures a connection between the webhook that was created and the external tool with events to be detected.
         * <p>
         * @return {@code this}
         * @param registerWithThirdParty Configures a connection between the webhook that was created and the external tool with events to be detected. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder registerWithThirdParty(final software.amazon.awscdk.IResolvable registerWithThirdParty) {
            this.props.registerWithThirdParty(registerWithThirdParty);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.CfnWebhook}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.CfnWebhook build() {
            return new software.amazon.awscdk.services.codepipeline.CfnWebhook(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
