package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a `CfnUserPoolClient`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolClientProps cfnUserPoolClientProps = CfnUserPoolClientProps.builder()
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .accessTokenValidity(123)
 *         .allowedOAuthFlows(List.of("allowedOAuthFlows"))
 *         .allowedOAuthFlowsUserPoolClient(false)
 *         .allowedOAuthScopes(List.of("allowedOAuthScopes"))
 *         .analyticsConfiguration(AnalyticsConfigurationProperty.builder()
 *                 .applicationArn("applicationArn")
 *                 .applicationId("applicationId")
 *                 .externalId("externalId")
 *                 .roleArn("roleArn")
 *                 .userDataShared(false)
 *                 .build())
 *         .callbackUrLs(List.of("callbackUrLs"))
 *         .clientName("clientName")
 *         .defaultRedirectUri("defaultRedirectUri")
 *         .enableTokenRevocation(false)
 *         .explicitAuthFlows(List.of("explicitAuthFlows"))
 *         .generateSecret(false)
 *         .idTokenValidity(123)
 *         .logoutUrLs(List.of("logoutUrLs"))
 *         .preventUserExistenceErrors("preventUserExistenceErrors")
 *         .readAttributes(List.of("readAttributes"))
 *         .refreshTokenValidity(123)
 *         .supportedIdentityProviders(List.of("supportedIdentityProviders"))
 *         .tokenValidityUnits(TokenValidityUnitsProperty.builder()
 *                 .accessToken("accessToken")
 *                 .idToken("idToken")
 *                 .refreshToken("refreshToken")
 *                 .build())
 *         .writeAttributes(List.of("writeAttributes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:44.729Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolClientProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolClientProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolClientProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user pool ID for the user pool where you want to create a user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * The time limit, after which the access token is no longer valid and cannot be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getAccessTokenValidity() {
        return null;
    }

    /**
     * The allowed OAuth flows.
     * <p>
     * Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.
     * <p>
     * Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.
     * <p>
     * Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOAuthFlows() {
        return null;
    }

    /**
     * Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAllowedOAuthFlowsUserPoolClient() {
        return null;
    }

    /**
     * The allowed OAuth scopes.
     * <p>
     * Possible values provided by OAuth are: <code>phone</code> , <code>email</code> , <code>openid</code> , and <code>profile</code> . Possible values provided by AWS are: <code>aws.cognito.signin.user.admin</code> . Custom scopes created in Resource Servers are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOAuthScopes() {
        return null;
    }

    /**
     * The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
     * <p>
     * <blockquote>
     * <p>
     * In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAnalyticsConfiguration() {
        return null;
    }

    /**
     * A list of allowed redirect (callback) URLs for the identity providers.
     * <p>
     * A redirect URI must:
     * <p>
     * <ul>
     * <li>Be an absolute URI.</li>
     * <li>Be registered with the authorization server.</li>
     * <li>Not include a fragment component.</li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * <p>
     * App callback URLs such as myapp://example are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCallbackUrLs() {
        return null;
    }

    /**
     * The client name for the user pool client you would like to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientName() {
        return null;
    }

    /**
     * The default redirect URI. Must be in the `CallbackURLs` list.
     * <p>
     * A redirect URI must:
     * <p>
     * <ul>
     * <li>Be an absolute URI.</li>
     * <li>Be registered with the authorization server.</li>
     * <li>Not include a fragment component.</li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
     * <p>
     * Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
     * <p>
     * App callback URLs such as myapp://example are also supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRedirectUri() {
        return null;
    }

    /**
     * Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
     * <p>
     * If you don't include this parameter, token revocation is automatically activated for the new user pool client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableTokenRevocation() {
        return null;
    }

    /**
     * The authentication flows that are supported by the user pool clients.
     * <p>
     * Flow names without the <code>ALLOW_</code> prefix are no longer supported, in favor of new names with the <code>ALLOW_</code> prefix.
     * <p>
     * <blockquote>
     * <p>
     * Values with <code>ALLOW_</code> prefix must be used only along with the <code>ALLOW_</code> prefix.
     * <p>
     * </blockquote>
     * <p>
     * Valid values include:
     * <p>
     * <ul>
     * <li><code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code> : Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code> . This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</li>
     * <li><code>ALLOW_CUSTOM_AUTH</code> : Enable AWS Lambda trigger based authentication.</li>
     * <li><code>ALLOW_USER_PASSWORD_AUTH</code> : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</li>
     * <li><code>ALLOW_USER_SRP_AUTH</code> : Enable SRP-based authentication.</li>
     * <li><code>ALLOW_REFRESH_TOKEN_AUTH</code> : Enable authflow to refresh tokens.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExplicitAuthFlows() {
        return null;
    }

    /**
     * Boolean to specify whether you want to generate a secret for the user pool client being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGenerateSecret() {
        return null;
    }

    /**
     * The time limit, after which the ID token is no longer valid and cannot be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIdTokenValidity() {
        return null;
    }

    /**
     * A list of allowed logout URLs for the identity providers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLogoutUrLs() {
        return null;
    }

    /**
     * Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool.
     * <p>
     * When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code> , those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreventUserExistenceErrors() {
        return null;
    }

    /**
     * The read attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReadAttributes() {
        return null;
    }

    /**
     * The time limit, in days, after which the refresh token is no longer valid and can't be used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRefreshTokenValidity() {
        return null;
    }

    /**
     * A list of provider names for the identity providers that are supported on this client.
     * <p>
     * The following are supported: <code>COGNITO</code> , <code>Facebook</code> , <code>SignInWithApple</code> , <code>Google</code> and <code>LoginWithAmazon</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSupportedIdentityProviders() {
        return null;
    }

    /**
     * The units in which the validity times are represented in.
     * <p>
     * Default for RefreshToken is days, and default for ID and access tokens are hours.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTokenValidityUnits() {
        return null;
    }

    /**
     * The user pool attributes that the app client can write to.
     * <p>
     * If your app client allows users to sign in through an identity provider, this array must include all attributes that you have mapped to identity provider attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your user pool</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWriteAttributes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolClientProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolClientProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolClientProps> {
        java.lang.String userPoolId;
        java.lang.Number accessTokenValidity;
        java.util.List<java.lang.String> allowedOAuthFlows;
        java.lang.Object allowedOAuthFlowsUserPoolClient;
        java.util.List<java.lang.String> allowedOAuthScopes;
        java.lang.Object analyticsConfiguration;
        java.util.List<java.lang.String> callbackUrLs;
        java.lang.String clientName;
        java.lang.String defaultRedirectUri;
        java.lang.Object enableTokenRevocation;
        java.util.List<java.lang.String> explicitAuthFlows;
        java.lang.Object generateSecret;
        java.lang.Number idTokenValidity;
        java.util.List<java.lang.String> logoutUrLs;
        java.lang.String preventUserExistenceErrors;
        java.util.List<java.lang.String> readAttributes;
        java.lang.Number refreshTokenValidity;
        java.util.List<java.lang.String> supportedIdentityProviders;
        java.lang.Object tokenValidityUnits;
        java.util.List<java.lang.String> writeAttributes;

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getUserPoolId}
         * @param userPoolId The user pool ID for the user pool where you want to create a user pool client. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getAccessTokenValidity}
         * @param accessTokenValidity The time limit, after which the access token is no longer valid and cannot be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessTokenValidity(java.lang.Number accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getAllowedOAuthFlows}
         * @param allowedOAuthFlows The allowed OAuth flows.
         *                          Set to <code>code</code> to initiate a code grant flow, which provides an authorization code as the response. This code can be exchanged for access tokens with the token endpoint.
         *                          <p>
         *                          Set to <code>implicit</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) directly.
         *                          <p>
         *                          Set to <code>client_credentials</code> to specify that the client should get the access token (and, optionally, ID token, based on scopes) from the token endpoint using a combination of client and client_secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlows(java.util.List<java.lang.String> allowedOAuthFlows) {
            this.allowedOAuthFlows = allowedOAuthFlows;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getAllowedOAuthFlowsUserPoolClient}
         * @param allowedOAuthFlowsUserPoolClient Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlowsUserPoolClient(java.lang.Boolean allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getAllowedOAuthFlowsUserPoolClient}
         * @param allowedOAuthFlowsUserPoolClient Set to true if the client is allowed to follow the OAuth protocol when interacting with Amazon Cognito user pools.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthFlowsUserPoolClient(software.amazon.awscdk.IResolvable allowedOAuthFlowsUserPoolClient) {
            this.allowedOAuthFlowsUserPoolClient = allowedOAuthFlowsUserPoolClient;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getAllowedOAuthScopes}
         * @param allowedOAuthScopes The allowed OAuth scopes.
         *                           Possible values provided by OAuth are: <code>phone</code> , <code>email</code> , <code>openid</code> , and <code>profile</code> . Possible values provided by AWS are: <code>aws.cognito.signin.user.admin</code> . Custom scopes created in Resource Servers are also supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedOAuthScopes(java.util.List<java.lang.String> allowedOAuthScopes) {
            this.allowedOAuthScopes = allowedOAuthScopes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getAnalyticsConfiguration}
         * @param analyticsConfiguration The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
         *                               <blockquote>
         *                               <p>
         *                               In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
         *                               <p>
         *                               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfiguration(software.amazon.awscdk.services.cognito.CfnUserPoolClient.AnalyticsConfigurationProperty analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getAnalyticsConfiguration}
         * @param analyticsConfiguration The user pool analytics configuration for collecting metrics and sending them to your Amazon Pinpoint campaign.
         *                               <blockquote>
         *                               <p>
         *                               In AWS Regions where Amazon Pinpoint isn't available, user pools only support sending events to Amazon Pinpoint projects in AWS Region us-east-1. In Regions where Amazon Pinpoint is available, user pools support sending events to Amazon Pinpoint projects within that same Region.
         *                               <p>
         *                               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsConfiguration(software.amazon.awscdk.IResolvable analyticsConfiguration) {
            this.analyticsConfiguration = analyticsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getCallbackUrLs}
         * @param callbackUrLs A list of allowed redirect (callback) URLs for the identity providers.
         *                     A redirect URI must:
         *                     <p>
         *                     <ul>
         *                     <li>Be an absolute URI.</li>
         *                     <li>Be registered with the authorization server.</li>
         *                     <li>Not include a fragment component.</li>
         *                     </ul>
         *                     <p>
         *                     See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
         *                     <p>
         *                     Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *                     <p>
         *                     App callback URLs such as myapp://example are also supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder callbackUrLs(java.util.List<java.lang.String> callbackUrLs) {
            this.callbackUrLs = callbackUrLs;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getClientName}
         * @param clientName The client name for the user pool client you would like to create.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientName(java.lang.String clientName) {
            this.clientName = clientName;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getDefaultRedirectUri}
         * @param defaultRedirectUri The default redirect URI. Must be in the `CallbackURLs` list.
         *                           A redirect URI must:
         *                           <p>
         *                           <ul>
         *                           <li>Be an absolute URI.</li>
         *                           <li>Be registered with the authorization server.</li>
         *                           <li>Not include a fragment component.</li>
         *                           </ul>
         *                           <p>
         *                           See <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6749#section-3.1.2">OAuth 2.0 - Redirection Endpoint</a> .
         *                           <p>
         *                           Amazon Cognito requires HTTPS over HTTP except for http://localhost for testing purposes only.
         *                           <p>
         *                           App callback URLs such as myapp://example are also supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultRedirectUri(java.lang.String defaultRedirectUri) {
            this.defaultRedirectUri = defaultRedirectUri;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getEnableTokenRevocation}
         * @param enableTokenRevocation Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
         *                              If you don't include this parameter, token revocation is automatically activated for the new user pool client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTokenRevocation(java.lang.Boolean enableTokenRevocation) {
            this.enableTokenRevocation = enableTokenRevocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getEnableTokenRevocation}
         * @param enableTokenRevocation Activates or deactivates token revocation. For more information about revoking tokens, see [RevokeToken](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html) .
         *                              If you don't include this parameter, token revocation is automatically activated for the new user pool client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableTokenRevocation(software.amazon.awscdk.IResolvable enableTokenRevocation) {
            this.enableTokenRevocation = enableTokenRevocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getExplicitAuthFlows}
         * @param explicitAuthFlows The authentication flows that are supported by the user pool clients.
         *                          Flow names without the <code>ALLOW_</code> prefix are no longer supported, in favor of new names with the <code>ALLOW_</code> prefix.
         *                          <p>
         *                          <blockquote>
         *                          <p>
         *                          Values with <code>ALLOW_</code> prefix must be used only along with the <code>ALLOW_</code> prefix.
         *                          <p>
         *                          </blockquote>
         *                          <p>
         *                          Valid values include:
         *                          <p>
         *                          <ul>
         *                          <li><code>ALLOW_ADMIN_USER_PASSWORD_AUTH</code> : Enable admin based user password authentication flow <code>ADMIN_USER_PASSWORD_AUTH</code> . This setting replaces the <code>ADMIN_NO_SRP_AUTH</code> setting. With this authentication flow, Amazon Cognito receives the password in the request instead of using the Secure Remote Password (SRP) protocol to verify passwords.</li>
         *                          <li><code>ALLOW_CUSTOM_AUTH</code> : Enable AWS Lambda trigger based authentication.</li>
         *                          <li><code>ALLOW_USER_PASSWORD_AUTH</code> : Enable user password-based authentication. In this flow, Amazon Cognito receives the password in the request instead of using the SRP protocol to verify passwords.</li>
         *                          <li><code>ALLOW_USER_SRP_AUTH</code> : Enable SRP-based authentication.</li>
         *                          <li><code>ALLOW_REFRESH_TOKEN_AUTH</code> : Enable authflow to refresh tokens.</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder explicitAuthFlows(java.util.List<java.lang.String> explicitAuthFlows) {
            this.explicitAuthFlows = explicitAuthFlows;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getGenerateSecret}
         * @param generateSecret Boolean to specify whether you want to generate a secret for the user pool client being created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(java.lang.Boolean generateSecret) {
            this.generateSecret = generateSecret;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getGenerateSecret}
         * @param generateSecret Boolean to specify whether you want to generate a secret for the user pool client being created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecret(software.amazon.awscdk.IResolvable generateSecret) {
            this.generateSecret = generateSecret;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getIdTokenValidity}
         * @param idTokenValidity The time limit, after which the ID token is no longer valid and cannot be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idTokenValidity(java.lang.Number idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getLogoutUrLs}
         * @param logoutUrLs A list of allowed logout URLs for the identity providers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logoutUrLs(java.util.List<java.lang.String> logoutUrLs) {
            this.logoutUrLs = logoutUrLs;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getPreventUserExistenceErrors}
         * @param preventUserExistenceErrors Use this setting to choose which errors and responses are returned by Cognito APIs during authentication, account confirmation, and password recovery when the user does not exist in the user pool.
         *                                   When set to <code>ENABLED</code> and the user does not exist, authentication returns an error indicating either the username or password was incorrect, and account confirmation and password recovery return a response indicating a code was sent to a simulated destination. When set to <code>LEGACY</code> , those APIs will return a <code>UserNotFoundException</code> exception if the user does not exist in the user pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preventUserExistenceErrors(java.lang.String preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getReadAttributes}
         * @param readAttributes The read attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readAttributes(java.util.List<java.lang.String> readAttributes) {
            this.readAttributes = readAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getRefreshTokenValidity}
         * @param refreshTokenValidity The time limit, in days, after which the refresh token is no longer valid and can't be used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshTokenValidity(java.lang.Number refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getSupportedIdentityProviders}
         * @param supportedIdentityProviders A list of provider names for the identity providers that are supported on this client.
         *                                   The following are supported: <code>COGNITO</code> , <code>Facebook</code> , <code>SignInWithApple</code> , <code>Google</code> and <code>LoginWithAmazon</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder supportedIdentityProviders(java.util.List<java.lang.String> supportedIdentityProviders) {
            this.supportedIdentityProviders = supportedIdentityProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getTokenValidityUnits}
         * @param tokenValidityUnits The units in which the validity times are represented in.
         *                           Default for RefreshToken is days, and default for ID and access tokens are hours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenValidityUnits(software.amazon.awscdk.services.cognito.CfnUserPoolClient.TokenValidityUnitsProperty tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getTokenValidityUnits}
         * @param tokenValidityUnits The units in which the validity times are represented in.
         *                           Default for RefreshToken is days, and default for ID and access tokens are hours.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tokenValidityUnits(software.amazon.awscdk.IResolvable tokenValidityUnits) {
            this.tokenValidityUnits = tokenValidityUnits;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolClientProps#getWriteAttributes}
         * @param writeAttributes The user pool attributes that the app client can write to.
         *                        If your app client allows users to sign in through an identity provider, this array must include all attributes that you have mapped to identity provider attributes. Amazon Cognito updates mapped attributes when users sign in to your application through an identity provider. If your app client does not have write access to a mapped attribute, Amazon Cognito throws an error when it tries to update the attribute. For more information, see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html">Specifying Identity Provider Attribute Mappings for Your user pool</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeAttributes(java.util.List<java.lang.String> writeAttributes) {
            this.writeAttributes = writeAttributes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolClientProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolClientProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolClientProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolClientProps {
        private final java.lang.String userPoolId;
        private final java.lang.Number accessTokenValidity;
        private final java.util.List<java.lang.String> allowedOAuthFlows;
        private final java.lang.Object allowedOAuthFlowsUserPoolClient;
        private final java.util.List<java.lang.String> allowedOAuthScopes;
        private final java.lang.Object analyticsConfiguration;
        private final java.util.List<java.lang.String> callbackUrLs;
        private final java.lang.String clientName;
        private final java.lang.String defaultRedirectUri;
        private final java.lang.Object enableTokenRevocation;
        private final java.util.List<java.lang.String> explicitAuthFlows;
        private final java.lang.Object generateSecret;
        private final java.lang.Number idTokenValidity;
        private final java.util.List<java.lang.String> logoutUrLs;
        private final java.lang.String preventUserExistenceErrors;
        private final java.util.List<java.lang.String> readAttributes;
        private final java.lang.Number refreshTokenValidity;
        private final java.util.List<java.lang.String> supportedIdentityProviders;
        private final java.lang.Object tokenValidityUnits;
        private final java.util.List<java.lang.String> writeAttributes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.accessTokenValidity = software.amazon.jsii.Kernel.get(this, "accessTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.allowedOAuthFlows = software.amazon.jsii.Kernel.get(this, "allowedOAuthFlows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.allowedOAuthFlowsUserPoolClient = software.amazon.jsii.Kernel.get(this, "allowedOAuthFlowsUserPoolClient", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.allowedOAuthScopes = software.amazon.jsii.Kernel.get(this, "allowedOAuthScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.analyticsConfiguration = software.amazon.jsii.Kernel.get(this, "analyticsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.callbackUrLs = software.amazon.jsii.Kernel.get(this, "callbackUrLs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clientName = software.amazon.jsii.Kernel.get(this, "clientName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultRedirectUri = software.amazon.jsii.Kernel.get(this, "defaultRedirectUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableTokenRevocation = software.amazon.jsii.Kernel.get(this, "enableTokenRevocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.explicitAuthFlows = software.amazon.jsii.Kernel.get(this, "explicitAuthFlows", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.generateSecret = software.amazon.jsii.Kernel.get(this, "generateSecret", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.idTokenValidity = software.amazon.jsii.Kernel.get(this, "idTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.logoutUrLs = software.amazon.jsii.Kernel.get(this, "logoutUrLs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.preventUserExistenceErrors = software.amazon.jsii.Kernel.get(this, "preventUserExistenceErrors", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.readAttributes = software.amazon.jsii.Kernel.get(this, "readAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.refreshTokenValidity = software.amazon.jsii.Kernel.get(this, "refreshTokenValidity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.supportedIdentityProviders = software.amazon.jsii.Kernel.get(this, "supportedIdentityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tokenValidityUnits = software.amazon.jsii.Kernel.get(this, "tokenValidityUnits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.writeAttributes = software.amazon.jsii.Kernel.get(this, "writeAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.accessTokenValidity = builder.accessTokenValidity;
            this.allowedOAuthFlows = builder.allowedOAuthFlows;
            this.allowedOAuthFlowsUserPoolClient = builder.allowedOAuthFlowsUserPoolClient;
            this.allowedOAuthScopes = builder.allowedOAuthScopes;
            this.analyticsConfiguration = builder.analyticsConfiguration;
            this.callbackUrLs = builder.callbackUrLs;
            this.clientName = builder.clientName;
            this.defaultRedirectUri = builder.defaultRedirectUri;
            this.enableTokenRevocation = builder.enableTokenRevocation;
            this.explicitAuthFlows = builder.explicitAuthFlows;
            this.generateSecret = builder.generateSecret;
            this.idTokenValidity = builder.idTokenValidity;
            this.logoutUrLs = builder.logoutUrLs;
            this.preventUserExistenceErrors = builder.preventUserExistenceErrors;
            this.readAttributes = builder.readAttributes;
            this.refreshTokenValidity = builder.refreshTokenValidity;
            this.supportedIdentityProviders = builder.supportedIdentityProviders;
            this.tokenValidityUnits = builder.tokenValidityUnits;
            this.writeAttributes = builder.writeAttributes;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.Number getAccessTokenValidity() {
            return this.accessTokenValidity;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedOAuthFlows() {
            return this.allowedOAuthFlows;
        }

        @Override
        public final java.lang.Object getAllowedOAuthFlowsUserPoolClient() {
            return this.allowedOAuthFlowsUserPoolClient;
        }

        @Override
        public final java.util.List<java.lang.String> getAllowedOAuthScopes() {
            return this.allowedOAuthScopes;
        }

        @Override
        public final java.lang.Object getAnalyticsConfiguration() {
            return this.analyticsConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getCallbackUrLs() {
            return this.callbackUrLs;
        }

        @Override
        public final java.lang.String getClientName() {
            return this.clientName;
        }

        @Override
        public final java.lang.String getDefaultRedirectUri() {
            return this.defaultRedirectUri;
        }

        @Override
        public final java.lang.Object getEnableTokenRevocation() {
            return this.enableTokenRevocation;
        }

        @Override
        public final java.util.List<java.lang.String> getExplicitAuthFlows() {
            return this.explicitAuthFlows;
        }

        @Override
        public final java.lang.Object getGenerateSecret() {
            return this.generateSecret;
        }

        @Override
        public final java.lang.Number getIdTokenValidity() {
            return this.idTokenValidity;
        }

        @Override
        public final java.util.List<java.lang.String> getLogoutUrLs() {
            return this.logoutUrLs;
        }

        @Override
        public final java.lang.String getPreventUserExistenceErrors() {
            return this.preventUserExistenceErrors;
        }

        @Override
        public final java.util.List<java.lang.String> getReadAttributes() {
            return this.readAttributes;
        }

        @Override
        public final java.lang.Number getRefreshTokenValidity() {
            return this.refreshTokenValidity;
        }

        @Override
        public final java.util.List<java.lang.String> getSupportedIdentityProviders() {
            return this.supportedIdentityProviders;
        }

        @Override
        public final java.lang.Object getTokenValidityUnits() {
            return this.tokenValidityUnits;
        }

        @Override
        public final java.util.List<java.lang.String> getWriteAttributes() {
            return this.writeAttributes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getAccessTokenValidity() != null) {
                data.set("accessTokenValidity", om.valueToTree(this.getAccessTokenValidity()));
            }
            if (this.getAllowedOAuthFlows() != null) {
                data.set("allowedOAuthFlows", om.valueToTree(this.getAllowedOAuthFlows()));
            }
            if (this.getAllowedOAuthFlowsUserPoolClient() != null) {
                data.set("allowedOAuthFlowsUserPoolClient", om.valueToTree(this.getAllowedOAuthFlowsUserPoolClient()));
            }
            if (this.getAllowedOAuthScopes() != null) {
                data.set("allowedOAuthScopes", om.valueToTree(this.getAllowedOAuthScopes()));
            }
            if (this.getAnalyticsConfiguration() != null) {
                data.set("analyticsConfiguration", om.valueToTree(this.getAnalyticsConfiguration()));
            }
            if (this.getCallbackUrLs() != null) {
                data.set("callbackUrLs", om.valueToTree(this.getCallbackUrLs()));
            }
            if (this.getClientName() != null) {
                data.set("clientName", om.valueToTree(this.getClientName()));
            }
            if (this.getDefaultRedirectUri() != null) {
                data.set("defaultRedirectUri", om.valueToTree(this.getDefaultRedirectUri()));
            }
            if (this.getEnableTokenRevocation() != null) {
                data.set("enableTokenRevocation", om.valueToTree(this.getEnableTokenRevocation()));
            }
            if (this.getExplicitAuthFlows() != null) {
                data.set("explicitAuthFlows", om.valueToTree(this.getExplicitAuthFlows()));
            }
            if (this.getGenerateSecret() != null) {
                data.set("generateSecret", om.valueToTree(this.getGenerateSecret()));
            }
            if (this.getIdTokenValidity() != null) {
                data.set("idTokenValidity", om.valueToTree(this.getIdTokenValidity()));
            }
            if (this.getLogoutUrLs() != null) {
                data.set("logoutUrLs", om.valueToTree(this.getLogoutUrLs()));
            }
            if (this.getPreventUserExistenceErrors() != null) {
                data.set("preventUserExistenceErrors", om.valueToTree(this.getPreventUserExistenceErrors()));
            }
            if (this.getReadAttributes() != null) {
                data.set("readAttributes", om.valueToTree(this.getReadAttributes()));
            }
            if (this.getRefreshTokenValidity() != null) {
                data.set("refreshTokenValidity", om.valueToTree(this.getRefreshTokenValidity()));
            }
            if (this.getSupportedIdentityProviders() != null) {
                data.set("supportedIdentityProviders", om.valueToTree(this.getSupportedIdentityProviders()));
            }
            if (this.getTokenValidityUnits() != null) {
                data.set("tokenValidityUnits", om.valueToTree(this.getTokenValidityUnits()));
            }
            if (this.getWriteAttributes() != null) {
                data.set("writeAttributes", om.valueToTree(this.getWriteAttributes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolClientProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolClientProps.Jsii$Proxy that = (CfnUserPoolClientProps.Jsii$Proxy) o;

            if (!userPoolId.equals(that.userPoolId)) return false;
            if (this.accessTokenValidity != null ? !this.accessTokenValidity.equals(that.accessTokenValidity) : that.accessTokenValidity != null) return false;
            if (this.allowedOAuthFlows != null ? !this.allowedOAuthFlows.equals(that.allowedOAuthFlows) : that.allowedOAuthFlows != null) return false;
            if (this.allowedOAuthFlowsUserPoolClient != null ? !this.allowedOAuthFlowsUserPoolClient.equals(that.allowedOAuthFlowsUserPoolClient) : that.allowedOAuthFlowsUserPoolClient != null) return false;
            if (this.allowedOAuthScopes != null ? !this.allowedOAuthScopes.equals(that.allowedOAuthScopes) : that.allowedOAuthScopes != null) return false;
            if (this.analyticsConfiguration != null ? !this.analyticsConfiguration.equals(that.analyticsConfiguration) : that.analyticsConfiguration != null) return false;
            if (this.callbackUrLs != null ? !this.callbackUrLs.equals(that.callbackUrLs) : that.callbackUrLs != null) return false;
            if (this.clientName != null ? !this.clientName.equals(that.clientName) : that.clientName != null) return false;
            if (this.defaultRedirectUri != null ? !this.defaultRedirectUri.equals(that.defaultRedirectUri) : that.defaultRedirectUri != null) return false;
            if (this.enableTokenRevocation != null ? !this.enableTokenRevocation.equals(that.enableTokenRevocation) : that.enableTokenRevocation != null) return false;
            if (this.explicitAuthFlows != null ? !this.explicitAuthFlows.equals(that.explicitAuthFlows) : that.explicitAuthFlows != null) return false;
            if (this.generateSecret != null ? !this.generateSecret.equals(that.generateSecret) : that.generateSecret != null) return false;
            if (this.idTokenValidity != null ? !this.idTokenValidity.equals(that.idTokenValidity) : that.idTokenValidity != null) return false;
            if (this.logoutUrLs != null ? !this.logoutUrLs.equals(that.logoutUrLs) : that.logoutUrLs != null) return false;
            if (this.preventUserExistenceErrors != null ? !this.preventUserExistenceErrors.equals(that.preventUserExistenceErrors) : that.preventUserExistenceErrors != null) return false;
            if (this.readAttributes != null ? !this.readAttributes.equals(that.readAttributes) : that.readAttributes != null) return false;
            if (this.refreshTokenValidity != null ? !this.refreshTokenValidity.equals(that.refreshTokenValidity) : that.refreshTokenValidity != null) return false;
            if (this.supportedIdentityProviders != null ? !this.supportedIdentityProviders.equals(that.supportedIdentityProviders) : that.supportedIdentityProviders != null) return false;
            if (this.tokenValidityUnits != null ? !this.tokenValidityUnits.equals(that.tokenValidityUnits) : that.tokenValidityUnits != null) return false;
            return this.writeAttributes != null ? this.writeAttributes.equals(that.writeAttributes) : that.writeAttributes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.userPoolId.hashCode();
            result = 31 * result + (this.accessTokenValidity != null ? this.accessTokenValidity.hashCode() : 0);
            result = 31 * result + (this.allowedOAuthFlows != null ? this.allowedOAuthFlows.hashCode() : 0);
            result = 31 * result + (this.allowedOAuthFlowsUserPoolClient != null ? this.allowedOAuthFlowsUserPoolClient.hashCode() : 0);
            result = 31 * result + (this.allowedOAuthScopes != null ? this.allowedOAuthScopes.hashCode() : 0);
            result = 31 * result + (this.analyticsConfiguration != null ? this.analyticsConfiguration.hashCode() : 0);
            result = 31 * result + (this.callbackUrLs != null ? this.callbackUrLs.hashCode() : 0);
            result = 31 * result + (this.clientName != null ? this.clientName.hashCode() : 0);
            result = 31 * result + (this.defaultRedirectUri != null ? this.defaultRedirectUri.hashCode() : 0);
            result = 31 * result + (this.enableTokenRevocation != null ? this.enableTokenRevocation.hashCode() : 0);
            result = 31 * result + (this.explicitAuthFlows != null ? this.explicitAuthFlows.hashCode() : 0);
            result = 31 * result + (this.generateSecret != null ? this.generateSecret.hashCode() : 0);
            result = 31 * result + (this.idTokenValidity != null ? this.idTokenValidity.hashCode() : 0);
            result = 31 * result + (this.logoutUrLs != null ? this.logoutUrLs.hashCode() : 0);
            result = 31 * result + (this.preventUserExistenceErrors != null ? this.preventUserExistenceErrors.hashCode() : 0);
            result = 31 * result + (this.readAttributes != null ? this.readAttributes.hashCode() : 0);
            result = 31 * result + (this.refreshTokenValidity != null ? this.refreshTokenValidity.hashCode() : 0);
            result = 31 * result + (this.supportedIdentityProviders != null ? this.supportedIdentityProviders.hashCode() : 0);
            result = 31 * result + (this.tokenValidityUnits != null ? this.tokenValidityUnits.hashCode() : 0);
            result = 31 * result + (this.writeAttributes != null ? this.writeAttributes.hashCode() : 0);
            return result;
        }
    }
}
