package software.amazon.awscdk.services.cognito;

/**
 * Properties for defining a `CfnUserPoolUICustomizationAttachment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * CfnUserPoolUICustomizationAttachmentProps cfnUserPoolUICustomizationAttachmentProps = CfnUserPoolUICustomizationAttachmentProps.builder()
 *         .clientId("clientId")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .css("css")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:44.753Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolUICustomizationAttachmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnUserPoolUICustomizationAttachmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUserPoolUICustomizationAttachmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The client ID for the client app.
     * <p>
     * You can specify the UI customization settings for a single client (with a specific clientId) or for all clients (by setting the clientId to <code>ALL</code> ).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClientId();

    /**
     * The user pool ID for the user pool.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId();

    /**
     * The CSS values in the UI customization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCss() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUserPoolUICustomizationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUserPoolUICustomizationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUserPoolUICustomizationAttachmentProps> {
        java.lang.String clientId;
        java.lang.String userPoolId;
        java.lang.String css;

        /**
         * Sets the value of {@link CfnUserPoolUICustomizationAttachmentProps#getClientId}
         * @param clientId The client ID for the client app. This parameter is required.
         *                 You can specify the UI customization settings for a single client (with a specific clientId) or for all clients (by setting the clientId to <code>ALL</code> ).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(java.lang.String clientId) {
            this.clientId = clientId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUICustomizationAttachmentProps#getUserPoolId}
         * @param userPoolId The user pool ID for the user pool. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(java.lang.String userPoolId) {
            this.userPoolId = userPoolId;
            return this;
        }

        /**
         * Sets the value of {@link CfnUserPoolUICustomizationAttachmentProps#getCss}
         * @param css The CSS values in the UI customization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder css(java.lang.String css) {
            this.css = css;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUserPoolUICustomizationAttachmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUserPoolUICustomizationAttachmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUserPoolUICustomizationAttachmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUserPoolUICustomizationAttachmentProps {
        private final java.lang.String clientId;
        private final java.lang.String userPoolId;
        private final java.lang.String css;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clientId = software.amazon.jsii.Kernel.get(this, "clientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.css = software.amazon.jsii.Kernel.get(this, "css", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clientId = java.util.Objects.requireNonNull(builder.clientId, "clientId is required");
            this.userPoolId = java.util.Objects.requireNonNull(builder.userPoolId, "userPoolId is required");
            this.css = builder.css;
        }

        @Override
        public final java.lang.String getClientId() {
            return this.clientId;
        }

        @Override
        public final java.lang.String getUserPoolId() {
            return this.userPoolId;
        }

        @Override
        public final java.lang.String getCss() {
            return this.css;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clientId", om.valueToTree(this.getClientId()));
            data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
            if (this.getCss() != null) {
                data.set("css", om.valueToTree(this.getCss()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.CfnUserPoolUICustomizationAttachmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUserPoolUICustomizationAttachmentProps.Jsii$Proxy that = (CfnUserPoolUICustomizationAttachmentProps.Jsii$Proxy) o;

            if (!clientId.equals(that.clientId)) return false;
            if (!userPoolId.equals(that.userPoolId)) return false;
            return this.css != null ? this.css.equals(that.css) : that.css == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clientId.hashCode();
            result = 31 * result + (this.userPoolId.hashCode());
            result = 31 * result + (this.css != null ? this.css.hashCode() : 0);
            return result;
        }
    }
}
