package software.amazon.awscdk.services.cognito;

/**
 * Email settings for the user pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * EmailSettings emailSettings = EmailSettings.builder()
 *         .from("from")
 *         .replyTo("replyTo")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:44.761Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.EmailSettings")
@software.amazon.jsii.Jsii.Proxy(EmailSettings.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EmailSettings extends software.amazon.jsii.JsiiSerializable {

    /**
     * The 'from' address on the emails received by the user.
     * <p>
     * Default: noreply
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFrom() {
        return null;
    }

    /**
     * The 'replyTo' address on the emails received by the user as defined by IETF RFC-5322.
     * <p>
     * When set, most email clients recognize to change 'to' line to this address when a reply is drafted.
     * <p>
     * Default: - Not set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReplyTo() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EmailSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EmailSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EmailSettings> {
        java.lang.String from;
        java.lang.String replyTo;

        /**
         * Sets the value of {@link EmailSettings#getFrom}
         * @param from The 'from' address on the emails received by the user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder from(java.lang.String from) {
            this.from = from;
            return this;
        }

        /**
         * Sets the value of {@link EmailSettings#getReplyTo}
         * @param replyTo The 'replyTo' address on the emails received by the user as defined by IETF RFC-5322.
         *                When set, most email clients recognize to change 'to' line to this address when a reply is drafted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replyTo(java.lang.String replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EmailSettings}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EmailSettings build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EmailSettings}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EmailSettings {
        private final java.lang.String from;
        private final java.lang.String replyTo;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.from = software.amazon.jsii.Kernel.get(this, "from", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replyTo = software.amazon.jsii.Kernel.get(this, "replyTo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.from = builder.from;
            this.replyTo = builder.replyTo;
        }

        @Override
        public final java.lang.String getFrom() {
            return this.from;
        }

        @Override
        public final java.lang.String getReplyTo() {
            return this.replyTo;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFrom() != null) {
                data.set("from", om.valueToTree(this.getFrom()));
            }
            if (this.getReplyTo() != null) {
                data.set("replyTo", om.valueToTree(this.getReplyTo()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.EmailSettings"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EmailSettings.Jsii$Proxy that = (EmailSettings.Jsii$Proxy) o;

            if (this.from != null ? !this.from.equals(that.from) : that.from != null) return false;
            return this.replyTo != null ? this.replyTo.equals(that.replyTo) : that.replyTo == null;
        }

        @Override
        public final int hashCode() {
            int result = this.from != null ? this.from.hashCode() : 0;
            result = 31 * result + (this.replyTo != null ? this.replyTo.hashCode() : 0);
            return result;
        }
    }
}
