package software.amazon.awscdk.services.dlm;

/**
 * Properties for defining a `CfnLifecyclePolicy`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dlm.*;
 * CfnLifecyclePolicyProps cfnLifecyclePolicyProps = CfnLifecyclePolicyProps.builder()
 *         .description("description")
 *         .executionRoleArn("executionRoleArn")
 *         .policyDetails(PolicyDetailsProperty.builder()
 *                 .actions(List.of(ActionProperty.builder()
 *                         .crossRegionCopy(List.of(CrossRegionCopyActionProperty.builder()
 *                                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                         .encrypted(false)
 *                                         // the properties below are optional
 *                                         .cmkArn("cmkArn")
 *                                         .build())
 *                                 .target("target")
 *                                 // the properties below are optional
 *                                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .build()))
 *                         .name("name")
 *                         .build()))
 *                 .eventSource(EventSourceProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .parameters(EventParametersProperty.builder()
 *                                 .eventType("eventType")
 *                                 .snapshotOwner(List.of("snapshotOwner"))
 *                                 // the properties below are optional
 *                                 .descriptionRegex("descriptionRegex")
 *                                 .build())
 *                         .build())
 *                 .parameters(ParametersProperty.builder()
 *                         .excludeBootVolume(false)
 *                         .noReboot(false)
 *                         .build())
 *                 .policyType("policyType")
 *                 .resourceLocations(List.of("resourceLocations"))
 *                 .resourceTypes(List.of("resourceTypes"))
 *                 .schedules(List.of(ScheduleProperty.builder()
 *                         .copyTags(false)
 *                         .createRule(CreateRuleProperty.builder()
 *                                 .cronExpression("cronExpression")
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .location("location")
 *                                 .times(List.of("times"))
 *                                 .build())
 *                         .crossRegionCopyRules(List.of(CrossRegionCopyRuleProperty.builder()
 *                                 .encrypted(false)
 *                                 // the properties below are optional
 *                                 .cmkArn("cmkArn")
 *                                 .copyTags(false)
 *                                 .deprecateRule(CrossRegionCopyDeprecateRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .retainRule(CrossRegionCopyRetainRuleProperty.builder()
 *                                         .interval(123)
 *                                         .intervalUnit("intervalUnit")
 *                                         .build())
 *                                 .target("target")
 *                                 .targetRegion("targetRegion")
 *                                 .build()))
 *                         .deprecateRule(DeprecateRuleProperty.builder()
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .fastRestoreRule(FastRestoreRuleProperty.builder()
 *                                 .availabilityZones(List.of("availabilityZones"))
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .name("name")
 *                         .retainRule(RetainRuleProperty.builder()
 *                                 .count(123)
 *                                 .interval(123)
 *                                 .intervalUnit("intervalUnit")
 *                                 .build())
 *                         .shareRules(List.of(ShareRuleProperty.builder()
 *                                 .targetAccounts(List.of("targetAccounts"))
 *                                 .unshareInterval(123)
 *                                 .unshareIntervalUnit("unshareIntervalUnit")
 *                                 .build()))
 *                         .tagsToAdd(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .variableTags(List.of(CfnTag.builder()
 *                                 .key("key")
 *                                 .value("value")
 *                                 .build()))
 *                         .build()))
 *                 .targetTags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build())
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:44.999Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dlm.CfnLifecyclePolicyProps")
@software.amazon.jsii.Jsii.Proxy(CfnLifecyclePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLifecyclePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the lifecycle policy.
     * <p>
     * The characters ^[0-9A-Za-z _-]+$ are supported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return null;
    }

    /**
     * The configuration details of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyDetails() {
        return null;
    }

    /**
     * The activation state of the lifecycle policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * The tags to apply to the lifecycle policy during creation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLifecyclePolicyProps> {
        java.lang.String description;
        java.lang.String executionRoleArn;
        java.lang.Object policyDetails;
        java.lang.String state;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getDescription}
         * @param description A description of the lifecycle policy.
         *                    The characters ^[0-9A-Za-z _-]+$ are supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the IAM role used to run the operations specified by the lifecycle policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getPolicyDetails}
         * @param policyDetails The configuration details of the lifecycle policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(software.amazon.awscdk.services.dlm.CfnLifecyclePolicy.PolicyDetailsProperty policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getPolicyDetails}
         * @param policyDetails The configuration details of the lifecycle policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDetails(software.amazon.awscdk.IResolvable policyDetails) {
            this.policyDetails = policyDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getState}
         * @param state The activation state of the lifecycle policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnLifecyclePolicyProps#getTags}
         * @param tags The tags to apply to the lifecycle policy during creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLifecyclePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLifecyclePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLifecyclePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLifecyclePolicyProps {
        private final java.lang.String description;
        private final java.lang.String executionRoleArn;
        private final java.lang.Object policyDetails;
        private final java.lang.String state;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policyDetails = software.amazon.jsii.Kernel.get(this, "policyDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.executionRoleArn = builder.executionRoleArn;
            this.policyDetails = builder.policyDetails;
            this.state = builder.state;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.Object getPolicyDetails() {
            return this.policyDetails;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExecutionRoleArn() != null) {
                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            }
            if (this.getPolicyDetails() != null) {
                data.set("policyDetails", om.valueToTree(this.getPolicyDetails()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dlm.CfnLifecyclePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLifecyclePolicyProps.Jsii$Proxy that = (CfnLifecyclePolicyProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
            if (this.policyDetails != null ? !this.policyDetails.equals(that.policyDetails) : that.policyDetails != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
            result = 31 * result + (this.policyDetails != null ? this.policyDetails.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
