package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnPrefixList`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnPrefixListProps cfnPrefixListProps = CfnPrefixListProps.builder()
 *         .addressFamily("addressFamily")
 *         .maxEntries(123)
 *         .prefixListName("prefixListName")
 *         // the properties below are optional
 *         .entries(List.of(EntryProperty.builder()
 *                 .cidr("cidr")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.310Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnPrefixListProps")
@software.amazon.jsii.Jsii.Proxy(CfnPrefixListProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPrefixListProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IP address type.
     * <p>
     * Valid Values: <code>IPv4</code> | <code>IPv6</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAddressFamily();

    /**
     * The maximum number of entries for the prefix list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxEntries();

    /**
     * A name for the prefix list.
     * <p>
     * Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrefixListName();

    /**
     * One or more entries for the prefix list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEntries() {
        return null;
    }

    /**
     * The tags for the prefix list.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPrefixListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPrefixListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPrefixListProps> {
        java.lang.String addressFamily;
        java.lang.Number maxEntries;
        java.lang.String prefixListName;
        java.lang.Object entries;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPrefixListProps#getAddressFamily}
         * @param addressFamily The IP address type. This parameter is required.
         *                      Valid Values: <code>IPv4</code> | <code>IPv6</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder addressFamily(java.lang.String addressFamily) {
            this.addressFamily = addressFamily;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrefixListProps#getMaxEntries}
         * @param maxEntries The maximum number of entries for the prefix list. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEntries(java.lang.Number maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrefixListProps#getPrefixListName}
         * @param prefixListName A name for the prefix list. This parameter is required.
         *                       Constraints: Up to 255 characters in length. The name cannot start with <code>com.amazonaws</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixListName(java.lang.String prefixListName) {
            this.prefixListName = prefixListName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrefixListProps#getEntries}
         * @param entries One or more entries for the prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entries(software.amazon.awscdk.IResolvable entries) {
            this.entries = entries;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrefixListProps#getEntries}
         * @param entries One or more entries for the prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entries(java.util.List<? extends java.lang.Object> entries) {
            this.entries = entries;
            return this;
        }

        /**
         * Sets the value of {@link CfnPrefixListProps#getTags}
         * @param tags The tags for the prefix list.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPrefixListProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPrefixListProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPrefixListProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPrefixListProps {
        private final java.lang.String addressFamily;
        private final java.lang.Number maxEntries;
        private final java.lang.String prefixListName;
        private final java.lang.Object entries;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.addressFamily = software.amazon.jsii.Kernel.get(this, "addressFamily", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxEntries = software.amazon.jsii.Kernel.get(this, "maxEntries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.prefixListName = software.amazon.jsii.Kernel.get(this, "prefixListName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.entries = software.amazon.jsii.Kernel.get(this, "entries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.addressFamily = java.util.Objects.requireNonNull(builder.addressFamily, "addressFamily is required");
            this.maxEntries = java.util.Objects.requireNonNull(builder.maxEntries, "maxEntries is required");
            this.prefixListName = java.util.Objects.requireNonNull(builder.prefixListName, "prefixListName is required");
            this.entries = builder.entries;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getAddressFamily() {
            return this.addressFamily;
        }

        @Override
        public final java.lang.Number getMaxEntries() {
            return this.maxEntries;
        }

        @Override
        public final java.lang.String getPrefixListName() {
            return this.prefixListName;
        }

        @Override
        public final java.lang.Object getEntries() {
            return this.entries;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("addressFamily", om.valueToTree(this.getAddressFamily()));
            data.set("maxEntries", om.valueToTree(this.getMaxEntries()));
            data.set("prefixListName", om.valueToTree(this.getPrefixListName()));
            if (this.getEntries() != null) {
                data.set("entries", om.valueToTree(this.getEntries()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnPrefixListProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPrefixListProps.Jsii$Proxy that = (CfnPrefixListProps.Jsii$Proxy) o;

            if (!addressFamily.equals(that.addressFamily)) return false;
            if (!maxEntries.equals(that.maxEntries)) return false;
            if (!prefixListName.equals(that.prefixListName)) return false;
            if (this.entries != null ? !this.entries.equals(that.entries) : that.entries != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.addressFamily.hashCode();
            result = 31 * result + (this.maxEntries.hashCode());
            result = 31 * result + (this.prefixListName.hashCode());
            result = 31 * result + (this.entries != null ? this.entries.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
