package software.amazon.awscdk.services.ec2;

/**
 * The type of VPC traffic to log.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Vpc vpc = new Vpc(this, "Vpc");
 * vpc.addFlowLog("FlowLogS3", FlowLogOptions.builder()
 *         .destination(FlowLogDestination.toS3())
 *         .build());
 * vpc.addFlowLog("FlowLogCloudWatch", FlowLogOptions.builder()
 *         .trafficType(FlowLogTrafficType.REJECT)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.436Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.FlowLogTrafficType")
public enum FlowLogTrafficType {
    /**
     * Only log accepts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACCEPT,
    /**
     * Log all requests.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
    /**
     * Only log rejects.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REJECT,
}
