package software.amazon.awscdk.services.ec2;

/**
 * A services that be enabled, disabled or restarted when the instance is launched.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * Bucket myBucket;
 * InitServiceRestartHandle handle = new InitServiceRestartHandle();
 * CloudFormationInit.fromElements(InitFile.fromString("/etc/nginx/nginx.conf", "...", InitFileOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitSource.fromS3Object("/var/www/html", myBucket, "html.zip", InitSourceOptions.builder().serviceRestartHandles(List.of(handle)).build()), InitService.enable("nginx", InitServiceOptions.builder()
 *         .serviceRestartHandle(handle)
 *         .build()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.467Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InitService")
public class InitService extends software.amazon.awscdk.services.ec2.InitElement {

    protected InitService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected InitService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Disable and stop the given service.
     * <p>
     * @param serviceName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitService disable(final @org.jetbrains.annotations.NotNull java.lang.String serviceName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitService.class, "disable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitService.class), new Object[] { java.util.Objects.requireNonNull(serviceName, "serviceName is required") });
    }

    /**
     * Enable and start the given service, optionally restarting it.
     * <p>
     * @param serviceName This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitService enable(final @org.jetbrains.annotations.NotNull java.lang.String serviceName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InitServiceOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitService.class, "enable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitService.class), new Object[] { java.util.Objects.requireNonNull(serviceName, "serviceName is required"), options });
    }

    /**
     * Enable and start the given service, optionally restarting it.
     * <p>
     * @param serviceName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InitService enable(final @org.jetbrains.annotations.NotNull java.lang.String serviceName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ec2.InitService.class, "enable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InitService.class), new Object[] { java.util.Objects.requireNonNull(serviceName, "serviceName is required") });
    }

    /**
     * Returns the init element type for this element.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getElementType() {
        return software.amazon.jsii.Kernel.get(this, "elementType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
