package software.amazon.awscdk.services.ecr;

/**
 * Define an ECR repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.*;
 * Service.Builder.create(this, "Service")
 *         .source(Source.fromEcr(EcrProps.builder()
 *                 .imageConfiguration(ImageConfiguration.builder().port(80).build())
 *                 .repository(Repository.fromRepositoryName(this, "NginxRepository", "nginx"))
 *                 .tag("latest")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.558Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr.Repository")
public class Repository extends software.amazon.awscdk.services.ecr.RepositoryBase {

    protected Repository(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Repository(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Repository(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.RepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Repository(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Returns an ECR ARN for a repository that resides in the same account/region as the current stack.
     * <p>
     * @param repositoryName This parameter is required.
     * @param scope This parameter is required.
     * @param account
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForLocalRepository(final @org.jetbrains.annotations.NotNull java.lang.String repositoryName, final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope, final @org.jetbrains.annotations.Nullable java.lang.String account) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.Repository.class, "arnForLocalRepository", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(repositoryName, "repositoryName is required"), java.util.Objects.requireNonNull(scope, "scope is required"), account });
    }

    /**
     * Returns an ECR ARN for a repository that resides in the same account/region as the current stack.
     * <p>
     * @param repositoryName This parameter is required.
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String arnForLocalRepository(final @org.jetbrains.annotations.NotNull java.lang.String repositoryName, final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.Repository.class, "arnForLocalRepository", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(repositoryName, "repositoryName is required"), java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param repositoryArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository fromRepositoryArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String repositoryArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.Repository.class, "fromRepositoryArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(repositoryArn, "repositoryArn is required") });
    }

    /**
     * Import a repository.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository fromRepositoryAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.RepositoryAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.Repository.class, "fromRepositoryAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param repositoryName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository fromRepositoryName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String repositoryName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecr.Repository.class, "fromRepositoryName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(repositoryName, "repositoryName is required") });
    }

    /**
     * Add a life cycle rule to the repository.
     * <p>
     * Life cycle rules automatically expire images from the repository that match
     * certain conditions.
     * <p>
     * @param rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLifecycleRule(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.LifecycleRule rule) {
        software.amazon.jsii.Kernel.call(this, "addLifecycleRule", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(rule, "rule is required") });
    }

    /**
     * Add a policy statement to the repository's resource policy.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * The ARN of the repository.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryArn() {
        return software.amazon.jsii.Kernel.get(this, "repositoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the repository.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
        return software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecr.Repository}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecr.Repository> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecr.RepositoryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The kind of server-side encryption to apply to this repository.
         * <p>
         * If you choose KMS, you can specify a KMS key via <code>encryptionKey</code>. If
         * encryptionKey is not specified, an AWS managed KMS key is used.
         * <p>
         * Default: - `KMS` if `encryptionKey` is specified, or `AES256` otherwise.
         * <p>
         * @return {@code this}
         * @param encryption The kind of server-side encryption to apply to this repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.ecr.RepositoryEncryption encryption) {
            this.props().encryption(encryption);
            return this;
        }

        /**
         * External KMS key to use for repository encryption.
         * <p>
         * The 'encryption' property must be either not specified or set to "KMS".
         * An error will be emitted if encryption is set to "AES256".
         * <p>
         * Default: - If encryption is set to `KMS` and this property is undefined,
         * an AWS managed KMS key is used.
         * <p>
         * @return {@code this}
         * @param encryptionKey External KMS key to use for repository encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props().encryptionKey(encryptionKey);
            return this;
        }

        /**
         * Enable the scan on push when creating the repository.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param imageScanOnPush Enable the scan on push when creating the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageScanOnPush(final java.lang.Boolean imageScanOnPush) {
            this.props().imageScanOnPush(imageScanOnPush);
            return this;
        }

        /**
         * The tag mutability setting for the repository.
         * <p>
         * If this parameter is omitted, the default setting of MUTABLE will be used which will allow image tags to be overwritten.
         * <p>
         * Default: TagMutability.MUTABLE
         * <p>
         * @return {@code this}
         * @param imageTagMutability The tag mutability setting for the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTagMutability(final software.amazon.awscdk.services.ecr.TagMutability imageTagMutability) {
            this.props().imageTagMutability(imageTagMutability);
            return this;
        }

        /**
         * The AWS account ID associated with the registry that contains the repository.
         * <p>
         * Default: The default registry is assumed.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AmazonECR/latest/APIReference/API_PutLifecyclePolicy.html
         * @param lifecycleRegistryId The AWS account ID associated with the registry that contains the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleRegistryId(final java.lang.String lifecycleRegistryId) {
            this.props().lifecycleRegistryId(lifecycleRegistryId);
            return this;
        }

        /**
         * Life cycle rules to apply to this registry.
         * <p>
         * Default: No life cycle rules
         * <p>
         * @return {@code this}
         * @param lifecycleRules Life cycle rules to apply to this registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lifecycleRules(final java.util.List<? extends software.amazon.awscdk.services.ecr.LifecycleRule> lifecycleRules) {
            this.props().lifecycleRules(lifecycleRules);
            return this;
        }

        /**
         * Determine what happens to the repository when the resource/stack is deleted.
         * <p>
         * Default: RemovalPolicy.Retain
         * <p>
         * @return {@code this}
         * @param removalPolicy Determine what happens to the repository when the resource/stack is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Name for this repository.
         * <p>
         * Default: Automatically generated name.
         * <p>
         * @return {@code this}
         * @param repositoryName Name for this repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props().repositoryName(repositoryName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecr.Repository}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecr.Repository build() {
            return new software.amazon.awscdk.services.ecr.Repository(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecr.RepositoryProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecr.RepositoryProps.Builder();
            }
            return this.props;
        }
    }
}
