package software.amazon.awscdk.services.ecs;

/**
 * Constructs for types of container images.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "FargateCPCluster")
 *         .vpc(vpc)
 *         .enableFargateCapacityProviders(true)
 *         .build();
 * FargateTaskDefinition taskDefinition = new FargateTaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .build());
 * FargateService.Builder.create(this, "FargateService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider("FARGATE_SPOT")
 *                 .weight(2)
 *                 .build(), CapacityProviderStrategy.builder()
 *                 .capacityProvider("FARGATE")
 *                 .weight(1)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.706Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ContainerImage")
public abstract class ContainerImage extends software.amazon.jsii.JsiiObject {

    protected ContainerImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ContainerImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ContainerImage() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Reference an image that's constructed directly from sources on disk.
     * <p>
     * If you already have a <code>DockerImageAsset</code> instance, you can use the
     * <code>ContainerImage.fromDockerImageAsset</code> method instead.
     * <p>
     * @param directory The directory containing the Dockerfile. This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AssetImage fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String directory, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AssetImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ContainerImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AssetImage.class), new Object[] { java.util.Objects.requireNonNull(directory, "directory is required"), props });
    }

    /**
     * Reference an image that's constructed directly from sources on disk.
     * <p>
     * If you already have a <code>DockerImageAsset</code> instance, you can use the
     * <code>ContainerImage.fromDockerImageAsset</code> method instead.
     * <p>
     * @param directory The directory containing the Dockerfile. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AssetImage fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String directory) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ContainerImage.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.AssetImage.class), new Object[] { java.util.Objects.requireNonNull(directory, "directory is required") });
    }

    /**
     * Use an existing `DockerImageAsset` for this container image.
     * <p>
     * @param asset The `DockerImageAsset` to use for this container definition. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage fromDockerImageAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAsset asset) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ContainerImage.class, "fromDockerImageAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class), new Object[] { java.util.Objects.requireNonNull(asset, "asset is required") });
    }

    /**
     * Reference an image in an ECR repository.
     * <p>
     * @param repository This parameter is required.
     * @param tag
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcrImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tag) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ContainerImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcrImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tag });
    }

    /**
     * Reference an image in an ECR repository.
     * <p>
     * @param repository This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcrImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ContainerImage.class, "fromEcrRepository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcrImage.class), new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Reference an image on DockerHub or another online registry.
     * <p>
     * @param name This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.RepositoryImage fromRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.RepositoryImageProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ContainerImage.class, "fromRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.RepositoryImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required"), props });
    }

    /**
     * Reference an image on DockerHub or another online registry.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.RepositoryImage fromRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ContainerImage.class, "fromRegistry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.RepositoryImage.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Use an existing tarball for this container image.
     * <p>
     * Use this method if the container image has already been created by another process (e.g. jib)
     * and you want to add it as a container image asset.
     * <p>
     * @param tarballFile Absolute path to the tarball. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImage fromTarball(final @org.jetbrains.annotations.NotNull java.lang.String tarballFile) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.ContainerImage.class, "fromTarball", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class), new Object[] { java.util.Objects.requireNonNull(tarballFile, "tarballFile is required") });
    }

    /**
     * Called when the image is used by a ContainerDefinition.
     * <p>
     * @param scope This parameter is required.
     * @param containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImageConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.ContainerImage {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Called when the image is used by a ContainerDefinition.
         * <p>
         * @param scope This parameter is required.
         * @param containerDefinition This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImageConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(containerDefinition, "containerDefinition is required") });
        }
    }
}
