package software.amazon.awscdk.services.ecs;

/**
 * The machine image type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.addCapacity("graviton-cluster", AddCapacityOptions.builder()
 *         .minCapacity(2)
 *         .instanceType(new InstanceType("c6g.large"))
 *         .machineImageType(MachineImageType.BOTTLEROCKET)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.762Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.MachineImageType")
public enum MachineImageType {
    /**
     * Amazon ECS-optimized Amazon Linux 2 AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AMAZON_LINUX_2,
    /**
     * Bottlerocket AMI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOTTLEROCKET,
}
