package software.amazon.awscdk.services.ecs;

/**
 * Port mappings allow containers to access ports on the host container instance to send or receive traffic.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * ContainerDefinition container;
 * container.addPortMappings(PortMapping.builder()
 *         .containerPort(3000)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.764Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.PortMapping")
@software.amazon.jsii.Jsii.Proxy(PortMapping.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface PortMapping extends software.amazon.jsii.JsiiSerializable {

    /**
     * The port number on the container that is bound to the user-specified or automatically assigned host port.
     * <p>
     * If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
     * If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
     * your container automatically receives a host port in the ephemeral port range.
     * <p>
     * For more information, see hostPort.
     * Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getContainerPort();

    /**
     * The port number on the container instance to reserve for your container.
     * <p>
     * If you are using containers in a task with the awsvpc or host network mode,
     * the hostPort can either be left blank or set to the same value as the containerPort.
     * <p>
     * If you are using containers in a task with the bridge network mode,
     * you can specify a non-reserved host port for your container port mapping, or
     * you can omit the hostPort (or set it to 0) while specifying a containerPort and
     * your container automatically receives a port in the ephemeral port range for
     * your container instance operating system and Docker version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHostPort() {
        return null;
    }

    /**
     * The protocol used for the port mapping.
     * <p>
     * Valid values are Protocol.TCP and Protocol.UDP.
     * <p>
     * Default: TCP
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.Protocol getProtocol() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link PortMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link PortMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<PortMapping> {
        java.lang.Number containerPort;
        java.lang.Number hostPort;
        software.amazon.awscdk.services.ecs.Protocol protocol;

        /**
         * Sets the value of {@link PortMapping#getContainerPort}
         * @param containerPort The port number on the container that is bound to the user-specified or automatically assigned host port. This parameter is required.
         *                      If you are using containers in a task with the awsvpc or host network mode, exposed ports should be specified using containerPort.
         *                      If you are using containers in a task with the bridge network mode and you specify a container port and not a host port,
         *                      your container automatically receives a host port in the ephemeral port range.
         *                      <p>
         *                      For more information, see hostPort.
         *                      Port mappings that are automatically assigned in this way do not count toward the 100 reserved ports limit of a container instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPort(java.lang.Number containerPort) {
            this.containerPort = containerPort;
            return this;
        }

        /**
         * Sets the value of {@link PortMapping#getHostPort}
         * @param hostPort The port number on the container instance to reserve for your container.
         *                 If you are using containers in a task with the awsvpc or host network mode,
         *                 the hostPort can either be left blank or set to the same value as the containerPort.
         *                 <p>
         *                 If you are using containers in a task with the bridge network mode,
         *                 you can specify a non-reserved host port for your container port mapping, or
         *                 you can omit the hostPort (or set it to 0) while specifying a containerPort and
         *                 your container automatically receives a port in the ephemeral port range for
         *                 your container instance operating system and Docker version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPort(java.lang.Number hostPort) {
            this.hostPort = hostPort;
            return this;
        }

        /**
         * Sets the value of {@link PortMapping#getProtocol}
         * @param protocol The protocol used for the port mapping.
         *                 Valid values are Protocol.TCP and Protocol.UDP.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.ecs.Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link PortMapping}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public PortMapping build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link PortMapping}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PortMapping {
        private final java.lang.Number containerPort;
        private final java.lang.Number hostPort;
        private final software.amazon.awscdk.services.ecs.Protocol protocol;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.hostPort = software.amazon.jsii.Kernel.get(this, "hostPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Protocol.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerPort = java.util.Objects.requireNonNull(builder.containerPort, "containerPort is required");
            this.hostPort = builder.hostPort;
            this.protocol = builder.protocol;
        }

        @Override
        public final java.lang.Number getContainerPort() {
            return this.containerPort;
        }

        @Override
        public final java.lang.Number getHostPort() {
            return this.hostPort;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.Protocol getProtocol() {
            return this.protocol;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("containerPort", om.valueToTree(this.getContainerPort()));
            if (this.getHostPort() != null) {
                data.set("hostPort", om.valueToTree(this.getHostPort()));
            }
            if (this.getProtocol() != null) {
                data.set("protocol", om.valueToTree(this.getProtocol()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.PortMapping"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            PortMapping.Jsii$Proxy that = (PortMapping.Jsii$Proxy) o;

            if (!containerPort.equals(that.containerPort)) return false;
            if (this.hostPort != null ? !this.hostPort.equals(that.hostPort) : that.hostPort != null) return false;
            return this.protocol != null ? this.protocol.equals(that.protocol) : that.protocol == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerPort.hashCode();
            result = 31 * result + (this.hostPort != null ? this.hostPort.hashCode() : 0);
            result = 31 * result + (this.protocol != null ? this.protocol.hashCode() : 0);
            return result;
        }
    }
}
