package software.amazon.awscdk.services.ecs;

/**
 * The properties for task definitions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc = Vpc.fromLookup(this, "Vpc", VpcLookupOptions.builder()
 *         .isDefault(true)
 *         .build());
 * Cluster cluster = Cluster.Builder.create(this, "Ec2Cluster").vpc(vpc).build();
 * cluster.addCapacity("DefaultAutoScalingGroup", AddCapacityOptions.builder()
 *         .instanceType(new InstanceType("t2.micro"))
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build())
 *         .build());
 * TaskDefinition taskDefinition = TaskDefinition.Builder.create(this, "TD")
 *         .compatibility(Compatibility.EC2)
 *         .build();
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("foo/bar"))
 *         .memoryLimitMiB(256)
 *         .build());
 * EcsRunTask runTask = EcsRunTask.Builder.create(this, "Run")
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .launchTarget(EcsEc2LaunchTarget.Builder.create()
 *                 .placementStrategies(List.of(PlacementStrategy.spreadAcrossInstances(), PlacementStrategy.packedByCpu(), PlacementStrategy.randomly()))
 *                 .placementConstraints(List.of(PlacementConstraint.memberOf("blieptuut")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.786Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.TaskDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(TaskDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TaskDefinitionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.CommonTaskDefinitionProps {

    /**
     * The task launch type compatiblity requirement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Compatibility getCompatibility();

    /**
     * The number of cpu units used by the task.
     * <p>
     * If you are using the EC2 launch type, this field is optional and any value can be used.
     * If you are using the Fargate launch type, this field is required and you must use one of the following values,
     * which determines your range of valid values for the memory parameter:
     * <p>
     * 256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
     * <p>
     * 512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
     * <p>
     * 1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
     * <p>
     * 2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
     * <p>
     * 4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
     * <p>
     * Default: - CPU units are not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
        return null;
    }

    /**
     * The amount (in GiB) of ephemeral storage to be allocated to the task.
     * <p>
     * Only supported in Fargate platform version 1.4.0 or later.
     * <p>
     * Default: - Undefined, in which case, the task will receive 20GiB ephemeral storage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getEphemeralStorageGiB() {
        return null;
    }

    /**
     * The inference accelerators to use for the containers in the task.
     * <p>
     * Not supported in Fargate.
     * <p>
     * Default: - No inference accelerators.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> getInferenceAccelerators() {
        return null;
    }

    /**
     * The IPC resource namespace to use for the containers in the task.
     * <p>
     * Not supported in Fargate and Windows containers.
     * <p>
     * Default: - IpcMode used by the task is not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.IpcMode getIpcMode() {
        return null;
    }

    /**
     * The amount (in MiB) of memory used by the task.
     * <p>
     * If using the EC2 launch type, this field is optional and any value can be used.
     * If using the Fargate launch type, this field is required and you must use one of the following values,
     * which determines your range of valid values for the cpu parameter:
     * <p>
     * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
     * <p>
     * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
     * <p>
     * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
     * <p>
     * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
     * <p>
     * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
     * <p>
     * Default: - Memory used by task is not specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMemoryMiB() {
        return null;
    }

    /**
     * The networking mode to use for the containers in the task.
     * <p>
     * On Fargate, the only supported networking mode is AwsVpc.
     * <p>
     * Default: - NetworkMode.Bridge for EC2 & External tasks, AwsVpc for Fargate tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
        return null;
    }

    /**
     * The process namespace to use for the containers in the task.
     * <p>
     * Not supported in Fargate and Windows containers.
     * <p>
     * Default: - PidMode used by the task is not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.PidMode getPidMode() {
        return null;
    }

    /**
     * The placement constraints to use for tasks in the service.
     * <p>
     * You can specify a maximum of 10 constraints per task (this limit includes
     * constraints in the task definition and those specified at run time).
     * <p>
     * Not supported in Fargate.
     * <p>
     * Default: - No placement constraints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> getPlacementConstraints() {
        return null;
    }

    /**
     * The operating system that your task definitions are running on.
     * <p>
     * A runtimePlatform is supported only for tasks using the Fargate launch type.
     * <p>
     * Default: - Undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.RuntimePlatform getRuntimePlatform() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TaskDefinitionProps> {
        software.amazon.awscdk.services.ecs.Compatibility compatibility;
        java.lang.String cpu;
        java.lang.Number ephemeralStorageGiB;
        java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators;
        software.amazon.awscdk.services.ecs.IpcMode ipcMode;
        java.lang.String memoryMiB;
        software.amazon.awscdk.services.ecs.NetworkMode networkMode;
        software.amazon.awscdk.services.ecs.PidMode pidMode;
        java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints;
        software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform;
        software.amazon.awscdk.services.iam.IRole executionRole;
        java.lang.String family;
        software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration;
        software.amazon.awscdk.services.iam.IRole taskRole;
        java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Sets the value of {@link TaskDefinitionProps#getCompatibility}
         * @param compatibility The task launch type compatiblity requirement. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compatibility(software.amazon.awscdk.services.ecs.Compatibility compatibility) {
            this.compatibility = compatibility;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getCpu}
         * @param cpu The number of cpu units used by the task.
         *            If you are using the EC2 launch type, this field is optional and any value can be used.
         *            If you are using the Fargate launch type, this field is required and you must use one of the following values,
         *            which determines your range of valid values for the memory parameter:
         *            <p>
         *            256 (.25 vCPU) - Available memory values: 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB)
         *            <p>
         *            512 (.5 vCPU) - Available memory values: 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB)
         *            <p>
         *            1024 (1 vCPU) - Available memory values: 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB)
         *            <p>
         *            2048 (2 vCPU) - Available memory values: Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB)
         *            <p>
         *            4096 (4 vCPU) - Available memory values: Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.String cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getEphemeralStorageGiB}
         * @param ephemeralStorageGiB The amount (in GiB) of ephemeral storage to be allocated to the task.
         *                            Only supported in Fargate platform version 1.4.0 or later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageGiB(java.lang.Number ephemeralStorageGiB) {
            this.ephemeralStorageGiB = ephemeralStorageGiB;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getInferenceAccelerators}
         * @param inferenceAccelerators The inference accelerators to use for the containers in the task.
         *                              Not supported in Fargate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder inferenceAccelerators(java.util.List<? extends software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators) {
            this.inferenceAccelerators = (java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator>)inferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getIpcMode}
         * @param ipcMode The IPC resource namespace to use for the containers in the task.
         *                Not supported in Fargate and Windows containers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipcMode(software.amazon.awscdk.services.ecs.IpcMode ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getMemoryMiB}
         * @param memoryMiB The amount (in MiB) of memory used by the task.
         *                  If using the EC2 launch type, this field is optional and any value can be used.
         *                  If using the Fargate launch type, this field is required and you must use one of the following values,
         *                  which determines your range of valid values for the cpu parameter:
         *                  <p>
         *                  512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         *                  <p>
         *                  1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         *                  <p>
         *                  2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         *                  <p>
         *                  Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         *                  <p>
         *                  Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryMiB(java.lang.String memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getNetworkMode}
         * @param networkMode The networking mode to use for the containers in the task.
         *                    On Fargate, the only supported networking mode is AwsVpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(software.amazon.awscdk.services.ecs.NetworkMode networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getPidMode}
         * @param pidMode The process namespace to use for the containers in the task.
         *                Not supported in Fargate and Windows containers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pidMode(software.amazon.awscdk.services.ecs.PidMode pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getPlacementConstraints}
         * @param placementConstraints The placement constraints to use for tasks in the service.
         *                             You can specify a maximum of 10 constraints per task (this limit includes
         *                             constraints in the task definition and those specified at run time).
         *                             <p>
         *                             Not supported in Fargate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder placementConstraints(java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.placementConstraints = (java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint>)placementConstraints;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getRuntimePlatform}
         * @param runtimePlatform The operating system that your task definitions are running on.
         *                        A runtimePlatform is supported only for tasks using the Fargate launch type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getExecutionRole}
         * @param executionRole The name of the IAM task execution role that grants the ECS agent permission to call AWS APIs on your behalf.
         *                      The role will be used to retrieve container images from ECR and create CloudWatch log groups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(software.amazon.awscdk.services.iam.IRole executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getFamily}
         * @param family The name of a family that this task definition is registered to.
         *               A family groups multiple versions of a task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getProxyConfiguration}
         * @param proxyConfiguration The configuration details for the App Mesh proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getTaskRole}
         * @param taskRole The name of the IAM role that grants containers in the task permission to call AWS APIs on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRole(software.amazon.awscdk.services.iam.IRole taskRole) {
            this.taskRole = taskRole;
            return this;
        }

        /**
         * Sets the value of {@link TaskDefinitionProps#getVolumes}
         * @param volumes The list of volume definitions for the task.
         *                For more information, see
         *                <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide//task_definition_parameters.html#volumes">Task Definition Parameter Volumes</a>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder volumes(java.util.List<? extends software.amazon.awscdk.services.ecs.Volume> volumes) {
            this.volumes = (java.util.List<software.amazon.awscdk.services.ecs.Volume>)volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TaskDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TaskDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskDefinitionProps {
        private final software.amazon.awscdk.services.ecs.Compatibility compatibility;
        private final java.lang.String cpu;
        private final java.lang.Number ephemeralStorageGiB;
        private final java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> inferenceAccelerators;
        private final software.amazon.awscdk.services.ecs.IpcMode ipcMode;
        private final java.lang.String memoryMiB;
        private final software.amazon.awscdk.services.ecs.NetworkMode networkMode;
        private final software.amazon.awscdk.services.ecs.PidMode pidMode;
        private final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints;
        private final software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform;
        private final software.amazon.awscdk.services.iam.IRole executionRole;
        private final java.lang.String family;
        private final software.amazon.awscdk.services.ecs.ProxyConfiguration proxyConfiguration;
        private final software.amazon.awscdk.services.iam.IRole taskRole;
        private final java.util.List<software.amazon.awscdk.services.ecs.Volume> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.compatibility = software.amazon.jsii.Kernel.get(this, "compatibility", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Compatibility.class));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ephemeralStorageGiB = software.amazon.jsii.Kernel.get(this, "ephemeralStorageGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.inferenceAccelerators = software.amazon.jsii.Kernel.get(this, "inferenceAccelerators", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.InferenceAccelerator.class)));
            this.ipcMode = software.amazon.jsii.Kernel.get(this, "ipcMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IpcMode.class));
            this.memoryMiB = software.amazon.jsii.Kernel.get(this, "memoryMiB", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.NetworkMode.class));
            this.pidMode = software.amazon.jsii.Kernel.get(this, "pidMode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PidMode.class));
            this.placementConstraints = software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementConstraint.class)));
            this.runtimePlatform = software.amazon.jsii.Kernel.get(this, "runtimePlatform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.RuntimePlatform.class));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyConfiguration = software.amazon.jsii.Kernel.get(this, "proxyConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ProxyConfiguration.class));
            this.taskRole = software.amazon.jsii.Kernel.get(this, "taskRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Volume.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.compatibility = java.util.Objects.requireNonNull(builder.compatibility, "compatibility is required");
            this.cpu = builder.cpu;
            this.ephemeralStorageGiB = builder.ephemeralStorageGiB;
            this.inferenceAccelerators = (java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator>)builder.inferenceAccelerators;
            this.ipcMode = builder.ipcMode;
            this.memoryMiB = builder.memoryMiB;
            this.networkMode = builder.networkMode;
            this.pidMode = builder.pidMode;
            this.placementConstraints = (java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint>)builder.placementConstraints;
            this.runtimePlatform = builder.runtimePlatform;
            this.executionRole = builder.executionRole;
            this.family = builder.family;
            this.proxyConfiguration = builder.proxyConfiguration;
            this.taskRole = builder.taskRole;
            this.volumes = (java.util.List<software.amazon.awscdk.services.ecs.Volume>)builder.volumes;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.Compatibility getCompatibility() {
            return this.compatibility;
        }

        @Override
        public final java.lang.String getCpu() {
            return this.cpu;
        }

        @Override
        public final java.lang.Number getEphemeralStorageGiB() {
            return this.ephemeralStorageGiB;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.InferenceAccelerator> getInferenceAccelerators() {
            return this.inferenceAccelerators;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.IpcMode getIpcMode() {
            return this.ipcMode;
        }

        @Override
        public final java.lang.String getMemoryMiB() {
            return this.memoryMiB;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.NetworkMode getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PidMode getPidMode() {
            return this.pidMode;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> getPlacementConstraints() {
            return this.placementConstraints;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.RuntimePlatform getRuntimePlatform() {
            return this.runtimePlatform;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ProxyConfiguration getProxyConfiguration() {
            return this.proxyConfiguration;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getTaskRole() {
            return this.taskRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.Volume> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("compatibility", om.valueToTree(this.getCompatibility()));
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getEphemeralStorageGiB() != null) {
                data.set("ephemeralStorageGiB", om.valueToTree(this.getEphemeralStorageGiB()));
            }
            if (this.getInferenceAccelerators() != null) {
                data.set("inferenceAccelerators", om.valueToTree(this.getInferenceAccelerators()));
            }
            if (this.getIpcMode() != null) {
                data.set("ipcMode", om.valueToTree(this.getIpcMode()));
            }
            if (this.getMemoryMiB() != null) {
                data.set("memoryMiB", om.valueToTree(this.getMemoryMiB()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getPidMode() != null) {
                data.set("pidMode", om.valueToTree(this.getPidMode()));
            }
            if (this.getPlacementConstraints() != null) {
                data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
            }
            if (this.getRuntimePlatform() != null) {
                data.set("runtimePlatform", om.valueToTree(this.getRuntimePlatform()));
            }
            if (this.getExecutionRole() != null) {
                data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getProxyConfiguration() != null) {
                data.set("proxyConfiguration", om.valueToTree(this.getProxyConfiguration()));
            }
            if (this.getTaskRole() != null) {
                data.set("taskRole", om.valueToTree(this.getTaskRole()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.TaskDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TaskDefinitionProps.Jsii$Proxy that = (TaskDefinitionProps.Jsii$Proxy) o;

            if (!compatibility.equals(that.compatibility)) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.ephemeralStorageGiB != null ? !this.ephemeralStorageGiB.equals(that.ephemeralStorageGiB) : that.ephemeralStorageGiB != null) return false;
            if (this.inferenceAccelerators != null ? !this.inferenceAccelerators.equals(that.inferenceAccelerators) : that.inferenceAccelerators != null) return false;
            if (this.ipcMode != null ? !this.ipcMode.equals(that.ipcMode) : that.ipcMode != null) return false;
            if (this.memoryMiB != null ? !this.memoryMiB.equals(that.memoryMiB) : that.memoryMiB != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.pidMode != null ? !this.pidMode.equals(that.pidMode) : that.pidMode != null) return false;
            if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
            if (this.runtimePlatform != null ? !this.runtimePlatform.equals(that.runtimePlatform) : that.runtimePlatform != null) return false;
            if (this.executionRole != null ? !this.executionRole.equals(that.executionRole) : that.executionRole != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.proxyConfiguration != null ? !this.proxyConfiguration.equals(that.proxyConfiguration) : that.proxyConfiguration != null) return false;
            if (this.taskRole != null ? !this.taskRole.equals(that.taskRole) : that.taskRole != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.compatibility.hashCode();
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.ephemeralStorageGiB != null ? this.ephemeralStorageGiB.hashCode() : 0);
            result = 31 * result + (this.inferenceAccelerators != null ? this.inferenceAccelerators.hashCode() : 0);
            result = 31 * result + (this.ipcMode != null ? this.ipcMode.hashCode() : 0);
            result = 31 * result + (this.memoryMiB != null ? this.memoryMiB.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.pidMode != null ? this.pidMode.hashCode() : 0);
            result = 31 * result + (this.placementConstraints != null ? this.placementConstraints.hashCode() : 0);
            result = 31 * result + (this.runtimePlatform != null ? this.runtimePlatform.hashCode() : 0);
            result = 31 * result + (this.executionRole != null ? this.executionRole.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.proxyConfiguration != null ? this.proxyConfiguration.hashCode() : 0);
            result = 31 * result + (this.taskRole != null ? this.taskRole.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
