package software.amazon.awscdk.services.eks;

/**
 * Helm Chart options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.s3.assets.*;
 * Cluster cluster;
 * Asset chartAsset = Asset.Builder.create(this, "ChartAsset")
 *         .path("/path/to/asset")
 *         .build();
 * cluster.addHelmChart("test-chart", HelmChartOptions.builder()
 *         .chartAsset(chartAsset)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.962Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.HelmChartOptions")
@software.amazon.jsii.Jsii.Proxy(HelmChartOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HelmChartOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the chart.
     * <p>
     * Either this or <code>chartAsset</code> must be specified.
     * <p>
     * Default: - No chart name. Implies `chartAsset` is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getChart() {
        return null;
    }

    /**
     * The chart in the form of an asset.
     * <p>
     * Either this or <code>chart</code> must be specified.
     * <p>
     * Default: - No chart asset. Implies `chart` is used.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.Asset getChartAsset() {
        return null;
    }

    /**
     * create namespace if not exist.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCreateNamespace() {
        return null;
    }

    /**
     * The Kubernetes namespace scope of the requests.
     * <p>
     * Default: default
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
        return null;
    }

    /**
     * The name of the release.
     * <p>
     * Default: - If no release name is given, it will use the last 53 characters of the node's unique id.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRelease() {
        return null;
    }

    /**
     * The repository which contains the chart.
     * <p>
     * For example: https://kubernetes-charts.storage.googleapis.com/
     * <p>
     * Default: - No repository will be used, which means that the chart needs to be an absolute URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRepository() {
        return null;
    }

    /**
     * Amount of time to wait for any individual Kubernetes operation.
     * <p>
     * Maximum 15 minutes.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * The values to be used by the chart.
     * <p>
     * Default: - No values are provided to the chart.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getValues() {
        return null;
    }

    /**
     * The chart version to install.
     * <p>
     * Default: - If this is not specified, the latest version is installed
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * Whether or not Helm should wait until all Pods, PVCs, Services, and minimum number of Pods of a Deployment, StatefulSet, or ReplicaSet are in a ready state before marking the release as successful.
     * <p>
     * Default: - Helm will not wait before marking release as successful
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWait() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HelmChartOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HelmChartOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HelmChartOptions> {
        java.lang.String chart;
        software.amazon.awscdk.services.s3.assets.Asset chartAsset;
        java.lang.Boolean createNamespace;
        java.lang.String namespace;
        java.lang.String release;
        java.lang.String repository;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> values;
        java.lang.String version;
        java.lang.Boolean wait;

        /**
         * Sets the value of {@link HelmChartOptions#getChart}
         * @param chart The name of the chart.
         *              Either this or <code>chartAsset</code> must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chart(java.lang.String chart) {
            this.chart = chart;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getChartAsset}
         * @param chartAsset The chart in the form of an asset.
         *                   Either this or <code>chart</code> must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder chartAsset(software.amazon.awscdk.services.s3.assets.Asset chartAsset) {
            this.chartAsset = chartAsset;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getCreateNamespace}
         * @param createNamespace create namespace if not exist.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createNamespace(java.lang.Boolean createNamespace) {
            this.createNamespace = createNamespace;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getNamespace}
         * @param namespace The Kubernetes namespace scope of the requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getRelease}
         * @param release The name of the release.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder release(java.lang.String release) {
            this.release = release;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getRepository}
         * @param repository The repository which contains the chart.
         *                   For example: https://kubernetes-charts.storage.googleapis.com/
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(java.lang.String repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getTimeout}
         * @param timeout Amount of time to wait for any individual Kubernetes operation.
         *                Maximum 15 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getValues}
         * @param values The values to be used by the chart.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder values(java.util.Map<java.lang.String, ? extends java.lang.Object> values) {
            this.values = (java.util.Map<java.lang.String, java.lang.Object>)values;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getVersion}
         * @param version The chart version to install.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link HelmChartOptions#getWait}
         * @param wait Whether or not Helm should wait until all Pods, PVCs, Services, and minimum number of Pods of a Deployment, StatefulSet, or ReplicaSet are in a ready state before marking the release as successful.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder wait(java.lang.Boolean wait) {
            this.wait = wait;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HelmChartOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HelmChartOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HelmChartOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HelmChartOptions {
        private final java.lang.String chart;
        private final software.amazon.awscdk.services.s3.assets.Asset chartAsset;
        private final java.lang.Boolean createNamespace;
        private final java.lang.String namespace;
        private final java.lang.String release;
        private final java.lang.String repository;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> values;
        private final java.lang.String version;
        private final java.lang.Boolean wait;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.chart = software.amazon.jsii.Kernel.get(this, "chart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.chartAsset = software.amazon.jsii.Kernel.get(this, "chartAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.assets.Asset.class));
            this.createNamespace = software.amazon.jsii.Kernel.get(this, "createNamespace", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.release = software.amazon.jsii.Kernel.get(this, "release", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.repository = software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.wait = software.amazon.jsii.Kernel.get(this, "wait", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.chart = builder.chart;
            this.chartAsset = builder.chartAsset;
            this.createNamespace = builder.createNamespace;
            this.namespace = builder.namespace;
            this.release = builder.release;
            this.repository = builder.repository;
            this.timeout = builder.timeout;
            this.values = (java.util.Map<java.lang.String, java.lang.Object>)builder.values;
            this.version = builder.version;
            this.wait = builder.wait;
        }

        @Override
        public final java.lang.String getChart() {
            return this.chart;
        }

        @Override
        public final software.amazon.awscdk.services.s3.assets.Asset getChartAsset() {
            return this.chartAsset;
        }

        @Override
        public final java.lang.Boolean getCreateNamespace() {
            return this.createNamespace;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.String getRelease() {
            return this.release;
        }

        @Override
        public final java.lang.String getRepository() {
            return this.repository;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getValues() {
            return this.values;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.Boolean getWait() {
            return this.wait;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getChart() != null) {
                data.set("chart", om.valueToTree(this.getChart()));
            }
            if (this.getChartAsset() != null) {
                data.set("chartAsset", om.valueToTree(this.getChartAsset()));
            }
            if (this.getCreateNamespace() != null) {
                data.set("createNamespace", om.valueToTree(this.getCreateNamespace()));
            }
            if (this.getNamespace() != null) {
                data.set("namespace", om.valueToTree(this.getNamespace()));
            }
            if (this.getRelease() != null) {
                data.set("release", om.valueToTree(this.getRelease()));
            }
            if (this.getRepository() != null) {
                data.set("repository", om.valueToTree(this.getRepository()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getValues() != null) {
                data.set("values", om.valueToTree(this.getValues()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }
            if (this.getWait() != null) {
                data.set("wait", om.valueToTree(this.getWait()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.HelmChartOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HelmChartOptions.Jsii$Proxy that = (HelmChartOptions.Jsii$Proxy) o;

            if (this.chart != null ? !this.chart.equals(that.chart) : that.chart != null) return false;
            if (this.chartAsset != null ? !this.chartAsset.equals(that.chartAsset) : that.chartAsset != null) return false;
            if (this.createNamespace != null ? !this.createNamespace.equals(that.createNamespace) : that.createNamespace != null) return false;
            if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
            if (this.release != null ? !this.release.equals(that.release) : that.release != null) return false;
            if (this.repository != null ? !this.repository.equals(that.repository) : that.repository != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.values != null ? !this.values.equals(that.values) : that.values != null) return false;
            if (this.version != null ? !this.version.equals(that.version) : that.version != null) return false;
            return this.wait != null ? this.wait.equals(that.wait) : that.wait == null;
        }

        @Override
        public final int hashCode() {
            int result = this.chart != null ? this.chart.hashCode() : 0;
            result = 31 * result + (this.chartAsset != null ? this.chartAsset.hashCode() : 0);
            result = 31 * result + (this.createNamespace != null ? this.createNamespace.hashCode() : 0);
            result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
            result = 31 * result + (this.release != null ? this.release.hashCode() : 0);
            result = 31 * result + (this.repository != null ? this.repository.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + (this.wait != null ? this.wait.hashCode() : 0);
            return result;
        }
    }
}
