package software.amazon.awscdk.services.eks;

/**
 * Represents a value of a specific object deployed in the cluster.
 * <p>
 * Use this to fetch any information available by the <code>kubectl get</code> command.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * // query the load balancer address
 * KubernetesObjectValue myServiceAddress = KubernetesObjectValue.Builder.create(this, "LoadBalancerAttribute")
 *         .cluster(cluster)
 *         .objectType("service")
 *         .objectName("my-service")
 *         .jsonPath(".status.loadBalancer.ingress[0].hostname")
 *         .build();
 * // pass the address to a lambda function
 * Function proxyFunction = Function.Builder.create(this, "ProxyFunction")
 *         .handler("index.handler")
 *         .code(Code.fromInline("my-code"))
 *         .runtime(Runtime.NODEJS_14_X)
 *         .environment(Map.of(
 *                 "myServiceAddress", myServiceAddress.getValue()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:45.969Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.KubernetesObjectValue")
public class KubernetesObjectValue extends software.constructs.Construct {

    protected KubernetesObjectValue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KubernetesObjectValue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        RESOURCE_TYPE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.eks.KubernetesObjectValue.class, "RESOURCE_TYPE", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KubernetesObjectValue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.KubernetesObjectValueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The CloudFormation reosurce type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String RESOURCE_TYPE;

    /**
     * The value as a string token.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.eks.KubernetesObjectValue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.eks.KubernetesObjectValue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.eks.KubernetesObjectValueProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.eks.KubernetesObjectValueProps.Builder();
        }

        /**
         * The EKS cluster to fetch attributes from.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * @return {@code this}
         * @param cluster The EKS cluster to fetch attributes from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.eks.ICluster cluster) {
            this.props.cluster(cluster);
            return this;
        }

        /**
         * JSONPath to the specific value.
         * <p>
         * @return {@code this}
         * @see https://kubernetes.io/docs/reference/kubectl/jsonpath/
         * @param jsonPath JSONPath to the specific value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonPath(final java.lang.String jsonPath) {
            this.props.jsonPath(jsonPath);
            return this;
        }

        /**
         * The name of the object to query.
         * <p>
         * @return {@code this}
         * @param objectName The name of the object to query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectName(final java.lang.String objectName) {
            this.props.objectName(objectName);
            return this;
        }

        /**
         * The object type to query.
         * <p>
         * (e.g 'service', 'pod'...)
         * <p>
         * @return {@code this}
         * @param objectType The object type to query. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectType(final java.lang.String objectType) {
            this.props.objectType(objectType);
            return this;
        }

        /**
         * The namespace the object belongs to.
         * <p>
         * Default: 'default'
         * <p>
         * @return {@code this}
         * @param objectNamespace The namespace the object belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectNamespace(final java.lang.String objectNamespace) {
            this.props.objectNamespace(objectNamespace);
            return this;
        }

        /**
         * Timeout for waiting on a value.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param timeout Timeout for waiting on a value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.eks.KubernetesObjectValue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.eks.KubernetesObjectValue build() {
            return new software.amazon.awscdk.services.eks.KubernetesObjectValue(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
