package software.amazon.awscdk.services.elasticloadbalancing;

/**
 * Properties for defining a `CfnLoadBalancer`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancing.*;
 * Object attributes;
 * CfnLoadBalancerProps cfnLoadBalancerProps = CfnLoadBalancerProps.builder()
 *         .listeners(List.of(ListenersProperty.builder()
 *                 .instancePort("instancePort")
 *                 .loadBalancerPort("loadBalancerPort")
 *                 .protocol("protocol")
 *                 // the properties below are optional
 *                 .instanceProtocol("instanceProtocol")
 *                 .policyNames(List.of("policyNames"))
 *                 .sslCertificateId("sslCertificateId")
 *                 .build()))
 *         // the properties below are optional
 *         .accessLoggingPolicy(AccessLoggingPolicyProperty.builder()
 *                 .enabled(false)
 *                 .s3BucketName("s3BucketName")
 *                 // the properties below are optional
 *                 .emitInterval(123)
 *                 .s3BucketPrefix("s3BucketPrefix")
 *                 .build())
 *         .appCookieStickinessPolicy(List.of(AppCookieStickinessPolicyProperty.builder()
 *                 .cookieName("cookieName")
 *                 .policyName("policyName")
 *                 .build()))
 *         .availabilityZones(List.of("availabilityZones"))
 *         .connectionDrainingPolicy(ConnectionDrainingPolicyProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .timeout(123)
 *                 .build())
 *         .connectionSettings(ConnectionSettingsProperty.builder()
 *                 .idleTimeout(123)
 *                 .build())
 *         .crossZone(false)
 *         .healthCheck(HealthCheckProperty.builder()
 *                 .healthyThreshold("healthyThreshold")
 *                 .interval("interval")
 *                 .target("target")
 *                 .timeout("timeout")
 *                 .unhealthyThreshold("unhealthyThreshold")
 *                 .build())
 *         .instances(List.of("instances"))
 *         .lbCookieStickinessPolicy(List.of(LBCookieStickinessPolicyProperty.builder()
 *                 .cookieExpirationPeriod("cookieExpirationPeriod")
 *                 .policyName("policyName")
 *                 .build()))
 *         .loadBalancerName("loadBalancerName")
 *         .policies(List.of(PoliciesProperty.builder()
 *                 .attributes(List.of(attributes))
 *                 .policyName("policyName")
 *                 .policyType("policyType")
 *                 // the properties below are optional
 *                 .instancePorts(List.of("instancePorts"))
 *                 .loadBalancerPorts(List.of("loadBalancerPorts"))
 *                 .build()))
 *         .scheme("scheme")
 *         .securityGroups(List.of("securityGroups"))
 *         .subnets(List.of("subnets"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:46.053Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancing.CfnLoadBalancerProps")
@software.amazon.jsii.Jsii.Proxy(CfnLoadBalancerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnLoadBalancerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The listeners for the load balancer. You can specify at most one listener per port.
     * <p>
     * If you update the properties for a listener, AWS CloudFormation deletes the existing listener and creates a new one with the specified properties. While the new listener is being created, clients cannot connect to the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getListeners();

    /**
     * Information about where and how access logs are stored for the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAccessLoggingPolicy() {
        return null;
    }

    /**
     * Information about a policy for application-controlled session stickiness.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAppCookieStickinessPolicy() {
        return null;
    }

    /**
     * The Availability Zones for the load balancer. For load balancers in a VPC, specify `Subnets` instead.
     * <p>
     * Update requires replacement if you did not previously specify an Availability Zone or if you are removing all Availability Zones. Otherwise, update requires no interruption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAvailabilityZones() {
        return null;
    }

    /**
     * If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining</a> in the <em>Classic Load Balancers Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionDrainingPolicy() {
        return null;
    }

    /**
     * If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.
     * <p>
     * By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout</a> in the <em>Classic Load Balancers Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionSettings() {
        return null;
    }

    /**
     * If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing</a> in the <em>Classic Load Balancers Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCrossZone() {
        return null;
    }

    /**
     * The health check settings to use when evaluating the health of your EC2 instances.
     * <p>
     * Update requires replacement if you did not previously specify health check settings or if you are removing the health check settings. Otherwise, update requires no interruption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHealthCheck() {
        return null;
    }

    /**
     * The IDs of the instances for the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInstances() {
        return null;
    }

    /**
     * Information about a policy for duration-based session stickiness.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLbCookieStickinessPolicy() {
        return null;
    }

    /**
     * The name of the load balancer.
     * <p>
     * This name must be unique within your set of load balancers for the region.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the load balancer. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> . If you specify a name, you cannot perform updates that require replacement of this resource, but you can perform other updates. To replace the resource, specify a new name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerName() {
        return null;
    }

    /**
     * The policies defined for your Classic Load Balancer.
     * <p>
     * Specify only back-end server policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicies() {
        return null;
    }

    /**
     * The type of load balancer. Valid only for load balancers in a VPC.
     * <p>
     * If <code>Scheme</code> is <code>internet-facing</code> , the load balancer has a public DNS name that resolves to a public IP address.
     * <p>
     * If <code>Scheme</code> is <code>internal</code> , the load balancer has a public DNS name that resolves to a private IP address.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getScheme() {
        return null;
    }

    /**
     * The security groups for the load balancer.
     * <p>
     * Valid only for load balancers in a VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return null;
    }

    /**
     * The IDs of the subnets for the load balancer. You can specify at most one subnet per Availability Zone.
     * <p>
     * Update requires replacement if you did not previously specify a subnet or if you are removing all subnets. Otherwise, update requires no interruption. To update to a different subnet in the current Availability Zone, you must first update to a subnet in a different Availability Zone, then update to the new subnet in the original Availability Zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
        return null;
    }

    /**
     * The tags associated with a load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnLoadBalancerProps> {
        java.lang.Object listeners;
        java.lang.Object accessLoggingPolicy;
        java.lang.Object appCookieStickinessPolicy;
        java.util.List<java.lang.String> availabilityZones;
        java.lang.Object connectionDrainingPolicy;
        java.lang.Object connectionSettings;
        java.lang.Object crossZone;
        java.lang.Object healthCheck;
        java.util.List<java.lang.String> instances;
        java.lang.Object lbCookieStickinessPolicy;
        java.lang.String loadBalancerName;
        java.lang.Object policies;
        java.lang.String scheme;
        java.util.List<java.lang.String> securityGroups;
        java.util.List<java.lang.String> subnets;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getListeners}
         * @param listeners The listeners for the load balancer. You can specify at most one listener per port. This parameter is required.
         *                  If you update the properties for a listener, AWS CloudFormation deletes the existing listener and creates a new one with the specified properties. While the new listener is being created, clients cannot connect to the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(software.amazon.awscdk.IResolvable listeners) {
            this.listeners = listeners;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getListeners}
         * @param listeners The listeners for the load balancer. You can specify at most one listener per port. This parameter is required.
         *                  If you update the properties for a listener, AWS CloudFormation deletes the existing listener and creates a new one with the specified properties. While the new listener is being created, clients cannot connect to the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listeners(java.util.List<? extends java.lang.Object> listeners) {
            this.listeners = listeners;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getAccessLoggingPolicy}
         * @param accessLoggingPolicy Information about where and how access logs are stored for the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingPolicy(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.AccessLoggingPolicyProperty accessLoggingPolicy) {
            this.accessLoggingPolicy = accessLoggingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getAccessLoggingPolicy}
         * @param accessLoggingPolicy Information about where and how access logs are stored for the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessLoggingPolicy(software.amazon.awscdk.IResolvable accessLoggingPolicy) {
            this.accessLoggingPolicy = accessLoggingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getAppCookieStickinessPolicy}
         * @param appCookieStickinessPolicy Information about a policy for application-controlled session stickiness.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appCookieStickinessPolicy(software.amazon.awscdk.IResolvable appCookieStickinessPolicy) {
            this.appCookieStickinessPolicy = appCookieStickinessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getAppCookieStickinessPolicy}
         * @param appCookieStickinessPolicy Information about a policy for application-controlled session stickiness.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appCookieStickinessPolicy(java.util.List<? extends java.lang.Object> appCookieStickinessPolicy) {
            this.appCookieStickinessPolicy = appCookieStickinessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getAvailabilityZones}
         * @param availabilityZones The Availability Zones for the load balancer. For load balancers in a VPC, specify `Subnets` instead.
         *                          Update requires replacement if you did not previously specify an Availability Zone or if you are removing all Availability Zones. Otherwise, update requires no interruption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZones(java.util.List<java.lang.String> availabilityZones) {
            this.availabilityZones = availabilityZones;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getConnectionDrainingPolicy}
         * @param connectionDrainingPolicy If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.
         *                                 For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining</a> in the <em>Classic Load Balancers Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionDrainingPolicy(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionDrainingPolicyProperty connectionDrainingPolicy) {
            this.connectionDrainingPolicy = connectionDrainingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getConnectionDrainingPolicy}
         * @param connectionDrainingPolicy If enabled, the load balancer allows existing requests to complete before the load balancer shifts traffic away from a deregistered or unhealthy instance.
         *                                 For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-conn-drain.html">Configure Connection Draining</a> in the <em>Classic Load Balancers Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionDrainingPolicy(software.amazon.awscdk.IResolvable connectionDrainingPolicy) {
            this.connectionDrainingPolicy = connectionDrainingPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getConnectionSettings}
         * @param connectionSettings If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.
         *                           By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout</a> in the <em>Classic Load Balancers Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionSettings(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.ConnectionSettingsProperty connectionSettings) {
            this.connectionSettings = connectionSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getConnectionSettings}
         * @param connectionSettings If enabled, the load balancer allows the connections to remain idle (no data is sent over the connection) for the specified duration.
         *                           By default, Elastic Load Balancing maintains a 60-second idle connection timeout for both front-end and back-end connections of your load balancer. For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/config-idle-timeout.html">Configure Idle Connection Timeout</a> in the <em>Classic Load Balancers Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionSettings(software.amazon.awscdk.IResolvable connectionSettings) {
            this.connectionSettings = connectionSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getCrossZone}
         * @param crossZone If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.
         *                  For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing</a> in the <em>Classic Load Balancers Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZone(java.lang.Boolean crossZone) {
            this.crossZone = crossZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getCrossZone}
         * @param crossZone If enabled, the load balancer routes the request traffic evenly across all instances regardless of the Availability Zones.
         *                  For more information, see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/enable-disable-crosszone-lb.html">Configure Cross-Zone Load Balancing</a> in the <em>Classic Load Balancers Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder crossZone(software.amazon.awscdk.IResolvable crossZone) {
            this.crossZone = crossZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getHealthCheck}
         * @param healthCheck The health check settings to use when evaluating the health of your EC2 instances.
         *                    Update requires replacement if you did not previously specify health check settings or if you are removing the health check settings. Otherwise, update requires no interruption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.services.elasticloadbalancing.CfnLoadBalancer.HealthCheckProperty healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getHealthCheck}
         * @param healthCheck The health check settings to use when evaluating the health of your EC2 instances.
         *                    Update requires replacement if you did not previously specify health check settings or if you are removing the health check settings. Otherwise, update requires no interruption.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(software.amazon.awscdk.IResolvable healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getInstances}
         * @param instances The IDs of the instances for the load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(java.util.List<java.lang.String> instances) {
            this.instances = instances;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getLbCookieStickinessPolicy}
         * @param lbCookieStickinessPolicy Information about a policy for duration-based session stickiness.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lbCookieStickinessPolicy(software.amazon.awscdk.IResolvable lbCookieStickinessPolicy) {
            this.lbCookieStickinessPolicy = lbCookieStickinessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getLbCookieStickinessPolicy}
         * @param lbCookieStickinessPolicy Information about a policy for duration-based session stickiness.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lbCookieStickinessPolicy(java.util.List<? extends java.lang.Object> lbCookieStickinessPolicy) {
            this.lbCookieStickinessPolicy = lbCookieStickinessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getLoadBalancerName}
         * @param loadBalancerName The name of the load balancer.
         *                         This name must be unique within your set of load balancers for the region.
         *                         <p>
         *                         If you don't specify a name, AWS CloudFormation generates a unique physical ID for the load balancer. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> . If you specify a name, you cannot perform updates that require replacement of this resource, but you can perform other updates. To replace the resource, specify a new name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancerName(java.lang.String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getPolicies}
         * @param policies The policies defined for your Classic Load Balancer.
         *                 Specify only back-end server policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(software.amazon.awscdk.IResolvable policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getPolicies}
         * @param policies The policies defined for your Classic Load Balancer.
         *                 Specify only back-end server policies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policies(java.util.List<? extends java.lang.Object> policies) {
            this.policies = policies;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getScheme}
         * @param scheme The type of load balancer. Valid only for load balancers in a VPC.
         *               If <code>Scheme</code> is <code>internet-facing</code> , the load balancer has a public DNS name that resolves to a public IP address.
         *               <p>
         *               If <code>Scheme</code> is <code>internal</code> , the load balancer has a public DNS name that resolves to a private IP address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheme(java.lang.String scheme) {
            this.scheme = scheme;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSecurityGroups}
         * @param securityGroups The security groups for the load balancer.
         *                       Valid only for load balancers in a VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getSubnets}
         * @param subnets The IDs of the subnets for the load balancer. You can specify at most one subnet per Availability Zone.
         *                Update requires replacement if you did not previously specify a subnet or if you are removing all subnets. Otherwise, update requires no interruption. To update to a different subnet in the current Availability Zone, you must first update to a subnet in a different Availability Zone, then update to the new subnet in the original Availability Zone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnets(java.util.List<java.lang.String> subnets) {
            this.subnets = subnets;
            return this;
        }

        /**
         * Sets the value of {@link CfnLoadBalancerProps#getTags}
         * @param tags The tags associated with a load balancer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnLoadBalancerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnLoadBalancerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnLoadBalancerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnLoadBalancerProps {
        private final java.lang.Object listeners;
        private final java.lang.Object accessLoggingPolicy;
        private final java.lang.Object appCookieStickinessPolicy;
        private final java.util.List<java.lang.String> availabilityZones;
        private final java.lang.Object connectionDrainingPolicy;
        private final java.lang.Object connectionSettings;
        private final java.lang.Object crossZone;
        private final java.lang.Object healthCheck;
        private final java.util.List<java.lang.String> instances;
        private final java.lang.Object lbCookieStickinessPolicy;
        private final java.lang.String loadBalancerName;
        private final java.lang.Object policies;
        private final java.lang.String scheme;
        private final java.util.List<java.lang.String> securityGroups;
        private final java.util.List<java.lang.String> subnets;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listeners = software.amazon.jsii.Kernel.get(this, "listeners", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.accessLoggingPolicy = software.amazon.jsii.Kernel.get(this, "accessLoggingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.appCookieStickinessPolicy = software.amazon.jsii.Kernel.get(this, "appCookieStickinessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.availabilityZones = software.amazon.jsii.Kernel.get(this, "availabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.connectionDrainingPolicy = software.amazon.jsii.Kernel.get(this, "connectionDrainingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectionSettings = software.amazon.jsii.Kernel.get(this, "connectionSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.crossZone = software.amazon.jsii.Kernel.get(this, "crossZone", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.healthCheck = software.amazon.jsii.Kernel.get(this, "healthCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.instances = software.amazon.jsii.Kernel.get(this, "instances", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.lbCookieStickinessPolicy = software.amazon.jsii.Kernel.get(this, "lbCookieStickinessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.loadBalancerName = software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policies = software.amazon.jsii.Kernel.get(this, "policies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scheme = software.amazon.jsii.Kernel.get(this, "scheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listeners = java.util.Objects.requireNonNull(builder.listeners, "listeners is required");
            this.accessLoggingPolicy = builder.accessLoggingPolicy;
            this.appCookieStickinessPolicy = builder.appCookieStickinessPolicy;
            this.availabilityZones = builder.availabilityZones;
            this.connectionDrainingPolicy = builder.connectionDrainingPolicy;
            this.connectionSettings = builder.connectionSettings;
            this.crossZone = builder.crossZone;
            this.healthCheck = builder.healthCheck;
            this.instances = builder.instances;
            this.lbCookieStickinessPolicy = builder.lbCookieStickinessPolicy;
            this.loadBalancerName = builder.loadBalancerName;
            this.policies = builder.policies;
            this.scheme = builder.scheme;
            this.securityGroups = builder.securityGroups;
            this.subnets = builder.subnets;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getListeners() {
            return this.listeners;
        }

        @Override
        public final java.lang.Object getAccessLoggingPolicy() {
            return this.accessLoggingPolicy;
        }

        @Override
        public final java.lang.Object getAppCookieStickinessPolicy() {
            return this.appCookieStickinessPolicy;
        }

        @Override
        public final java.util.List<java.lang.String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final java.lang.Object getConnectionDrainingPolicy() {
            return this.connectionDrainingPolicy;
        }

        @Override
        public final java.lang.Object getConnectionSettings() {
            return this.connectionSettings;
        }

        @Override
        public final java.lang.Object getCrossZone() {
            return this.crossZone;
        }

        @Override
        public final java.lang.Object getHealthCheck() {
            return this.healthCheck;
        }

        @Override
        public final java.util.List<java.lang.String> getInstances() {
            return this.instances;
        }

        @Override
        public final java.lang.Object getLbCookieStickinessPolicy() {
            return this.lbCookieStickinessPolicy;
        }

        @Override
        public final java.lang.String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        @Override
        public final java.lang.Object getPolicies() {
            return this.policies;
        }

        @Override
        public final java.lang.String getScheme() {
            return this.scheme;
        }

        @Override
        public final java.util.List<java.lang.String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.util.List<java.lang.String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listeners", om.valueToTree(this.getListeners()));
            if (this.getAccessLoggingPolicy() != null) {
                data.set("accessLoggingPolicy", om.valueToTree(this.getAccessLoggingPolicy()));
            }
            if (this.getAppCookieStickinessPolicy() != null) {
                data.set("appCookieStickinessPolicy", om.valueToTree(this.getAppCookieStickinessPolicy()));
            }
            if (this.getAvailabilityZones() != null) {
                data.set("availabilityZones", om.valueToTree(this.getAvailabilityZones()));
            }
            if (this.getConnectionDrainingPolicy() != null) {
                data.set("connectionDrainingPolicy", om.valueToTree(this.getConnectionDrainingPolicy()));
            }
            if (this.getConnectionSettings() != null) {
                data.set("connectionSettings", om.valueToTree(this.getConnectionSettings()));
            }
            if (this.getCrossZone() != null) {
                data.set("crossZone", om.valueToTree(this.getCrossZone()));
            }
            if (this.getHealthCheck() != null) {
                data.set("healthCheck", om.valueToTree(this.getHealthCheck()));
            }
            if (this.getInstances() != null) {
                data.set("instances", om.valueToTree(this.getInstances()));
            }
            if (this.getLbCookieStickinessPolicy() != null) {
                data.set("lbCookieStickinessPolicy", om.valueToTree(this.getLbCookieStickinessPolicy()));
            }
            if (this.getLoadBalancerName() != null) {
                data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
            }
            if (this.getPolicies() != null) {
                data.set("policies", om.valueToTree(this.getPolicies()));
            }
            if (this.getScheme() != null) {
                data.set("scheme", om.valueToTree(this.getScheme()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSubnets() != null) {
                data.set("subnets", om.valueToTree(this.getSubnets()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancing.CfnLoadBalancerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnLoadBalancerProps.Jsii$Proxy that = (CfnLoadBalancerProps.Jsii$Proxy) o;

            if (!listeners.equals(that.listeners)) return false;
            if (this.accessLoggingPolicy != null ? !this.accessLoggingPolicy.equals(that.accessLoggingPolicy) : that.accessLoggingPolicy != null) return false;
            if (this.appCookieStickinessPolicy != null ? !this.appCookieStickinessPolicy.equals(that.appCookieStickinessPolicy) : that.appCookieStickinessPolicy != null) return false;
            if (this.availabilityZones != null ? !this.availabilityZones.equals(that.availabilityZones) : that.availabilityZones != null) return false;
            if (this.connectionDrainingPolicy != null ? !this.connectionDrainingPolicy.equals(that.connectionDrainingPolicy) : that.connectionDrainingPolicy != null) return false;
            if (this.connectionSettings != null ? !this.connectionSettings.equals(that.connectionSettings) : that.connectionSettings != null) return false;
            if (this.crossZone != null ? !this.crossZone.equals(that.crossZone) : that.crossZone != null) return false;
            if (this.healthCheck != null ? !this.healthCheck.equals(that.healthCheck) : that.healthCheck != null) return false;
            if (this.instances != null ? !this.instances.equals(that.instances) : that.instances != null) return false;
            if (this.lbCookieStickinessPolicy != null ? !this.lbCookieStickinessPolicy.equals(that.lbCookieStickinessPolicy) : that.lbCookieStickinessPolicy != null) return false;
            if (this.loadBalancerName != null ? !this.loadBalancerName.equals(that.loadBalancerName) : that.loadBalancerName != null) return false;
            if (this.policies != null ? !this.policies.equals(that.policies) : that.policies != null) return false;
            if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.listeners.hashCode();
            result = 31 * result + (this.accessLoggingPolicy != null ? this.accessLoggingPolicy.hashCode() : 0);
            result = 31 * result + (this.appCookieStickinessPolicy != null ? this.appCookieStickinessPolicy.hashCode() : 0);
            result = 31 * result + (this.availabilityZones != null ? this.availabilityZones.hashCode() : 0);
            result = 31 * result + (this.connectionDrainingPolicy != null ? this.connectionDrainingPolicy.hashCode() : 0);
            result = 31 * result + (this.connectionSettings != null ? this.connectionSettings.hashCode() : 0);
            result = 31 * result + (this.crossZone != null ? this.crossZone.hashCode() : 0);
            result = 31 * result + (this.healthCheck != null ? this.healthCheck.hashCode() : 0);
            result = 31 * result + (this.instances != null ? this.instances.hashCode() : 0);
            result = 31 * result + (this.lbCookieStickinessPolicy != null ? this.lbCookieStickinessPolicy.hashCode() : 0);
            result = 31 * result + (this.loadBalancerName != null ? this.loadBalancerName.hashCode() : 0);
            result = 31 * result + (this.policies != null ? this.policies.hashCode() : 0);
            result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
