package software.amazon.awscdk.services.events.targets;

/**
 * Allows the pipeline to be used as an EventBridge rule target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // A pipeline being used as a target for a CloudWatch event rule.
 * import software.amazon.awscdk.services.events.targets.*;
 * import software.amazon.awscdk.services.events.*;
 * Pipeline pipeline;
 * // kick off the pipeline every day
 * Rule rule = Rule.Builder.create(this, "Daily")
 *         .schedule(Schedule.rate(Duration.days(1)))
 *         .build();
 * rule.addTarget(new CodePipeline(pipeline));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:46.325Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.CodePipeline")
public class CodePipeline extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.events.IRuleTarget {

    protected CodePipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CodePipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param pipeline This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodePipeline(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IPipeline pipeline, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(pipeline, "pipeline is required"), options });
    }

    /**
     * @param pipeline This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CodePipeline(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IPipeline pipeline) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(pipeline, "pipeline is required") });
    }

    /**
     * Returns the rule target specification.
     * <p>
     * NOTE: Do not use the various <code>inputXxx</code> options. They can be set in a call to <code>addTarget</code>.
     * <p>
     * @param _rule This parameter is required.
     * @param _id
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule, final @org.jetbrains.annotations.Nullable java.lang.String _id) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required"), _id });
    }

    /**
     * Returns the rule target specification.
     * <p>
     * NOTE: Do not use the various <code>inputXxx</code> options. They can be set in a call to <code>addTarget</code>.
     * <p>
     * @param _rule This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.RuleTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IRule _rule) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_rule, "_rule is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.events.targets.CodePipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.events.targets.CodePipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param pipeline This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.codepipeline.IPipeline pipeline) {
            return new Builder(pipeline);
        }

        private final software.amazon.awscdk.services.codepipeline.IPipeline pipeline;
        private software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions.Builder options;

        private Builder(final software.amazon.awscdk.services.codepipeline.IPipeline pipeline) {
            this.pipeline = pipeline;
        }

        /**
         * The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations).
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the [considerations for using a dead-letter queue](https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.options().deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.options().maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.options().retryAttempts(retryAttempts);
            return this;
        }

        /**
         * The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered.
         * <p>
         * Default: - a new role will be created
         * <p>
         * @return {@code this}
         * @param eventRole The role to assume before invoking the target (i.e., the pipeline) when the given rule is triggered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRole(final software.amazon.awscdk.services.iam.IRole eventRole) {
            this.options().eventRole(eventRole);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.events.targets.CodePipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.events.targets.CodePipeline build() {
            return new software.amazon.awscdk.services.events.targets.CodePipeline(
                this.pipeline,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.events.targets.CodePipelineTargetOptions.Builder();
            }
            return this.options;
        }
    }
}
