package software.amazon.awscdk.services.globalaccelerator;

/**
 * The Accelerator construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create an Accelerator
 * Accelerator accelerator = new Accelerator(this, "Accelerator");
 * // Create a Listener
 * Listener listener = accelerator.addListener("Listener", ListenerOptions.builder()
 *         .portRanges(List.of(PortRange.builder().fromPort(80).build(), PortRange.builder().fromPort(443).build()))
 *         .build());
 * // Import the Load Balancers
 * INetworkLoadBalancer nlb1 = NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(this, "NLB1", NetworkLoadBalancerAttributes.builder()
 *         .loadBalancerArn("arn:aws:elasticloadbalancing:us-west-2:111111111111:loadbalancer/app/my-load-balancer1/e16bef66805b")
 *         .build());
 * INetworkLoadBalancer nlb2 = NetworkLoadBalancer.fromNetworkLoadBalancerAttributes(this, "NLB2", NetworkLoadBalancerAttributes.builder()
 *         .loadBalancerArn("arn:aws:elasticloadbalancing:ap-south-1:111111111111:loadbalancer/app/my-load-balancer2/5513dc2ea8a1")
 *         .build());
 * // Add one EndpointGroup for each Region we are targeting
 * listener.addEndpointGroup("Group1", EndpointGroupOptions.builder()
 *         .endpoints(List.of(new NetworkLoadBalancerEndpoint(nlb1)))
 *         .build());
 * listener.addEndpointGroup("Group2", EndpointGroupOptions.builder()
 *         // Imported load balancers automatically calculate their Region from the ARN.
 *         // If you are load balancing to other resources, you must also pass a `region`
 *         // parameter here.
 *         .endpoints(List.of(new NetworkLoadBalancerEndpoint(nlb2)))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:46.479Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_globalaccelerator.Accelerator")
public class Accelerator extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.globalaccelerator.IAccelerator {

    protected Accelerator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Accelerator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Accelerator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.globalaccelerator.AcceleratorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Accelerator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * import from attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.IAccelerator fromAcceleratorAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.AcceleratorAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.globalaccelerator.Accelerator.class, "fromAcceleratorAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.IAccelerator.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add a listener to the accelerator.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.Listener addListener(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.globalaccelerator.ListenerOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addListener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.globalaccelerator.Listener.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The ARN of the accelerator.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAcceleratorArn() {
        return software.amazon.jsii.Kernel.get(this, "acceleratorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Domain Name System (DNS) name that Global Accelerator creates that points to your accelerator's static IP addresses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDnsName() {
        return software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.globalaccelerator.Accelerator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.globalaccelerator.Accelerator> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.globalaccelerator.AcceleratorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the accelerator.
         * <p>
         * Default: - resource ID
         * <p>
         * @return {@code this}
         * @param acceleratorName The name of the accelerator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceleratorName(final java.lang.String acceleratorName) {
            this.props().acceleratorName(acceleratorName);
            return this;
        }

        /**
         * Indicates whether the accelerator is enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Indicates whether the accelerator is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.globalaccelerator.Accelerator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.globalaccelerator.Accelerator build() {
            return new software.amazon.awscdk.services.globalaccelerator.Accelerator(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.globalaccelerator.AcceleratorProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.globalaccelerator.AcceleratorProps.Builder();
            }
            return this.props;
        }
    }
}
