package software.amazon.awscdk.services.guardduty;

/**
 * Properties for defining a `CfnMember`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.guardduty.*;
 * CfnMemberProps cfnMemberProps = CfnMemberProps.builder()
 *         .detectorId("detectorId")
 *         .email("email")
 *         .memberId("memberId")
 *         // the properties below are optional
 *         .disableEmailNotification(false)
 *         .message("message")
 *         .status("status")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:46.672Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_guardduty.CfnMemberProps")
@software.amazon.jsii.Jsii.Proxy(CfnMemberProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMemberProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the detector associated with the  service to add the member to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDetectorId();

    /**
     * The email address associated with the member account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEmail();

    /**
     * The AWS account ID of the account to designate as a member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMemberId();

    /**
     * Specifies whether or not to disable email notification for the member account that you invite.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDisableEmailNotification() {
        return null;
    }

    /**
     * The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
        return null;
    }

    /**
     * You can use the `Status` property to update the status of the relationship between the member account and its administrator account.
     * <p>
     * Valid values are <code>Created</code> and <code>Invited</code> when using an <code>AWS::GuardDuty::Member</code> resource. If the value for this property is not provided or set to <code>Created</code> , a member account is created but not invited. If the value of this property is set to <code>Invited</code> , a member account is created and invited.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMemberProps> {
        java.lang.String detectorId;
        java.lang.String email;
        java.lang.String memberId;
        java.lang.Object disableEmailNotification;
        java.lang.String message;
        java.lang.String status;

        /**
         * Sets the value of {@link CfnMemberProps#getDetectorId}
         * @param detectorId The ID of the detector associated with the  service to add the member to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detectorId(java.lang.String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getEmail}
         * @param email The email address associated with the member account. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder email(java.lang.String email) {
            this.email = email;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getMemberId}
         * @param memberId The AWS account ID of the account to designate as a member. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memberId(java.lang.String memberId) {
            this.memberId = memberId;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getDisableEmailNotification}
         * @param disableEmailNotification Specifies whether or not to disable email notification for the member account that you invite.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableEmailNotification(java.lang.Boolean disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getDisableEmailNotification}
         * @param disableEmailNotification Specifies whether or not to disable email notification for the member account that you invite.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableEmailNotification(software.amazon.awscdk.IResolvable disableEmailNotification) {
            this.disableEmailNotification = disableEmailNotification;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getMessage}
         * @param message The invitation message that you want to send to the accounts that you're inviting to GuardDuty as members.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder message(java.lang.String message) {
            this.message = message;
            return this;
        }

        /**
         * Sets the value of {@link CfnMemberProps#getStatus}
         * @param status You can use the `Status` property to update the status of the relationship between the member account and its administrator account.
         *               Valid values are <code>Created</code> and <code>Invited</code> when using an <code>AWS::GuardDuty::Member</code> resource. If the value for this property is not provided or set to <code>Created</code> , a member account is created but not invited. If the value of this property is set to <code>Invited</code> , a member account is created and invited.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMemberProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMemberProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMemberProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMemberProps {
        private final java.lang.String detectorId;
        private final java.lang.String email;
        private final java.lang.String memberId;
        private final java.lang.Object disableEmailNotification;
        private final java.lang.String message;
        private final java.lang.String status;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.detectorId = software.amazon.jsii.Kernel.get(this, "detectorId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memberId = software.amazon.jsii.Kernel.get(this, "memberId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disableEmailNotification = software.amazon.jsii.Kernel.get(this, "disableEmailNotification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.detectorId = java.util.Objects.requireNonNull(builder.detectorId, "detectorId is required");
            this.email = java.util.Objects.requireNonNull(builder.email, "email is required");
            this.memberId = java.util.Objects.requireNonNull(builder.memberId, "memberId is required");
            this.disableEmailNotification = builder.disableEmailNotification;
            this.message = builder.message;
            this.status = builder.status;
        }

        @Override
        public final java.lang.String getDetectorId() {
            return this.detectorId;
        }

        @Override
        public final java.lang.String getEmail() {
            return this.email;
        }

        @Override
        public final java.lang.String getMemberId() {
            return this.memberId;
        }

        @Override
        public final java.lang.Object getDisableEmailNotification() {
            return this.disableEmailNotification;
        }

        @Override
        public final java.lang.String getMessage() {
            return this.message;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("detectorId", om.valueToTree(this.getDetectorId()));
            data.set("email", om.valueToTree(this.getEmail()));
            data.set("memberId", om.valueToTree(this.getMemberId()));
            if (this.getDisableEmailNotification() != null) {
                data.set("disableEmailNotification", om.valueToTree(this.getDisableEmailNotification()));
            }
            if (this.getMessage() != null) {
                data.set("message", om.valueToTree(this.getMessage()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_guardduty.CfnMemberProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMemberProps.Jsii$Proxy that = (CfnMemberProps.Jsii$Proxy) o;

            if (!detectorId.equals(that.detectorId)) return false;
            if (!email.equals(that.email)) return false;
            if (!memberId.equals(that.memberId)) return false;
            if (this.disableEmailNotification != null ? !this.disableEmailNotification.equals(that.disableEmailNotification) : that.disableEmailNotification != null) return false;
            if (this.message != null ? !this.message.equals(that.message) : that.message != null) return false;
            return this.status != null ? this.status.equals(that.status) : that.status == null;
        }

        @Override
        public final int hashCode() {
            int result = this.detectorId.hashCode();
            result = 31 * result + (this.email.hashCode());
            result = 31 * result + (this.memberId.hashCode());
            result = 31 * result + (this.disableEmailNotification != null ? this.disableEmailNotification.hashCode() : 0);
            result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            return result;
        }
    }
}
