package software.amazon.awscdk.services.imagebuilder;

/**
 * A CloudFormation `AWS::ImageBuilder::Image`.
 * <p>
 * An image build version. An image is a customized, secure, and up-to-date “golden” server image that is pre-installed and pre-configured with software and settings to meet specific IT standards.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnImage cfnImage = CfnImage.Builder.create(this, "MyCfnImage")
 *         .infrastructureConfigurationArn("infrastructureConfigurationArn")
 *         // the properties below are optional
 *         .containerRecipeArn("containerRecipeArn")
 *         .distributionConfigurationArn("distributionConfigurationArn")
 *         .enhancedImageMetadataEnabled(false)
 *         .imageRecipeArn("imageRecipeArn")
 *         .imageTestsConfiguration(ImageTestsConfigurationProperty.builder()
 *                 .imageTestsEnabled(false)
 *                 .timeoutMinutes(123)
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:46.777Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImage")
public class CfnImage extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.imagebuilder.CfnImage.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ImageBuilder::Image`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnImage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.imagebuilder.CfnImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the image.
     * <p>
     * For example, <code>arn:aws:imagebuilder:us-west-2:123456789012:image/mybasicrecipe/2019.12.03/1</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the AMI ID of the Amazon EC2 AMI in the Region in which you are using Image Builder.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrImageId() {
        return software.amazon.jsii.Kernel.get(this, "attrImageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrImageUri() {
        return software.amazon.jsii.Kernel.get(this, "attrImageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of the image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags of the image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getInfrastructureConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "infrastructureConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInfrastructureConfigurationArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "infrastructureConfigurationArn", java.util.Objects.requireNonNull(value, "infrastructureConfigurationArn is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getContainerRecipeArn() {
        return software.amazon.jsii.Kernel.get(this, "containerRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setContainerRecipeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "containerRecipeArn", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDistributionConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "distributionConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionConfigurationArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "distributionConfigurationArn", value);
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedImageMetadataEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enhancedImageMetadataEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedImageMetadataEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enhancedImageMetadataEnabled", value);
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedImageMetadataEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enhancedImageMetadataEnabled", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the image recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getImageRecipeArn() {
        return software.amazon.jsii.Kernel.get(this, "imageRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the image recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageRecipeArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageRecipeArn", value);
    }

    /**
     * The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getImageTestsConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "imageTestsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageTestsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.imagebuilder.CfnImage.ImageTestsConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "imageTestsConfiguration", value);
    }

    /**
     * The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageTestsConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "imageTestsConfiguration", value);
    }
    /**
     * When you create an image or container recipe with Image Builder , you can add the build or test components that are used to create the final image.
     * <p>
     * You must have at least one build component to create a recipe, but test components are not required. If you have added tests, they run after the image is created, to ensure that the target image is functional and can be used reliably for launching Amazon EC2 instances.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.imagebuilder.*;
     * ImageTestsConfigurationProperty imageTestsConfigurationProperty = ImageTestsConfigurationProperty.builder()
     *         .imageTestsEnabled(false)
     *         .timeoutMinutes(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImage.ImageTestsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ImageTestsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ImageTestsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines if tests should run after building the image.
         * <p>
         * Image Builder defaults to enable tests to run following the image build, before image distribution.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImageTestsEnabled() {
            return null;
        }

        /**
         * The maximum time in minutes that tests are permitted to run.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ImageTestsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ImageTestsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ImageTestsConfigurationProperty> {
            java.lang.Object imageTestsEnabled;
            java.lang.Number timeoutMinutes;

            /**
             * Sets the value of {@link ImageTestsConfigurationProperty#getImageTestsEnabled}
             * @param imageTestsEnabled Determines if tests should run after building the image.
             *                          Image Builder defaults to enable tests to run following the image build, before image distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageTestsEnabled(java.lang.Boolean imageTestsEnabled) {
                this.imageTestsEnabled = imageTestsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ImageTestsConfigurationProperty#getImageTestsEnabled}
             * @param imageTestsEnabled Determines if tests should run after building the image.
             *                          Image Builder defaults to enable tests to run following the image build, before image distribution.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder imageTestsEnabled(software.amazon.awscdk.IResolvable imageTestsEnabled) {
                this.imageTestsEnabled = imageTestsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ImageTestsConfigurationProperty#getTimeoutMinutes}
             * @param timeoutMinutes The maximum time in minutes that tests are permitted to run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutMinutes(java.lang.Number timeoutMinutes) {
                this.timeoutMinutes = timeoutMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ImageTestsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ImageTestsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ImageTestsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ImageTestsConfigurationProperty {
            private final java.lang.Object imageTestsEnabled;
            private final java.lang.Number timeoutMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.imageTestsEnabled = software.amazon.jsii.Kernel.get(this, "imageTestsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutMinutes = software.amazon.jsii.Kernel.get(this, "timeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.imageTestsEnabled = builder.imageTestsEnabled;
                this.timeoutMinutes = builder.timeoutMinutes;
            }

            @Override
            public final java.lang.Object getImageTestsEnabled() {
                return this.imageTestsEnabled;
            }

            @Override
            public final java.lang.Number getTimeoutMinutes() {
                return this.timeoutMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImageTestsEnabled() != null) {
                    data.set("imageTestsEnabled", om.valueToTree(this.getImageTestsEnabled()));
                }
                if (this.getTimeoutMinutes() != null) {
                    data.set("timeoutMinutes", om.valueToTree(this.getTimeoutMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnImage.ImageTestsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ImageTestsConfigurationProperty.Jsii$Proxy that = (ImageTestsConfigurationProperty.Jsii$Proxy) o;

                if (this.imageTestsEnabled != null ? !this.imageTestsEnabled.equals(that.imageTestsEnabled) : that.imageTestsEnabled != null) return false;
                return this.timeoutMinutes != null ? this.timeoutMinutes.equals(that.timeoutMinutes) : that.timeoutMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.imageTestsEnabled != null ? this.imageTestsEnabled.hashCode() : 0;
                result = 31 * result + (this.timeoutMinutes != null ? this.timeoutMinutes.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.imagebuilder.CfnImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.imagebuilder.CfnImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.imagebuilder.CfnImageProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.imagebuilder.CfnImageProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
         * <p>
         * @return {@code this}
         * @param infrastructureConfigurationArn The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructureConfigurationArn(final java.lang.String infrastructureConfigurationArn) {
            this.props.infrastructureConfigurationArn(infrastructureConfigurationArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
         * <p>
         * @return {@code this}
         * @param containerRecipeArn The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRecipeArn(final java.lang.String containerRecipeArn) {
            this.props.containerRecipeArn(containerRecipeArn);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the distribution configuration.
         * <p>
         * @return {@code this}
         * @param distributionConfigurationArn The Amazon Resource Name (ARN) of the distribution configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfigurationArn(final java.lang.String distributionConfigurationArn) {
            this.props.distributionConfigurationArn(distributionConfigurationArn);
            return this;
        }

        /**
         * Collects additional information about the image being created, including the operating system (OS) version and package list.
         * <p>
         * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * <p>
         * @return {@code this}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(final java.lang.Boolean enhancedImageMetadataEnabled) {
            this.props.enhancedImageMetadataEnabled(enhancedImageMetadataEnabled);
            return this;
        }
        /**
         * Collects additional information about the image being created, including the operating system (OS) version and package list.
         * <p>
         * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * <p>
         * @return {@code this}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(final software.amazon.awscdk.IResolvable enhancedImageMetadataEnabled) {
            this.props.enhancedImageMetadataEnabled(enhancedImageMetadataEnabled);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the image recipe.
         * <p>
         * @return {@code this}
         * @param imageRecipeArn The Amazon Resource Name (ARN) of the image recipe. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageRecipeArn(final java.lang.String imageRecipeArn) {
            this.props.imageRecipeArn(imageRecipeArn);
            return this;
        }

        /**
         * The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting.
         * <p>
         * @return {@code this}
         * @param imageTestsConfiguration The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(final software.amazon.awscdk.services.imagebuilder.CfnImage.ImageTestsConfigurationProperty imageTestsConfiguration) {
            this.props.imageTestsConfiguration(imageTestsConfiguration);
            return this;
        }
        /**
         * The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting.
         * <p>
         * @return {@code this}
         * @param imageTestsConfiguration The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(final software.amazon.awscdk.IResolvable imageTestsConfiguration) {
            this.props.imageTestsConfiguration(imageTestsConfiguration);
            return this;
        }

        /**
         * The tags of the image.
         * <p>
         * @return {@code this}
         * @param tags The tags of the image. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.imagebuilder.CfnImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.imagebuilder.CfnImage build() {
            return new software.amazon.awscdk.services.imagebuilder.CfnImage(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
