package software.amazon.awscdk.services.imagebuilder;

/**
 * Properties for defining a `CfnImage`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.imagebuilder.*;
 * CfnImageProps cfnImageProps = CfnImageProps.builder()
 *         .infrastructureConfigurationArn("infrastructureConfigurationArn")
 *         // the properties below are optional
 *         .containerRecipeArn("containerRecipeArn")
 *         .distributionConfigurationArn("distributionConfigurationArn")
 *         .enhancedImageMetadataEnabled(false)
 *         .imageRecipeArn("imageRecipeArn")
 *         .imageTestsConfiguration(ImageTestsConfigurationProperty.builder()
 *                 .imageTestsEnabled(false)
 *                 .timeoutMinutes(123)
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:46.781Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_imagebuilder.CfnImageProps")
@software.amazon.jsii.Jsii.Proxy(CfnImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInfrastructureConfigurationArn();

    /**
     * The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerRecipeArn() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the distribution configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDistributionConfigurationArn() {
        return null;
    }

    /**
     * Collects additional information about the image being created, including the operating system (OS) version and package list.
     * <p>
     * This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedImageMetadataEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the image recipe.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getImageRecipeArn() {
        return null;
    }

    /**
     * The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getImageTestsConfiguration() {
        return null;
    }

    /**
     * The tags of the image.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnImageProps> {
        java.lang.String infrastructureConfigurationArn;
        java.lang.String containerRecipeArn;
        java.lang.String distributionConfigurationArn;
        java.lang.Object enhancedImageMetadataEnabled;
        java.lang.String imageRecipeArn;
        java.lang.Object imageTestsConfiguration;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnImageProps#getInfrastructureConfigurationArn}
         * @param infrastructureConfigurationArn The Amazon Resource Name (ARN) of the infrastructure configuration associated with this image pipeline. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder infrastructureConfigurationArn(java.lang.String infrastructureConfigurationArn) {
            this.infrastructureConfigurationArn = infrastructureConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getContainerRecipeArn}
         * @param containerRecipeArn The Amazon Resource Name (ARN) of the container recipe that is used for this pipeline.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerRecipeArn(java.lang.String containerRecipeArn) {
            this.containerRecipeArn = containerRecipeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getDistributionConfigurationArn}
         * @param distributionConfigurationArn The Amazon Resource Name (ARN) of the distribution configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfigurationArn(java.lang.String distributionConfigurationArn) {
            this.distributionConfigurationArn = distributionConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getEnhancedImageMetadataEnabled}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list.
         *                                     This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(java.lang.Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getEnhancedImageMetadataEnabled}
         * @param enhancedImageMetadataEnabled Collects additional information about the image being created, including the operating system (OS) version and package list.
         *                                     This information is used to enhance the overall experience of using EC2 Image Builder. Enabled by default.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedImageMetadataEnabled(software.amazon.awscdk.IResolvable enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageRecipeArn}
         * @param imageRecipeArn The Amazon Resource Name (ARN) of the image recipe.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageRecipeArn(java.lang.String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageTestsConfiguration}
         * @param imageTestsConfiguration The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(software.amazon.awscdk.services.imagebuilder.CfnImage.ImageTestsConfigurationProperty imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getImageTestsConfiguration}
         * @param imageTestsConfiguration The configuration settings for your image test components, which includes a toggle that allows you to turn off tests, and a timeout setting.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder imageTestsConfiguration(software.amazon.awscdk.IResolvable imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnImageProps#getTags}
         * @param tags The tags of the image.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnImageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnImageProps {
        private final java.lang.String infrastructureConfigurationArn;
        private final java.lang.String containerRecipeArn;
        private final java.lang.String distributionConfigurationArn;
        private final java.lang.Object enhancedImageMetadataEnabled;
        private final java.lang.String imageRecipeArn;
        private final java.lang.Object imageTestsConfiguration;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.infrastructureConfigurationArn = software.amazon.jsii.Kernel.get(this, "infrastructureConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.containerRecipeArn = software.amazon.jsii.Kernel.get(this, "containerRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.distributionConfigurationArn = software.amazon.jsii.Kernel.get(this, "distributionConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enhancedImageMetadataEnabled = software.amazon.jsii.Kernel.get(this, "enhancedImageMetadataEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.imageRecipeArn = software.amazon.jsii.Kernel.get(this, "imageRecipeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.imageTestsConfiguration = software.amazon.jsii.Kernel.get(this, "imageTestsConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.infrastructureConfigurationArn = java.util.Objects.requireNonNull(builder.infrastructureConfigurationArn, "infrastructureConfigurationArn is required");
            this.containerRecipeArn = builder.containerRecipeArn;
            this.distributionConfigurationArn = builder.distributionConfigurationArn;
            this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
            this.imageRecipeArn = builder.imageRecipeArn;
            this.imageTestsConfiguration = builder.imageTestsConfiguration;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getInfrastructureConfigurationArn() {
            return this.infrastructureConfigurationArn;
        }

        @Override
        public final java.lang.String getContainerRecipeArn() {
            return this.containerRecipeArn;
        }

        @Override
        public final java.lang.String getDistributionConfigurationArn() {
            return this.distributionConfigurationArn;
        }

        @Override
        public final java.lang.Object getEnhancedImageMetadataEnabled() {
            return this.enhancedImageMetadataEnabled;
        }

        @Override
        public final java.lang.String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        @Override
        public final java.lang.Object getImageTestsConfiguration() {
            return this.imageTestsConfiguration;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("infrastructureConfigurationArn", om.valueToTree(this.getInfrastructureConfigurationArn()));
            if (this.getContainerRecipeArn() != null) {
                data.set("containerRecipeArn", om.valueToTree(this.getContainerRecipeArn()));
            }
            if (this.getDistributionConfigurationArn() != null) {
                data.set("distributionConfigurationArn", om.valueToTree(this.getDistributionConfigurationArn()));
            }
            if (this.getEnhancedImageMetadataEnabled() != null) {
                data.set("enhancedImageMetadataEnabled", om.valueToTree(this.getEnhancedImageMetadataEnabled()));
            }
            if (this.getImageRecipeArn() != null) {
                data.set("imageRecipeArn", om.valueToTree(this.getImageRecipeArn()));
            }
            if (this.getImageTestsConfiguration() != null) {
                data.set("imageTestsConfiguration", om.valueToTree(this.getImageTestsConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_imagebuilder.CfnImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnImageProps.Jsii$Proxy that = (CfnImageProps.Jsii$Proxy) o;

            if (!infrastructureConfigurationArn.equals(that.infrastructureConfigurationArn)) return false;
            if (this.containerRecipeArn != null ? !this.containerRecipeArn.equals(that.containerRecipeArn) : that.containerRecipeArn != null) return false;
            if (this.distributionConfigurationArn != null ? !this.distributionConfigurationArn.equals(that.distributionConfigurationArn) : that.distributionConfigurationArn != null) return false;
            if (this.enhancedImageMetadataEnabled != null ? !this.enhancedImageMetadataEnabled.equals(that.enhancedImageMetadataEnabled) : that.enhancedImageMetadataEnabled != null) return false;
            if (this.imageRecipeArn != null ? !this.imageRecipeArn.equals(that.imageRecipeArn) : that.imageRecipeArn != null) return false;
            if (this.imageTestsConfiguration != null ? !this.imageTestsConfiguration.equals(that.imageTestsConfiguration) : that.imageTestsConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.infrastructureConfigurationArn.hashCode();
            result = 31 * result + (this.containerRecipeArn != null ? this.containerRecipeArn.hashCode() : 0);
            result = 31 * result + (this.distributionConfigurationArn != null ? this.distributionConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.enhancedImageMetadataEnabled != null ? this.enhancedImageMetadataEnabled.hashCode() : 0);
            result = 31 * result + (this.imageRecipeArn != null ? this.imageRecipeArn.hashCode() : 0);
            result = 31 * result + (this.imageTestsConfiguration != null ? this.imageTestsConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
