package software.amazon.awscdk.services.iot;

/**
 * A CloudFormation `AWS::IoT::JobTemplate`.
 * <p>
 * Represents a job template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * Object abortConfig;
 * Object jobExecutionsRetryConfig;
 * Object jobExecutionsRolloutConfig;
 * Object presignedUrlConfig;
 * Object timeoutConfig;
 * CfnJobTemplate cfnJobTemplate = CfnJobTemplate.Builder.create(this, "MyCfnJobTemplate")
 *         .description("description")
 *         .jobTemplateId("jobTemplateId")
 *         // the properties below are optional
 *         .abortConfig(abortConfig)
 *         .document("document")
 *         .documentSource("documentSource")
 *         .jobArn("jobArn")
 *         .jobExecutionsRetryConfig(jobExecutionsRetryConfig)
 *         .jobExecutionsRolloutConfig(jobExecutionsRolloutConfig)
 *         .presignedUrlConfig(presignedUrlConfig)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeoutConfig(timeoutConfig)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:46.823Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnJobTemplate")
public class CfnJobTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnJobTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJobTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnJobTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoT::JobTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnJobTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnJobTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the job to use as the basis for the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Metadata that can be used to manage the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The criteria that determine when and how a job abort takes place.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAbortConfig() {
        return software.amazon.jsii.Kernel.get(this, "abortConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The criteria that determine when and how a job abort takes place.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAbortConfig(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "abortConfig", java.util.Objects.requireNonNull(value, "abortConfig is required"));
    }

    /**
     * A description of the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * Allows you to create the criteria to retry a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getJobExecutionsRetryConfig() {
        return software.amazon.jsii.Kernel.get(this, "jobExecutionsRetryConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Allows you to create the criteria to retry a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobExecutionsRetryConfig(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "jobExecutionsRetryConfig", java.util.Objects.requireNonNull(value, "jobExecutionsRetryConfig is required"));
    }

    /**
     * Allows you to create a staged rollout of a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getJobExecutionsRolloutConfig() {
        return software.amazon.jsii.Kernel.get(this, "jobExecutionsRolloutConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Allows you to create a staged rollout of a job.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobExecutionsRolloutConfig(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "jobExecutionsRolloutConfig", java.util.Objects.requireNonNull(value, "jobExecutionsRolloutConfig is required"));
    }

    /**
     * A unique identifier for the job template.
     * <p>
     * We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobTemplateId() {
        return software.amazon.jsii.Kernel.get(this, "jobTemplateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the job template.
     * <p>
     * We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobTemplateId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobTemplateId", java.util.Objects.requireNonNull(value, "jobTemplateId is required"));
    }

    /**
     * Configuration for pre-signed S3 URLs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPresignedUrlConfig() {
        return software.amazon.jsii.Kernel.get(this, "presignedUrlConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration for pre-signed S3 URLs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPresignedUrlConfig(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "presignedUrlConfig", java.util.Objects.requireNonNull(value, "presignedUrlConfig is required"));
    }

    /**
     * Specifies the amount of time each device has to finish its execution of the job.
     * <p>
     * A timer is started when the job execution status is set to <code>IN_PROGRESS</code> . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTimeoutConfig() {
        return software.amazon.jsii.Kernel.get(this, "timeoutConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the amount of time each device has to finish its execution of the job.
     * <p>
     * A timer is started when the job execution status is set to <code>IN_PROGRESS</code> . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeoutConfig(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "timeoutConfig", java.util.Objects.requireNonNull(value, "timeoutConfig is required"));
    }

    /**
     * The job document.
     * <p>
     * Required if you don't specify a value for <code>documentSource</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDocument() {
        return software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The job document.
     * <p>
     * Required if you don't specify a value for <code>documentSource</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocument(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "document", value);
    }

    /**
     * An S3 link to the job document to use in the template.
     * <p>
     * Required if you don't specify a value for <code>document</code> .
     * <p>
     * <blockquote>
     * <p>
     * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     * <p>
     * The placeholder link is of the following form:
     * <p>
     * <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/ *bucket* / *key* }</code>
     * <p>
     * where <em>bucket</em> is your bucket name and <em>key</em> is the object in the bucket to which you are linking.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDocumentSource() {
        return software.amazon.jsii.Kernel.get(this, "documentSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An S3 link to the job document to use in the template.
     * <p>
     * Required if you don't specify a value for <code>document</code> .
     * <p>
     * <blockquote>
     * <p>
     * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     * <p>
     * The placeholder link is of the following form:
     * <p>
     * <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/ *bucket* / *key* }</code>
     * <p>
     * where <em>bucket</em> is your bucket name and <em>key</em> is the object in the bucket to which you are linking.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDocumentSource(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "documentSource", value);
    }

    /**
     * The ARN of the job to use as the basis for the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getJobArn() {
        return software.amazon.jsii.Kernel.get(this, "jobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the job to use as the basis for the job template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setJobArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "jobArn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnJobTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnJobTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iot.CfnJobTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iot.CfnJobTemplateProps.Builder();
        }

        /**
         * A description of the job template.
         * <p>
         * @return {@code this}
         * @param description A description of the job template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A unique identifier for the job template.
         * <p>
         * We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
         * <p>
         * @return {@code this}
         * @param jobTemplateId A unique identifier for the job template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobTemplateId(final java.lang.String jobTemplateId) {
            this.props.jobTemplateId(jobTemplateId);
            return this;
        }

        /**
         * The criteria that determine when and how a job abort takes place.
         * <p>
         * @return {@code this}
         * @param abortConfig The criteria that determine when and how a job abort takes place. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder abortConfig(final java.lang.Object abortConfig) {
            this.props.abortConfig(abortConfig);
            return this;
        }

        /**
         * The job document.
         * <p>
         * Required if you don't specify a value for <code>documentSource</code> .
         * <p>
         * @return {@code this}
         * @param document The job document. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder document(final java.lang.String document) {
            this.props.document(document);
            return this;
        }

        /**
         * An S3 link to the job document to use in the template.
         * <p>
         * Required if you don't specify a value for <code>document</code> .
         * <p>
         * <blockquote>
         * <p>
         * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
         * <p>
         * The placeholder link is of the following form:
         * <p>
         * <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/ *bucket* / *key* }</code>
         * <p>
         * where <em>bucket</em> is your bucket name and <em>key</em> is the object in the bucket to which you are linking.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param documentSource An S3 link to the job document to use in the template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentSource(final java.lang.String documentSource) {
            this.props.documentSource(documentSource);
            return this;
        }

        /**
         * The ARN of the job to use as the basis for the job template.
         * <p>
         * @return {@code this}
         * @param jobArn The ARN of the job to use as the basis for the job template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobArn(final java.lang.String jobArn) {
            this.props.jobArn(jobArn);
            return this;
        }

        /**
         * Allows you to create the criteria to retry a job.
         * <p>
         * @return {@code this}
         * @param jobExecutionsRetryConfig Allows you to create the criteria to retry a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobExecutionsRetryConfig(final java.lang.Object jobExecutionsRetryConfig) {
            this.props.jobExecutionsRetryConfig(jobExecutionsRetryConfig);
            return this;
        }

        /**
         * Allows you to create a staged rollout of a job.
         * <p>
         * @return {@code this}
         * @param jobExecutionsRolloutConfig Allows you to create a staged rollout of a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobExecutionsRolloutConfig(final java.lang.Object jobExecutionsRolloutConfig) {
            this.props.jobExecutionsRolloutConfig(jobExecutionsRolloutConfig);
            return this;
        }

        /**
         * Configuration for pre-signed S3 URLs.
         * <p>
         * @return {@code this}
         * @param presignedUrlConfig Configuration for pre-signed S3 URLs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder presignedUrlConfig(final java.lang.Object presignedUrlConfig) {
            this.props.presignedUrlConfig(presignedUrlConfig);
            return this;
        }

        /**
         * Metadata that can be used to manage the job template.
         * <p>
         * @return {@code this}
         * @param tags Metadata that can be used to manage the job template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies the amount of time each device has to finish its execution of the job.
         * <p>
         * A timer is started when the job execution status is set to <code>IN_PROGRESS</code> . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to <code>TIMED_OUT</code> .
         * <p>
         * @return {@code this}
         * @param timeoutConfig Specifies the amount of time each device has to finish its execution of the job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeoutConfig(final java.lang.Object timeoutConfig) {
            this.props.timeoutConfig(timeoutConfig);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.CfnJobTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnJobTemplate build() {
            return new software.amazon.awscdk.services.iot.CfnJobTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
