package software.amazon.awscdk.services.iotsitewise;

/**
 * A CloudFormation `AWS::IoTSiteWise::Gateway`.
 * <p>
 * Creates a gateway, which is a virtual or edge device that delivers industrial data streams from local servers to AWS IoT SiteWise . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway</a> in the <em>AWS IoT SiteWise User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotsitewise.*;
 * CfnGateway cfnGateway = CfnGateway.Builder.create(this, "MyCfnGateway")
 *         .gatewayName("gatewayName")
 *         .gatewayPlatform(GatewayPlatformProperty.builder()
 *                 .greengrass(GreengrassProperty.builder()
 *                         .groupArn("groupArn")
 *                         .build())
 *                 .greengrassV2(GreengrassV2Property.builder()
 *                         .coreDeviceThingName("coreDeviceThingName")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .gatewayCapabilitySummaries(List.of(GatewayCapabilitySummaryProperty.builder()
 *                 .capabilityNamespace("capabilityNamespace")
 *                 // the properties below are optional
 *                 .capabilityConfiguration("capabilityConfiguration")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:47.005Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnGateway")
public class CfnGateway extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnGateway(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGateway(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iotsitewise.CfnGateway.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoTSiteWise::Gateway`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGateway(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotsitewise.CfnGatewayProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID for the gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "attrGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of key-value pairs that contain metadata for the gateway.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A unique, friendly name for the gateway.
     * <p>
     * The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGatewayName() {
        return software.amazon.jsii.Kernel.get(this, "gatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique, friendly name for the gateway.
     * <p>
     * The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "gatewayName", java.util.Objects.requireNonNull(value, "gatewayName is required"));
    }

    /**
     * The gateway's platform.
     * <p>
     * You can only specify one platform in a gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getGatewayPlatform() {
        return software.amazon.jsii.Kernel.get(this, "gatewayPlatform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The gateway's platform.
     * <p>
     * You can only specify one platform in a gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayPlatform(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iotsitewise.CfnGateway.GatewayPlatformProperty value) {
        software.amazon.jsii.Kernel.set(this, "gatewayPlatform", java.util.Objects.requireNonNull(value, "gatewayPlatform is required"));
    }

    /**
     * The gateway's platform.
     * <p>
     * You can only specify one platform in a gateway.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayPlatform(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gatewayPlatform", java.util.Objects.requireNonNull(value, "gatewayPlatform is required"));
    }

    /**
     * A list of gateway capability summaries that each contain a namespace and status.
     * <p>
     * Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGatewayCapabilitySummaries() {
        return software.amazon.jsii.Kernel.get(this, "gatewayCapabilitySummaries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of gateway capability summaries that each contain a namespace and status.
     * <p>
     * Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayCapabilitySummaries(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gatewayCapabilitySummaries", value);
    }

    /**
     * A list of gateway capability summaries that each contain a namespace and status.
     * <p>
     * Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayCapabilitySummaries(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "gatewayCapabilitySummaries", value);
    }
    /**
     * Contains a summary of a gateway capability configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * GatewayCapabilitySummaryProperty gatewayCapabilitySummaryProperty = GatewayCapabilitySummaryProperty.builder()
     *         .capabilityNamespace("capabilityNamespace")
     *         // the properties below are optional
     *         .capabilityConfiguration("capabilityConfiguration")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnGateway.GatewayCapabilitySummaryProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayCapabilitySummaryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayCapabilitySummaryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The namespace of the capability configuration.
         * <p>
         * For example, if you configure OPC-UA sources from the AWS IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code> , where <code>version</code> is a number such as <code>1</code> .
         * <p>
         * The maximum length is 512 characters with the pattern <code>^[a-zA-Z]+:[a-zA-Z]+:[0-9]+$</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCapabilityNamespace();

        /**
         * The JSON document that defines the configuration for the gateway capability.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <em>AWS IoT SiteWise User Guide</em> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapabilityConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayCapabilitySummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayCapabilitySummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayCapabilitySummaryProperty> {
            java.lang.String capabilityNamespace;
            java.lang.String capabilityConfiguration;

            /**
             * Sets the value of {@link GatewayCapabilitySummaryProperty#getCapabilityNamespace}
             * @param capabilityNamespace The namespace of the capability configuration. This parameter is required.
             *                            For example, if you configure OPC-UA sources from the AWS IoT SiteWise console, your OPC-UA capability configuration has the namespace <code>iotsitewise:opcuacollector:version</code> , where <code>version</code> is a number such as <code>1</code> .
             *                            <p>
             *                            The maximum length is 512 characters with the pattern <code>^[a-zA-Z]+:[a-zA-Z]+:[0-9]+$</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capabilityNamespace(java.lang.String capabilityNamespace) {
                this.capabilityNamespace = capabilityNamespace;
                return this;
            }

            /**
             * Sets the value of {@link GatewayCapabilitySummaryProperty#getCapabilityConfiguration}
             * @param capabilityConfiguration The JSON document that defines the configuration for the gateway capability.
             *                                For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli">Configuring data sources (CLI)</a> in the <em>AWS IoT SiteWise User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capabilityConfiguration(java.lang.String capabilityConfiguration) {
                this.capabilityConfiguration = capabilityConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayCapabilitySummaryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayCapabilitySummaryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayCapabilitySummaryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayCapabilitySummaryProperty {
            private final java.lang.String capabilityNamespace;
            private final java.lang.String capabilityConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.capabilityNamespace = software.amazon.jsii.Kernel.get(this, "capabilityNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.capabilityConfiguration = software.amazon.jsii.Kernel.get(this, "capabilityConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.capabilityNamespace = java.util.Objects.requireNonNull(builder.capabilityNamespace, "capabilityNamespace is required");
                this.capabilityConfiguration = builder.capabilityConfiguration;
            }

            @Override
            public final java.lang.String getCapabilityNamespace() {
                return this.capabilityNamespace;
            }

            @Override
            public final java.lang.String getCapabilityConfiguration() {
                return this.capabilityConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("capabilityNamespace", om.valueToTree(this.getCapabilityNamespace()));
                if (this.getCapabilityConfiguration() != null) {
                    data.set("capabilityConfiguration", om.valueToTree(this.getCapabilityConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnGateway.GatewayCapabilitySummaryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayCapabilitySummaryProperty.Jsii$Proxy that = (GatewayCapabilitySummaryProperty.Jsii$Proxy) o;

                if (!capabilityNamespace.equals(that.capabilityNamespace)) return false;
                return this.capabilityConfiguration != null ? this.capabilityConfiguration.equals(that.capabilityConfiguration) : that.capabilityConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.capabilityNamespace.hashCode();
                result = 31 * result + (this.capabilityConfiguration != null ? this.capabilityConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains a gateway's platform information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * GatewayPlatformProperty gatewayPlatformProperty = GatewayPlatformProperty.builder()
     *         .greengrass(GreengrassProperty.builder()
     *                 .groupArn("groupArn")
     *                 .build())
     *         .greengrassV2(GreengrassV2Property.builder()
     *                 .coreDeviceThingName("coreDeviceThingName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnGateway.GatewayPlatformProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayPlatformProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayPlatformProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A gateway that runs on AWS IoT Greengrass .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGreengrass() {
            return null;
        }

        /**
         * A gateway that runs on AWS IoT Greengrass V2.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGreengrassV2() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayPlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayPlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayPlatformProperty> {
            java.lang.Object greengrass;
            java.lang.Object greengrassV2;

            /**
             * Sets the value of {@link GatewayPlatformProperty#getGreengrass}
             * @param greengrass A gateway that runs on AWS IoT Greengrass .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greengrass(software.amazon.awscdk.services.iotsitewise.CfnGateway.GreengrassProperty greengrass) {
                this.greengrass = greengrass;
                return this;
            }

            /**
             * Sets the value of {@link GatewayPlatformProperty#getGreengrass}
             * @param greengrass A gateway that runs on AWS IoT Greengrass .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greengrass(software.amazon.awscdk.IResolvable greengrass) {
                this.greengrass = greengrass;
                return this;
            }

            /**
             * Sets the value of {@link GatewayPlatformProperty#getGreengrassV2}
             * @param greengrassV2 A gateway that runs on AWS IoT Greengrass V2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greengrassV2(software.amazon.awscdk.services.iotsitewise.CfnGateway.GreengrassV2Property greengrassV2) {
                this.greengrassV2 = greengrassV2;
                return this;
            }

            /**
             * Sets the value of {@link GatewayPlatformProperty#getGreengrassV2}
             * @param greengrassV2 A gateway that runs on AWS IoT Greengrass V2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder greengrassV2(software.amazon.awscdk.IResolvable greengrassV2) {
                this.greengrassV2 = greengrassV2;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayPlatformProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayPlatformProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayPlatformProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayPlatformProperty {
            private final java.lang.Object greengrass;
            private final java.lang.Object greengrassV2;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.greengrass = software.amazon.jsii.Kernel.get(this, "greengrass", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.greengrassV2 = software.amazon.jsii.Kernel.get(this, "greengrassV2", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.greengrass = builder.greengrass;
                this.greengrassV2 = builder.greengrassV2;
            }

            @Override
            public final java.lang.Object getGreengrass() {
                return this.greengrass;
            }

            @Override
            public final java.lang.Object getGreengrassV2() {
                return this.greengrassV2;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGreengrass() != null) {
                    data.set("greengrass", om.valueToTree(this.getGreengrass()));
                }
                if (this.getGreengrassV2() != null) {
                    data.set("greengrassV2", om.valueToTree(this.getGreengrassV2()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnGateway.GatewayPlatformProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayPlatformProperty.Jsii$Proxy that = (GatewayPlatformProperty.Jsii$Proxy) o;

                if (this.greengrass != null ? !this.greengrass.equals(that.greengrass) : that.greengrass != null) return false;
                return this.greengrassV2 != null ? this.greengrassV2.equals(that.greengrassV2) : that.greengrassV2 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.greengrass != null ? this.greengrass.hashCode() : 0;
                result = 31 * result + (this.greengrassV2 != null ? this.greengrassV2.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains details for a gateway that runs on AWS IoT Greengrass .
     * <p>
     * To create a gateway that runs on AWS IoT Greengrass , you must add the IoT SiteWise connector to a Greengrass group and deploy it. Your Greengrass group must also have permissions to upload data to AWS IoT SiteWise . For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/gateway-connector.html">Ingesting data using a gateway</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * GreengrassProperty greengrassProperty = GreengrassProperty.builder()
     *         .groupArn("groupArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnGateway.GreengrassProperty")
    @software.amazon.jsii.Jsii.Proxy(GreengrassProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GreengrassProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Greengrass group. For more information about how to find a group's ARN, see [ListGroups](https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html) and [GetGroup](https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html) in the *AWS IoT Greengrass API Reference* .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getGroupArn();

        /**
         * @return a {@link Builder} of {@link GreengrassProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GreengrassProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GreengrassProperty> {
            java.lang.String groupArn;

            /**
             * Sets the value of {@link GreengrassProperty#getGroupArn}
             * @param groupArn The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the Greengrass group. For more information about how to find a group's ARN, see [ListGroups](https://docs.aws.amazon.com/greengrass/latest/apireference/listgroups-get.html) and [GetGroup](https://docs.aws.amazon.com/greengrass/latest/apireference/getgroup-get.html) in the *AWS IoT Greengrass API Reference* . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupArn(java.lang.String groupArn) {
                this.groupArn = groupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GreengrassProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GreengrassProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GreengrassProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GreengrassProperty {
            private final java.lang.String groupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupArn = software.amazon.jsii.Kernel.get(this, "groupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupArn = java.util.Objects.requireNonNull(builder.groupArn, "groupArn is required");
            }

            @Override
            public final java.lang.String getGroupArn() {
                return this.groupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("groupArn", om.valueToTree(this.getGroupArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnGateway.GreengrassProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GreengrassProperty.Jsii$Proxy that = (GreengrassProperty.Jsii$Proxy) o;

                return this.groupArn.equals(that.groupArn);
            }

            @Override
            public final int hashCode() {
                int result = this.groupArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains details for a gateway that runs on AWS IoT Greengrass V2.
     * <p>
     * To create a gateway that runs on AWS IoT Greengrass V2, you must deploy the IoT SiteWise Edge component to your gateway device. Your <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/device-service-role.html">Greengrass device role</a> must use the <code>AWSIoTSiteWiseEdgeAccess</code> policy. For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/sw-gateways.html">Using AWS IoT SiteWise at the edge</a> in the <em>AWS IoT SiteWise User Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iotsitewise.*;
     * GreengrassV2Property greengrassV2Property = GreengrassV2Property.builder()
     *         .coreDeviceThingName("coreDeviceThingName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotsitewise.CfnGateway.GreengrassV2Property")
    @software.amazon.jsii.Jsii.Proxy(GreengrassV2Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GreengrassV2Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the AWS IoT thing for your AWS IoT Greengrass V2 core device.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCoreDeviceThingName();

        /**
         * @return a {@link Builder} of {@link GreengrassV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GreengrassV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GreengrassV2Property> {
            java.lang.String coreDeviceThingName;

            /**
             * Sets the value of {@link GreengrassV2Property#getCoreDeviceThingName}
             * @param coreDeviceThingName The name of the AWS IoT thing for your AWS IoT Greengrass V2 core device. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coreDeviceThingName(java.lang.String coreDeviceThingName) {
                this.coreDeviceThingName = coreDeviceThingName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GreengrassV2Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GreengrassV2Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GreengrassV2Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GreengrassV2Property {
            private final java.lang.String coreDeviceThingName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coreDeviceThingName = software.amazon.jsii.Kernel.get(this, "coreDeviceThingName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coreDeviceThingName = java.util.Objects.requireNonNull(builder.coreDeviceThingName, "coreDeviceThingName is required");
            }

            @Override
            public final java.lang.String getCoreDeviceThingName() {
                return this.coreDeviceThingName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("coreDeviceThingName", om.valueToTree(this.getCoreDeviceThingName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotsitewise.CfnGateway.GreengrassV2Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GreengrassV2Property.Jsii$Proxy that = (GreengrassV2Property.Jsii$Proxy) o;

                return this.coreDeviceThingName.equals(that.coreDeviceThingName);
            }

            @Override
            public final int hashCode() {
                int result = this.coreDeviceThingName.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iotsitewise.CfnGateway}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iotsitewise.CfnGateway> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iotsitewise.CfnGatewayProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iotsitewise.CfnGatewayProps.Builder();
        }

        /**
         * A unique, friendly name for the gateway.
         * <p>
         * The maximum length is 256 characters with the pattern <code>[^\ u0000-\ u001F\ u007F]+</code> .
         * <p>
         * @return {@code this}
         * @param gatewayName A unique, friendly name for the gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayName(final java.lang.String gatewayName) {
            this.props.gatewayName(gatewayName);
            return this;
        }

        /**
         * The gateway's platform.
         * <p>
         * You can only specify one platform in a gateway.
         * <p>
         * @return {@code this}
         * @param gatewayPlatform The gateway's platform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayPlatform(final software.amazon.awscdk.services.iotsitewise.CfnGateway.GatewayPlatformProperty gatewayPlatform) {
            this.props.gatewayPlatform(gatewayPlatform);
            return this;
        }
        /**
         * The gateway's platform.
         * <p>
         * You can only specify one platform in a gateway.
         * <p>
         * @return {@code this}
         * @param gatewayPlatform The gateway's platform. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayPlatform(final software.amazon.awscdk.IResolvable gatewayPlatform) {
            this.props.gatewayPlatform(gatewayPlatform);
            return this;
        }

        /**
         * A list of gateway capability summaries that each contain a namespace and status.
         * <p>
         * Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a> .
         * <p>
         * @return {@code this}
         * @param gatewayCapabilitySummaries A list of gateway capability summaries that each contain a namespace and status. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayCapabilitySummaries(final software.amazon.awscdk.IResolvable gatewayCapabilitySummaries) {
            this.props.gatewayCapabilitySummaries(gatewayCapabilitySummaries);
            return this;
        }
        /**
         * A list of gateway capability summaries that each contain a namespace and status.
         * <p>
         * Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html">DescribeGatewayCapabilityConfiguration</a> .
         * <p>
         * @return {@code this}
         * @param gatewayCapabilitySummaries A list of gateway capability summaries that each contain a namespace and status. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayCapabilitySummaries(final java.util.List<? extends java.lang.Object> gatewayCapabilitySummaries) {
            this.props.gatewayCapabilitySummaries(gatewayCapabilitySummaries);
            return this;
        }

        /**
         * A list of key-value pairs that contain metadata for the gateway.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your AWS IoT SiteWise resources</a> in the <em>AWS IoT SiteWise User Guide</em> .
         * <p>
         * @return {@code this}
         * @param tags A list of key-value pairs that contain metadata for the gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iotsitewise.CfnGateway}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iotsitewise.CfnGateway build() {
            return new software.amazon.awscdk.services.iotsitewise.CfnGateway(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
