package software.amazon.awscdk.services.lambda;

/**
 * Non runtime options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.lambda.*;
 * LayerVersionOptions layerVersionOptions = LayerVersionOptions.builder()
 *         .description("description")
 *         .layerVersionName("layerVersionName")
 *         .license("license")
 *         .removalPolicy(RemovalPolicy.DESTROY)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:47.391Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.LayerVersionOptions")
@software.amazon.jsii.Jsii.Proxy(LayerVersionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LayerVersionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The description the this Lambda Layer.
     * <p>
     * Default: - No description.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The name of the layer.
     * <p>
     * Default: - A name will be generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLayerVersionName() {
        return null;
    }

    /**
     * The SPDX licence identifier or URL to the license file for this layer.
     * <p>
     * Default: - No license information will be recorded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLicense() {
        return null;
    }

    /**
     * Whether to retain this version of the layer when a new version is added or when the stack is deleted.
     * <p>
     * Default: RemovalPolicy.DESTROY
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LayerVersionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LayerVersionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LayerVersionOptions> {
        java.lang.String description;
        java.lang.String layerVersionName;
        java.lang.String license;
        software.amazon.awscdk.RemovalPolicy removalPolicy;

        /**
         * Sets the value of {@link LayerVersionOptions#getDescription}
         * @param description The description the this Lambda Layer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link LayerVersionOptions#getLayerVersionName}
         * @param layerVersionName The name of the layer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layerVersionName(java.lang.String layerVersionName) {
            this.layerVersionName = layerVersionName;
            return this;
        }

        /**
         * Sets the value of {@link LayerVersionOptions#getLicense}
         * @param license The SPDX licence identifier or URL to the license file for this layer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder license(java.lang.String license) {
            this.license = license;
            return this;
        }

        /**
         * Sets the value of {@link LayerVersionOptions#getRemovalPolicy}
         * @param removalPolicy Whether to retain this version of the layer when a new version is added or when the stack is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LayerVersionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LayerVersionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LayerVersionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LayerVersionOptions {
        private final java.lang.String description;
        private final java.lang.String layerVersionName;
        private final java.lang.String license;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.layerVersionName = software.amazon.jsii.Kernel.get(this, "layerVersionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.license = software.amazon.jsii.Kernel.get(this, "license", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.layerVersionName = builder.layerVersionName;
            this.license = builder.license;
            this.removalPolicy = builder.removalPolicy;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getLayerVersionName() {
            return this.layerVersionName;
        }

        @Override
        public final java.lang.String getLicense() {
            return this.license;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getLayerVersionName() != null) {
                data.set("layerVersionName", om.valueToTree(this.getLayerVersionName()));
            }
            if (this.getLicense() != null) {
                data.set("license", om.valueToTree(this.getLicense()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.LayerVersionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LayerVersionOptions.Jsii$Proxy that = (LayerVersionOptions.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.layerVersionName != null ? !this.layerVersionName.equals(that.layerVersionName) : that.layerVersionName != null) return false;
            if (this.license != null ? !this.license.equals(that.license) : that.license != null) return false;
            return this.removalPolicy != null ? this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.layerVersionName != null ? this.layerVersionName.hashCode() : 0);
            result = 31 * result + (this.license != null ? this.license.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            return result;
        }
    }
}
