package software.amazon.awscdk.services.lambda.destinations;

/**
 * Use a Lambda function as a Lambda destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Auto-extract response payload with a lambda destination
 * Function destinationFn;
 * Function sourceFn = Function.Builder.create(this, "Source")
 *         .runtime(Runtime.NODEJS_12_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "lambda-handler")))
 *         // auto-extract on success
 *         .onSuccess(LambdaDestination.Builder.create(destinationFn)
 *                 .responseOnly(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:47.415Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_destinations.LambdaDestination")
public class LambdaDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IDestination {

    protected LambdaDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param fn This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.destinations.LambdaDestinationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(fn, "fn is required"), options });
    }

    /**
     * @param fn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(fn, "fn is required") });
    }

    /**
     * Returns a destination configuration.
     * <p>
     * @param scope This parameter is required.
     * @param fn This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.DestinationOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(fn, "fn is required"), options });
    }

    /**
     * Returns a destination configuration.
     * <p>
     * @param scope This parameter is required.
     * @param fn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.DestinationConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction fn) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.DestinationConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(fn, "fn is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.destinations.LambdaDestination}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.destinations.LambdaDestination> {
        /**
         * @return a new instance of {@link Builder}.
         * @param fn This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.lambda.IFunction fn) {
            return new Builder(fn);
        }

        private final software.amazon.awscdk.services.lambda.IFunction fn;
        private software.amazon.awscdk.services.lambda.destinations.LambdaDestinationOptions.Builder options;

        private Builder(final software.amazon.awscdk.services.lambda.IFunction fn) {
            this.fn = fn;
        }

        /**
         * Whether the destination function receives only the `responsePayload` of the source function.
         * <p>
         * When set to <code>true</code> and used as <code>onSuccess</code> destination, the destination
         * function will be invoked with the payload returned by the source function.
         * <p>
         * When set to <code>true</code> and used as <code>onFailure</code> destination, the destination
         * function will be invoked with the error object returned by source function.
         * <p>
         * See the README of this module to see a full explanation of this option.
         * <p>
         * Default: false The destination function receives the full invocation record.
         * <p>
         * @return {@code this}
         * @param responseOnly Whether the destination function receives only the `responsePayload` of the source function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseOnly(final java.lang.Boolean responseOnly) {
            this.options().responseOnly(responseOnly);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.destinations.LambdaDestination}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.destinations.LambdaDestination build() {
            return new software.amazon.awscdk.services.lambda.destinations.LambdaDestination(
                this.fn,
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.lambda.destinations.LambdaDestinationOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.lambda.destinations.LambdaDestinationOptions.Builder();
            }
            return this.options;
        }
    }
}
