package software.amazon.awscdk.services.location;

/**
 * Properties for defining a `CfnPlaceIndex`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnPlaceIndexProps cfnPlaceIndexProps = CfnPlaceIndexProps.builder()
 *         .dataSource("dataSource")
 *         .indexName("indexName")
 *         // the properties below are optional
 *         .dataSourceConfiguration(DataSourceConfigurationProperty.builder()
 *                 .intendedUse("intendedUse")
 *                 .build())
 *         .description("description")
 *         .pricingPlan("pricingPlan")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:47.601Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnPlaceIndexProps")
@software.amazon.jsii.Jsii.Proxy(CfnPlaceIndexProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPlaceIndexProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the data provider of geospatial data.
     * <p>
     * <blockquote>
     * <p>
     * This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> will return an error.
     * <p>
     * </blockquote>
     * <p>
     * Valid values include:
     * <p>
     * <ul>
     * <li><code>Esri</code></li>
     * <li><code>Here</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * Place index resources using HERE as a data provider can't be used to <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store</a> results for locations in Japan. For more information, see the <a href="https://docs.aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.
     * <p>
     * </blockquote>
     * <p>
     * For additional details on data providers, see the <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers page</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataSource();

    /**
     * The name of the place index resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique place index resource name.</li>
     * <li>No spaces allowed. For example, <code>ExamplePlaceIndex</code> .</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIndexName();

    /**
     * Specifies the data storage option for requesting Places.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataSourceConfiguration() {
        return null;
    }

    /**
     * The optional description for the place index resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * No longer used. If included, the only allowed value is `RequestBasedUsage` .
     * <p>
     * <em>Allowed Values</em> : <code>RequestBasedUsage</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPricingPlan() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPlaceIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPlaceIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPlaceIndexProps> {
        java.lang.String dataSource;
        java.lang.String indexName;
        java.lang.Object dataSourceConfiguration;
        java.lang.String description;
        java.lang.String pricingPlan;

        /**
         * Sets the value of {@link CfnPlaceIndexProps#getDataSource}
         * @param dataSource Specifies the data provider of geospatial data. This parameter is required.
         *                   <blockquote>
         *                   <p>
         *                   This field is case-sensitive. Enter the valid values as shown. For example, entering <code>HERE</code> will return an error.
         *                   <p>
         *                   </blockquote>
         *                   <p>
         *                   Valid values include:
         *                   <p>
         *                   <ul>
         *                   <li><code>Esri</code></li>
         *                   <li><code>Here</code></li>
         *                   </ul>
         *                   <p>
         *                   <blockquote>
         *                   <p>
         *                   Place index resources using HERE as a data provider can't be used to <a href="https://docs.aws.amazon.com/location-places/latest/APIReference/API_DataSourceConfiguration.html">store</a> results for locations in Japan. For more information, see the <a href="https://docs.aws.amazon.com/service-terms/">AWS Service Terms</a> for Amazon Location Service.
         *                   <p>
         *                   </blockquote>
         *                   <p>
         *                   For additional details on data providers, see the <a href="https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html">Amazon Location Service data providers page</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSource(java.lang.String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaceIndexProps#getIndexName}
         * @param indexName The name of the place index resource. This parameter is required.
         *                  Requirements:
         *                  <p>
         *                  <ul>
         *                  <li>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
         *                  <li>Must be a unique place index resource name.</li>
         *                  <li>No spaces allowed. For example, <code>ExamplePlaceIndex</code> .</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaceIndexProps#getDataSourceConfiguration}
         * @param dataSourceConfiguration Specifies the data storage option for requesting Places.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(software.amazon.awscdk.services.location.CfnPlaceIndex.DataSourceConfigurationProperty dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaceIndexProps#getDataSourceConfiguration}
         * @param dataSourceConfiguration Specifies the data storage option for requesting Places.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSourceConfiguration(software.amazon.awscdk.IResolvable dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaceIndexProps#getDescription}
         * @param description The optional description for the place index resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnPlaceIndexProps#getPricingPlan}
         * @param pricingPlan No longer used. If included, the only allowed value is `RequestBasedUsage` .
         *                    <em>Allowed Values</em> : <code>RequestBasedUsage</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricingPlan(java.lang.String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPlaceIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPlaceIndexProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPlaceIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPlaceIndexProps {
        private final java.lang.String dataSource;
        private final java.lang.String indexName;
        private final java.lang.Object dataSourceConfiguration;
        private final java.lang.String description;
        private final java.lang.String pricingPlan;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataSourceConfiguration = software.amazon.jsii.Kernel.get(this, "dataSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pricingPlan = software.amazon.jsii.Kernel.get(this, "pricingPlan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataSource = java.util.Objects.requireNonNull(builder.dataSource, "dataSource is required");
            this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
            this.dataSourceConfiguration = builder.dataSourceConfiguration;
            this.description = builder.description;
            this.pricingPlan = builder.pricingPlan;
        }

        @Override
        public final java.lang.String getDataSource() {
            return this.dataSource;
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public final java.lang.Object getDataSourceConfiguration() {
            return this.dataSourceConfiguration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getPricingPlan() {
            return this.pricingPlan;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataSource", om.valueToTree(this.getDataSource()));
            data.set("indexName", om.valueToTree(this.getIndexName()));
            if (this.getDataSourceConfiguration() != null) {
                data.set("dataSourceConfiguration", om.valueToTree(this.getDataSourceConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getPricingPlan() != null) {
                data.set("pricingPlan", om.valueToTree(this.getPricingPlan()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_location.CfnPlaceIndexProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPlaceIndexProps.Jsii$Proxy that = (CfnPlaceIndexProps.Jsii$Proxy) o;

            if (!dataSource.equals(that.dataSource)) return false;
            if (!indexName.equals(that.indexName)) return false;
            if (this.dataSourceConfiguration != null ? !this.dataSourceConfiguration.equals(that.dataSourceConfiguration) : that.dataSourceConfiguration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.pricingPlan != null ? this.pricingPlan.equals(that.pricingPlan) : that.pricingPlan == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataSource.hashCode();
            result = 31 * result + (this.indexName.hashCode());
            result = 31 * result + (this.dataSourceConfiguration != null ? this.dataSourceConfiguration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.pricingPlan != null ? this.pricingPlan.hashCode() : 0);
            return result;
        }
    }
}
