package software.amazon.awscdk.services.lookoutequipment;

/**
 * A CloudFormation `AWS::LookoutEquipment::InferenceScheduler`.
 * <p>
 * Creates a scheduled inference. Scheduling an inference is setting up a continuous real-time inference plan to analyze new measurement data. When setting up the schedule, you provide an Amazon S3 bucket location for the input data, assign it a delimiter between separate entries in the data, set an offset delay if desired, and set the frequency of inferencing. You must also provide an Amazon S3 bucket location for the output data.
 * <p>
 * <blockquote>
 * <p>
 * Updating some properties below (for example, InferenceSchedulerName and ServerSideKmsKeyId) triggers a resource replacement, which requires a new model. To replace such a property using AWS CloudFormation , but without creating a completely new stack, you must replace ModelName. If you need to replace the property, but want to use the same model, delete the current stack and create a new one with the updated properties.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lookoutequipment.*;
 * Object dataInputConfiguration;
 * Object dataOutputConfiguration;
 * CfnInferenceScheduler cfnInferenceScheduler = CfnInferenceScheduler.Builder.create(this, "MyCfnInferenceScheduler")
 *         .dataInputConfiguration(dataInputConfiguration)
 *         .dataOutputConfiguration(dataOutputConfiguration)
 *         .dataUploadFrequency("dataUploadFrequency")
 *         .modelName("modelName")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .dataDelayOffsetInMinutes(123)
 *         .inferenceSchedulerName("inferenceSchedulerName")
 *         .serverSideKmsKeyId("serverSideKmsKeyId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:47.642Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutequipment.CfnInferenceScheduler")
public class CfnInferenceScheduler extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnInferenceScheduler(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnInferenceScheduler(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lookoutequipment.CfnInferenceScheduler.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::LookoutEquipment::InferenceScheduler`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnInferenceScheduler(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lookoutequipment.CfnInferenceSchedulerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the inference scheduler being created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrInferenceSchedulerArn() {
        return software.amazon.jsii.Kernel.get(this, "attrInferenceSchedulerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Any tags associated with the inference scheduler.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDataInputConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataInputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataInputConfiguration(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "dataInputConfiguration", java.util.Objects.requireNonNull(value, "dataInputConfiguration is required"));
    }

    /**
     * Specifies configuration information for the output results for the inference scheduler, including the Amazon S3 location for the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDataOutputConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "dataOutputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies configuration information for the output results for the inference scheduler, including the Amazon S3 location for the output.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataOutputConfiguration(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "dataOutputConfiguration", java.util.Objects.requireNonNull(value, "dataOutputConfiguration is required"));
    }

    /**
     * How often data is uploaded to the source S3 bucket for the input data.
     * <p>
     * This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDataUploadFrequency() {
        return software.amazon.jsii.Kernel.get(this, "dataUploadFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * How often data is uploaded to the source S3 bucket for the input data.
     * <p>
     * This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataUploadFrequency(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataUploadFrequency", java.util.Objects.requireNonNull(value, "dataUploadFrequency is required"));
    }

    /**
     * The name of the ML model used for the inference scheduler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getModelName() {
        return software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the ML model used for the inference scheduler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setModelName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "modelName", java.util.Objects.requireNonNull(value, "modelName is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * A period of time (in minutes) by which inference on the data is delayed after the data starts.
     * <p>
     * For instance, if an offset delay time of five minutes was selected, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when uploading new data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDataDelayOffsetInMinutes() {
        return software.amazon.jsii.Kernel.get(this, "dataDelayOffsetInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A period of time (in minutes) by which inference on the data is delayed after the data starts.
     * <p>
     * For instance, if an offset delay time of five minutes was selected, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when uploading new data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataDelayOffsetInMinutes(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "dataDelayOffsetInMinutes", value);
    }

    /**
     * The name of the inference scheduler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInferenceSchedulerName() {
        return software.amazon.jsii.Kernel.get(this, "inferenceSchedulerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the inference scheduler.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInferenceSchedulerName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "inferenceSchedulerName", value);
    }

    /**
     * Provides the identifier of the AWS KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerSideKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "serverSideKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Provides the identifier of the AWS KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerSideKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverSideKmsKeyId", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lookoutequipment.CfnInferenceScheduler}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lookoutequipment.CfnInferenceScheduler> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lookoutequipment.CfnInferenceSchedulerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lookoutequipment.CfnInferenceSchedulerProps.Builder();
        }

        /**
         * Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
         * <p>
         * @return {@code this}
         * @param dataInputConfiguration Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataInputConfiguration(final java.lang.Object dataInputConfiguration) {
            this.props.dataInputConfiguration(dataInputConfiguration);
            return this;
        }

        /**
         * Specifies configuration information for the output results for the inference scheduler, including the Amazon S3 location for the output.
         * <p>
         * @return {@code this}
         * @param dataOutputConfiguration Specifies configuration information for the output results for the inference scheduler, including the Amazon S3 location for the output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataOutputConfiguration(final java.lang.Object dataOutputConfiguration) {
            this.props.dataOutputConfiguration(dataOutputConfiguration);
            return this;
        }

        /**
         * How often data is uploaded to the source S3 bucket for the input data.
         * <p>
         * This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
         * <p>
         * @return {@code this}
         * @param dataUploadFrequency How often data is uploaded to the source S3 bucket for the input data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataUploadFrequency(final java.lang.String dataUploadFrequency) {
            this.props.dataUploadFrequency(dataUploadFrequency);
            return this;
        }

        /**
         * The name of the ML model used for the inference scheduler.
         * <p>
         * @return {@code this}
         * @param modelName The name of the ML model used for the inference scheduler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelName(final java.lang.String modelName) {
            this.props.modelName(modelName);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * A period of time (in minutes) by which inference on the data is delayed after the data starts.
         * <p>
         * For instance, if an offset delay time of five minutes was selected, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when uploading new data.
         * <p>
         * @return {@code this}
         * @param dataDelayOffsetInMinutes A period of time (in minutes) by which inference on the data is delayed after the data starts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDelayOffsetInMinutes(final java.lang.Number dataDelayOffsetInMinutes) {
            this.props.dataDelayOffsetInMinutes(dataDelayOffsetInMinutes);
            return this;
        }

        /**
         * The name of the inference scheduler.
         * <p>
         * @return {@code this}
         * @param inferenceSchedulerName The name of the inference scheduler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceSchedulerName(final java.lang.String inferenceSchedulerName) {
            this.props.inferenceSchedulerName(inferenceSchedulerName);
            return this;
        }

        /**
         * Provides the identifier of the AWS KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment .
         * <p>
         * @return {@code this}
         * @param serverSideKmsKeyId Provides the identifier of the AWS KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideKmsKeyId(final java.lang.String serverSideKmsKeyId) {
            this.props.serverSideKmsKeyId(serverSideKmsKeyId);
            return this;
        }

        /**
         * Any tags associated with the inference scheduler.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * <p>
         * @return {@code this}
         * @param tags Any tags associated with the inference scheduler. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lookoutequipment.CfnInferenceScheduler}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lookoutequipment.CfnInferenceScheduler build() {
            return new software.amazon.awscdk.services.lookoutequipment.CfnInferenceScheduler(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
