package software.amazon.awscdk.services.msk;

/**
 * Properties for defining a `CfnCluster`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.msk.*;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .brokerNodeGroupInfo(BrokerNodeGroupInfoProperty.builder()
 *                 .clientSubnets(List.of("clientSubnets"))
 *                 .instanceType("instanceType")
 *                 // the properties below are optional
 *                 .brokerAzDistribution("brokerAzDistribution")
 *                 .connectivityInfo(ConnectivityInfoProperty.builder()
 *                         .publicAccess(PublicAccessProperty.builder()
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .storageInfo(StorageInfoProperty.builder()
 *                         .ebsStorageInfo(EBSStorageInfoProperty.builder()
 *                                 .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                                         .enabled(false)
 *                                         .volumeThroughput(123)
 *                                         .build())
 *                                 .volumeSize(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .clusterName("clusterName")
 *         .kafkaVersion("kafkaVersion")
 *         .numberOfBrokerNodes(123)
 *         // the properties below are optional
 *         .clientAuthentication(ClientAuthenticationProperty.builder()
 *                 .sasl(SaslProperty.builder()
 *                         .iam(IamProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .scram(ScramProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .build())
 *                 .tls(TlsProperty.builder()
 *                         .certificateAuthorityArnList(List.of("certificateAuthorityArnList"))
 *                         .enabled(false)
 *                         .build())
 *                 .unauthenticated(UnauthenticatedProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .build())
 *         .configurationInfo(ConfigurationInfoProperty.builder()
 *                 .arn("arn")
 *                 .revision(123)
 *                 .build())
 *         .currentVersion("currentVersion")
 *         .encryptionInfo(EncryptionInfoProperty.builder()
 *                 .encryptionAtRest(EncryptionAtRestProperty.builder()
 *                         .dataVolumeKmsKeyId("dataVolumeKmsKeyId")
 *                         .build())
 *                 .encryptionInTransit(EncryptionInTransitProperty.builder()
 *                         .clientBroker("clientBroker")
 *                         .inCluster(false)
 *                         .build())
 *                 .build())
 *         .enhancedMonitoring("enhancedMonitoring")
 *         .loggingInfo(LoggingInfoProperty.builder()
 *                 .brokerLogs(BrokerLogsProperty.builder()
 *                         .cloudWatchLogs(CloudWatchLogsProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .logGroup("logGroup")
 *                                 .build())
 *                         .firehose(FirehoseProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .deliveryStream("deliveryStream")
 *                                 .build())
 *                         .s3(S3Property.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .bucket("bucket")
 *                                 .prefix("prefix")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .openMonitoring(OpenMonitoringProperty.builder()
 *                 .prometheus(PrometheusProperty.builder()
 *                         .jmxExporter(JmxExporterProperty.builder()
 *                                 .enabledInBroker(false)
 *                                 .build())
 *                         .nodeExporter(NodeExporterProperty.builder()
 *                                 .enabledInBroker(false)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:47.881Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The setup to be used for brokers in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getBrokerNodeGroupInfo();

    /**
     * The name of the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterName();

    /**
     * The version of Apache Kafka.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/supported-kafka-versions.html">Supported Apache Kafka versions</a> in the Amazon MSK Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKafkaVersion();

    /**
     * The number of broker nodes you want in the Amazon MSK cluster.
     * <p>
     * You can submit an update to increase the number of broker nodes in a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getNumberOfBrokerNodes();

    /**
     * Includes information related to client authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClientAuthentication() {
        return null;
    }

    /**
     * The Amazon MSK configuration to use for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationInfo() {
        return null;
    }

    /**
     * The version of the cluster that you want to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCurrentVersion() {
        return null;
    }

    /**
     * Includes all encryption-related information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionInfo() {
        return null;
    }

    /**
     * Specifies the level of monitoring for the MSK cluster.
     * <p>
     * The possible values are <code>DEFAULT</code> , <code>PER_BROKER</code> , and <code>PER_TOPIC_PER_BROKER</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnhancedMonitoring() {
        return null;
    }

    /**
     * You can configure your Amazon MSK cluster to send broker logs to different destination types.
     * <p>
     * This is a container for the configuration details related to broker logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLoggingInfo() {
        return null;
    }

    /**
     * The settings for open monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpenMonitoring() {
        return null;
    }

    /**
     * A map of key:value pairs to apply to this resource.
     * <p>
     * Both key and value are of type String.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.lang.Object brokerNodeGroupInfo;
        java.lang.String clusterName;
        java.lang.String kafkaVersion;
        java.lang.Number numberOfBrokerNodes;
        java.lang.Object clientAuthentication;
        java.lang.Object configurationInfo;
        java.lang.String currentVersion;
        java.lang.Object encryptionInfo;
        java.lang.String enhancedMonitoring;
        java.lang.Object loggingInfo;
        java.lang.Object openMonitoring;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnClusterProps#getBrokerNodeGroupInfo}
         * @param brokerNodeGroupInfo The setup to be used for brokers in the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder brokerNodeGroupInfo(software.amazon.awscdk.services.msk.CfnCluster.BrokerNodeGroupInfoProperty brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getBrokerNodeGroupInfo}
         * @param brokerNodeGroupInfo The setup to be used for brokers in the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder brokerNodeGroupInfo(software.amazon.awscdk.IResolvable brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterName}
         * @param clusterName The name of the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getKafkaVersion}
         * @param kafkaVersion The version of Apache Kafka. This parameter is required.
         *                     For more information, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/supported-kafka-versions.html">Supported Apache Kafka versions</a> in the Amazon MSK Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaVersion(java.lang.String kafkaVersion) {
            this.kafkaVersion = kafkaVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getNumberOfBrokerNodes}
         * @param numberOfBrokerNodes The number of broker nodes you want in the Amazon MSK cluster. This parameter is required.
         *                            You can submit an update to increase the number of broker nodes in a cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfBrokerNodes(java.lang.Number numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClientAuthentication}
         * @param clientAuthentication Includes information related to client authentication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientAuthentication(software.amazon.awscdk.services.msk.CfnCluster.ClientAuthenticationProperty clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClientAuthentication}
         * @param clientAuthentication Includes information related to client authentication.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientAuthentication(software.amazon.awscdk.IResolvable clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getConfigurationInfo}
         * @param configurationInfo The Amazon MSK configuration to use for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationInfo(software.amazon.awscdk.services.msk.CfnCluster.ConfigurationInfoProperty configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getConfigurationInfo}
         * @param configurationInfo The Amazon MSK configuration to use for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationInfo(software.amazon.awscdk.IResolvable configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getCurrentVersion}
         * @param currentVersion The version of the cluster that you want to update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersion(java.lang.String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncryptionInfo}
         * @param encryptionInfo Includes all encryption-related information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionInfo(software.amazon.awscdk.services.msk.CfnCluster.EncryptionInfoProperty encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEncryptionInfo}
         * @param encryptionInfo Includes all encryption-related information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionInfo(software.amazon.awscdk.IResolvable encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getEnhancedMonitoring}
         * @param enhancedMonitoring Specifies the level of monitoring for the MSK cluster.
         *                           The possible values are <code>DEFAULT</code> , <code>PER_BROKER</code> , and <code>PER_TOPIC_PER_BROKER</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedMonitoring(java.lang.String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLoggingInfo}
         * @param loggingInfo You can configure your Amazon MSK cluster to send broker logs to different destination types.
         *                    This is a container for the configuration details related to broker logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingInfo(software.amazon.awscdk.services.msk.CfnCluster.LoggingInfoProperty loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getLoggingInfo}
         * @param loggingInfo You can configure your Amazon MSK cluster to send broker logs to different destination types.
         *                    This is a container for the configuration details related to broker logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingInfo(software.amazon.awscdk.IResolvable loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOpenMonitoring}
         * @param openMonitoring The settings for open monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openMonitoring(software.amazon.awscdk.services.msk.CfnCluster.OpenMonitoringProperty openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getOpenMonitoring}
         * @param openMonitoring The settings for open monitoring.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openMonitoring(software.amazon.awscdk.IResolvable openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags A map of key:value pairs to apply to this resource.
         *             Both key and value are of type String.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.lang.Object brokerNodeGroupInfo;
        private final java.lang.String clusterName;
        private final java.lang.String kafkaVersion;
        private final java.lang.Number numberOfBrokerNodes;
        private final java.lang.Object clientAuthentication;
        private final java.lang.Object configurationInfo;
        private final java.lang.String currentVersion;
        private final java.lang.Object encryptionInfo;
        private final java.lang.String enhancedMonitoring;
        private final java.lang.Object loggingInfo;
        private final java.lang.Object openMonitoring;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.brokerNodeGroupInfo = software.amazon.jsii.Kernel.get(this, "brokerNodeGroupInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kafkaVersion = software.amazon.jsii.Kernel.get(this, "kafkaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.numberOfBrokerNodes = software.amazon.jsii.Kernel.get(this, "numberOfBrokerNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.clientAuthentication = software.amazon.jsii.Kernel.get(this, "clientAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configurationInfo = software.amazon.jsii.Kernel.get(this, "configurationInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.currentVersion = software.amazon.jsii.Kernel.get(this, "currentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionInfo = software.amazon.jsii.Kernel.get(this, "encryptionInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enhancedMonitoring = software.amazon.jsii.Kernel.get(this, "enhancedMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.loggingInfo = software.amazon.jsii.Kernel.get(this, "loggingInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.openMonitoring = software.amazon.jsii.Kernel.get(this, "openMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.brokerNodeGroupInfo = java.util.Objects.requireNonNull(builder.brokerNodeGroupInfo, "brokerNodeGroupInfo is required");
            this.clusterName = java.util.Objects.requireNonNull(builder.clusterName, "clusterName is required");
            this.kafkaVersion = java.util.Objects.requireNonNull(builder.kafkaVersion, "kafkaVersion is required");
            this.numberOfBrokerNodes = java.util.Objects.requireNonNull(builder.numberOfBrokerNodes, "numberOfBrokerNodes is required");
            this.clientAuthentication = builder.clientAuthentication;
            this.configurationInfo = builder.configurationInfo;
            this.currentVersion = builder.currentVersion;
            this.encryptionInfo = builder.encryptionInfo;
            this.enhancedMonitoring = builder.enhancedMonitoring;
            this.loggingInfo = builder.loggingInfo;
            this.openMonitoring = builder.openMonitoring;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.Object getBrokerNodeGroupInfo() {
            return this.brokerNodeGroupInfo;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.String getKafkaVersion() {
            return this.kafkaVersion;
        }

        @Override
        public final java.lang.Number getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        @Override
        public final java.lang.Object getClientAuthentication() {
            return this.clientAuthentication;
        }

        @Override
        public final java.lang.Object getConfigurationInfo() {
            return this.configurationInfo;
        }

        @Override
        public final java.lang.String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final java.lang.Object getEncryptionInfo() {
            return this.encryptionInfo;
        }

        @Override
        public final java.lang.String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        @Override
        public final java.lang.Object getLoggingInfo() {
            return this.loggingInfo;
        }

        @Override
        public final java.lang.Object getOpenMonitoring() {
            return this.openMonitoring;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("brokerNodeGroupInfo", om.valueToTree(this.getBrokerNodeGroupInfo()));
            data.set("clusterName", om.valueToTree(this.getClusterName()));
            data.set("kafkaVersion", om.valueToTree(this.getKafkaVersion()));
            data.set("numberOfBrokerNodes", om.valueToTree(this.getNumberOfBrokerNodes()));
            if (this.getClientAuthentication() != null) {
                data.set("clientAuthentication", om.valueToTree(this.getClientAuthentication()));
            }
            if (this.getConfigurationInfo() != null) {
                data.set("configurationInfo", om.valueToTree(this.getConfigurationInfo()));
            }
            if (this.getCurrentVersion() != null) {
                data.set("currentVersion", om.valueToTree(this.getCurrentVersion()));
            }
            if (this.getEncryptionInfo() != null) {
                data.set("encryptionInfo", om.valueToTree(this.getEncryptionInfo()));
            }
            if (this.getEnhancedMonitoring() != null) {
                data.set("enhancedMonitoring", om.valueToTree(this.getEnhancedMonitoring()));
            }
            if (this.getLoggingInfo() != null) {
                data.set("loggingInfo", om.valueToTree(this.getLoggingInfo()));
            }
            if (this.getOpenMonitoring() != null) {
                data.set("openMonitoring", om.valueToTree(this.getOpenMonitoring()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (!brokerNodeGroupInfo.equals(that.brokerNodeGroupInfo)) return false;
            if (!clusterName.equals(that.clusterName)) return false;
            if (!kafkaVersion.equals(that.kafkaVersion)) return false;
            if (!numberOfBrokerNodes.equals(that.numberOfBrokerNodes)) return false;
            if (this.clientAuthentication != null ? !this.clientAuthentication.equals(that.clientAuthentication) : that.clientAuthentication != null) return false;
            if (this.configurationInfo != null ? !this.configurationInfo.equals(that.configurationInfo) : that.configurationInfo != null) return false;
            if (this.currentVersion != null ? !this.currentVersion.equals(that.currentVersion) : that.currentVersion != null) return false;
            if (this.encryptionInfo != null ? !this.encryptionInfo.equals(that.encryptionInfo) : that.encryptionInfo != null) return false;
            if (this.enhancedMonitoring != null ? !this.enhancedMonitoring.equals(that.enhancedMonitoring) : that.enhancedMonitoring != null) return false;
            if (this.loggingInfo != null ? !this.loggingInfo.equals(that.loggingInfo) : that.loggingInfo != null) return false;
            if (this.openMonitoring != null ? !this.openMonitoring.equals(that.openMonitoring) : that.openMonitoring != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.brokerNodeGroupInfo.hashCode();
            result = 31 * result + (this.clusterName.hashCode());
            result = 31 * result + (this.kafkaVersion.hashCode());
            result = 31 * result + (this.numberOfBrokerNodes.hashCode());
            result = 31 * result + (this.clientAuthentication != null ? this.clientAuthentication.hashCode() : 0);
            result = 31 * result + (this.configurationInfo != null ? this.configurationInfo.hashCode() : 0);
            result = 31 * result + (this.currentVersion != null ? this.currentVersion.hashCode() : 0);
            result = 31 * result + (this.encryptionInfo != null ? this.encryptionInfo.hashCode() : 0);
            result = 31 * result + (this.enhancedMonitoring != null ? this.enhancedMonitoring.hashCode() : 0);
            result = 31 * result + (this.loggingInfo != null ? this.loggingInfo.hashCode() : 0);
            result = 31 * result + (this.openMonitoring != null ? this.openMonitoring.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
