package software.amazon.awscdk.services.opsworks;

/**
 * Properties for defining a `CfnInstance`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opsworks.*;
 * CfnInstanceProps cfnInstanceProps = CfnInstanceProps.builder()
 *         .instanceType("instanceType")
 *         .layerIds(List.of("layerIds"))
 *         .stackId("stackId")
 *         // the properties below are optional
 *         .agentVersion("agentVersion")
 *         .amiId("amiId")
 *         .architecture("architecture")
 *         .autoScalingType("autoScalingType")
 *         .availabilityZone("availabilityZone")
 *         .blockDeviceMappings(List.of(BlockDeviceMappingProperty.builder()
 *                 .deviceName("deviceName")
 *                 .ebs(EbsBlockDeviceProperty.builder()
 *                         .deleteOnTermination(false)
 *                         .iops(123)
 *                         .snapshotId("snapshotId")
 *                         .volumeSize(123)
 *                         .volumeType("volumeType")
 *                         .build())
 *                 .noDevice("noDevice")
 *                 .virtualName("virtualName")
 *                 .build()))
 *         .ebsOptimized(false)
 *         .elasticIps(List.of("elasticIps"))
 *         .hostname("hostname")
 *         .installUpdatesOnBoot(false)
 *         .os("os")
 *         .rootDeviceType("rootDeviceType")
 *         .sshKeyName("sshKeyName")
 *         .subnetId("subnetId")
 *         .tenancy("tenancy")
 *         .timeBasedAutoScaling(TimeBasedAutoScalingProperty.builder()
 *                 .friday(Map.of(
 *                         "fridayKey", "friday"))
 *                 .monday(Map.of(
 *                         "mondayKey", "monday"))
 *                 .saturday(Map.of(
 *                         "saturdayKey", "saturday"))
 *                 .sunday(Map.of(
 *                         "sundayKey", "sunday"))
 *                 .thursday(Map.of(
 *                         "thursdayKey", "thursday"))
 *                 .tuesday(Map.of(
 *                         "tuesdayKey", "tuesday"))
 *                 .wednesday(Map.of(
 *                         "wednesdayKey", "wednesday"))
 *                 .build())
 *         .virtualizationType("virtualizationType")
 *         .volumes(List.of("volumes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:48.019Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opsworks.CfnInstanceProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The instance type, such as `t2.micro` . For a list of supported instance types, open the stack in the console, choose *Instances* , and choose *+ Instance* . The *Size* list contains the currently supported types. For more information, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) . The parameter values that you use to specify the various types are in the *API Name* column of the *Available Instance Types* table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

    /**
     * An array that contains the instance's layer IDs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getLayerIds();

    /**
     * The stack ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStackId();

    /**
     * The default AWS OpsWorks Stacks agent version. You have the following options:.
     * <p>
     * <ul>
     * <li><code>INHERIT</code> - Use the stack's default agent version setting.</li>
     * <li><em>version_number</em> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks installs that version on the instance.</li>
     * </ul>
     * <p>
     * The default setting is <code>INHERIT</code> . To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeAgentVersions">DescribeAgentVersions</a> . AgentVersion cannot be set to Chef 12.2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAgentVersion() {
        return null;
    }

    /**
     * A custom AMI ID to be used to create the instance.
     * <p>
     * The AMI should be based on one of the supported operating systems. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAmiId() {
        return null;
    }

    /**
     * The instance architecture.
     * <p>
     * The default option is <code>x86_64</code> . Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getArchitecture() {
        return null;
    }

    /**
     * For load-based or time-based instances, the type.
     * <p>
     * Windows stacks can use only time-based instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoScalingType() {
        return null;
    }

    /**
     * The Availability Zone of the AWS OpsWorks instance, such as `us-east-2a` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * An array of `BlockDeviceMapping` objects that specify the instance's block devices.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> . Note that block device mappings are not supported for custom AMIs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBlockDeviceMappings() {
        return null;
    }

    /**
     * Whether to create an Amazon EBS-optimized instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptimized() {
        return null;
    }

    /**
     * A list of Elastic IP addresses to associate with the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getElasticIps() {
        return null;
    }

    /**
     * The instance host name. The following are character limits for instance host names.
     * <p>
     * <ul>
     * <li>Linux-based instances: 63 characters</li>
     * <li>Windows-based instances: 15 characters</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getHostname() {
        return null;
    }

    /**
     * Whether to install operating system and package updates when the instance boots.
     * <p>
     * The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * <p>
     * <blockquote>
     * <p>
     * We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstallUpdatesOnBoot() {
        return null;
    }

    /**
     * The instance's operating system, which must be set to one of the following.
     * <p>
     * <ul>
     * <li>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code> , <code>Amazon Linux 2018.03</code> , <code>Amazon Linux 2017.09</code> , <code>Amazon Linux 2017.03</code> , <code>Amazon Linux 2016.09</code> , <code>Amazon Linux 2016.03</code> , <code>Amazon Linux 2015.09</code> , or <code>Amazon Linux 2015.03</code> .</li>
     * <li>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code> , <code>Ubuntu 16.04 LTS</code> , <code>Ubuntu 14.04 LTS</code> , or <code>Ubuntu 12.04 LTS</code> .</li>
     * <li><code>CentOS Linux 7</code></li>
     * <li><code>Red Hat Enterprise Linux 7</code></li>
     * <li>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code> , or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code> .</li>
     * <li>A custom AMI: <code>Custom</code> .</li>
     * </ul>
     * <p>
     * Not all operating systems are supported with all versions of Chef. For more information about the supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a> .
     * <p>
     * The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code> , you must use the <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateInstance">CreateInstance</a> action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is <code>Custom</code> . For more information about how to use custom AMIs with AWS OpsWorks Stacks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOs() {
        return null;
    }

    /**
     * The instance root device type.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRootDeviceType() {
        return null;
    }

    /**
     * The instance's Amazon EC2 key-pair name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSshKeyName() {
        return null;
    }

    /**
     * The ID of the instance's subnet.
     * <p>
     * If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
        return null;
    }

    /**
     * The instance's tenancy option.
     * <p>
     * The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: <code>dedicated</code> , <code>default</code> , or <code>host</code> . Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see <a href="https://docs.aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a href="https://docs.aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a> . For more information about dedicated instances, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> and <a href="https://docs.aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated Instances</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTenancy() {
        return null;
    }

    /**
     * The time-based scaling configuration for the instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimeBasedAutoScaling() {
        return null;
    }

    /**
     * The instance's virtualization type, `paravirtual` or `hvm` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVirtualizationType() {
        return null;
    }

    /**
     * A list of AWS OpsWorks volume IDs to associate with the instance.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html"><code>AWS::OpsWorks::Volume</code></a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceProps> {
        java.lang.String instanceType;
        java.util.List<java.lang.String> layerIds;
        java.lang.String stackId;
        java.lang.String agentVersion;
        java.lang.String amiId;
        java.lang.String architecture;
        java.lang.String autoScalingType;
        java.lang.String availabilityZone;
        java.lang.Object blockDeviceMappings;
        java.lang.Object ebsOptimized;
        java.util.List<java.lang.String> elasticIps;
        java.lang.String hostname;
        java.lang.Object installUpdatesOnBoot;
        java.lang.String os;
        java.lang.String rootDeviceType;
        java.lang.String sshKeyName;
        java.lang.String subnetId;
        java.lang.String tenancy;
        java.lang.Object timeBasedAutoScaling;
        java.lang.String virtualizationType;
        java.util.List<java.lang.String> volumes;

        /**
         * Sets the value of {@link CfnInstanceProps#getInstanceType}
         * @param instanceType The instance type, such as `t2.micro` . For a list of supported instance types, open the stack in the console, choose *Instances* , and choose *+ Instance* . The *Size* list contains the currently supported types. For more information, see [Instance Families and Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) . The parameter values that you use to specify the various types are in the *API Name* column of the *Available Instance Types* table. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(java.lang.String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getLayerIds}
         * @param layerIds An array that contains the instance's layer IDs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder layerIds(java.util.List<java.lang.String> layerIds) {
            this.layerIds = layerIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getStackId}
         * @param stackId The stack ID. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackId(java.lang.String stackId) {
            this.stackId = stackId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAgentVersion}
         * @param agentVersion The default AWS OpsWorks Stacks agent version. You have the following options:.
         *                     <ul>
         *                     <li><code>INHERIT</code> - Use the stack's default agent version setting.</li>
         *                     <li><em>version_number</em> - Use the specified agent version. This value overrides the stack's default setting. To update the agent version, edit the instance configuration and specify a new version. AWS OpsWorks Stacks installs that version on the instance.</li>
         *                     </ul>
         *                     <p>
         *                     The default setting is <code>INHERIT</code> . To specify an agent version, you must use the complete version number, not the abbreviated number shown on the console. For a list of available agent version numbers, call <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeAgentVersions">DescribeAgentVersions</a> . AgentVersion cannot be set to Chef 12.2.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentVersion(java.lang.String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAmiId}
         * @param amiId A custom AMI ID to be used to create the instance.
         *              The AMI should be based on one of the supported operating systems. For more information, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a> .
         *              <p>
         *              <blockquote>
         *              <p>
         *              If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code> .
         *              <p>
         *              </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amiId(java.lang.String amiId) {
            this.amiId = amiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getArchitecture}
         * @param architecture The instance architecture.
         *                     The default option is <code>x86_64</code> . Instance types do not necessarily support both architectures. For a list of the architectures that are supported by the different instance types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(java.lang.String architecture) {
            this.architecture = architecture;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAutoScalingType}
         * @param autoScalingType For load-based or time-based instances, the type.
         *                        Windows stacks can use only time-based instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingType(java.lang.String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getAvailabilityZone}
         * @param availabilityZone The Availability Zone of the AWS OpsWorks instance, such as `us-east-2a` .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getBlockDeviceMappings}
         * @param blockDeviceMappings An array of `BlockDeviceMapping` objects that specify the instance's block devices.
         *                            For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> . Note that block device mappings are not supported for custom AMIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(software.amazon.awscdk.IResolvable blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getBlockDeviceMappings}
         * @param blockDeviceMappings An array of `BlockDeviceMapping` objects that specify the instance's block devices.
         *                            For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device Mapping</a> . Note that block device mappings are not supported for custom AMIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder blockDeviceMappings(java.util.List<? extends java.lang.Object> blockDeviceMappings) {
            this.blockDeviceMappings = blockDeviceMappings;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getEbsOptimized}
         * @param ebsOptimized Whether to create an Amazon EBS-optimized instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getEbsOptimized}
         * @param ebsOptimized Whether to create an Amazon EBS-optimized instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(software.amazon.awscdk.IResolvable ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getElasticIps}
         * @param elasticIps A list of Elastic IP addresses to associate with the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticIps(java.util.List<java.lang.String> elasticIps) {
            this.elasticIps = elasticIps;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getHostname}
         * @param hostname The instance host name. The following are character limits for instance host names.
         *                 <ul>
         *                 <li>Linux-based instances: 63 characters</li>
         *                 <li>Windows-based instances: 15 characters</li>
         *                 </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostname(java.lang.String hostname) {
            this.hostname = hostname;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getInstallUpdatesOnBoot}
         * @param installUpdatesOnBoot Whether to install operating system and package updates when the instance boots.
         *                             The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installUpdatesOnBoot(java.lang.Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getInstallUpdatesOnBoot}
         * @param installUpdatesOnBoot Whether to install operating system and package updates when the instance boots.
         *                             The default value is <code>true</code> . To control when updates are installed, set this value to <code>false</code> . You must then update your instances manually by using <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment">CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *                             <p>
         *                             <blockquote>
         *                             <p>
         *                             We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest security updates.
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installUpdatesOnBoot(software.amazon.awscdk.IResolvable installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getOs}
         * @param os The instance's operating system, which must be set to one of the following.
         *           <ul>
         *           <li>A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code> , <code>Amazon Linux 2018.03</code> , <code>Amazon Linux 2017.09</code> , <code>Amazon Linux 2017.03</code> , <code>Amazon Linux 2016.09</code> , <code>Amazon Linux 2016.03</code> , <code>Amazon Linux 2015.09</code> , or <code>Amazon Linux 2015.03</code> .</li>
         *           <li>A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code> , <code>Ubuntu 16.04 LTS</code> , <code>Ubuntu 14.04 LTS</code> , or <code>Ubuntu 12.04 LTS</code> .</li>
         *           <li><code>CentOS Linux 7</code></li>
         *           <li><code>Red Hat Enterprise Linux 7</code></li>
         *           <li>A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code> , <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code> , or <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code> .</li>
         *           <li>A custom AMI: <code>Custom</code> .</li>
         *           </ul>
         *           <p>
         *           Not all operating systems are supported with all versions of Chef. For more information about the supported operating systems, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks Stacks Operating Systems</a> .
         *           <p>
         *           The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code> , you must use the <a href="https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateInstance">CreateInstance</a> action's AmiId parameter to specify the custom AMI that you want to use. Block device mappings are not supported if the value is <code>Custom</code> . For more information about how to use custom AMIs with AWS OpsWorks Stacks, see <a href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom AMIs</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder os(java.lang.String os) {
            this.os = os;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getRootDeviceType}
         * @param rootDeviceType The instance root device type.
         *                       For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage for the Root Device</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rootDeviceType(java.lang.String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSshKeyName}
         * @param sshKeyName The instance's Amazon EC2 key-pair name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sshKeyName(java.lang.String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getSubnetId}
         * @param subnetId The ID of the instance's subnet.
         *                 If the stack is running in a VPC, you can use this parameter to override the stack's default subnet ID value and direct AWS OpsWorks Stacks to launch the instance in a different subnet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getTenancy}
         * @param tenancy The instance's tenancy option.
         *                The default option is no tenancy, or if the instance is running in a VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter: <code>dedicated</code> , <code>default</code> , or <code>host</code> . Because there are costs associated with changes in tenancy options, we recommend that you research tenancy options before choosing them for your instances. For more information about dedicated hosts, see <a href="https://docs.aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a href="https://docs.aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a> . For more information about dedicated instances, see <a href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> and <a href="https://docs.aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated Instances</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tenancy(java.lang.String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getTimeBasedAutoScaling}
         * @param timeBasedAutoScaling The time-based scaling configuration for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeBasedAutoScaling(software.amazon.awscdk.services.opsworks.CfnInstance.TimeBasedAutoScalingProperty timeBasedAutoScaling) {
            this.timeBasedAutoScaling = timeBasedAutoScaling;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getTimeBasedAutoScaling}
         * @param timeBasedAutoScaling The time-based scaling configuration for the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeBasedAutoScaling(software.amazon.awscdk.IResolvable timeBasedAutoScaling) {
            this.timeBasedAutoScaling = timeBasedAutoScaling;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getVirtualizationType}
         * @param virtualizationType The instance's virtualization type, `paravirtual` or `hvm` .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualizationType(java.lang.String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceProps#getVolumes}
         * @param volumes A list of AWS OpsWorks volume IDs to associate with the instance.
         *                For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opsworks-volume.html"><code>AWS::OpsWorks::Volume</code></a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(java.util.List<java.lang.String> volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceProps {
        private final java.lang.String instanceType;
        private final java.util.List<java.lang.String> layerIds;
        private final java.lang.String stackId;
        private final java.lang.String agentVersion;
        private final java.lang.String amiId;
        private final java.lang.String architecture;
        private final java.lang.String autoScalingType;
        private final java.lang.String availabilityZone;
        private final java.lang.Object blockDeviceMappings;
        private final java.lang.Object ebsOptimized;
        private final java.util.List<java.lang.String> elasticIps;
        private final java.lang.String hostname;
        private final java.lang.Object installUpdatesOnBoot;
        private final java.lang.String os;
        private final java.lang.String rootDeviceType;
        private final java.lang.String sshKeyName;
        private final java.lang.String subnetId;
        private final java.lang.String tenancy;
        private final java.lang.Object timeBasedAutoScaling;
        private final java.lang.String virtualizationType;
        private final java.util.List<java.lang.String> volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.layerIds = software.amazon.jsii.Kernel.get(this, "layerIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.stackId = software.amazon.jsii.Kernel.get(this, "stackId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.agentVersion = software.amazon.jsii.Kernel.get(this, "agentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.amiId = software.amazon.jsii.Kernel.get(this, "amiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.architecture = software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoScalingType = software.amazon.jsii.Kernel.get(this, "autoScalingType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockDeviceMappings = software.amazon.jsii.Kernel.get(this, "blockDeviceMappings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticIps = software.amazon.jsii.Kernel.get(this, "elasticIps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.installUpdatesOnBoot = software.amazon.jsii.Kernel.get(this, "installUpdatesOnBoot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.os = software.amazon.jsii.Kernel.get(this, "os", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.rootDeviceType = software.amazon.jsii.Kernel.get(this, "rootDeviceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.sshKeyName = software.amazon.jsii.Kernel.get(this, "sshKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tenancy = software.amazon.jsii.Kernel.get(this, "tenancy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeBasedAutoScaling = software.amazon.jsii.Kernel.get(this, "timeBasedAutoScaling", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.virtualizationType = software.amazon.jsii.Kernel.get(this, "virtualizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.layerIds = java.util.Objects.requireNonNull(builder.layerIds, "layerIds is required");
            this.stackId = java.util.Objects.requireNonNull(builder.stackId, "stackId is required");
            this.agentVersion = builder.agentVersion;
            this.amiId = builder.amiId;
            this.architecture = builder.architecture;
            this.autoScalingType = builder.autoScalingType;
            this.availabilityZone = builder.availabilityZone;
            this.blockDeviceMappings = builder.blockDeviceMappings;
            this.ebsOptimized = builder.ebsOptimized;
            this.elasticIps = builder.elasticIps;
            this.hostname = builder.hostname;
            this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
            this.os = builder.os;
            this.rootDeviceType = builder.rootDeviceType;
            this.sshKeyName = builder.sshKeyName;
            this.subnetId = builder.subnetId;
            this.tenancy = builder.tenancy;
            this.timeBasedAutoScaling = builder.timeBasedAutoScaling;
            this.virtualizationType = builder.virtualizationType;
            this.volumes = builder.volumes;
        }

        @Override
        public final java.lang.String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final java.util.List<java.lang.String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final java.lang.String getStackId() {
            return this.stackId;
        }

        @Override
        public final java.lang.String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final java.lang.String getAmiId() {
            return this.amiId;
        }

        @Override
        public final java.lang.String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final java.lang.String getAutoScalingType() {
            return this.autoScalingType;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.lang.Object getBlockDeviceMappings() {
            return this.blockDeviceMappings;
        }

        @Override
        public final java.lang.Object getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final java.util.List<java.lang.String> getElasticIps() {
            return this.elasticIps;
        }

        @Override
        public final java.lang.String getHostname() {
            return this.hostname;
        }

        @Override
        public final java.lang.Object getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final java.lang.String getOs() {
            return this.os;
        }

        @Override
        public final java.lang.String getRootDeviceType() {
            return this.rootDeviceType;
        }

        @Override
        public final java.lang.String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.lang.String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final java.lang.Object getTimeBasedAutoScaling() {
            return this.timeBasedAutoScaling;
        }

        @Override
        public final java.lang.String getVirtualizationType() {
            return this.virtualizationType;
        }

        @Override
        public final java.util.List<java.lang.String> getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("layerIds", om.valueToTree(this.getLayerIds()));
            data.set("stackId", om.valueToTree(this.getStackId()));
            if (this.getAgentVersion() != null) {
                data.set("agentVersion", om.valueToTree(this.getAgentVersion()));
            }
            if (this.getAmiId() != null) {
                data.set("amiId", om.valueToTree(this.getAmiId()));
            }
            if (this.getArchitecture() != null) {
                data.set("architecture", om.valueToTree(this.getArchitecture()));
            }
            if (this.getAutoScalingType() != null) {
                data.set("autoScalingType", om.valueToTree(this.getAutoScalingType()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBlockDeviceMappings() != null) {
                data.set("blockDeviceMappings", om.valueToTree(this.getBlockDeviceMappings()));
            }
            if (this.getEbsOptimized() != null) {
                data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
            }
            if (this.getElasticIps() != null) {
                data.set("elasticIps", om.valueToTree(this.getElasticIps()));
            }
            if (this.getHostname() != null) {
                data.set("hostname", om.valueToTree(this.getHostname()));
            }
            if (this.getInstallUpdatesOnBoot() != null) {
                data.set("installUpdatesOnBoot", om.valueToTree(this.getInstallUpdatesOnBoot()));
            }
            if (this.getOs() != null) {
                data.set("os", om.valueToTree(this.getOs()));
            }
            if (this.getRootDeviceType() != null) {
                data.set("rootDeviceType", om.valueToTree(this.getRootDeviceType()));
            }
            if (this.getSshKeyName() != null) {
                data.set("sshKeyName", om.valueToTree(this.getSshKeyName()));
            }
            if (this.getSubnetId() != null) {
                data.set("subnetId", om.valueToTree(this.getSubnetId()));
            }
            if (this.getTenancy() != null) {
                data.set("tenancy", om.valueToTree(this.getTenancy()));
            }
            if (this.getTimeBasedAutoScaling() != null) {
                data.set("timeBasedAutoScaling", om.valueToTree(this.getTimeBasedAutoScaling()));
            }
            if (this.getVirtualizationType() != null) {
                data.set("virtualizationType", om.valueToTree(this.getVirtualizationType()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opsworks.CfnInstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceProps.Jsii$Proxy that = (CfnInstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!layerIds.equals(that.layerIds)) return false;
            if (!stackId.equals(that.stackId)) return false;
            if (this.agentVersion != null ? !this.agentVersion.equals(that.agentVersion) : that.agentVersion != null) return false;
            if (this.amiId != null ? !this.amiId.equals(that.amiId) : that.amiId != null) return false;
            if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) return false;
            if (this.autoScalingType != null ? !this.autoScalingType.equals(that.autoScalingType) : that.autoScalingType != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.blockDeviceMappings != null ? !this.blockDeviceMappings.equals(that.blockDeviceMappings) : that.blockDeviceMappings != null) return false;
            if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
            if (this.elasticIps != null ? !this.elasticIps.equals(that.elasticIps) : that.elasticIps != null) return false;
            if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
            if (this.installUpdatesOnBoot != null ? !this.installUpdatesOnBoot.equals(that.installUpdatesOnBoot) : that.installUpdatesOnBoot != null) return false;
            if (this.os != null ? !this.os.equals(that.os) : that.os != null) return false;
            if (this.rootDeviceType != null ? !this.rootDeviceType.equals(that.rootDeviceType) : that.rootDeviceType != null) return false;
            if (this.sshKeyName != null ? !this.sshKeyName.equals(that.sshKeyName) : that.sshKeyName != null) return false;
            if (this.subnetId != null ? !this.subnetId.equals(that.subnetId) : that.subnetId != null) return false;
            if (this.tenancy != null ? !this.tenancy.equals(that.tenancy) : that.tenancy != null) return false;
            if (this.timeBasedAutoScaling != null ? !this.timeBasedAutoScaling.equals(that.timeBasedAutoScaling) : that.timeBasedAutoScaling != null) return false;
            if (this.virtualizationType != null ? !this.virtualizationType.equals(that.virtualizationType) : that.virtualizationType != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.layerIds.hashCode());
            result = 31 * result + (this.stackId.hashCode());
            result = 31 * result + (this.agentVersion != null ? this.agentVersion.hashCode() : 0);
            result = 31 * result + (this.amiId != null ? this.amiId.hashCode() : 0);
            result = 31 * result + (this.architecture != null ? this.architecture.hashCode() : 0);
            result = 31 * result + (this.autoScalingType != null ? this.autoScalingType.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.blockDeviceMappings != null ? this.blockDeviceMappings.hashCode() : 0);
            result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
            result = 31 * result + (this.elasticIps != null ? this.elasticIps.hashCode() : 0);
            result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
            result = 31 * result + (this.installUpdatesOnBoot != null ? this.installUpdatesOnBoot.hashCode() : 0);
            result = 31 * result + (this.os != null ? this.os.hashCode() : 0);
            result = 31 * result + (this.rootDeviceType != null ? this.rootDeviceType.hashCode() : 0);
            result = 31 * result + (this.sshKeyName != null ? this.sshKeyName.hashCode() : 0);
            result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
            result = 31 * result + (this.tenancy != null ? this.tenancy.hashCode() : 0);
            result = 31 * result + (this.timeBasedAutoScaling != null ? this.timeBasedAutoScaling.hashCode() : 0);
            result = 31 * result + (this.virtualizationType != null ? this.virtualizationType.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
