package software.amazon.awscdk.services.personalize;

/**
 * A CloudFormation `AWS::Personalize::Dataset`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.personalize.*;
 * Object dataSource;
 * CfnDataset cfnDataset = CfnDataset.Builder.create(this, "MyCfnDataset")
 *         .datasetGroupArn("datasetGroupArn")
 *         .datasetType("datasetType")
 *         .name("name")
 *         .schemaArn("schemaArn")
 *         // the properties below are optional
 *         .datasetImportJob(DatasetImportJobProperty.builder()
 *                 .datasetArn("datasetArn")
 *                 .datasetImportJobArn("datasetImportJobArn")
 *                 .dataSource(dataSource)
 *                 .jobName("jobName")
 *                 .roleArn("roleArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:48.067Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnDataset")
public class CfnDataset extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDataset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDataset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.personalize.CfnDataset.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Personalize::Dataset`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDataset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.personalize.CfnDatasetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatasetArn() {
        return software.amazon.jsii.Kernel.get(this, "attrDatasetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::Personalize::Dataset.DatasetGroupArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatasetGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "datasetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Personalize::Dataset.DatasetGroupArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetGroupArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datasetGroupArn", java.util.Objects.requireNonNull(value, "datasetGroupArn is required"));
    }

    /**
     * `AWS::Personalize::Dataset.DatasetType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDatasetType() {
        return software.amazon.jsii.Kernel.get(this, "datasetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Personalize::Dataset.DatasetType`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "datasetType", java.util.Objects.requireNonNull(value, "datasetType is required"));
    }

    /**
     * `AWS::Personalize::Dataset.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Personalize::Dataset.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * `AWS::Personalize::Dataset.SchemaArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSchemaArn() {
        return software.amazon.jsii.Kernel.get(this, "schemaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * `AWS::Personalize::Dataset.SchemaArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schemaArn", java.util.Objects.requireNonNull(value, "schemaArn is required"));
    }

    /**
     * `AWS::Personalize::Dataset.DatasetImportJob`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDatasetImportJob() {
        return software.amazon.jsii.Kernel.get(this, "datasetImportJob", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::Personalize::Dataset.DatasetImportJob`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetImportJob(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.personalize.CfnDataset.DatasetImportJobProperty value) {
        software.amazon.jsii.Kernel.set(this, "datasetImportJob", value);
    }

    /**
     * `AWS::Personalize::Dataset.DatasetImportJob`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDatasetImportJob(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "datasetImportJob", value);
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.personalize.*;
     * Object dataSource;
     * DatasetImportJobProperty datasetImportJobProperty = DatasetImportJobProperty.builder()
     *         .datasetArn("datasetArn")
     *         .datasetImportJobArn("datasetImportJobArn")
     *         .dataSource(dataSource)
     *         .jobName("jobName")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_personalize.CfnDataset.DatasetImportJobProperty")
    @software.amazon.jsii.Jsii.Proxy(DatasetImportJobProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatasetImportJobProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDataset.DatasetImportJobProperty.DatasetArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatasetArn() {
            return null;
        }

        /**
         * `CfnDataset.DatasetImportJobProperty.DatasetImportJobArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatasetImportJobArn() {
            return null;
        }

        /**
         * `CfnDataset.DatasetImportJobProperty.DataSource`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataSource() {
            return null;
        }

        /**
         * `CfnDataset.DatasetImportJobProperty.JobName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJobName() {
            return null;
        }

        /**
         * `CfnDataset.DatasetImportJobProperty.RoleArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DatasetImportJobProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatasetImportJobProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatasetImportJobProperty> {
            java.lang.String datasetArn;
            java.lang.String datasetImportJobArn;
            java.lang.Object dataSource;
            java.lang.String jobName;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link DatasetImportJobProperty#getDatasetArn}
             * @param datasetArn `CfnDataset.DatasetImportJobProperty.DatasetArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetArn(java.lang.String datasetArn) {
                this.datasetArn = datasetArn;
                return this;
            }

            /**
             * Sets the value of {@link DatasetImportJobProperty#getDatasetImportJobArn}
             * @param datasetImportJobArn `CfnDataset.DatasetImportJobProperty.DatasetImportJobArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datasetImportJobArn(java.lang.String datasetImportJobArn) {
                this.datasetImportJobArn = datasetImportJobArn;
                return this;
            }

            /**
             * Sets the value of {@link DatasetImportJobProperty#getDataSource}
             * @param dataSource `CfnDataset.DatasetImportJobProperty.DataSource`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSource(java.lang.Object dataSource) {
                this.dataSource = dataSource;
                return this;
            }

            /**
             * Sets the value of {@link DatasetImportJobProperty#getJobName}
             * @param jobName `CfnDataset.DatasetImportJobProperty.JobName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobName(java.lang.String jobName) {
                this.jobName = jobName;
                return this;
            }

            /**
             * Sets the value of {@link DatasetImportJobProperty#getRoleArn}
             * @param roleArn `CfnDataset.DatasetImportJobProperty.RoleArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatasetImportJobProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatasetImportJobProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatasetImportJobProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatasetImportJobProperty {
            private final java.lang.String datasetArn;
            private final java.lang.String datasetImportJobArn;
            private final java.lang.Object dataSource;
            private final java.lang.String jobName;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datasetArn = software.amazon.jsii.Kernel.get(this, "datasetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datasetImportJobArn = software.amazon.jsii.Kernel.get(this, "datasetImportJobArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jobName = software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datasetArn = builder.datasetArn;
                this.datasetImportJobArn = builder.datasetImportJobArn;
                this.dataSource = builder.dataSource;
                this.jobName = builder.jobName;
                this.roleArn = builder.roleArn;
            }

            @Override
            public final java.lang.String getDatasetArn() {
                return this.datasetArn;
            }

            @Override
            public final java.lang.String getDatasetImportJobArn() {
                return this.datasetImportJobArn;
            }

            @Override
            public final java.lang.Object getDataSource() {
                return this.dataSource;
            }

            @Override
            public final java.lang.String getJobName() {
                return this.jobName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatasetArn() != null) {
                    data.set("datasetArn", om.valueToTree(this.getDatasetArn()));
                }
                if (this.getDatasetImportJobArn() != null) {
                    data.set("datasetImportJobArn", om.valueToTree(this.getDatasetImportJobArn()));
                }
                if (this.getDataSource() != null) {
                    data.set("dataSource", om.valueToTree(this.getDataSource()));
                }
                if (this.getJobName() != null) {
                    data.set("jobName", om.valueToTree(this.getJobName()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_personalize.CfnDataset.DatasetImportJobProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatasetImportJobProperty.Jsii$Proxy that = (DatasetImportJobProperty.Jsii$Proxy) o;

                if (this.datasetArn != null ? !this.datasetArn.equals(that.datasetArn) : that.datasetArn != null) return false;
                if (this.datasetImportJobArn != null ? !this.datasetImportJobArn.equals(that.datasetImportJobArn) : that.datasetImportJobArn != null) return false;
                if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) return false;
                if (this.jobName != null ? !this.jobName.equals(that.jobName) : that.jobName != null) return false;
                return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.datasetArn != null ? this.datasetArn.hashCode() : 0;
                result = 31 * result + (this.datasetImportJobArn != null ? this.datasetImportJobArn.hashCode() : 0);
                result = 31 * result + (this.dataSource != null ? this.dataSource.hashCode() : 0);
                result = 31 * result + (this.jobName != null ? this.jobName.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.personalize.CfnDataset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.personalize.CfnDataset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.personalize.CfnDatasetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.personalize.CfnDatasetProps.Builder();
        }

        /**
         * `AWS::Personalize::Dataset.DatasetGroupArn`.
         * <p>
         * @return {@code this}
         * @param datasetGroupArn `AWS::Personalize::Dataset.DatasetGroupArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetGroupArn(final java.lang.String datasetGroupArn) {
            this.props.datasetGroupArn(datasetGroupArn);
            return this;
        }

        /**
         * `AWS::Personalize::Dataset.DatasetType`.
         * <p>
         * @return {@code this}
         * @param datasetType `AWS::Personalize::Dataset.DatasetType`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetType(final java.lang.String datasetType) {
            this.props.datasetType(datasetType);
            return this;
        }

        /**
         * `AWS::Personalize::Dataset.Name`.
         * <p>
         * @return {@code this}
         * @param name `AWS::Personalize::Dataset.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::Personalize::Dataset.SchemaArn`.
         * <p>
         * @return {@code this}
         * @param schemaArn `AWS::Personalize::Dataset.SchemaArn`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaArn(final java.lang.String schemaArn) {
            this.props.schemaArn(schemaArn);
            return this;
        }

        /**
         * `AWS::Personalize::Dataset.DatasetImportJob`.
         * <p>
         * @return {@code this}
         * @param datasetImportJob `AWS::Personalize::Dataset.DatasetImportJob`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetImportJob(final software.amazon.awscdk.services.personalize.CfnDataset.DatasetImportJobProperty datasetImportJob) {
            this.props.datasetImportJob(datasetImportJob);
            return this;
        }
        /**
         * `AWS::Personalize::Dataset.DatasetImportJob`.
         * <p>
         * @return {@code this}
         * @param datasetImportJob `AWS::Personalize::Dataset.DatasetImportJob`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetImportJob(final software.amazon.awscdk.IResolvable datasetImportJob) {
            this.props.datasetImportJob(datasetImportJob);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.personalize.CfnDataset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.personalize.CfnDataset build() {
            return new software.amazon.awscdk.services.personalize.CfnDataset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
