package software.amazon.awscdk.services.pinpoint;

/**
 * Properties for defining a `CfnSegment`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.pinpoint.*;
 * Object attributes;
 * Object metrics;
 * Object tags;
 * Object userAttributes;
 * CfnSegmentProps cfnSegmentProps = CfnSegmentProps.builder()
 *         .applicationId("applicationId")
 *         .name("name")
 *         // the properties below are optional
 *         .dimensions(SegmentDimensionsProperty.builder()
 *                 .attributes(attributes)
 *                 .behavior(BehaviorProperty.builder()
 *                         .recency(RecencyProperty.builder()
 *                                 .duration("duration")
 *                                 .recencyType("recencyType")
 *                                 .build())
 *                         .build())
 *                 .demographic(DemographicProperty.builder()
 *                         .appVersion(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .channel(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .deviceType(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .make(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .model(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .platform(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .build())
 *                 .location(LocationProperty.builder()
 *                         .country(SetDimensionProperty.builder()
 *                                 .dimensionType("dimensionType")
 *                                 .values(List.of("values"))
 *                                 .build())
 *                         .gpsPoint(GPSPointProperty.builder()
 *                                 .coordinates(CoordinatesProperty.builder()
 *                                         .latitude(123)
 *                                         .longitude(123)
 *                                         .build())
 *                                 .rangeInKilometers(123)
 *                                 .build())
 *                         .build())
 *                 .metrics(metrics)
 *                 .userAttributes(userAttributes)
 *                 .build())
 *         .segmentGroups(SegmentGroupsProperty.builder()
 *                 .groups(List.of(GroupsProperty.builder()
 *                         .dimensions(List.of(SegmentDimensionsProperty.builder()
 *                                 .attributes(attributes)
 *                                 .behavior(BehaviorProperty.builder()
 *                                         .recency(RecencyProperty.builder()
 *                                                 .duration("duration")
 *                                                 .recencyType("recencyType")
 *                                                 .build())
 *                                         .build())
 *                                 .demographic(DemographicProperty.builder()
 *                                         .appVersion(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .channel(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .deviceType(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .make(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .model(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .platform(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .build())
 *                                 .location(LocationProperty.builder()
 *                                         .country(SetDimensionProperty.builder()
 *                                                 .dimensionType("dimensionType")
 *                                                 .values(List.of("values"))
 *                                                 .build())
 *                                         .gpsPoint(GPSPointProperty.builder()
 *                                                 .coordinates(CoordinatesProperty.builder()
 *                                                         .latitude(123)
 *                                                         .longitude(123)
 *                                                         .build())
 *                                                 .rangeInKilometers(123)
 *                                                 .build())
 *                                         .build())
 *                                 .metrics(metrics)
 *                                 .userAttributes(userAttributes)
 *                                 .build()))
 *                         .sourceSegments(List.of(SourceSegmentsProperty.builder()
 *                                 .id("id")
 *                                 // the properties below are optional
 *                                 .version(123)
 *                                 .build()))
 *                         .sourceType("sourceType")
 *                         .type("type")
 *                         .build()))
 *                 .include("include")
 *                 .build())
 *         .tags(tags)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:48.132Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_pinpoint.CfnSegmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnSegmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSegmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier for the Amazon Pinpoint application that the segment is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The name of the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The criteria that define the dimensions for the segment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDimensions() {
        return null;
    }

    /**
     * The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
     * <p>
     * A segment group can consist of zero or more base segments. Your request can include only one segment group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSegmentGroups() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSegmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSegmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSegmentProps> {
        java.lang.String applicationId;
        java.lang.String name;
        java.lang.Object dimensions;
        java.lang.Object segmentGroups;
        java.lang.Object tags;

        /**
         * Sets the value of {@link CfnSegmentProps#getApplicationId}
         * @param applicationId The unique identifier for the Amazon Pinpoint application that the segment is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(java.lang.String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentProps#getName}
         * @param name The name of the segment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentProps#getDimensions}
         * @param dimensions The criteria that define the dimensions for the segment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(software.amazon.awscdk.services.pinpoint.CfnSegment.SegmentDimensionsProperty dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentProps#getDimensions}
         * @param dimensions The criteria that define the dimensions for the segment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(software.amazon.awscdk.IResolvable dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentProps#getSegmentGroups}
         * @param segmentGroups The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
         *                      A segment group can consist of zero or more base segments. Your request can include only one segment group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentGroups(software.amazon.awscdk.services.pinpoint.CfnSegment.SegmentGroupsProperty segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentProps#getSegmentGroups}
         * @param segmentGroups The segment group to use and the dimensions to apply to the group's base segments in order to build the segment.
         *                      A segment group can consist of zero or more base segments. Your request can include only one segment group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder segmentGroups(software.amazon.awscdk.IResolvable segmentGroups) {
            this.segmentGroups = segmentGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnSegmentProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.lang.Object tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSegmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSegmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSegmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSegmentProps {
        private final java.lang.String applicationId;
        private final java.lang.String name;
        private final java.lang.Object dimensions;
        private final java.lang.Object segmentGroups;
        private final java.lang.Object tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.applicationId = software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.segmentGroups = software.amazon.jsii.Kernel.get(this, "segmentGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.applicationId = java.util.Objects.requireNonNull(builder.applicationId, "applicationId is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.dimensions = builder.dimensions;
            this.segmentGroups = builder.segmentGroups;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getDimensions() {
            return this.dimensions;
        }

        @Override
        public final java.lang.Object getSegmentGroups() {
            return this.segmentGroups;
        }

        @Override
        public final java.lang.Object getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("applicationId", om.valueToTree(this.getApplicationId()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDimensions() != null) {
                data.set("dimensions", om.valueToTree(this.getDimensions()));
            }
            if (this.getSegmentGroups() != null) {
                data.set("segmentGroups", om.valueToTree(this.getSegmentGroups()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_pinpoint.CfnSegmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSegmentProps.Jsii$Proxy that = (CfnSegmentProps.Jsii$Proxy) o;

            if (!applicationId.equals(that.applicationId)) return false;
            if (!name.equals(that.name)) return false;
            if (this.dimensions != null ? !this.dimensions.equals(that.dimensions) : that.dimensions != null) return false;
            if (this.segmentGroups != null ? !this.segmentGroups.equals(that.segmentGroups) : that.segmentGroups != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.applicationId.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.dimensions != null ? this.dimensions.hashCode() : 0);
            result = 31 * result + (this.segmentGroups != null ? this.segmentGroups.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
