package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::DBSecurityGroup`.
 * <p>
 * The <code>AWS::RDS::DBSecurityGroup</code> resource creates or updates an Amazon RDS DB security group.
 * <p>
 * <blockquote>
 * <p>
 * DB security groups are a part of the EC2-Classic Platform and as such are not supported in all regions. It is advised to use the <code>AWS::EC2::SecurityGroup</code> resource in those regions instead. To determine which platform you are on, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.FindDefaultVPC.html">Determining Whether You Are Using the EC2-VPC or EC2-Classic Platform</a> . For more information on the <code>AWS::EC2::SecurityGroup</code> , see the documentation for <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-security-group.html">EC2 security groups</a> .
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBSecurityGroup cfnDBSecurityGroup = CfnDBSecurityGroup.Builder.create(this, "MyCfnDBSecurityGroup")
 *         .dbSecurityGroupIngress(List.of(IngressProperty.builder()
 *                 .cidrip("cidrip")
 *                 .ec2SecurityGroupId("ec2SecurityGroupId")
 *                 .ec2SecurityGroupName("ec2SecurityGroupName")
 *                 .ec2SecurityGroupOwnerId("ec2SecurityGroupOwnerId")
 *                 .build()))
 *         .groupDescription("groupDescription")
 *         // the properties below are optional
 *         .ec2VpcId("ec2VpcId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:48.305Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBSecurityGroup")
public class CfnDBSecurityGroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDBSecurityGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDBSecurityGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnDBSecurityGroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::DBSecurityGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDBSecurityGroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnDBSecurityGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tags to assign to the DB security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Ingress rules to be applied to the DB security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDbSecurityGroupIngress() {
        return software.amazon.jsii.Kernel.get(this, "dbSecurityGroupIngress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Ingress rules to be applied to the DB security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSecurityGroupIngress(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dbSecurityGroupIngress", java.util.Objects.requireNonNull(value, "dbSecurityGroupIngress is required"));
    }

    /**
     * Ingress rules to be applied to the DB security group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDbSecurityGroupIngress(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "dbSecurityGroupIngress", java.util.Objects.requireNonNull(value, "dbSecurityGroupIngress is required"));
    }

    /**
     * Provides the description of the DB Security Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGroupDescription() {
        return software.amazon.jsii.Kernel.get(this, "groupDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Provides the description of the DB Security Group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGroupDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "groupDescription", java.util.Objects.requireNonNull(value, "groupDescription is required"));
    }

    /**
     * The identifier of an Amazon VPC. This property indicates the VPC that this DB security group belongs to.
     * <p>
     * <blockquote>
     * <p>
     * The <code>EC2VpcId</code> property is for backward compatibility with older regions, and is no longer recommended for providing security information to an RDS DB instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEc2VpcId() {
        return software.amazon.jsii.Kernel.get(this, "ec2VpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of an Amazon VPC. This property indicates the VPC that this DB security group belongs to.
     * <p>
     * <blockquote>
     * <p>
     * The <code>EC2VpcId</code> property is for backward compatibility with older regions, and is no longer recommended for providing security information to an RDS DB instance.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEc2VpcId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ec2VpcId", value);
    }
    /**
     * The `Ingress` property type specifies an individual ingress rule within an `AWS::RDS::DBSecurityGroup` resource.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.rds.*;
     * IngressProperty ingressProperty = IngressProperty.builder()
     *         .cidrip("cidrip")
     *         .ec2SecurityGroupId("ec2SecurityGroupId")
     *         .ec2SecurityGroupName("ec2SecurityGroupName")
     *         .ec2SecurityGroupOwnerId("ec2SecurityGroupOwnerId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBSecurityGroup.IngressProperty")
    @software.amazon.jsii.Jsii.Proxy(IngressProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IngressProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IP range to authorize.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCidrip() {
            return null;
        }

        /**
         * Id of the EC2 Security Group to authorize.
         * <p>
         * For VPC DB Security Groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupId() {
            return null;
        }

        /**
         * Name of the EC2 Security Group to authorize.
         * <p>
         * For VPC DB Security Groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupName() {
            return null;
        }

        /**
         * AWS Account Number of the owner of the EC2 Security Group specified in the EC2SecurityGroupName parameter.
         * <p>
         * The AWS Access Key ID is not an acceptable value. For VPC DB Security Groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupOwnerId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IngressProperty> {
            java.lang.String cidrip;
            java.lang.String ec2SecurityGroupId;
            java.lang.String ec2SecurityGroupName;
            java.lang.String ec2SecurityGroupOwnerId;

            /**
             * Sets the value of {@link IngressProperty#getCidrip}
             * @param cidrip The IP range to authorize.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cidrip(java.lang.String cidrip) {
                this.cidrip = cidrip;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getEc2SecurityGroupId}
             * @param ec2SecurityGroupId Id of the EC2 Security Group to authorize.
             *                           For VPC DB Security Groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2SecurityGroupId(java.lang.String ec2SecurityGroupId) {
                this.ec2SecurityGroupId = ec2SecurityGroupId;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getEc2SecurityGroupName}
             * @param ec2SecurityGroupName Name of the EC2 Security Group to authorize.
             *                             For VPC DB Security Groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2SecurityGroupName(java.lang.String ec2SecurityGroupName) {
                this.ec2SecurityGroupName = ec2SecurityGroupName;
                return this;
            }

            /**
             * Sets the value of {@link IngressProperty#getEc2SecurityGroupOwnerId}
             * @param ec2SecurityGroupOwnerId AWS Account Number of the owner of the EC2 Security Group specified in the EC2SecurityGroupName parameter.
             *                                The AWS Access Key ID is not an acceptable value. For VPC DB Security Groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, EC2SecurityGroupOwnerId and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ec2SecurityGroupOwnerId(java.lang.String ec2SecurityGroupOwnerId) {
                this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IngressProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IngressProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IngressProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IngressProperty {
            private final java.lang.String cidrip;
            private final java.lang.String ec2SecurityGroupId;
            private final java.lang.String ec2SecurityGroupName;
            private final java.lang.String ec2SecurityGroupOwnerId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cidrip = software.amazon.jsii.Kernel.get(this, "cidrip", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2SecurityGroupId = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2SecurityGroupName = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ec2SecurityGroupOwnerId = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cidrip = builder.cidrip;
                this.ec2SecurityGroupId = builder.ec2SecurityGroupId;
                this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
                this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
            }

            @Override
            public final java.lang.String getCidrip() {
                return this.cidrip;
            }

            @Override
            public final java.lang.String getEc2SecurityGroupId() {
                return this.ec2SecurityGroupId;
            }

            @Override
            public final java.lang.String getEc2SecurityGroupName() {
                return this.ec2SecurityGroupName;
            }

            @Override
            public final java.lang.String getEc2SecurityGroupOwnerId() {
                return this.ec2SecurityGroupOwnerId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCidrip() != null) {
                    data.set("cidrip", om.valueToTree(this.getCidrip()));
                }
                if (this.getEc2SecurityGroupId() != null) {
                    data.set("ec2SecurityGroupId", om.valueToTree(this.getEc2SecurityGroupId()));
                }
                if (this.getEc2SecurityGroupName() != null) {
                    data.set("ec2SecurityGroupName", om.valueToTree(this.getEc2SecurityGroupName()));
                }
                if (this.getEc2SecurityGroupOwnerId() != null) {
                    data.set("ec2SecurityGroupOwnerId", om.valueToTree(this.getEc2SecurityGroupOwnerId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBSecurityGroup.IngressProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IngressProperty.Jsii$Proxy that = (IngressProperty.Jsii$Proxy) o;

                if (this.cidrip != null ? !this.cidrip.equals(that.cidrip) : that.cidrip != null) return false;
                if (this.ec2SecurityGroupId != null ? !this.ec2SecurityGroupId.equals(that.ec2SecurityGroupId) : that.ec2SecurityGroupId != null) return false;
                if (this.ec2SecurityGroupName != null ? !this.ec2SecurityGroupName.equals(that.ec2SecurityGroupName) : that.ec2SecurityGroupName != null) return false;
                return this.ec2SecurityGroupOwnerId != null ? this.ec2SecurityGroupOwnerId.equals(that.ec2SecurityGroupOwnerId) : that.ec2SecurityGroupOwnerId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cidrip != null ? this.cidrip.hashCode() : 0;
                result = 31 * result + (this.ec2SecurityGroupId != null ? this.ec2SecurityGroupId.hashCode() : 0);
                result = 31 * result + (this.ec2SecurityGroupName != null ? this.ec2SecurityGroupName.hashCode() : 0);
                result = 31 * result + (this.ec2SecurityGroupOwnerId != null ? this.ec2SecurityGroupOwnerId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnDBSecurityGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnDBSecurityGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnDBSecurityGroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnDBSecurityGroupProps.Builder();
        }

        /**
         * Ingress rules to be applied to the DB security group.
         * <p>
         * @return {@code this}
         * @param dbSecurityGroupIngress Ingress rules to be applied to the DB security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroupIngress(final software.amazon.awscdk.IResolvable dbSecurityGroupIngress) {
            this.props.dbSecurityGroupIngress(dbSecurityGroupIngress);
            return this;
        }
        /**
         * Ingress rules to be applied to the DB security group.
         * <p>
         * @return {@code this}
         * @param dbSecurityGroupIngress Ingress rules to be applied to the DB security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroupIngress(final java.util.List<? extends java.lang.Object> dbSecurityGroupIngress) {
            this.props.dbSecurityGroupIngress(dbSecurityGroupIngress);
            return this;
        }

        /**
         * Provides the description of the DB Security Group.
         * <p>
         * @return {@code this}
         * @param groupDescription Provides the description of the DB Security Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupDescription(final java.lang.String groupDescription) {
            this.props.groupDescription(groupDescription);
            return this;
        }

        /**
         * The identifier of an Amazon VPC. This property indicates the VPC that this DB security group belongs to.
         * <p>
         * <blockquote>
         * <p>
         * The <code>EC2VpcId</code> property is for backward compatibility with older regions, and is no longer recommended for providing security information to an RDS DB instance.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param ec2VpcId The identifier of an Amazon VPC. This property indicates the VPC that this DB security group belongs to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2VpcId(final java.lang.String ec2VpcId) {
            this.props.ec2VpcId(ec2VpcId);
            return this;
        }

        /**
         * Tags to assign to the DB security group.
         * <p>
         * @return {@code this}
         * @param tags Tags to assign to the DB security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnDBSecurityGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnDBSecurityGroup build() {
            return new software.amazon.awscdk.services.rds.CfnDBSecurityGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
