package software.amazon.awscdk.services.rds;

/**
 * A CloudFormation `AWS::RDS::EventSubscription`.
 * <p>
 * The <code>AWS::RDS::EventSubscription</code> resource allows you to receive notifications for Amazon Relational Database Service events through the Amazon Simple Notification Service (Amazon SNS). For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Using Amazon RDS Event Notification</a> in the <em>Amazon RDS User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnEventSubscription cfnEventSubscription = CfnEventSubscription.Builder.create(this, "MyCfnEventSubscription")
 *         .snsTopicArn("snsTopicArn")
 *         // the properties below are optional
 *         .enabled(false)
 *         .eventCategories(List.of("eventCategories"))
 *         .sourceIds(List.of("sourceIds"))
 *         .sourceType("sourceType")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:48.309Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnEventSubscription")
public class CfnEventSubscription extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnEventSubscription(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEventSubscription(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.CfnEventSubscription.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::RDS::EventSubscription`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEventSubscription(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.CfnEventSubscriptionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification.
     * <p>
     * The ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSnsTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the SNS topic created for event notification.
     * <p>
     * The ARN is created by Amazon SNS when you create a topic and subscribe to it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnsTopicArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snsTopicArn", java.util.Objects.requireNonNull(value, "snsTopicArn is required"));
    }

    /**
     * A Boolean value;
     * <p>
     * set to <em>true</em> to activate the subscription, set to <em>false</em> to create the subscription but not active it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A Boolean value;
     * <p>
     * set to <em>true</em> to activate the subscription, set to <em>false</em> to create the subscription but not active it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * A Boolean value;
     * <p>
     * set to <em>true</em> to activate the subscription, set to <em>false</em> to create the subscription but not active it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * A list of event categories for a SourceType that you want to subscribe to.
     * <p>
     * You can see a list of the categories for a given SourceType in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> topic in the Amazon RDS User Guide or by using the <em>DescribeEventCategories</em> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEventCategories() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "eventCategories", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of event categories for a SourceType that you want to subscribe to.
     * <p>
     * You can see a list of the categories for a given SourceType in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> topic in the Amazon RDS User Guide or by using the <em>DescribeEventCategories</em> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventCategories(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "eventCategories", value);
    }

    /**
     * The list of identifiers of the event sources for which events are returned.
     * <p>
     * If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If a <code>SourceIds</code> value is supplied, <code>SourceType</code> must also be provided.</li>
     * <li>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</li>
     * <li>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</li>
     * <li>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</li>
     * <li>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</li>
     * <li>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</li>
     * <li>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSourceIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "sourceIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of identifiers of the event sources for which events are returned.
     * <p>
     * If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
     * <p>
     * Constraints:
     * <p>
     * <ul>
     * <li>If a <code>SourceIds</code> value is supplied, <code>SourceType</code> must also be provided.</li>
     * <li>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</li>
     * <li>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</li>
     * <li>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</li>
     * <li>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</li>
     * <li>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</li>
     * <li>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "sourceIds", value);
    }

    /**
     * The type of source that is generating the events.
     * <p>
     * For example, if you want to be notified of events generated by a DB instance, set this parameter to <code>db-instance</code> . If this value isn't specified, all events are returned.
     * <p>
     * Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceType() {
        return software.amazon.jsii.Kernel.get(this, "sourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of source that is generating the events.
     * <p>
     * For example, if you want to be notified of events generated by a DB instance, set this parameter to <code>db-instance</code> . If this value isn't specified, all events are returned.
     * <p>
     * Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceType", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.rds.CfnEventSubscription}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.rds.CfnEventSubscription> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.rds.CfnEventSubscriptionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.rds.CfnEventSubscriptionProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the SNS topic created for event notification.
         * <p>
         * The ARN is created by Amazon SNS when you create a topic and subscribe to it.
         * <p>
         * @return {@code this}
         * @param snsTopicArn The Amazon Resource Name (ARN) of the SNS topic created for event notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicArn(final java.lang.String snsTopicArn) {
            this.props.snsTopicArn(snsTopicArn);
            return this;
        }

        /**
         * A Boolean value;
         * <p>
         * set to <em>true</em> to activate the subscription, set to <em>false</em> to create the subscription but not active it.
         * <p>
         * @return {@code this}
         * @param enabled A Boolean value;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }
        /**
         * A Boolean value;
         * <p>
         * set to <em>true</em> to activate the subscription, set to <em>false</em> to create the subscription but not active it.
         * <p>
         * @return {@code this}
         * @param enabled A Boolean value;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final software.amazon.awscdk.IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * A list of event categories for a SourceType that you want to subscribe to.
         * <p>
         * You can see a list of the categories for a given SourceType in the <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Events.html">Events</a> topic in the Amazon RDS User Guide or by using the <em>DescribeEventCategories</em> action.
         * <p>
         * @return {@code this}
         * @param eventCategories A list of event categories for a SourceType that you want to subscribe to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventCategories(final java.util.List<java.lang.String> eventCategories) {
            this.props.eventCategories(eventCategories);
            return this;
        }

        /**
         * The list of identifiers of the event sources for which events are returned.
         * <p>
         * If not specified, then all sources are included in the response. An identifier must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't end with a hyphen or contain two consecutive hyphens.
         * <p>
         * Constraints:
         * <p>
         * <ul>
         * <li>If a <code>SourceIds</code> value is supplied, <code>SourceType</code> must also be provided.</li>
         * <li>If the source type is a DB instance, a <code>DBInstanceIdentifier</code> value must be supplied.</li>
         * <li>If the source type is a DB cluster, a <code>DBClusterIdentifier</code> value must be supplied.</li>
         * <li>If the source type is a DB parameter group, a <code>DBParameterGroupName</code> value must be supplied.</li>
         * <li>If the source type is a DB security group, a <code>DBSecurityGroupName</code> value must be supplied.</li>
         * <li>If the source type is a DB snapshot, a <code>DBSnapshotIdentifier</code> value must be supplied.</li>
         * <li>If the source type is a DB cluster snapshot, a <code>DBClusterSnapshotIdentifier</code> value must be supplied.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param sourceIds The list of identifiers of the event sources for which events are returned. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceIds(final java.util.List<java.lang.String> sourceIds) {
            this.props.sourceIds(sourceIds);
            return this;
        }

        /**
         * The type of source that is generating the events.
         * <p>
         * For example, if you want to be notified of events generated by a DB instance, set this parameter to <code>db-instance</code> . If this value isn't specified, all events are returned.
         * <p>
         * Valid values: <code>db-instance</code> | <code>db-cluster</code> | <code>db-parameter-group</code> | <code>db-security-group</code> | <code>db-snapshot</code> | <code>db-cluster-snapshot</code>
         * <p>
         * @return {@code this}
         * @param sourceType The type of source that is generating the events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceType(final java.lang.String sourceType) {
            this.props.sourceType(sourceType);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.rds.CfnEventSubscription}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.rds.CfnEventSubscription build() {
            return new software.amazon.awscdk.services.rds.CfnEventSubscription(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
