package software.amazon.awscdk.services.route53;

/**
 * A DNS NS record.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone myZone;
 * NsRecord.Builder.create(this, "NSRecord")
 *         .zone(myZone)
 *         .recordName("foo")
 *         .values(List.of("ns-1.awsdns.co.uk.", "ns-2.awsdns.com."))
 *         .ttl(Duration.minutes(90))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:48.543Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.NsRecord")
public class NsRecord extends software.amazon.awscdk.services.route53.RecordSet {

    protected NsRecord(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected NsRecord(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public NsRecord(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.NsRecordProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.route53.NsRecord}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.route53.NsRecord> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.route53.NsRecordProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.route53.NsRecordProps.Builder();
        }

        /**
         * The hosted zone in which to define the new record.
         * <p>
         * @return {@code this}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(final software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.props.zone(zone);
            return this;
        }

        /**
         * A comment to add on the record.
         * <p>
         * Default: no comment
         * <p>
         * @return {@code this}
         * @param comment A comment to add on the record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The domain name for this record.
         * <p>
         * Default: zone root
         * <p>
         * @return {@code this}
         * @param recordName The domain name for this record. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordName(final java.lang.String recordName) {
            this.props.recordName(recordName);
            return this;
        }

        /**
         * The resource record cache time to live (TTL).
         * <p>
         * Default: Duration.minutes(30)
         * <p>
         * @return {@code this}
         * @param ttl The resource record cache time to live (TTL). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(final software.amazon.awscdk.Duration ttl) {
            this.props.ttl(ttl);
            return this;
        }

        /**
         * The NS values.
         * <p>
         * @return {@code this}
         * @param values The NS values. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder values(final java.util.List<java.lang.String> values) {
            this.props.values(values);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.route53.NsRecord}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.route53.NsRecord build() {
            return new software.amazon.awscdk.services.route53.NsRecord(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
