package software.amazon.awscdk.services.secretsmanager;

/**
 * Properties for defining a `CfnSecret`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.secretsmanager.*;
 * CfnSecretProps cfnSecretProps = CfnSecretProps.builder()
 *         .description("description")
 *         .generateSecretString(GenerateSecretStringProperty.builder()
 *                 .excludeCharacters("excludeCharacters")
 *                 .excludeLowercase(false)
 *                 .excludeNumbers(false)
 *                 .excludePunctuation(false)
 *                 .excludeUppercase(false)
 *                 .generateStringKey("generateStringKey")
 *                 .includeSpace(false)
 *                 .passwordLength(123)
 *                 .requireEachIncludedType(false)
 *                 .secretStringTemplate("secretStringTemplate")
 *                 .build())
 *         .kmsKeyId("kmsKeyId")
 *         .name("name")
 *         .replicaRegions(List.of(ReplicaRegionProperty.builder()
 *                 .region("region")
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build()))
 *         .secretString("secretString")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:48.900Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.CfnSecretProps")
@software.amazon.jsii.Jsii.Proxy(CfnSecretProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnSecretProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The description of the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A structure that specifies how to generate a password to encrypt and store in the secret.
     * <p>
     * Either <code>GenerateSecretString</code> or <code>SecretString</code> must have a value, but not both. They cannot both be empty.
     * <p>
     * We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGenerateSecretString() {
        return null;
    }

    /**
     * The ARN, key ID, or alias of the AWS KMS key that Secrets Manager uses to encrypt the secret value in the secret.
     * <p>
     * To use a AWS KMS key in a different account, use the key ARN or the alias ARN.
     * <p>
     * If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code> . If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
     * <p>
     * If the secret is in a different AWS account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed AWS KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The name of the new secret.
     * <p>
     * The secret name can contain ASCII letters, numbers, and the following characters: /_+=.&#64;-
     * <p>
     * Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * A custom type that specifies a `Region` and the `KmsKeyId` for a replica secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplicaRegions() {
        return null;
    }

    /**
     * The text to encrypt and store in the secret.
     * <p>
     * We recommend you use a JSON structure of key/value pairs for your secret value.
     * <p>
     * Either <code>GenerateSecretString</code> or <code>SecretString</code> must have a value, but not both. They cannot both be empty. We recommend that you use the <code>GenerateSecretString</code> property to generate a random password.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretString() {
        return null;
    }

    /**
     * A list of tags to attach to the secret.
     * <p>
     * Each tag is a key and value pair of strings in a JSON text string, for example:
     * <p>
     * <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code>
     * <p>
     * Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".
     * <p>
     * If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an <code>Access Denied</code> error. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac">Control access to secrets using tags</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2">Limit access to identities with tags that match secrets' tags</a> .
     * <p>
     * For information about how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a> . If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.
     * <p>
     * The following restrictions apply to tags:
     * <p>
     * <ul>
     * <li>Maximum number of tags per secret: 50</li>
     * <li>Maximum key length: 127 Unicode characters in UTF-8</li>
     * <li>Maximum value length: 255 Unicode characters in UTF-8</li>
     * <li>Tag keys and values are case sensitive.</li>
     * <li>Do not use the <code>aws:</code> prefix in your tag names or values because AWS reserves it for AWS use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</li>
     * <li>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / &#64;.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnSecretProps> {
        java.lang.String description;
        java.lang.Object generateSecretString;
        java.lang.String kmsKeyId;
        java.lang.String name;
        java.lang.Object replicaRegions;
        java.lang.String secretString;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnSecretProps#getDescription}
         * @param description The description of the secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretProps#getGenerateSecretString}
         * @param generateSecretString A structure that specifies how to generate a password to encrypt and store in the secret.
         *                             Either <code>GenerateSecretString</code> or <code>SecretString</code> must have a value, but not both. They cannot both be empty.
         *                             <p>
         *                             We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecretString(software.amazon.awscdk.services.secretsmanager.CfnSecret.GenerateSecretStringProperty generateSecretString) {
            this.generateSecretString = generateSecretString;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretProps#getGenerateSecretString}
         * @param generateSecretString A structure that specifies how to generate a password to encrypt and store in the secret.
         *                             Either <code>GenerateSecretString</code> or <code>SecretString</code> must have a value, but not both. They cannot both be empty.
         *                             <p>
         *                             We recommend that you specify the maximum length and include every character type that the system you are generating a password for can support.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateSecretString(software.amazon.awscdk.IResolvable generateSecretString) {
            this.generateSecretString = generateSecretString;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretProps#getKmsKeyId}
         * @param kmsKeyId The ARN, key ID, or alias of the AWS KMS key that Secrets Manager uses to encrypt the secret value in the secret.
         *                 To use a AWS KMS key in a different account, use the key ARN or the alias ARN.
         *                 <p>
         *                 If you don't specify this value, then Secrets Manager uses the key <code>aws/secretsmanager</code> . If that key doesn't yet exist, then Secrets Manager creates it for you automatically the first time it encrypts the secret value.
         *                 <p>
         *                 If the secret is in a different AWS account from the credentials calling the API, then you can't use <code>aws/secretsmanager</code> to encrypt the secret, and you must create and use a customer managed AWS KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretProps#getName}
         * @param name The name of the new secret.
         *             The secret name can contain ASCII letters, numbers, and the following characters: /_+=.&#64;-
         *             <p>
         *             Do not end your secret name with a hyphen followed by six characters. If you do so, you risk confusion and unexpected results when searching for a secret by partial ARN. Secrets Manager automatically adds a hyphen and six random characters after the secret name at the end of the ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretProps#getReplicaRegions}
         * @param replicaRegions A custom type that specifies a `Region` and the `KmsKeyId` for a replica secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaRegions(software.amazon.awscdk.IResolvable replicaRegions) {
            this.replicaRegions = replicaRegions;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretProps#getReplicaRegions}
         * @param replicaRegions A custom type that specifies a `Region` and the `KmsKeyId` for a replica secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicaRegions(java.util.List<? extends java.lang.Object> replicaRegions) {
            this.replicaRegions = replicaRegions;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretProps#getSecretString}
         * @param secretString The text to encrypt and store in the secret.
         *                     We recommend you use a JSON structure of key/value pairs for your secret value.
         *                     <p>
         *                     Either <code>GenerateSecretString</code> or <code>SecretString</code> must have a value, but not both. They cannot both be empty. We recommend that you use the <code>GenerateSecretString</code> property to generate a random password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretString(java.lang.String secretString) {
            this.secretString = secretString;
            return this;
        }

        /**
         * Sets the value of {@link CfnSecretProps#getTags}
         * @param tags A list of tags to attach to the secret.
         *             Each tag is a key and value pair of strings in a JSON text string, for example:
         *             <p>
         *             <code>[{"Key":"CostCenter","Value":"12345"},{"Key":"environment","Value":"production"}]</code>
         *             <p>
         *             Secrets Manager tag key names are case sensitive. A tag with the key "ABC" is a different tag from one with key "abc".
         *             <p>
         *             If you check tags in permissions policies as part of your security strategy, then adding or removing a tag can change permissions. If the completion of this operation would result in you losing your permissions for this secret, then Secrets Manager blocks the operation and returns an <code>Access Denied</code> error. For more information, see <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#tag-secrets-abac">Control access to secrets using tags</a> and <a href="https://docs.aws.amazon.com/secretsmanager/latest/userguide/auth-and-access_examples.html#auth-and-access_tags2">Limit access to identities with tags that match secrets' tags</a> .
         *             <p>
         *             For information about how to format a JSON parameter for the various command line tool environments, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json">Using JSON for Parameters</a> . If your command-line tool or SDK requires quotation marks around the parameter, you should use single quotes to avoid confusion with the double quotes required in the JSON text.
         *             <p>
         *             The following restrictions apply to tags:
         *             <p>
         *             <ul>
         *             <li>Maximum number of tags per secret: 50</li>
         *             <li>Maximum key length: 127 Unicode characters in UTF-8</li>
         *             <li>Maximum value length: 255 Unicode characters in UTF-8</li>
         *             <li>Tag keys and values are case sensitive.</li>
         *             <li>Do not use the <code>aws:</code> prefix in your tag names or values because AWS reserves it for AWS use. You can't edit or delete tag names or values with this prefix. Tags with this prefix do not count against your tags per secret limit.</li>
         *             <li>If you use your tagging schema across multiple services and resources, other services might have restrictions on allowed characters. Generally allowed characters: letters, spaces, and numbers representable in UTF-8, plus the following special characters: + - = . _ : / &#64;.</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnSecretProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnSecretProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnSecretProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnSecretProps {
        private final java.lang.String description;
        private final java.lang.Object generateSecretString;
        private final java.lang.String kmsKeyId;
        private final java.lang.String name;
        private final java.lang.Object replicaRegions;
        private final java.lang.String secretString;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.generateSecretString = software.amazon.jsii.Kernel.get(this, "generateSecretString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.replicaRegions = software.amazon.jsii.Kernel.get(this, "replicaRegions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.secretString = software.amazon.jsii.Kernel.get(this, "secretString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.generateSecretString = builder.generateSecretString;
            this.kmsKeyId = builder.kmsKeyId;
            this.name = builder.name;
            this.replicaRegions = builder.replicaRegions;
            this.secretString = builder.secretString;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getGenerateSecretString() {
            return this.generateSecretString;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getReplicaRegions() {
            return this.replicaRegions;
        }

        @Override
        public final java.lang.String getSecretString() {
            return this.secretString;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGenerateSecretString() != null) {
                data.set("generateSecretString", om.valueToTree(this.getGenerateSecretString()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getReplicaRegions() != null) {
                data.set("replicaRegions", om.valueToTree(this.getReplicaRegions()));
            }
            if (this.getSecretString() != null) {
                data.set("secretString", om.valueToTree(this.getSecretString()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_secretsmanager.CfnSecretProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnSecretProps.Jsii$Proxy that = (CfnSecretProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.generateSecretString != null ? !this.generateSecretString.equals(that.generateSecretString) : that.generateSecretString != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.replicaRegions != null ? !this.replicaRegions.equals(that.replicaRegions) : that.replicaRegions != null) return false;
            if (this.secretString != null ? !this.secretString.equals(that.secretString) : that.secretString != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.generateSecretString != null ? this.generateSecretString.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.replicaRegions != null ? this.replicaRegions.hashCode() : 0);
            result = 31 * result + (this.secretString != null ? this.secretString.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
