package software.amazon.awscdk.services.servicediscovery;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * PublicDnsNamespace namespace = PublicDnsNamespace.Builder.create(stack, "Namespace")
 *         .name("foobar.com")
 *         .build();
 * Service service = namespace.createService("Service", DnsServiceProps.builder()
 *         .name("foo")
 *         .dnsRecordType(DnsRecordType.CNAME)
 *         .dnsTtl(Duration.seconds(30))
 *         .build());
 * service.registerCnameInstance("CnameInstance", CnameInstanceBaseProps.builder()
 *         .instanceCname("service.pizza")
 *         .build());
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:48.986Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.DnsRecordType")
public enum DnsRecordType {
    /**
     * An A record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A,
    /**
     * An AAAA record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AAAA,
    /**
     * Both an A and AAAA record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A_AAAA,
    /**
     * A Srv record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SRV,
    /**
     * A CNAME record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CNAME,
}
