package software.amazon.awscdk.services.sns;

/**
 * Options for creating a new subscription.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sns.*;
 * import software.amazon.awscdk.services.sqs.*;
 * Queue queue;
 * SubscriptionFilter subscriptionFilter;
 * SubscriptionOptions subscriptionOptions = SubscriptionOptions.builder()
 *         .endpoint("endpoint")
 *         .protocol(SubscriptionProtocol.HTTP)
 *         // the properties below are optional
 *         .deadLetterQueue(queue)
 *         .filterPolicy(Map.of(
 *                 "filterPolicyKey", subscriptionFilter))
 *         .rawMessageDelivery(false)
 *         .region("region")
 *         .subscriptionRoleArn("subscriptionRoleArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.54.0 (build b1b977a)", date = "2022-03-17T13:49:49.068Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.SubscriptionOptions")
@software.amazon.jsii.Jsii.Proxy(SubscriptionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SubscriptionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The subscription endpoint.
     * <p>
     * The meaning of this value depends on the value for 'protocol'.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

    /**
     * What type of subscription to add.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol();

    /**
     * Queue to be used as dead letter queue.
     * <p>
     * If not passed no dead letter queue is enabled.
     * <p>
     * Default: - No dead letter queue enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
        return null;
    }

    /**
     * The filter policy.
     * <p>
     * Default: - all messages are delivered
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
        return null;
    }

    /**
     * true if raw message delivery is enabled for the subscription.
     * <p>
     * Raw messages are free of JSON formatting and can be
     * sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
     * Notification Service API Reference.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRawMessageDelivery() {
        return null;
    }

    /**
     * The region where the topic resides, in the case of cross-region subscriptions.
     * <p>
     * Default: - the region where the CloudFormation stack is being deployed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return null;
    }

    /**
     * Arn of role allowing access to firehose delivery stream.
     * <p>
     * Required for a firehose subscription protocol.
     * <p>
     * Default: - No subscription role is provided
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubscriptionRoleArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SubscriptionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SubscriptionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SubscriptionOptions> {
        java.lang.String endpoint;
        software.amazon.awscdk.services.sns.SubscriptionProtocol protocol;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        java.lang.Boolean rawMessageDelivery;
        java.lang.String region;
        java.lang.String subscriptionRoleArn;

        /**
         * Sets the value of {@link SubscriptionOptions#getEndpoint}
         * @param endpoint The subscription endpoint. This parameter is required.
         *                 The meaning of this value depends on the value for 'protocol'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(java.lang.String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getProtocol}
         * @param protocol What type of subscription to add. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(software.amazon.awscdk.services.sns.SubscriptionProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getDeadLetterQueue}
         * @param deadLetterQueue Queue to be used as dead letter queue.
         *                        If not passed no dead letter queue is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getFilterPolicy}
         * @param filterPolicy The filter policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder filterPolicy(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy) {
            this.filterPolicy = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter>)filterPolicy;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getRawMessageDelivery}
         * @param rawMessageDelivery true if raw message delivery is enabled for the subscription.
         *                           Raw messages are free of JSON formatting and can be
         *                           sent to HTTP/S and Amazon SQS endpoints. For more information, see GetSubscriptionAttributes in the Amazon Simple
         *                           Notification Service API Reference.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rawMessageDelivery(java.lang.Boolean rawMessageDelivery) {
            this.rawMessageDelivery = rawMessageDelivery;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getRegion}
         * @param region The region where the topic resides, in the case of cross-region subscriptions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder region(java.lang.String region) {
            this.region = region;
            return this;
        }

        /**
         * Sets the value of {@link SubscriptionOptions#getSubscriptionRoleArn}
         * @param subscriptionRoleArn Arn of role allowing access to firehose delivery stream.
         *                            Required for a firehose subscription protocol.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriptionRoleArn(java.lang.String subscriptionRoleArn) {
            this.subscriptionRoleArn = subscriptionRoleArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SubscriptionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SubscriptionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SubscriptionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SubscriptionOptions {
        private final java.lang.String endpoint;
        private final software.amazon.awscdk.services.sns.SubscriptionProtocol protocol;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> filterPolicy;
        private final java.lang.Boolean rawMessageDelivery;
        private final java.lang.String region;
        private final java.lang.String subscriptionRoleArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.protocol = software.amazon.jsii.Kernel.get(this, "protocol", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionProtocol.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.filterPolicy = software.amazon.jsii.Kernel.get(this, "filterPolicy", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.SubscriptionFilter.class)));
            this.rawMessageDelivery = software.amazon.jsii.Kernel.get(this, "rawMessageDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subscriptionRoleArn = software.amazon.jsii.Kernel.get(this, "subscriptionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
            this.protocol = java.util.Objects.requireNonNull(builder.protocol, "protocol is required");
            this.deadLetterQueue = builder.deadLetterQueue;
            this.filterPolicy = (java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter>)builder.filterPolicy;
            this.rawMessageDelivery = builder.rawMessageDelivery;
            this.region = builder.region;
            this.subscriptionRoleArn = builder.subscriptionRoleArn;
        }

        @Override
        public final java.lang.String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final software.amazon.awscdk.services.sns.SubscriptionProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.sns.SubscriptionFilter> getFilterPolicy() {
            return this.filterPolicy;
        }

        @Override
        public final java.lang.Boolean getRawMessageDelivery() {
            return this.rawMessageDelivery;
        }

        @Override
        public final java.lang.String getRegion() {
            return this.region;
        }

        @Override
        public final java.lang.String getSubscriptionRoleArn() {
            return this.subscriptionRoleArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpoint", om.valueToTree(this.getEndpoint()));
            data.set("protocol", om.valueToTree(this.getProtocol()));
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getFilterPolicy() != null) {
                data.set("filterPolicy", om.valueToTree(this.getFilterPolicy()));
            }
            if (this.getRawMessageDelivery() != null) {
                data.set("rawMessageDelivery", om.valueToTree(this.getRawMessageDelivery()));
            }
            if (this.getRegion() != null) {
                data.set("region", om.valueToTree(this.getRegion()));
            }
            if (this.getSubscriptionRoleArn() != null) {
                data.set("subscriptionRoleArn", om.valueToTree(this.getSubscriptionRoleArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.SubscriptionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SubscriptionOptions.Jsii$Proxy that = (SubscriptionOptions.Jsii$Proxy) o;

            if (!endpoint.equals(that.endpoint)) return false;
            if (!protocol.equals(that.protocol)) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.filterPolicy != null ? !this.filterPolicy.equals(that.filterPolicy) : that.filterPolicy != null) return false;
            if (this.rawMessageDelivery != null ? !this.rawMessageDelivery.equals(that.rawMessageDelivery) : that.rawMessageDelivery != null) return false;
            if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
            return this.subscriptionRoleArn != null ? this.subscriptionRoleArn.equals(that.subscriptionRoleArn) : that.subscriptionRoleArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.endpoint.hashCode();
            result = 31 * result + (this.protocol.hashCode());
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.filterPolicy != null ? this.filterPolicy.hashCode() : 0);
            result = 31 * result + (this.rawMessageDelivery != null ? this.rawMessageDelivery.hashCode() : 0);
            result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
            result = 31 * result + (this.subscriptionRoleArn != null ? this.subscriptionRoleArn.hashCode() : 0);
            return result;
        }
    }
}
